/** 
 *  _   _        _  _                           _             
 * | |_| |  ___ | || |  ___   __ _  _ __  _ __ (_)  ___  _ __ 
 * |  _  | / _ \| || | / __| / _` || '__|| '__|| | / _ \| '__|
 * | | | ||  __/| || || (__ | (_| || |   | |   | ||  __/| |   
 * |_| |_| \___||_||_| \___| \__,_||_|   |_|   |_| \___||_|   
 * 
 *  (c) 2001 Free Lunch Design, Teknisk-IT, AerotechTelub
 *			  http://www.freelunchdesign.com
 * 
 * This source code is released as is under GPL (General Public
 * License). Please refer to license.txt for more information.
 * 
 */
 
#ifndef _OBJECT_H_
#define _OBJECT_H_

#include "allegro.h"
#include "main.h"
#include "mission.h"
#include "sector.h"

// altitudes / gfx layers / types
#define GL_GROUND_FLAT_SCENERY	0
#define GL_GROUND_SCENERY		1
#define GL_GROUND_UNIT			2
#define GL_MIDDLE				3
#define GL_AIR					4

// object types
#define OBJ_PROJECTILE			1
#define OBJ_MISSILE				2
#define OBJ_FIRE				3
#define OBJ_SOLDIER				4
#define OBJ_FOOT_SOLDIER		5
#define OBJ_BAZOOKA_SOLDIER		6
#define OBJ_JEEP				7
#define OBJ_TRUCK				8
#define OBJ_TANK				9
#define OBJ_HELI				10
#define OBJ_TOWER				11
#define OBJ_SCENERY				12
#define OBJ_BUILDING			13
#define OBJ_PICKUP				14

// collision types
#define COLL_SPHERE				1
#define COLL_SEMI_SPHERE		3
#define COLL_RECTANGLE			2


class object {

public:
	char	name[32];
	int		index;
	bool	inside;
	int		type;
	char	file[32];
	int		altitude;
	double	x,y;				// absolute map coordinates
	int		w,h;				// size of object
	bool    exist;
	bool	target;
	int		detail_level;
	fixed	angle;
	fixed	target_angle;
	int		base_image;
	int		shadow_image;
	int		wreck_image;
	int		anim_pos;
	int		anim_frames;
	int		anim_rate;
	int		anim_count;
	int		armour;
	int		max_armour;
	int		smoking;
	double	rot_str, rot_step, rot_fric;
	double	thr_str, thr_step, thr_fric;
	double	str_str, str_step, str_fric;
	double  x_force, y_force, f_fric;
	double  target_thrust;
	char	team;
	class	mission *current_mission;
	double	r_dx, r_dy, r_hyp, r_angle;	// distance from heli (radar)
	int		shadow_dist;

	int render_x, render_y;
	double shax, shay;
	bool rendered;
	bool selected;
	int radius;
	double pw;
	bool essential;		// used in any mission


	// for when in a dbl linked list
	object *next;
	object *prev;
	sector *sect;

	object();
	~object();
	void kill();
	void reset();
	void rotate(double dir);
	void thrust(double dir);
	void strafe(double dir);
	void calc_movement();
	void set_position(int x, int y);
	void to_string(char *str);
	void type_to_string(char *str);
	void draw_border(BITMAP *bmp);
	bool collision(object *o, int c_type);
	bool collision(int px, int py, int mx, int my, int c_type);
	bool collision(int px, int py, double pw, double ph);
	bool collision(int px, int py, int radius);
	bool is_unit();
	bool is_armed();
	virtual void set_from_file(char* fname) = 0;
	virtual void evaluate_AI() = 0;
	virtual bool add_object(object *o) = 0;
	virtual void empty(class mission *m) = 0;
	virtual void save(PACKFILE *fp) = 0;
	virtual void load(PACKFILE *fp) = 0;
	virtual void draw(BITMAP *bmp, DATAFILE *gfx, fixed ca, bool shadow) = 0;
	void draw_shadow(BITMAP *bmp, DATAFILE *gfx, fixed ca);
	bool is_more_dangerous_than(object *o, int me);
};


#endif
