/** 
 *  _   _        _  _                           _             
 * | |_| |  ___ | || |  ___   __ _  _ __  _ __ (_)  ___  _ __ 
 * |  _  | / _ \| || | / __| / _` || '__|| '__|| | / _ \| '__|
 * | | | ||  __/| || || (__ | (_| || |   | |   | ||  __/| |   
 * |_| |_| \___||_||_| \___| \__,_||_|   |_|   |_| \___||_|   
 * 
 *  (c) 2001 Free Lunch Design, Teknisk-IT, AerotechTelub
 *			  http://www.freelunchdesign.com
 * 
 * This source code is released as is under GPL (General Public
 * License). Please refer to license.txt for more information.
 * 
 */
 
#ifndef _MAIN_H_
#define _MAIN_H_

#define byte		unsigned char
#define bool		unsigned char

#define DETAIL_LOW		1
#define DETAIL_MED		2
#define DETAIL_HIGH		3

#define FRAME_LENGTH	20				// 20 msec per frame -> 50 fps

#define MAX_SUB_MISSIONS	32
#define MAX_EVENTS			1024
#define MAX_OBJECTS			1024
#define MAX_TARGETS			512

#define GAME_W			640
#define GAME_H			480
#define HELI_X			320
#define HELI_Y			380

#define PI				3.1415926535


typedef struct {
	int detail_level;
	int size;
	int sound_volume;
	bool sound_mute;
	int music_volume;
	bool music_mute;
	int frame_step;
	bool shadow;
	bool use_joy;
	int analog_joy;  // 0 = no, x = #axes
	bool smoke;
} Toptions;


typedef struct {
	int value;
	int pos;
	int delta;
} Tm_line;


void my_alert(char *func, char *txt);
char *get_pwd();

#endif