/** 
 *  _   _        _  _                           _             
 * | |_| |  ___ | || |  ___   __ _  _ __  _ __ (_)  ___  _ __ 
 * |  _  | / _ \| || | / __| / _` || '__|| '__|| | / _ \| '__|
 * | | | ||  __/| || || (__ | (_| || |   | |   | ||  __/| |   
 * |_| |_| \___||_||_| \___| \__,_||_|   |_|   |_| \___||_|   
 * 
 *  (c) 2001 Free Lunch Design, Teknisk-IT, AerotechTelub
 *			  http://www.freelunchdesign.com
 * 
 * This source code is released as is under GPL (General Public
 * License). Please refer to license.txt for more information.
 * 
 */
 
#include "allegro.h"
#include "main.h"
#include "debris.h"


debris :: debris(BITMAP *src, double xp, double yp) {
	int w, h;
	// create triangle and put it in debris_bmp
	debris_bmp = create_bitmap(64, 64);
	clear(debris_bmp);

	w = rand()%(src->w/2)+src->w/4; h = rand()%(src->h/2)+src->h/4;
	V3D_f v1 = { w,	h,	0,	w,	h,	1 };
	w = rand()%(src->w/2)+src->w/4; h = rand()%(src->h/2)+src->h/4;
	V3D_f v2 = { w,	h,	0,	w,	h,	1 };
	w = rand()%(src->w/2)+src->w/4; h = rand()%(src->h/2)+src->h/4;
	V3D_f v3 = { w,	h,	0,	w,	h,	1 };

	triangle3d_f(debris_bmp, POLYTYPE_ATEX, src, &v1, &v2, &v3);
	
	life = 40 + rand()%25;
	speed_x = 0;
	speed_y = 0;
	speed_scale = 0;
	speed_angle = 0;
	scale = itofix(1);
	angle = 0;
	size = 32;
	x = xp;
	y = yp;
}

debris::~debris() {
	if (debris_bmp != NULL)
		destroy_bitmap(debris_bmp);
};

void debris::draw(BITMAP *bmp, DATAFILE *gfx, fixed ca, bool shadow) {
	rotate_scaled_sprite(bmp, debris_bmp, render_x-32, render_y-32, angle, scale);
}

void debris::update() {
	x += speed_x;
	y += speed_y;
	angle = angle + speed_angle;
	scale = scale + speed_scale;
	
	if (life) {
		life --;
	}
}

void debris::set_params(double xv, double yv, fixed ss, fixed rs) {
	speed_angle = rs;
	speed_scale = ss;
	speed_x = xv;
	speed_y = yv;
}

