/** 
 *  _   _        _  _                           _             
 * | |_| |  ___ | || |  ___   __ _  _ __  _ __ (_)  ___  _ __ 
 * |  _  | / _ \| || | / __| / _` || '__|| '__|| | / _ \| '__|
 * | | | ||  __/| || || (__ | (_| || |   | |   | ||  __/| |   
 * |_| |_| \___||_||_| \___| \__,_||_|   |_|   |_| \___||_|   
 * 
 *  (c) 2001 Free Lunch Design, Teknisk-IT, AerotechTelub
 *			  http://www.freelunchdesign.com
 * 
 * This source code is released as is under GPL (General Public
 * License). Please refer to license.txt for more information.
 * 
 */
 
#ifndef _BUILDING_H_
#define _BUILDING_H_

#include "allegro.h"
#include "scenery.h"
#include "building.h"

#define MAX_OCCUPANTS	64

class building : public scenery {

public:
	int occupant[MAX_OCCUPANTS];	// ids of the people in the house
	int num_occupants;
	bool got_rotor;
	int rot_w, rot_h;
	fixed rot_angle;

	building();
	~building();

	bool add_object(object *o);
	void empty(mission *m);
	void destroy(mission *m);
	void props_dialog(DATAFILE *df);
	void to_string(char *str);
	void save(PACKFILE *fp);
	void load(PACKFILE *fp);
	void draw(BITMAP *bmp, DATAFILE *gfx, fixed ca, bool shadow);
	void set_from_file(char* fname);
};


#endif