/*
 *  POP 'EM!
 *
 *  Johan Peitz
 */


#define POPEM_VERSION_STR      "v1.1"

/*
    TODO
   ********************
	instructions
	outro
 */

#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
#include "popem.h"
#include "button.h"		// button lib
#include "hisc.h"		// highscore lib
#include "../data/gfx.h"


void doOptions();

BITMAP *swap_screen;
BITMAP *bg_screen;
BITMAP *score_screen;
DATAFILE *gfx;
Tplayfield field;
Tplayfield undo_field;
Thisc *hisc[4];					// one table for each mode
Tparticle dust[MAX_PARTICLES];	// particles for the particle engine

// head to buttons
Tbutton *buttHead;

// options
int theme=0;
int animon=0;
int soundvol=0;
int musicvol=0;
int mode;	//0=trad,1=cont,2=2trad,3=2cont
int optionsOn=0;
int optClick=0;
int widescreen = 32;

// stuff
int NUMBUB=5;
int started;
int marked=0;
int btx[4]={260,175,260,175};  // new , opt, quit, undo
int bty[4]={185,205,205,185};
int bton;
unsigned int score,showS;
unsigned int popped;
unsigned int undo_score,showS;
unsigned int undo_popped;
int undo_srand;
int undo;
char *modeStr[4] = {"TRAD","CONT","SHFT","MEGA"};
int scx,scy,sct;
int go=0, goy=-30;
int fnrg=0;
int drwscrs=0;
unsigned char globAngle=0;

Tbubble noBubble = {0,0,0,0,0,0};

// RGB -> color mapping table. Not needed, but speeds things up
RGB_MAP rgb_table;

// lighting color mapping table
COLOR_MAP dark_table;
COLOR_MAP light_table;
COLOR_MAP trans_table;
COLOR_MAP title_table;
COLOR_MAP dialog_table;

// number of current screenshot
int screen_shot=0;

// timer variables
volatile int frame_count;
volatile int fps;
volatile int game_count;

void fps_counter(void) {
	fps=frame_count;
	frame_count=0;
}
END_OF_FUNCTION(fps_counter)

void game_counter(void) {
	game_count++;
}
END_OF_FUNCTION(game_counter)


void myAlert(char *txt) {
	//PALETTE p;

	//get_palette(p);
	//set_palette(desktop_palette);
	alert("POP'EM", NULL, txt, "Cool", "Yeah", 'y', 27);
	//set_palette(p);
}

void take_screenshot(BITMAP *bmp, char *fname) {
	PALETTE p;
	BITMAP *b;

	packfile_password(NULL);
	get_palette(p);

	b = create_sub_bitmap(bmp, 0, 0, bmp->w, bmp->h);

	save_bitmap(fname, b, p);

	destroy_bitmap(b);


	packfile_password("popem");

}

int new_rand() {
    int x;
    seed = seed*MAGIC_N;
    while(seed > 0xFFFF)
        seed-=0xFFFF;
    x = (int)((seed - (int)seed) * 0xFFFF);
    return x;
}

void new_srand(int s) {
    seed = (double)s;
}

void resetScores(Thisc *table) {
	resetTable(table,"J Peitz",1000,0);
}

int load_data() {
	int ok=1;

	gfx = load_datafile("data/gfx.dat");
	if (!gfx) ok=0;

	return ok;
}

void belvelBox(BITMAP *bmp, int x1, int y1, int x2, int y2, int col) {
	rectfill(bmp,x1,y1,x2,y2,col);
    drawing_mode(DRAW_MODE_TRANS,NULL,0,0);
    color_map=&dark_table;
	line(bmp,x1,y1-1,x2,y1-1,170);
	line(bmp,x1-1,y1-1,x1-1,y2,170);
    color_map=&light_table;
	line(bmp,x2+1,y1,x2+1,y2+1,170);
	line(bmp,x1,y2+1,x2,y2+1,170);
    solid_mode();
}

void createBg() {
	int i;
	draw_sprite(bg_screen,gfx[PAT01].dat,0,0);
	rectfill(bg_screen,19,9,219,169,0);
    drawing_mode(DRAW_MODE_TRANS,NULL,0,0);
    color_map=&dark_table;
	for(i=1;i<5;i++) rectfill(bg_screen,19-i,9-i,219+i,169+i,60+i*40);
    solid_mode();

	belvelBox(bg_screen,240,20,310,35,0);
	belvelBox(bg_screen,240,70,310,85,0);
	belvelBox(bg_screen,240,120,310,135,0);
	//belvelBox(bg_screen,240,140,290,150,0);

    color_map=&title_table;
	draw_trans_sprite(bg_screen,gfx[TITLE].dat,20+1,180);
	draw_trans_sprite(bg_screen,gfx[TITLE].dat,20-1,180);
	//draw_trans_sprite(bg_screen,gfx[TITLE].dat,20,180+1);
	//draw_trans_sprite(bg_screen,gfx[TITLE].dat,20,180-1);
	draw_sprite(bg_screen,gfx[TITLE].dat,20,180);
	draw_sprite(bg_screen,gfx[TEXT000].dat,235,13);
	draw_sprite(bg_screen,gfx[TEXT001].dat,235,63);
	draw_sprite(bg_screen,gfx[TEXT002].dat,235,113);
	//draw_sprite(bg_screen,gfx[TEXT003].dat,235,133);

	for(i=0;i<4;i++) {
		draw_sprite(bg_screen,gfx[BUTTON01].dat,btx[i],bty[i]);
		draw_sprite(bg_screen,gfx[TEXT004+i].dat,btx[i] + 20,bty[i] + 3);
	}
}

void resetParticles() {
	int i;
	for(i=0;i<MAX_PARTICLES;i++)
		dust[i].exist = 0;
}

void loadCFG() {
	PACKFILE *fp;
	int i;

	fp = pack_fopen("popem.sav", "rp");
	if (!fp) {
		soundvol=200;
		musicvol=100;
		mode = 0;
		animon = 1;
		theme = 0;
		widescreen = 0;
	}
	else {
		pack_fread(&soundvol, 1, fp);
		pack_fread(&musicvol, 1, fp);
		pack_fread(&mode, 1, fp);
		pack_fread(&theme, 1, fp);
		pack_fread(&animon, 1, fp);
		pack_fread(&widescreen, 1, fp);
		pack_fclose(fp);
		if (widescreen != 1) widescreen = 0;
	}

	for(i=0;i<4;i++) {
		char str[40];
		sprintf(str,"scores%d.sav",i);
		hisc[i] = makeTable();
		if (!loadTable(hisc[i],str)) resetScores(hisc[i]);
	}

}

void saveCFG() {
	PACKFILE *fp;
	int i;

	for(i=0;i<4;i++) {
		char str[40];
		sprintf(str,"scores%d.sav",i);
		saveTable(hisc[i],str);
	}

	fp = pack_fopen("popem.sav", "wp");
	pack_fwrite(&soundvol, 1, fp);
	pack_fwrite(&musicvol, 1, fp);
	pack_fwrite(&mode, 1, fp);
	pack_fwrite(&theme, 1, fp);
	pack_fwrite(&animon, 1, fp);
	pack_fwrite(&widescreen, 1, fp);
	pack_fclose(fp);
}

void init() {
	allegro_init();

	packfile_password("popem");

	if (!load_data()) { allegro_message("Failed to load data."); exit(1); }

	install_keyboard();

	install_timer();
	LOCK_VARIABLE(game_count);
	LOCK_VARIABLE(fps);
	LOCK_VARIABLE(frame_count);
	LOCK_VARIABLE(level_time);
	LOCK_FUNCTION(fps_counter);
	install_int(fps_counter,1000);
	fps=0;
	frame_count=0;
	LOCK_FUNCTION(game_counter);
	install_int(game_counter,15);
	game_count=0;

	swap_screen  = create_bitmap(320,240);
	bg_screen    = create_bitmap(320,240);
	score_screen = create_bitmap(200,50);

	install_mouse();

	install_sound(DIGI_AUTODETECT,MIDI_AUTODETECT,NULL);

	createBg();
	text_mode(-1);
	new_srand(42);

	create_rgb_table(&rgb_table, gfx[0].dat, NULL);
	rgb_map = &rgb_table;
	create_light_table(&dark_table, gfx[0].dat, 2, 2, 2, NULL);
	create_light_table(&light_table, gfx[0].dat, 62, 62, 62, NULL);
	create_trans_table(&trans_table, gfx[0].dat, 190, 190, 190, NULL);
	create_trans_table(&dialog_table, gfx[0].dat, 220, 220, 220, NULL);
	create_trans_table(&title_table, gfx[0].dat, 63, 63, 63, NULL);
	drawing_mode(DRAW_MODE_TRANS,NULL,0,0);

	loadCFG();
	set_volume(-1,musicvol);


	if (widescreen) {
		if (set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0) < 0) widescreen = 0;
	}

	if (widescreen == 0) {
		if (set_gfx_mode(GFX_AUTODETECT, 320, 240, 0, 0) < 0) {
			allegro_message("Failed to set graphics mode.");
			exit(1);
		}
	}

	resetParticles();
	buttHead = createButtHead();
	addButton(buttHead, gfx, OARROWL, OARROWL, 30, 62, 1);
	addButton(buttHead, gfx, OARROWR, OARROWR, 190, 62, 2);
	addButton(buttHead, gfx, OARROWL, OARROWL, 30, 97, 3);
	addButton(buttHead, gfx, OARROWR, OARROWR, 190, 97, 4);
	addButton(buttHead, gfx, OBOX, OBOX, 22, 120, 5);
	addButton(buttHead, gfx, OFX, OFX, 160, 40, 7);
	addButton(buttHead, gfx, OMUSIC, OMUSIC, 160, 20, 6);
	addButton(buttHead, gfx, OOK, OOK, 190, 160, 8);
	addButton(buttHead, gfx, OBOX, OBOX, 22, 145, 9);

}

void shutdown() {
	fade_out(16);
	saveCFG();
	destroy_bitmap(swap_screen);
	allegro_exit();
}

void pause_game() {
	midi_pause();
	while(!key[KEY_PAUSE]);
	rectfill(screen,0,0,SCREEN_W,SCREEN_H,100);
	textout_centre(screen,font,"GAME PAUSED",160,80,-1);
	while(key[KEY_PAUSE]);
	midi_resume();
}

int title() {
	return 3;
}

void createParticle(int x,int y,int col,int str,int type) {
	int i=0;
	fixed r;
	int s=new_rand()%str+1;

	while(dust[i].exist && i<MAX_PARTICLES-1) i++;  // find available i

	r = itofix(new_rand()%256);

	dust[i].x = itofix(x);
	dust[i].y = itofix(y);
	dust[i].dx = fcos(r)*s;
	dust[i].dy = fsin(r)*s;
	dust[i].color = col;
	dust[i].type = type;
	dust[i].exist = 1;
}

void drawParticles() {
	int i,x,y;

    drawing_mode(DRAW_MODE_TRANS,NULL,0,0);
    color_map=&trans_table;
	for(i=0;i<MAX_PARTICLES;i++)
		if (dust[i].exist) {
			if (dust[i].type==1)
				putpixel(swap_screen, fixtoi(dust[i].x), fixtoi(dust[i].y), dust[i].color);
			else
				draw_sprite(swap_screen,gfx[BUBBLE000+dust[i].color].dat,fixtoi(dust[i].x), fixtoi(dust[i].y));
			dust[i].x += dust[i].dx;
			dust[i].y += dust[i].dy;
			dust[i].dy += fsin(itofix(2));
			x = fixtoi(dust[i].x);
			y = fixtoi(dust[i].y);
			if (y > 240 || x>320 || x<-20) dust[i].exist = 0;
		}
	solid_mode();
}

void drawScores() {
	int i;

	textout_centre(swap_screen,gfx[MYFONT].dat,"HIGH SCORES",120,8,-1);
	for(i=0;i<MAX_SCORES;i++) {
		textprintf(swap_screen,gfx[MYFONT].dat,21+fixtoi(4*fcos(itofix(globAngle*4+i*21))),26+i*14,-1,"%s",hisc[mode][i].name);
		textprintf_right(swap_screen,gfx[MYFONT].dat,218-fixtoi(4*fcos(itofix(globAngle*4+i*21))),26+i*14,-1,"%5d",hisc[mode][i].score);
	}
}

void drawScreen(int showMouse) {
	int x,y;
	int mx = (widescreen ? mouse_x >> 1 : mouse_x);
	int my = (widescreen ? mouse_y >> 1 : mouse_y);

	// fps and stuff
	frame_count++;
	globAngle++;

	blit(bg_screen,swap_screen,0,0,0,0,320,240);

	color_map = &dark_table;
	// draw bubbles
	for(x=0;x<WIDTH;x++)
		for(y=0;y<HEIGHT;y++) {
			if (field.pos[x][y].value) {
				if (field.pos[x][y].glow>0) {
					color_map = &light_table;
					draw_lit_sprite(swap_screen,gfx[BUBBLE000+field.pos[x][y].value+theme*5].dat,20+x*20+new_rand()%3-1,10+y*20+new_rand()%3-1,field.pos[x][y].glow);
				}
				else if (field.pos[x][y].fade>0) draw_lit_sprite(swap_screen,gfx[BUBBLE000+field.pos[x][y].value+theme*5].dat,20+x*20+new_rand()%3-1,10+y*20+new_rand()%3-1,field.pos[x][y].fade);
				else if (field.pos[x][y].fade<0) stretch_sprite(swap_screen,gfx[BUBBLE000+field.pos[x][y].value+theme*5].dat,20+x*20-(field.pos[x][y].fade>>1),10+y*20-(field.pos[x][y].fade>>1),19+field.pos[x][y].fade,19+field.pos[x][y].fade);
				else {
					if (!field.pos[x][y].selected) draw_sprite(swap_screen,gfx[BUBBLE000+theme*5+field.pos[x][y].value].dat,20+x*20+field.pos[x][y].dx,10+y*20+field.pos[x][y].dy);
					else draw_sprite(swap_screen,gfx[BUBBLE000+theme*5+field.pos[x][y].value].dat,20+x*20+new_rand()%3-1,10+y*20+new_rand()%3-1);
				}
				if (field.pos[x][y].dx > 0) field.pos[x][y].dx-=4;
				else if (field.pos[x][y].dx < 0) field.pos[x][y].dx+=4;
				else if (field.pos[x][y].dy > 0) field.pos[x][y].dy-=4;
				else if (field.pos[x][y].dy < 0) field.pos[x][y].dy+=4;
			}
		}

	// draw score
	if (sct) {
		color_map = &trans_table;
		draw_trans_sprite(swap_screen,score_screen,scx,scy);
		sct--;
		if (!sct && showS>30 && animon) {
			for (x=0;x<50*(int)((showS/100)+1);x++) createParticle(110+new_rand()%20,70+new_rand()%20,15,(showS/100)*3+1,1);
		}
	}

	//draw buttons
	if (bton >= 0 && bton < 4)
		draw_sprite(swap_screen,gfx[BUTTON02].dat,btx[bton],bty[bton]);



	// draw high score
	if (drwscrs) drawScores();

	// draw game over
	if (go || goy>-30) {
		color_map = &trans_table;
		draw_trans_sprite(swap_screen,gfx[GAMEOVER].dat,24,goy);
		if (go && goy<70) goy+=2;
		if (!go) goy-=2;
	}

	textprintf_right(swap_screen,gfx[MYFONT].dat,310,19,-1,"%d",score);
	textprintf_right(swap_screen,gfx[MYFONT].dat,310,69,-1,"%d",popped);
	textprintf_right(swap_screen,gfx[MYFONT].dat,310,119,-1,"%s",modeStr[mode]);

	// show POPEM_VERSION_STR
	textprintf_right(swap_screen,gfx[FONT_SML].dat,317,2,68,"%s",POPEM_VERSION_STR);

	// draw particles
	drawParticles();

	// options is up?
	if (optionsOn) doOptions();

	// draw mouse
	if (showMouse) draw_sprite(swap_screen,gfx[POINTER].dat,mx,my);
}

void blitScreen() {
	vsync();
	acquire_screen();
	if (widescreen)
		stretch_blit(swap_screen,screen,0,0,320,240,0,0,640,480);
	else
		blit(swap_screen,screen,0,0,0,0,320,240);
	release_screen();
}

void randFill() {
	int x,y;

	for(x=0;x<WIDTH;x++)
		for(y=0;y<HEIGHT;y++) {
			field.pos[x][y].dx =
			field.pos[x][y].dy = 0;
			field.pos[x][y].value = 1+(rand()%NUMBUB);
		}
}

void pack() {
	int z,x,y,i=0,j;

	for(x=0;x<WIDTH;x++) if (!field.pos[x][HEIGHT-1].value) i++;

	for(j=0;j<i;j++) {
		z=WIDTH-1;
		while(field.pos[z][HEIGHT-1].value) z--;
		for(x=z;x>0;x--)
			for(y=0;y<HEIGHT;y++) {
				field.pos[x][y] = field.pos[x-1][y];
				field.pos[x-1][y] = noBubble;
				if (animon && field.pos[x][y].value) field.pos[x][y].dx = -20;
			}
		if (mode==1 || mode==3)
			for(y=0;y<HEIGHT;y++) {
				field.pos[0][y].value = 1+rand()%NUMBUB;
			}
	}
}

void yfall() {
	int x,y,i;

	for(x=0;x<WIDTH;x++)
		for(i=0;i<HEIGHT;i++)
			for(y=HEIGHT-1;y>0;y--)
				if (field.pos[x][y].value==0) {
					field.pos[x][y] = field.pos[x][y-1];
					field.pos[x][y-1] = noBubble;
					if (animon && field.pos[x][y].value) field.pos[x][y].dy -= 20;
				}
}

void xfall() {
	int x,y,i;

	for(y=0;y<HEIGHT;y++)
		for(i=0;i<WIDTH;i++)
			for(x=WIDTH-1;x>0;x--)
				if (field.pos[x][y].value==0) {
					field.pos[x][y] = field.pos[x-1][y];
					field.pos[x-1][y] = noBubble;
					if (animon && field.pos[x][y].value) field.pos[x][y].dx -= 20;
				}
}

void push(int fadeSpeed) {
	int x,y,i;

	if (animon) {
		for(i=50;i<255;i+=fadeSpeed) {
			for(x=0;x<WIDTH;x++)
				for(y=0;y<HEIGHT;y++)
					field.pos[x][y].fade = i;
			drawScreen(1);
			blitScreen();
		}
	}
	for(x=0;x<WIDTH;x++)
		for(y=0;y<HEIGHT;y++)
			field.pos[x][y].glow =
			field.pos[x][y].fade = 0;
}

void pop(int fadeSpeed, int type) {
	int x,y,i;

	if (animon) {
		switch(type) {
			case 1: { // fade
				play_sample(gfx[SKLICK].dat,soundvol,128,800+new_rand()%400,0);
				for(i=250;i>=50;i-=fadeSpeed) {
					drawScreen(1);
					blitScreen();
					for(x=0;x<WIDTH;x++)
						for(y=0;y<HEIGHT;y++)
							if (field.pos[x][y].selected)
								field.pos[x][y].fade = i;
				}
				break;
			}
			case 2: {  // make bubble particles
				play_sample(gfx[SPOP3].dat,soundvol,128,800+new_rand()%400,0);
				for(x=0;x<WIDTH;x++)
					for(y=0;y<HEIGHT;y++)
						if (field.pos[x][y].selected)
							createParticle(20+x*20,10+y*20,field.pos[x][y].value+theme*5,3,2);
				break;
			}
			case 3: {  // shrink
				play_sample(gfx[SPOP2].dat,soundvol,128,800+new_rand()%400,0);
				for(i=1;i<20;i++) {
					drawScreen(1);
					blitScreen();
					for(x=0;x<WIDTH;x++)
						for(y=0;y<HEIGHT;y++)
							if (field.pos[x][y].selected)
								field.pos[x][y].fade = -i;
				}
				break;
			}
			case 4: { // fade to white and then explode
				play_sample(gfx[SPOP4].dat,soundvol,128,800,0);
				for(i=255;i>=0;i-=fadeSpeed) {
					drawScreen(1);
					blitScreen();
					for(x=0;x<WIDTH;x++)
						for(y=0;y<HEIGHT;y++)
							if (field.pos[x][y].selected)
								field.pos[x][y].glow = i;
				}
				play_sample(gfx[SPOP5].dat,soundvol,128,1000,0);
				for(x=0;x<WIDTH;x++)
					for(y=0;y<HEIGHT;y++)
						if (field.pos[x][y].selected)
							for(i=0;i<20;i++)
								createParticle(25+x*20,15+y*20,15,4,1);
				break;
			}
		}
	}


	for(x=0;x<WIDTH;x++)
		for(y=0;y<HEIGHT;y++) {
			if (field.pos[x][y].selected) {
				field.pos[x][y].value = 0;
			}
		}
}

int unmark() {
	int x,y;
	for(x=0;x<WIDTH;x++)
		for(y=0;y<HEIGHT;y++) {
			field.pos[x][y].selected =
			field.pos[x][y].fade =
			field.pos[x][y].glow = 0;
		}
	return 0;
}

int mark(int x, int y) {
	int v=1;
	Tbubble me = field.pos[x][y];

	field.pos[x][y].selected = 1;

	if (x<WIDTH-1)
		if(field.pos[x+1][y].value == me.value && !field.pos[x+1][y].selected)
			v+=mark(x+1,y);
	if (x>0)
		if(field.pos[x-1][y].value == me.value && !field.pos[x-1][y].selected)
			v+=mark(x-1,y);
	if (y<HEIGHT-1)
		if(field.pos[x][y+1].value == me.value && !field.pos[x][y+1].selected)
			v+=mark(x,y+1);
	if (y>0)
		if(field.pos[x][y-1].value == me.value && !field.pos[x][y-1].selected)
			v+=mark(x,y-1);

	return v;
}

int isEmpty() {
	int x,y;

	for(x=0;x<WIDTH;x++)
		for(y=0;y<HEIGHT;y++)
			if (field.pos[x][y].value) return 0;

	return 1;
}

int isPlayable() {
	int x,y;

	for(x=0;x<WIDTH;x++)
		for(y=0;y<HEIGHT;y++) {
			int v = field.pos[x][y].value;
			if (v) {
				if (x<WIDTH-1)
					if(field.pos[x+1][y].value == v) return 1;
				if (x>0)
					if(field.pos[x-1][y].value == v) return 1;
				if (y<HEIGHT-1)
					if(field.pos[x][y+1].value == v) return 1;
				if (y>0)
					if(field.pos[x][y-1].value == v) return 1;
			}
		}

	return 0;
}

void startNewGame() {
	score=0;
	popped=0;
	sct=0;
	randFill();
	unmark();
	started=2;
}

void showScore(int s, int bx, int by) {
	char str[10];
	int i=0,x=0;

	showS = s;

	clear(score_screen);

	sprintf(str,"%d",s);

	while(str[i]!='\0') {
		draw_sprite(score_screen,gfx[NUM000+str[i]-48].dat,x,50-((BITMAP*)gfx[NUM000+str[i]-48].dat)->h);
		x+=((BITMAP*)gfx[NUM000+str[i]-48].dat)->w;
		i++;
	}
	scy=50;
	scx=120-(x>>1);
	sct=50;
}

int yesNoOption(char *row1, char *row2) {
	int len1 = 0;
	int len2 = 0;
	int done=0;
	int w, h=70;
	int mx,my,i;
	BITMAP *bmp;

	if (row1 != NULL) len1 = text_length(gfx[MYFONT].dat,row1);
	if (row2 != NULL) len2 = text_length(gfx[MYFONT].dat,row2);
	w = MAX(len1,len2)+20;
	bmp = create_bitmap(w+1,h+1);
	clear_to_color(bmp,9);

	belvelBox(bmp,3,3,w-3,h-3,7);
	belvelBox(bmp,84-(160-w/2),45,140-(160-w/2),62,9);
	belvelBox(bmp,190-(160-w/2),45,236-(160-w/2),62,9);
	//	blit(gfx[PAT01].dat,bmp,0,0,0,0,w,h);
	rect(bmp,0,0,w,h,1);

	play_sample(gfx[SPOP1].dat,soundvol,128,800+new_rand()%400,0);
	for(i=-w;i<160-w/2;i+=8) {
		mx = (widescreen ? mouse_x >> 1 : mouse_x);
		my = (widescreen ? mouse_y >> 1 : mouse_y);
		drawScreen(0);
		color_map = &dialog_table;
		draw_trans_sprite(swap_screen,bmp,i,70);
		if (row1 != NULL) textprintf_centre(swap_screen,gfx[MYFONT].dat,i+w/2,70+5,-1,"%s",row1);
		if (row2 != NULL) textprintf_centre(swap_screen,gfx[MYFONT].dat,i+w/2,70+20,-1,"%s",row2);
		textprintf_centre(swap_screen,gfx[MYFONT].dat,i+w/2,70+45,-1,"%s   %s","Yes!","No!");
		draw_sprite(swap_screen,gfx[POINTER].dat,mx,my);
		blitScreen();
	}
	while (!done) {
		mx = (widescreen ? mouse_x >> 1 : mouse_x);
		my = (widescreen ? mouse_y >> 1 : mouse_y);
		drawScreen(0);
		color_map = &dialog_table;
		draw_trans_sprite(swap_screen,bmp,160-w/2,70);
		if (row1 != NULL) textprintf_centre(swap_screen,gfx[MYFONT].dat,160,70+5,-1,"%s",row1);
		if (row2 != NULL) textprintf_centre(swap_screen,gfx[MYFONT].dat,160,70+20,-1,"%s",row2);
		textprintf_centre(swap_screen,gfx[MYFONT].dat,160,70+45,-1,"%s   %s","Yes!","No!");
		draw_sprite(swap_screen,gfx[POINTER].dat,mx,my);
		//textprintf(swap_screen,font,160-w/2,70,2,"%d,%d",mx,my);
		blitScreen();
		if (mouse_b==1)
			if (my>=115 && my<=130) {
				if (mx>=85 && mx<=140) done = 2;	// yes!
				if (mx>=190 && mx<=240) done = 1;	// no...
			}
	}
	play_sample(gfx[SKLICK].dat,soundvol,128,800+new_rand()%400,0);
	while(mouse_b);
	play_sample(gfx[SPOP1].dat,soundvol,128,800+new_rand()%400,0);
	if (done == 2)
		for(i=160-w/2;i<320;i+=8) {
			mx = (widescreen ? mouse_x >> 1 : mouse_x);
			my = (widescreen ? mouse_y >> 1 : mouse_y);
			drawScreen(0);
			color_map = &dialog_table;
			draw_trans_sprite(swap_screen,bmp,i,70);
			if (row1 != NULL) textprintf_centre(swap_screen,gfx[MYFONT].dat,i+w/2,70+5,-1,"%s",row1);
			if (row2 != NULL) textprintf_centre(swap_screen,gfx[MYFONT].dat,i+w/2,70+20,-1,"%s",row2);
			textprintf_centre(swap_screen,gfx[MYFONT].dat,i+w/2,70+45,-1,"%s   %s","Yes!","No!");
			draw_sprite(swap_screen,gfx[POINTER].dat,mx,my);
			blitScreen();
		}
	else
		for(i=160-w/2;i>-w;i-=8) {
			mx = (widescreen ? mouse_x >> 1 : mouse_x);
			my = (widescreen ? mouse_y >> 1 : mouse_y);
			drawScreen(0);
			color_map = &dialog_table;
			draw_trans_sprite(swap_screen,bmp,i,70);
			if (row1 != NULL) textprintf_centre(swap_screen,gfx[MYFONT].dat,i+w/2,70+5,-1,"%s",row1);
			if (row2 != NULL) textprintf_centre(swap_screen,gfx[MYFONT].dat,i+w/2,70+20,-1,"%s",row2);
			textprintf_centre(swap_screen,gfx[MYFONT].dat,i+w/2,70+45,-1,"%s   %s","Yes!","No!");
			draw_sprite(swap_screen,gfx[POINTER].dat,mx,my);
			blitScreen();
		}

	if (done==2) return 1;
	return 0;
}

void inputOption(char *row1, char *row2) {
	int len1=0;
	int len2=0;
	int w, h=50;
	int mx,my;
	int i,kp=0;
	BITMAP *bmp;

	if (row1 != NULL) len1 = text_length(gfx[MYFONT].dat,row1);
	if (row2 != NULL) len2 = text_length(gfx[MYFONT].dat,row2);
	w = MAX(len1,len2)+20;

	bmp = create_bitmap(w+1,h+1);
	clear_to_color(bmp,9);

	belvelBox(bmp,3,3,w-3,h-3,7);
	//	blit(gfx[PAT01].dat,bmp,0,0,0,0,w,h);
	rect(bmp,0,0,w,h,1);

	for(i=-w;i<160-w/2;i+=8) {
		mx = (widescreen ? mouse_x >> 1 : mouse_x);
		my = (widescreen ? mouse_y >> 1 : mouse_y);
		drawScreen(0);
		color_map = &dialog_table;
		draw_trans_sprite(swap_screen,bmp,i,70);
		if (row1 != NULL) textprintf_centre(swap_screen,gfx[MYFONT].dat,i+w/2,70+5,-1,"%s",row1);
		if (row2 != NULL) textprintf_centre(swap_screen,gfx[MYFONT].dat,i+w/2,70+24,-1,"%s",row2);
		draw_sprite(swap_screen,gfx[POINTER].dat,mx,my);
		blitScreen();
	}

	// actual typing goes here

	i=0; clear_keybuf();
	do {
		mx = (widescreen ? mouse_x >> 1 : mouse_x);
		my = (widescreen ? mouse_y >> 1 : mouse_y);
		drawScreen(0);
		color_map = &dialog_table;
		draw_trans_sprite(swap_screen,bmp,160-w/2,70);
		if (row1 != NULL) textprintf_centre(swap_screen,gfx[MYFONT].dat,160,70+5,-1,"%s",row1);
		if (row2 != NULL) textprintf_centre(swap_screen,gfx[MYFONT].dat,160,70+24,-1,"%s",row2);
		draw_sprite(swap_screen,gfx[POINTER].dat,mx,my);
		//textprintf(swap_screen,font,160-w/2,70,2,"%d,%d",mx,my);
		blitScreen();

		// OK, screen is drawn. Let's handle those keys!
		if (keypressed()) {
			play_sample(gfx[SKLICK].dat,soundvol,128,800+new_rand()%400,0);
			kp=readkey();
			row2[i]=(kp & 0xff);
			if (kp>>8==KEY_BACKSPACE) { row2[i]='\0'; i--; }
			else i++;
			i=MAX(0,MIN(10,i));
			row2[i]='_';
			row2[i+1]='\0';
			if ((kp>>8)==KEY_ENTER) row2[i]='\0';
		}
	} while((kp>>8)!=KEY_ENTER);
	if (i<11) row2[i-1]='\0';

	play_sample(gfx[SPOP1].dat,soundvol,128,800+new_rand()%400,0);
	for(i=160-w/2;i<320;i+=8) {
		mx = (widescreen ? mouse_x >> 1 : mouse_x);
		my = (widescreen ? mouse_y >> 1 : mouse_y);
		drawScreen(0);
		color_map = &dialog_table;
		draw_trans_sprite(swap_screen,bmp,i,70);
		if (row1 != NULL) textprintf_centre(swap_screen,gfx[MYFONT].dat,i+w/2,70+5,-1,"%s",row1);
		if (row2 != NULL) textprintf_centre(swap_screen,gfx[MYFONT].dat,i+w/2,70+24,-1,"%s",row2);
		draw_sprite(swap_screen,gfx[POINTER].dat,mx,my);
		blitScreen();
	}
}


void okOption(char *row1, char *row2) {
	int len1=0;
	int len2=0;
	int done=0;
	int w, h=70;
	int mx,my;
	int i;
	BITMAP *bmp;

	if (row1 != NULL) len1 = text_length(gfx[MYFONT].dat,row1);
	if (row2 != NULL) len2 = text_length(gfx[MYFONT].dat,row2);
	w = MAX(len1,len2)+20;

	bmp = create_bitmap(w+1,h+1);
	clear_to_color(bmp,9);

	belvelBox(bmp,3,3,w-3,h-3,7);
	belvelBox(bmp,137-(160-w/2),45,184-(160-w/2),62,9);
	//	blit(gfx[PAT01].dat,bmp,0,0,0,0,w,h);
	rect(bmp,0,0,w,h,1);

	play_sample(gfx[SPOP1].dat,soundvol,128,800+new_rand()%400,0);
	for(i=-w;i<160-w/2;i+=8) {
		mx = (widescreen ? mouse_x >> 1 : mouse_x);
		my = (widescreen ? mouse_y >> 1 : mouse_y);
		drawScreen(0);
		color_map = &dialog_table;
		draw_trans_sprite(swap_screen,bmp,i,70);
		if (row1 != NULL) textprintf_centre(swap_screen,gfx[MYFONT].dat,i+w/2,70+5,-1,"%s",row1);
		if (row2 != NULL) textprintf_centre(swap_screen,gfx[MYFONT].dat,i+w/2,70+20,-1,"%s",row2);
		textprintf_centre(swap_screen,gfx[MYFONT].dat,i+w/2,70+45,-1,"%s","OK!");
		draw_sprite(swap_screen,gfx[POINTER].dat,mx,my);
		blitScreen();
	}
	while (!done) {
		mx = (widescreen ? mouse_x >> 1 : mouse_x);
		my = (widescreen ? mouse_y >> 1 : mouse_y);
		drawScreen(0);
		color_map = &dialog_table;
		draw_trans_sprite(swap_screen,bmp,160-w/2,70);
		if (row1 != NULL) textprintf_centre(swap_screen,gfx[MYFONT].dat,160,70+5,-1,"%s",row1);
		if (row2 != NULL) textprintf_centre(swap_screen,gfx[MYFONT].dat,160,70+20,-1,"%s",row2);
		textprintf_centre(swap_screen,gfx[MYFONT].dat,160,70+45,-1,"%s","OK!");
		draw_sprite(swap_screen,gfx[POINTER].dat,mx,my);
		//textprintf(swap_screen,font,160-w/2,70,2,"%d,%d",mx,my);
		blitScreen();
		if (mouse_b==1 && my>=115 && my<=130 && mx>=140 && mx<=180) done = 1;
	}
	play_sample(gfx[SKLICK].dat,soundvol,128,800+new_rand()%400,0);
	while(mouse_b);
	play_sample(gfx[SPOP1].dat,soundvol,128,800+new_rand()%400,0);
	for(i=160-w/2;i<320;i+=8) {
		mx = (widescreen ? mouse_x >> 1 : mouse_x);
		my = (widescreen ? mouse_y >> 1 : mouse_y);
		drawScreen(0);
		color_map = &dialog_table;
		draw_trans_sprite(swap_screen,bmp,i,70);
		if (row1 != NULL) textprintf_centre(swap_screen,gfx[MYFONT].dat,i+w/2,70+5,-1,"%s",row1);
		if (row2 != NULL) textprintf_centre(swap_screen,gfx[MYFONT].dat,i+w/2,70+20,-1,"%s",row2);
		textprintf_centre(swap_screen,gfx[MYFONT].dat,i+w/2,70+45,-1,"%s","OK!");
		draw_sprite(swap_screen,gfx[POINTER].dat,mx,my);
		blitScreen();
	}
}

void doOptions() {
	char *modes[4] = {"Traditional","Continous","Shifter","Megashifter"};
	char *themes[5] = {"Original","Dice","Squares","X-mas","Pacmania"};
	int id=0;
	int s = soundvol, m = musicvol;
	int mx = (widescreen ? mouse_x >> 1 : mouse_x);
	int my = (widescreen ? mouse_y >> 1 : mouse_y);


    drawing_mode(DRAW_MODE_TRANS,NULL,0,0);
    color_map=&dialog_table;
	rectfill(swap_screen,17,7,221,61,6);
	if (started != 1) rectfill(swap_screen,17,62,221,90,6);
	rectfill(swap_screen,17,91,221,171,6);
	solid_mode();

	textout(swap_screen,gfx[MYFONT].dat,"OPTIONS",20,8,-1);

	id = updateButtons(buttHead, mx, my);

	textout(swap_screen,gfx[MYFONT].dat,"Mode", 20, 43, -1);
	textprintf(swap_screen,gfx[MYFONT].dat,42,60,-1,"%s",modes[mode]);
	if (started==1) {
	    drawing_mode(DRAW_MODE_TRANS,NULL,0,0);
	    color_map=&dialog_table;
		rectfill(swap_screen,17,62,221,90,6);
		solid_mode();
	}

	textout(swap_screen,gfx[MYFONT].dat,"Theme", 20, 78, -1);
	textprintf(swap_screen,gfx[MYFONT].dat,42,95,-1,"%s",themes[theme]);

	draw_sprite(swap_screen, gfx[OBAR].dat, 150, 28);
	draw_sprite(swap_screen, gfx[OBAR].dat, 150, 48);

	setButtonPos(buttHead, 6, 150-6+musicvol/5, -1);
	setButtonPos(buttHead, 7, 150-6+soundvol/5, -1);

	color_map = &light_table;
	drawButtons(swap_screen, gfx, buttHead);

	if (animon) draw_sprite(swap_screen, gfx[OCHECK].dat, 22, 118);
	textout(swap_screen,gfx[MYFONT].dat,"Animations", 42, 118, -1);

	if (widescreen) draw_sprite(swap_screen, gfx[OCHECK].dat, 22, 118+25);
	textout(swap_screen,gfx[MYFONT].dat,"Stretch", 42, 118+25, -1);

	if (mouse_b==1) {
		if (!optClick) {
			if (id==1 && mode > 0 && started!=1) mode--;
			if (id==2 && mode < 3 && started!=1) mode++;
			if (id==3 && theme > 0) theme--;
			if (id==4 && theme < 4) theme++;
			if (id==5) animon = (animon?0:1);
			if (id==8) optionsOn = 0;
			if (id==9) {
				widescreen = (widescreen?0:1);
				if (widescreen) {
					set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0);
					set_palette(gfx[0].dat);
				}
				else {
					set_gfx_mode(GFX_AUTODETECT, 320, 240, 0, 0);
					set_palette(gfx[0].dat);
				}
			}
			if (id) play_sample(gfx[SKLICK].dat,soundvol,128,800+new_rand()%400,0);
		}
		if (id==6) musicvol=MIN(MAX((mx-150)*5,0),255);
		if (id==7) soundvol=MIN(MAX((mx-150)*5,0),255);
		if (m!=musicvol || soundvol!=s) {
			set_volume(-1,musicvol);
			if (s!=soundvol) play_sample(gfx[SKLICK].dat,soundvol,128,800+new_rand()%400,0);
		}
		optClick = 1;
	}
	else {
		optClick = 0;
	}
}

void options() {
	optionsOn = 1;
	while(optionsOn) {
		drawScreen(1);
		blitScreen();
	}
}

int checkButtons() {
	int done = 0;
	int mx = (widescreen ? mouse_x >> 1 : mouse_x);
	int my = (widescreen ? mouse_y >> 1 : mouse_y);
	int mb = mouse_b;
	int i;

	bton=-1;
	for(i=0;i<4;i++)
		if (mx>btx[i] && mx<btx[i]+17 && my>bty[i] && my<bty[i]+17)
			bton=i;

	if (bton>=0 && mb)
		play_sample(gfx[SKLICK].dat,soundvol,128,800+new_rand()%400,0);

	if (bton==0 && mb==1) done = (started==1 ? (yesNoOption("This will start a","new game. Restart?") ? 1 : 0) : 1);
	if (bton==1 && mb==1) options();
	if (bton==2 && mb==1) done = (yesNoOption("Are you sure you","want to quit?") ? 3 : 0);
	if (bton==3 && mb==1) undo = TRUE;

	if (bton>=0 && mb)
		while(mouse_b);

	return done;
}

int showScores() {
	int done=0;

	drwscrs=1;
	while(!done) {
		drawScreen(1);
		blitScreen();
		done=checkButtons(0);		// 1 == new game, 3= quit
		if(key[KEY_0]) mode=0;
		if(key[KEY_1]) mode=1;
		if(key[KEY_2]) mode=2;
		if(key[KEY_3]) mode=3;
	}
	drwscrs=0;

	return done;
}

int play() {
	int mx,my,mb,bx,by;
	int done=0;
	int mclick=0;
	int next_srand;
	int dummy;

	undo_srand = next_srand = rand()%99999;
	while (!done) {
		dummy = rand();
		mx = (widescreen ? mouse_x >> 1 : mouse_x);
		my = (widescreen ? mouse_y >> 1 : mouse_y);
		mb = mouse_b;
		game_count=0;
		drawScreen(1);
		blitScreen();

		bx=(mx-20)/20;
		by=(my-10)/20;
		if (bx>=0 && bx<WIDTH && by>=0 && by<HEIGHT) {
			fnrg = field.pos[bx][by].dy;
			if (mb==1 && mclick==0) {
				marked = unmark();
				if (field.pos[bx][by].value) { marked = mark(bx,by); mclick=1; }
				if (marked==1) { marked = unmark(); mclick=0; }
				if (marked) play_sample(gfx[SKLICK].dat,soundvol,128,800+new_rand()%400,0);
			}
			if (mb==1 && mclick==2) {
				if (field.pos[bx][by].selected && marked>1) {
					started = 1;
					undo_field = field;
					undo_score = score;
					undo_popped = popped;
					srand(next_srand);
					undo_srand = next_srand;
					score += (marked-1)*(marked+1);
					popped += marked;
					showScore((marked-1)*(marked+1),bx,by);
					if (showS<50) pop(10,1);
					else if (showS<100) pop(0,3);
					else if (showS<150) pop(0,2);
					else pop(5,4);
					yfall();
					pack();
					if (mode>1) xfall();
					next_srand = rand()%99999;
				}
				marked = unmark();
				mclick=3;
			}
		}
		if (mb==0 && mclick==1) mclick=2;
		if (mb==0 && mclick==3) mclick=0;


		//check buttons
		undo = 0;
		done = checkButtons();
		if ((undo || key[KEY_U]) && popped) {
			field = undo_field;
			score = undo_score;
			popped = undo_popped;
			marked = unmark();
			next_srand = undo_srand;
		}

		if (!isPlayable()) {
			if (isEmpty()) {
				okOption("WOW! Empty board!","250 bonus pts!!!");
				score += 250;
			}
			done=2;
		}

		if (key[KEY_F1]) take_screenshot(swap_screen, "popem.pcx");
		while(!game_count);
	}
	started = 0;

	if (done==2) {
		Thisc tmp;
		strcpy(tmp.name, "_");
		tmp.score = score;
		while(sct || mouse_b) {
			drawScreen(1);
			blitScreen();
		}
		goy = -30;
		go = 1;
		while(!mouse_b) {
			drawScreen(1);
			blitScreen();
		}
		go = 0;
		if (qualifyTable(hisc[mode],tmp)) {
			inputOption("You got a highscore!",tmp.name);
			enterTable(hisc[mode],tmp);
			sortTable(hisc[mode]);
			drawScreen(1);
			blitScreen();
		}
		done = showScores();
	}

	if (done==1) {
		int x,y,i=0;
		for(x=0;x<WIDTH;x++)
			for(y=0;y<HEIGHT;y++)
				if (field.pos[x][y].value) {
					field.pos[x][y].selected = 1;
					i++;
				}
		if (i) pop(5,new_rand()%3+1);
		startNewGame();
		push(5);
	}

	if (done==3) return 1;
	return 0;
}

void intro() {
	#define MAX_BUBBLES		256

	int i;
	Tbubble bub[MAX_BUBBLES];
	int y1=400,y2=1000,y3=700;
	int counter=2000;

	clear(screen);
	set_palette(gfx[0].dat);

	// init bubbles
	for(i=0;i<MAX_BUBBLES;i++) {
		bub[i].selected = 0;
		bub[i].value = new_rand()%NUMBUB + 1;
	}

	play_midi(gfx[MAINSONG].dat,1);

	do {
		game_count=0;
		if (new_rand()%100<30) { // create new bubble
			i=0;
			while(i<MAX_BUBBLES && bub[i].selected) i++;
			if (i<MAX_BUBBLES) { // bubble found
				bub[i].selected = 1;
				bub[i].dx = new_rand()%320;
				bub[i].dy = 240;
				bub[i].fade = new_rand()%8+1;
			}
		}
		// move bubbles
		for(i=0;i<MAX_BUBBLES;i++) {
			if (bub[i].selected) {
				bub[i].dy -= bub[i].fade;
				if (bub[i].dy < -20) bub[i].selected = 0;
			}
		}
		// draw screen
		clear(swap_screen);
		for(i=0;i<MAX_BUBBLES;i++) {
			if (bub[i].selected && bub[i].fade<4) {
				draw_sprite(swap_screen,gfx[bub[i].value+BUBBLE000].dat,bub[i].dx,bub[i].dy);
			}
		}
		draw_sprite(swap_screen,gfx[FLD].dat,28,y1);
		draw_sprite(swap_screen,gfx[PRESENTS].dat,104,y2);
		draw_sprite(swap_screen,gfx[TITLE].dat,79,y3);
		for(i=0;i<MAX_BUBBLES;i++) {
			if (bub[i].selected && bub[i].fade>=4) {
				draw_sprite(swap_screen,gfx[bub[i].value+BUBBLE000].dat,bub[i].dx,bub[i].dy);
			}
		}
		//textprintf(swap_screen,font,0,0,15,"%d",counter);

		y1--;
		y2-=2;
		y3--;

		while(!game_count);

		// blit to screen
		blitScreen();

	} while(--counter>1240 && !key[KEY_ESC]);

	fade_out(4);
	clear(screen);
}

int main(int argc, char *argv[]) {
	int done=0;

	init();
	createBg();
	intro();
	startNewGame();
	drawScreen(0);
	blitScreen();
	fade_in(gfx[0].dat,8);
	while (!done) {
		done = play();
	}
	//outro();  // show other games
	shutdown();

	return 0;
}
END_OF_MAIN()


