#include "button.h"

Tbutton *createButtHead() {
	Tbutton *tmp;

	// create head
	tmp = (Tbutton*)malloc(sizeof(Tbutton));
	tmp->next = NULL;

	return tmp;
}

void addButton(Tbutton *head, DATAFILE *df, int im1, int im2, int x, int y, int id) {
	Tbutton *tmp;
	Tbutton *ptr;

	// create new button
	tmp = (Tbutton*)malloc(sizeof(Tbutton));
	tmp->image1 = im1;
	tmp->image2 = im2;
	tmp->x = x;
	tmp->y = y;
	tmp->w = ((BITMAP *)df[im1].dat)->w;
	tmp->h = ((BITMAP *)df[im1].dat)->h;
	tmp->id = id;
	tmp->next = NULL;

	// find end of list and attach it
	ptr = (Tbutton*)head;
	while (ptr->next != NULL) ptr = (Tbutton*) ptr->next;
	ptr->next = (struct Tbutton *)tmp;
}

int updateButtons(Tbutton *head, int mx , int my) {
	Tbutton *ptr;
	int retValue = 0;

	ptr = (Tbutton*) head->next;
	while (ptr != NULL) {
		if (mx >= ptr->x && mx < ptr->x+ptr->w && my >= ptr->y && my < ptr->y+ptr->h) {
			ptr->mover = 1;
			retValue = ptr->id;
		}
		else
			ptr->mover = 0;
		ptr = (Tbutton*) ptr->next;
	}

	return retValue;
}

void drawButtons(BITMAP *bmp, DATAFILE *df, Tbutton *head) {
	Tbutton *ptr;

	ptr = (Tbutton*) head->next;
	while (ptr != NULL) {
		if (ptr->mover)
			draw_lit_sprite(bmp, df[ptr->image2].dat, ptr->x, ptr->y,150);
		else
			draw_sprite(bmp, df[ptr->image1].dat, ptr->x, ptr->y);
		ptr = (Tbutton*) ptr->next;
	}
}

void setButtonPos(Tbutton *head, int id, int x, int y) {
	Tbutton *ptr;

	ptr = (Tbutton*) head->next;
	while (ptr != NULL) {
		if (ptr->id == id) {
			if (x!=-1) ptr->x = x;
			if (y!=-1) ptr->y = y;
		}
		ptr = (Tbutton*) ptr->next;
	}
}

