
#ifdef GL_ES
precision mediump float;
#endif



uniform sampler2D al_tex; //texture used in al_draw_bitmap
uniform sampler2D tex_map; //for our colour map
uniform sampler2D tex_tex; //the texture to use

varying vec4 varying_color;
varying vec2 varying_texcoord;

vec4 pixel;
vec4 pixel_map;
vec4 pixel_tex;

uniform int r;
uniform int g;
uniform int b;



void main()
{
    //Get the pixel from the al_draw_bitmap call
    pixel = varying_color * texture2D(al_tex, varying_texcoord);

    //Get the pixel from the texture bitmap
    pixel_tex = texture2D(tex_tex, varying_texcoord);

    //Get the pixel from the fill map
    pixel_map = texture2D(tex_map, varying_texcoord);

    //Compare the fill map pixel with the rgb values we sent, if matched, multiply the sketch with the texture
    if(round(pixel_map.r * 255) == r && round(pixel_map.g * 255) == g && round(pixel_map.b * 255) == b){
        pixel = pixel * pixel_tex;
    }

    //Return the pixel
	gl_FragColor = pixel;
}


