#include <stdio.h>
#include <allegro5/allegro.h>
#include <allegro5/allegro_image.h>
#include "math.h"
#include "conio.h"

ALLEGRO_DISPLAY *display;
ALLEGRO_SHADER *shader = NULL;

ALLEGRO_BITMAP *imgMap = NULL;
ALLEGRO_BITMAP *imgTex = NULL;
ALLEGRO_BITMAP *imgSketch = NULL;

void SetupAllegro();
void SetupShader();
void LoadImages();

int main()
{
    SetupAllegro();
    SetupShader();
    LoadImages();

    al_use_shader(shader); //Use our shader

    al_set_shader_sampler("tex_tex", imgTex, 1); //Set texture image in shader
    al_set_shader_sampler("tex_map", imgMap, 2); //Set map in shader

    al_set_shader_int("r", 193); //Set shader "r"
    al_set_shader_int("g", 162); //Set shader "g"
    al_set_shader_int("b", 118); //Set shader "b"

    al_draw_bitmap(imgSketch, 0, 0, 0);  //Draw sketch using shader

    al_use_shader(NULL); //Turn off shader
    al_flip_display();  //Show backbuffer

    getch();  //Wait for input

    al_destroy_shader(shader);  //Cleanup
    al_destroy_bitmap(imgMap);
    al_destroy_bitmap(imgTex);
    al_destroy_bitmap(imgSketch);
    al_destroy_display(display);

    return 0;
}

void SetupAllegro()
{
    al_init();
    al_init_image_addon();

    al_set_new_display_flags(ALLEGRO_WINDOWED | ALLEGRO_PROGRAMMABLE_PIPELINE | ALLEGRO_OPENGL);

    al_set_new_display_option(ALLEGRO_SAMPLE_BUFFERS, 1, ALLEGRO_SUGGEST);
    al_set_new_display_option(ALLEGRO_SAMPLES, 16, ALLEGRO_SUGGEST);
    al_set_new_display_option(ALLEGRO_RENDER_METHOD, 1, ALLEGRO_SUGGEST);
    al_set_new_display_option(ALLEGRO_VSYNC, 1, ALLEGRO_SUGGEST);
    al_set_new_display_option(ALLEGRO_SUPPORT_NPOT_BITMAP, 1, ALLEGRO_SUGGEST);

    ALLEGRO_DISPLAY *display = al_create_display(1280, 768);

    al_set_new_bitmap_flags(ALLEGRO_VIDEO_BITMAP | ALLEGRO_NO_PRESERVE_TEXTURE | ALLEGRO_CONVERT_BITMAP);
}

void SetupShader()
{
    shader = al_create_shader(ALLEGRO_SHADER_GLSL);

    if (!al_attach_shader_source_file(shader, ALLEGRO_VERTEX_SHADER, "shader_vertex.glsl")) {
        printf("Cannot attach shader!");
        exit(-1);
    }

    if (!al_attach_shader_source_file(shader, ALLEGRO_PIXEL_SHADER,  "shader_fill.glsl")) {
        printf("Cannot attach shader!");
        exit(-1);
    }

    if(!al_build_shader(shader)){
        printf("Cannot build shader!");
        exit(-1);
    }
}

void LoadImages()
{
    imgMap = al_load_bitmap("sandstone.png");

    if(!imgMap){
        printf("Cannot load sandstone.png!");
        exit(-1);
    }

    imgTex = al_load_bitmap("sandstone_texture.png");

    if(!imgTex){
        printf("Cannot load sandstone_texture.png!");
        exit(-1);
    }

    imgSketch = al_load_bitmap("sketch.png");

    if(!imgSketch){
        printf("Cannot load sketch.png!");
        exit(-1);
    }
}
