#ifndef ELEMENT
#define ELEMENT

#include "allegro.h"

class Element
{
private:
        ALLEGRO_BITMAP *image;
        int w, h;
        int x, y;
        long int timestamp;
        bool visible;

public:
        Element(const char *, int = 0, int = 0, long int = 0);
        Element(const Element &, long int = 0);
        ~Element();

        inline ALLEGRO_BITMAP *getBitmap() { return image; };
        inline int getW() { return w; };
        inline int getH() { return h; };
        inline int getX() { return x; };
        inline int getY() { return y; };
        inline long int getT() { return timestamp; };
        inline bool getV() { return visible; };

        inline void setBitmap(ALLEGRO_BITMAP * in) { image = al_clone_bitmap(in); };
        inline void setW (int in) { w = in; };
        inline void setH (int in) { h = in; };
        inline void setX (int in) { x = in; };
        inline void setY (int in) { y = in; };
        inline void setT (long int in) { timestamp = in; };
        inline void setV (bool in) { visible = in; };

        void draw (int, int) const;
        void draw (int, int, int, int) const;

        Element & operator = (Element &);
};

class ElementQ
{
    struct Node
    {
        Element el;
        Node * next;
    };

private:
    Node * start;
    unsigned int cant;

public:
    ElementQ();
    ~ElementQ();

    inline unsigned int getCant() { return cant; };
    void add (const Element &);
    void remove (int);
    void remove (int, int);
    Element & get (int);

    ElementQ & operator << (const Element &);
    ElementQ & operator >> (int);
    Element & operator [] (int);
};

#endif
