﻿#include "element.h"

Element::Element(const char *path, int xin, int yin, long int time)
{
        image = al_load_bitmap(path);
        w = al_get_bitmap_width(image);
        h = al_get_bitmap_height(image);
        x = xin;
        y = yin;
        timestamp = time;
        visible = true;
}

Element::Element(const Element &cpy, long int time)
{
        image = al_clone_bitmap(cpy.image);
        w = cpy.w;
        h = cpy.h;
        x = cpy.x;
        y = cpy.y;
        timestamp = time;
        visible = cpy.visible;
}

Element::~Element()
{
    al_destroy_bitmap(image);
}

void Element::draw (int x, int y) const
{
        al_draw_bitmap(image, x, y, 0);
}

void Element::draw (int x, int y, int win, int hin) const
{
    al_draw_scaled_bitmap(image, 0, 0, w, h, x, y, win, hin, 0);
}

Element & Element::operator =(Element & cpy)
{
    image = al_clone_bitmap(cpy.image);
    w = cpy.w;
    h = cpy.h;
    x = cpy.x;
    y = cpy.y;
    visible = cpy.visible;

    return *this;
}

ElementQ::ElementQ()
{
    start = nullptr;
    cant = 0;
}

ElementQ::~ElementQ()
{
    Node * del;

    for(int i=0; start != nullptr; i++)
    {
        del = start;
        start = start->next;
        delete del;
    }
}

void ElementQ::add(const Element & in)
{

}
