#include <allegro5/allegro_primitives.h>
#include <math.h>
#include "util.h"
#include "tree.h"


CTree::CTree(int a_nLevel,int a_nX, int a_nY,double a_dAngle,double a_dSpread)
{
    m_nThickness = a_nLevel;
    m_nX1 = a_nX;
    m_nY1 = a_nY;
    double Angle = DegToRad(a_dAngle);

    m_nX2 = m_nX1 - (cos(Angle)* a_nLevel*20);
    m_nY2 = m_nY1 - (sin(Angle)* a_nLevel*20);

    m_color = al_map_rgb(a_nLevel*20+50,a_nLevel*20+50,a_nLevel*20+50);

    if (a_nLevel>0)
    {
        CTree * pTree = NULL;

        pTree = new CTree(a_nLevel-1,m_nX2, m_nY2, a_dAngle-a_dSpread,a_dSpread);
        m_vChildren.push_back(pTree);

        pTree = new CTree(a_nLevel-1,m_nX2, m_nY2, a_dAngle+a_dSpread,a_dSpread);
        m_vChildren.push_back(pTree);
    }
}

CTree::~CTree()
{
    // Destroy children
    vector<CTree *>::iterator I = m_vChildren.begin();
    while (I!= m_vChildren.end())
	{
		delete (*I);
		I =  m_vChildren.erase(I);
	}
}

void CTree::Draw()
{
    for( size_t i=0; i<m_vChildren.size(); i++)
    {
        m_vChildren[i]->Draw();
    }
    al_draw_line(m_nX1, m_nY1, m_nX2, m_nY2, m_color, m_nThickness);
}

