#ifndef _MAP_0010
#define _MAP_0010

#include <allegro5/allegro_font.h>
#include <allegro5/allegro_ttf.h>
#include <vector>
#include <list>
#include <queue>
#include "MathVectors.h"
#include "Sprite.h"


class CSprite;

struct AstarTask
{
    int startX;
    int startY;
    int goalX;
    int goalY;
    CSprite * pCaller;
};


class BasicEngine;

class BasicTile
{
   friend class BasicEngine;
   friend bool FSort(const BasicTile * a_pTile1, const BasicTile * a_pTile2);

   public:
   // set the bitmap for this tile
   void SetBitmap(ALLEGRO_BITMAP * a_pBitmap);
   void SetOffset(int a_nOffsetX,int a_nOffsetY);
      // constructor
   BasicTile();

   // destructor
   virtual ~BasicTile();

   int GetX();
   int GetY();

   bool IsAdjectend(BasicTile * a_pTile);
   void ResetPathMarker();
   void SetPathMarker();
   bool IsOccupied(CSprite * a_pOccupier);
   CSprite * GetOccupier();
   void SetOccupied(CSprite * a_pOccupier);
   void ResetOccupied(CSprite * a_pOccupier);

   protected:
   // draw the tile, this is used by Basic Engine
   // draws placeholders if no bitmap was set
   virtual void Draw(int a_nMapX,int a_nMapY);

   private:
   // pointer to engine
   BasicEngine * m_pEngine;

   // Pointer to a bitmap for this tile
   // This can be a tilesheet or a single tile;
   ALLEGRO_BITMAP * m_pBitmap;

   // A drawing offset
   int m_nOffsetX;
   int m_nOffsetY;

   // offset in a tilesheet -1 if bitmap is a single tile
   int m_nBitmapOffsetX;
   int m_nBitmapOffsetY;

   // for pathfinding
   bool m_blOccupied;
   bool m_blPathMarker;
   int  m_nTraverseCost;
   int  m_nX;
   int  m_nY;
   int  m_nDijkstra;
   double  m_dF;
   BasicTile * m_pParent;
   CSprite * m_pOccupier;

};




class BasicEngine
{
    friend class BasicTile;

    public:

    // Draw the tilemap looking at centerpoint a_nCamX, a_nCamY
    virtual void Draw(int a_nCamX,int a_nCamY);

    // Generate a testmap
    virtual void GenerateTest(int a_nWidth, int a_nHeight, ALLEGRO_BITMAP  * a_pBitmap);

    // constructor
    BasicEngine();

    // destructor
    virtual ~BasicEngine();

    int GetTileWidth();
    int GetTileHeight();
    int GetMapWidth();
    int GetMapHeight();

    BasicTile * GetTileAt(int a_nx,int a_nY);

    void GenerateDijkstra(int a_nGoalX, int a_nGoalY);
    bool LineOfSight(int x1, int y1, int x2, int y2);
    bool EnqueueAstar(int a_nStartX, int a_nStartY,int a_nGoalX, int a_nGoalY, CSprite * a_pCaller);

    void ResetPathMarkers();

    double TileToEngineX(int a_nTileX);
    double TileToEngineY(int a_nTileY);
    Vector2D TileToEngine(Vector2D a_vecTilePosition);

    Vector2D EngineToTile(Vector2D a_vecEnginePosition);

    protected:
    std::vector<BasicTile *> FindPath(int a_nStartX, int a_nStartY,int a_nEndX, int a_nEndY);
    std::vector<BasicTile *> GetAdjectend(int a_nX, int a_nY,bool blAllowDiagonal = true);

    void ClearDijkstra();
    void ClearAstar();
    bool IsInOpen(BasicTile * a_pTile);
    bool IsInClosed(BasicTile * a_pTile);
    bool IsDiagonal(BasicTile * a_pTile1, BasicTile * a_pTile2);

    private:

    static bool m_blAstarBusy;

    // nested vector to hold the tiles
    std::vector<std::vector< BasicTile * > >m_lstCell;

    std::list<BasicTile *> m_lstOpenList;
    std::list<BasicTile *> m_lstClosedList;

    std::queue<AstarTask> m_queueAstar;

    // the width of every tile
    int m_nTileWidth;

    // the height of every tile
    int m_nTileHeight;

    int m_nMapWidth;
    int m_nMapHeight;

    // The Y distance between two rows of tiles (usually 1/4 tileheight)
    int m_nYStep;

    // the screencenter
    int SCREENCENTER_X;
    int SCREENCENTER_Y;


    ALLEGRO_MUTEX * m_pMutex;
    ALLEGRO_THREAD * m_AstarThread;
    static void * Func_Thread(ALLEGRO_THREAD *thr, void *arg);

};
#endif // _MAP
