#ifndef _SPRITE_
#define _SPRITE_


#include "GameEngine.h"
#include "map.h"
#include "CoolMath.h"

class BasicTile;
class BasicEngine;

enum MOVE_STATE
{
    WAITING,     // pauze movement
    MOVING,      // moving to adjectend tile
    NAVIGATING,  // navigating to next tile to move to
    ASTARING,    // posting astar request and waiting
    BLOCKED,     // goal cannot be reached
    READY        // target reached
};


enum AI_STATE
{
    AI_NONE,    // do nothing
    AI_WANDER   // wander about
};



class CSprite: public GameMover
{
      public:
        CSprite(int a_nX,int a_nY, BasicEngine * a_pMapEngine);
        ~CSprite();

        virtual void Update(double a_dLagTime);
        virtual void Draw(Vector2D a_Screencenter,Vector2D a_CameraPosition);

        void TestCallAstar();

        int GetMapX();
        int GetMapY();
        int GetID();

        void OnCannotReach();

        ALLEGRO_MUTEX * m_pMutex;

      protected:
       BasicEngine * GetMapEngine();
       double WayPoint(double a_dX,double a_dY);
       MOVE_STATE GetMoveState();
       void SetMoveState(MOVE_STATE a_MoveState);
       AI_STATE m_AIState;
       virtual void DoAI();
       virtual void DoMove();
       double m_dSpeed;

      private:
      MOVE_STATE m_MoveState;


      BasicEngine * m_pMapEngine;
      ALLEGRO_COLOR m_Color;
      std::vector<BasicTile *> m_vPath;
      bool m_blHasPath;
      BasicTile * m_pTargetTile;
      BasicTile * m_pCurrentTile;
      double m_nWaypointX;
      double m_nWaypointY;
      size_t m_nWaypointCounter;
      friend class BasicEngine;
      bool m_blAstarEnqueued;
      int m_nID;
      int m_nMapTargetX;
      int m_nMapTargetY;
      double m_dTimer;
      static int NEXTID;

};





#endif // _SPRITE_
