#include "Sprite.h"

int CSprite::NEXTID = 1;

CSprite::CSprite(int a_nX, int a_nY, BasicEngine * a_pMapEngine)
:GameMover(0,0,10)
{
    m_pMapEngine = a_pMapEngine;
    m_Position.SetX(a_pMapEngine->TileToEngineX(a_nX));
    m_Position.SetY(a_pMapEngine->TileToEngineY(a_nY));
    m_blHasPath = false;
    m_pMutex = al_create_mutex();
    m_AIState = AI_WANDER;
    m_MoveState = READY;
    m_pTargetTile = NULL;
    m_nWaypointX = -1;
    m_nWaypointY = -1;
    m_nWaypointCounter = -1;
    m_blAstarEnqueued = false;
    m_nMapTargetX = -1;
    m_nMapTargetY = -1;
    m_dSpeed = 0;
    m_nID = NEXTID;
    NEXTID++;
    m_pMutex = al_create_mutex();

    m_pCurrentTile = m_pMapEngine->GetTileAt(GetMapX(),GetMapY());
    m_pCurrentTile->SetOccupied(this);
}

CSprite::~CSprite()
{
    al_destroy_mutex(m_pMutex);
}


void CSprite::Draw(Vector2D a_Screencenter,Vector2D a_CameraPosition)
{
    Vector2D DrawingCenter = GetDrawingCenter(a_Screencenter,a_CameraPosition);
    int DrawX = int(DrawingCenter.GetX());
	int DrawY = int(DrawingCenter.GetY());

    if (m_blHasPath)
    {
        al_draw_filled_circle(DrawX, DrawY,5,al_map_rgb(0,255,0));
    }
    else
    {
       al_draw_filled_circle(DrawX, DrawY,5,al_map_rgb(255,0,0));
    }
}


void CSprite::Update(double a_dLagTime)
{
    if (m_dTimer > 0)
    {
        m_dTimer -= a_dLagTime;
    }

    DoAI();
    DoMove();
    GameMover::Update(a_dLagTime);
}


void CSprite::DoAI()
{
   switch (m_AIState)
   {
       case AI_NONE:
       break;

       case AI_WANDER:
          MOVE_STATE movestate = GetMoveState();

          if ((movestate == READY) || (movestate == BLOCKED))
          {
             m_dTimer = 5;
             SetMoveState(WAITING);
          }
          else if ((movestate == WAITING) && (m_dTimer <= 0))
          {
              m_nMapTargetX = rand() % m_pMapEngine->GetMapWidth();
              m_nMapTargetY = rand() % m_pMapEngine->GetMapHeight();
              m_blAstarEnqueued = false;
              SetMoveState(ASTARING);
          }

       break;

    }
}

void CSprite::DoMove()
{

  switch(m_MoveState)
  {
      case WAITING:
      break;


      case MOVING:
           if ((m_pTargetTile != NULL)&& ((m_nWaypointX < 0)||(m_nWaypointY < 0) ))
           {
               m_nWaypointX = m_pTargetTile->GetX() * m_pMapEngine->GetTileWidth() + m_pMapEngine->GetTileWidth()/2;
               m_nWaypointY = m_pTargetTile->GetY() * m_pMapEngine->GetTileHeight() + m_pMapEngine->GetTileHeight()/2;
           }

           if ((m_nWaypointX >= 0)&&(m_nWaypointY >= 0))
           {
              Vector2D vec(20,0);
              double angle = WayPoint(m_nWaypointX,m_nWaypointY);
              vec.rotate(angle);
              SetVelocity(vec);

              if (Distance(m_Position.GetX(), m_Position.GetY() , m_nWaypointX, m_nWaypointY)< 5)
              {
                  StopMovement();
                  m_pCurrentTile->ResetOccupied(this);
                  m_pCurrentTile = m_pTargetTile;
                  m_Position.SetX(m_nWaypointX);
                  m_Position.SetY(m_nWaypointY);
                  m_nWaypointX =-1;
                  m_nWaypointY =-1;
                  m_pTargetTile =NULL;
                  m_MoveState = NAVIGATING;

              }
           }
      break;

      case NAVIGATING:
         StopMovement();
        if (m_blHasPath)
        {
           if (m_pTargetTile == NULL)
           {
               m_nWaypointCounter++;
               if (m_nWaypointCounter < m_vPath.size())
               {
                  al_lock_mutex(m_pMutex);
                   m_pTargetTile = m_vPath[m_nWaypointCounter];
                  al_unlock_mutex(m_pMutex);
               }
               else
               {
                   al_lock_mutex(m_pMutex);
                     m_vPath.clear();
                   al_unlock_mutex(m_pMutex);
                   m_blHasPath = false;
                   m_blAstarEnqueued = false;
                   m_nWaypointCounter = -1;
                   m_MoveState = READY;
                   if (m_pTargetTile != NULL)
                   {
                       m_pTargetTile->ResetOccupied(this);
                   }

               }
           }
           else
           {
               if (!m_pTargetTile->IsOccupied(this))
               {
                   m_pTargetTile->SetOccupied(this);
                   m_MoveState = MOVING;
               }
               else
               {
                   if (m_pTargetTile->GetOccupier()->m_MoveState != MOVING)
                   {
                       m_blAstarEnqueued = false;
                       m_MoveState = ASTARING;
                   }

               }
           }

        }
        else
        {

        }
      break;

      case ASTARING:
      if (! m_blAstarEnqueued)
      {
          al_lock_mutex(m_pMutex);
           m_vPath.clear();
          al_unlock_mutex(m_pMutex);
          m_blHasPath = false;
          m_pTargetTile = NULL;
          m_pMapEngine->EnqueueAstar(GetMapX(), GetMapY(),m_nMapTargetX , m_nMapTargetY, this);
          m_blAstarEnqueued = true;
          m_nWaypointCounter = -1;
      }
      else if (m_blHasPath)
      {
          m_MoveState = NAVIGATING;
      }
      break;


      case BLOCKED:
        StopMovement();
        m_blHasPath = false;
        m_blAstarEnqueued = false;
      break;

      case READY:
        StopMovement();
        m_blHasPath = false;
        m_blAstarEnqueued = false;
      break;
  }



}


void CSprite::OnCannotReach()
{
    al_lock_mutex(m_pMutex);
        m_MoveState = BLOCKED;
    al_unlock_mutex(m_pMutex);
}


MOVE_STATE CSprite::GetMoveState()
{
    return m_MoveState;
}


void CSprite::SetMoveState(MOVE_STATE a_MoveState)
{
    m_MoveState = a_MoveState;
}

BasicEngine * CSprite::GetMapEngine()
{
    return m_pMapEngine;
}


int CSprite::GetMapX()
{
    int width = m_pMapEngine->GetTileWidth();
    return (m_Position.GetX() - (width / 2) ) / width;
}

int CSprite::GetMapY()
{
    int height = m_pMapEngine->GetTileHeight();
    return (m_Position.GetY() - (height / 2) ) / height;
}

int CSprite::GetID()
{
    return m_nID;
}

double CSprite::WayPoint(double a_dX,double a_dY)
{
	double DX=m_Position.GetX()-a_dX;
	double DY=m_Position.GetY()-a_dY;
	if (DX!=0) return atan2(DY,DX)+PI;
	else return 0;
}


void CSprite::TestCallAstar()
{
    m_pMapEngine->EnqueueAstar(GetMapX(), GetMapY(),50, 20, this);
}


