//      Copyright (C) 2016   E.J.M. Martens
//
//      This program is free software; you can redistribute it and/or
//      modify it under the terms of the GNU General Public License
//      as published by the Free Software Foundation; either version 2
//      of the License, or (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.


#ifndef _GAME_ENGINE
#define _GAME_ENGINE

#include "MathVectors.h"
#include <allegro5/allegro.h>
#include <allegro5/allegro_image.h>
#include <allegro5/allegro_primitives.h>
#include <list>


using namespace std;


enum ObjectType {otGAMEOBJECT, otMOVER, otMOVINGBALL, otSPRITE,  otNONE };

class GameEngine;

class GameObject
{
    friend GameEngine;
    friend bool Comp(const GameObject * a_pObject1, const GameObject * a_pObject2);

    public:
       GameObject(double a_dX,double a_dY, int a_nZ );
       virtual ~GameObject();
       ObjectType GetType();
       void SetZ(int a_nDepth);
       virtual void Update(double a_dLagTime) = 0;
       virtual void Draw(Vector2D a_Screencenter,Vector2D a_CameraPosition)=0;
       void EnableCollision();
       void Remove();
       Vector2D GetPosition();
       bool IsRemovePending();

    protected:
       Vector2D m_Position;
       Vector2D GetDrawingCenter(Vector2D a_Screencenter,Vector2D a_CameraPosition);
       void SetType(ObjectType a_OT);

    private:
        ObjectType m_ObjectType;
        bool m_blDestroyed;
        bool m_blCanCollide;
        int m_nZ;

};


class GameMover :public GameObject
{
    public:
        GameMover(double a_dX,double a_dY, int a_nZ);
        virtual ~GameMover();

        virtual void Update(double a_dLagTime);
        void SetVelocity(Vector2D a_Velocity);
        void SetAcceleration(Vector2D a_Acceleration);
        void StopMovement();

    protected:
        Vector2D m_Velocity;
        Vector2D m_Acceleration;
        double m_dTopSpeed;
    private:

};


class MovingBall: public GameMover
{
      public:
        MovingBall(double a_dX,double a_dY, int a_nZ);
        ~MovingBall();

        virtual void Draw(Vector2D a_Screencenter,Vector2D a_CameraPosition);

      protected:


      private:

      ALLEGRO_COLOR m_Color;

};

class GameEngine
{
    public:
    GameEngine(int a_nScreenCenterX, int a_nScreenCenterY);
    ~GameEngine();

    void Update(double a_dLagTime);
    void draw();

    void AddObject(GameObject * a_pObject);
    void Kill();

    void SetCameraPosition(int a_nCameraX, int a_nCameraY);
    Vector2D MouseToWorld(int a_nMouseX, int a_nMouseY);

    protected:



    private:
    list <GameObject *> m_lItems;
    Vector2D m_ScreenCenter;
    Vector2D m_CameraPosition;

};


bool Comp(const GameObject * a_pObject1, const GameObject * a_pObject2);




#endif // _GAME_ENGINE
