//      Copyright (C) 2016   E.J.M. Martens
//
//      This program is free software; you can redistribute it and/or
//      modify it under the terms of the GNU General Public License
//      as published by the Free Software Foundation; either version 2
//      of the License, or (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.


#include "GameEngine.h"


/*
        Game Object implementation
*/


GameObject::GameObject(double a_dX, double a_dY, int a_nZ)
{
    m_Position.SetX(a_dX);
    m_Position.SetY(a_dY);

    m_ObjectType   = otGAMEOBJECT;
    m_blDestroyed  = false;
    m_blCanCollide = false;
    m_nZ           = a_nZ;
}

GameObject::~GameObject()
{

}

Vector2D GameObject::GetPosition()
{
    return m_Position;
}

void GameObject::EnableCollision()
{
    m_blCanCollide = true;
}


void GameObject::SetType(ObjectType a_OT)
{
    m_ObjectType = a_OT;
}


void GameObject::Update(double a_dLagTime)
{

}

Vector2D GameObject::GetDrawingCenter(Vector2D a_Screencenter,Vector2D a_CameraPosition)
{
    Vector2D DrawPosition = a_Screencenter + (m_Position-a_CameraPosition);
    return DrawPosition;
}

ObjectType GameObject::GetType()
{
    return m_ObjectType;
}

void GameObject::SetZ(int a_nDepth)
{
    m_nZ=a_nDepth;
}

void GameObject::Remove()
{
    m_blCanCollide = false;
    m_blDestroyed  = true;
}




bool GameObject::IsRemovePending()
{
    return m_blDestroyed;
}

/*
        Game Mover implementation
*/

 GameMover::GameMover(double a_dX,double a_dY, int a_nZ)
 :GameObject(a_dX,a_dY, a_nZ)
 {
    SetType(otMOVER);
    m_dTopSpeed =1000;
 }


 GameMover::~GameMover()
 {

 }

void GameMover::Update(double a_dLagTime)
 {
     m_Velocity += m_Acceleration * a_dLagTime;
     m_Velocity.Limit(m_dTopSpeed);
     m_Position += m_Velocity * a_dLagTime;
 }

 void GameMover::SetVelocity(Vector2D a_Velocity)
 {
      m_Velocity = a_Velocity;
 }

 void GameMover::SetAcceleration(Vector2D a_Acceleration)
 {
      m_Acceleration = a_Acceleration;
 }

 void GameMover::StopMovement()
 {
     m_Velocity.SetX(0);
     m_Velocity.SetY(0);

     m_Acceleration.SetX(0);
     m_Acceleration.SetY(0);
 }



/*
        Moving Ball implementation
*/



MovingBall::MovingBall(double a_dX,double a_dY, int a_nZ)
:GameMover(a_dX,a_dY, a_nZ)
{
     SetType(otMOVINGBALL);
     m_Color = al_map_rgb(255,0,255);
}

MovingBall::~MovingBall()
{

}

void MovingBall::Draw(Vector2D a_Screencenter,Vector2D a_CameraPosition)
{
    Vector2D DrawingCenter = GetDrawingCenter(a_Screencenter,a_CameraPosition);
    int DrawX = int(DrawingCenter.GetX());
	int DrawY = int(DrawingCenter.GetY());

    al_draw_filled_circle(DrawX, DrawY,5,m_Color);
}






/*
        GameEngine Ball implementation
*/




GameEngine::GameEngine(int a_nScreenCenterX, int a_nScreenCenterY)
{
    m_ScreenCenter.SetX(a_nScreenCenterX);
    m_ScreenCenter.SetY(a_nScreenCenterY);
    m_CameraPosition = m_ScreenCenter;
}


GameEngine::~GameEngine()
{
    list<GameObject *>::iterator p=m_lItems.begin();
	while (p!=m_lItems.end())
	{
		delete (*p);
		p = m_lItems.erase(p);
	}
}

void GameEngine::Update(double a_dLagTime)
{
    list<GameObject *>::iterator p=m_lItems.begin();
	while (p!=m_lItems.end())
	{
		(*p)->Update(a_dLagTime);
		if ((*p)->m_blCanCollide)
		{
            list<GameObject *>::iterator q=m_lItems.begin();
            while (q!=m_lItems.end())
			{
				if ((*q)!=(*p))
				{
					// Check collision !!!
					//if (detect_collision(hulp,hulp2)) hulp->DoCollision(hulp2);
				}
				q++;
			}
		}
		p++;
	}
}


void GameEngine::draw()
{
    list<GameObject *>::const_iterator p=m_lItems.begin();
	while (p!=m_lItems.end())
	{
		(*p)->Draw(m_ScreenCenter,m_CameraPosition);
		p++;
	}
}



Vector2D GameEngine::MouseToWorld(int a_nMouseX, int a_nMouseY)
{
    Vector2D mousevec(a_nMouseX, a_nMouseY);
    mousevec += (m_CameraPosition - m_ScreenCenter);
    return mousevec;
}


void GameEngine::AddObject(GameObject * a_pObject)
{
    m_lItems.push_back(a_pObject);
	m_lItems.sort(Comp);
}

void GameEngine::Kill()
{
    list<GameObject *>::iterator p=m_lItems.begin();
	while (p!=m_lItems.end())
	{

		if ((*p)->m_blDestroyed)
		{
			delete (*p);
			p = m_lItems.erase(p);
		}
		else
        p++;
	}

}


void GameEngine::SetCameraPosition(int a_nCameraX, int a_nCameraY)
{
     m_CameraPosition.SetX(a_nCameraX);
     m_CameraPosition.SetY(a_nCameraY);
}

bool Comp(const GameObject * a_pObject1, const GameObject * a_pObject2)
{
	return (a_pObject1->m_nZ < a_pObject2->m_nZ);
}


