//      Copyright (C) 2016   E.J.M. Martens
//
//      This program is free software; you can redistribute it and/or
//      modify it under the terms of the GNU General Public License
//      as published by the Free Software Foundation; either version 2
//      of the License, or (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.



#include "CustomProgram.h"
#include <allegro5/allegro_primitives.h>
#include <stdio.h>
#include <stdlib.h>     /* srand, rand */
#include <iostream>
#include "util.h"
#include "MathVectors.h"



CustomProgram::CustomProgram(int a_nScreenWidth, int a_nScreenheight, bool a_blFullscreen)
:A5Program(a_nScreenWidth, a_nScreenheight, a_blFullscreen,false)
{
    srand (time(NULL));
    m_pFontPath  = al_get_standard_path(ALLEGRO_RESOURCES_PATH);
    al_append_path_component(m_pFontPath, "Font");
    al_set_path_filename(m_pFontPath,"arial.ttf");
    const char * szPath = al_path_cstr(m_pFontPath,ALLEGRO_NATIVE_PATH_SEP);
    std::cout << "FontPath: " << szPath << "\n";

    m_pFont = al_load_ttf_font(szPath,10,0);
    m_TextCol = al_map_rgb(255,255,255);

    m_pTileEngine = NULL;
    m_pGameEngine = NULL;


    m_pTileEngine = new BasicEngine();
    m_pTileEngine->GenerateTest(20,20,NULL);

    m_dCameraX = a_nScreenWidth;
    m_dCameraY = a_nScreenheight;

    m_dDeltaX = 0;
    m_dDeltaY = 0;

    m_pGameEngine = new GameEngine(a_nScreenWidth, a_nScreenheight);


    //m_pTestObject = new CSprite(6 ,0 ,m_pTileEngine);

    for (int i=0; i<10; i++)
    {
         CSprite * pSprite = new CSprite(2 ,i+2 ,m_pTileEngine);
         m_pGameEngine->AddObject(pSprite);
    }

    m_MouseVec.SetX(0);
    m_MouseVec.SetY(0);

    SetTimer(100);
}


CustomProgram::~CustomProgram()
{
    delete m_pTileEngine;
}


void CustomProgram::DispatchEvent(ALLEGRO_EVENT * a_pEvent)
{

}


void CustomProgram::OnKeyDown(const ALLEGRO_KEYBOARD_EVENT & a_KeyboardEvent)
{
    switch(a_KeyboardEvent.keycode)
    {
        case ALLEGRO_KEY_ESCAPE:
               Quit();
             break;

        case ALLEGRO_KEY_UP:
             m_dDeltaY = -600;
             break;

        case ALLEGRO_KEY_DOWN:
             m_dDeltaY = 600;
             break;

        case ALLEGRO_KEY_LEFT:
             m_dDeltaX = -600;
             break;

        case ALLEGRO_KEY_RIGHT:
             m_dDeltaX = 600;
             break;


        case ALLEGRO_KEY_N:
             m_pTestObject->TestCallAstar();
             break;


    }


}

void CustomProgram::OnKeyUp(const ALLEGRO_KEYBOARD_EVENT & a_KeyboardEvent)
{
    switch(a_KeyboardEvent.keycode)
    {
        case ALLEGRO_KEY_UP:
             m_dDeltaY = 0;
             break;

        case ALLEGRO_KEY_DOWN:
             m_dDeltaY = 0;
             break;

        case ALLEGRO_KEY_LEFT:
             m_dDeltaX = 0;
             break;

        case ALLEGRO_KEY_RIGHT:
             m_dDeltaX = 0;
             break;

    }

}


void CustomProgram::OnMouseMove(const ALLEGRO_MOUSE_EVENT & a_MouseEvent)
{



}

void CustomProgram::OnMouseButtonDown(const ALLEGRO_MOUSE_EVENT & a_MouseEvent)
{


   if ((m_pTileEngine != NULL) && (m_pGameEngine != NULL))
   {
       m_MouseVec = m_pGameEngine->MouseToWorld(a_MouseEvent.x, a_MouseEvent.y);
       m_MouseVec = m_pTileEngine->EngineToTile(m_MouseVec);
       if (m_pTileEngine->LineOfSight(1,1,m_MouseVec.GetX(), m_MouseVec.GetY()))
       {
           m_blTestLineOfSight = true;
       }
   else
      {
        m_blTestLineOfSight = false;
      }
   }
}

void CustomProgram::OnMouseButtonUp(const ALLEGRO_MOUSE_EVENT & a_MouseEvent)
{

}




void CustomProgram::OnUpdate(double a_dLagTime)
{

  if (m_dDeltaY != 0)
  {
      m_dCameraY += (m_dDeltaY * a_dLagTime);
  }

  if (m_dDeltaX != 0)
  {
      m_dCameraX += (m_dDeltaX * a_dLagTime);
  }

  if (m_pGameEngine != NULL)
  {
      m_pGameEngine->SetCameraPosition(m_dCameraX, m_dCameraY);
      m_pGameEngine->Update(a_dLagTime);
  }

}



void CustomProgram::OnDraw()
{
    if (m_pTileEngine != NULL)
    {
        m_pTileEngine->Draw(m_dCameraX,m_dCameraY);
    }

    if (m_pGameEngine!= NULL)
    {
        m_pGameEngine->draw();
    }

    if (m_pTileEngine != NULL)
    {
        std::ostringstream m_StringStream;
        m_StringStream << "(" << m_MouseVec.GetX() << "," << m_MouseVec.GetY() << ")";

        if (m_blTestLineOfSight)
        {
            m_StringStream << "  LINE OF SIGHT !";
        }

        al_draw_text(m_pFont,al_map_rgb(255,255,255),10,10,0,m_StringStream.str().c_str());
    }
}

void CustomProgram::OnTimer()
{
    std::cout<< "test \n";
}




