

#include <allegro5/allegro.h>
#include <allegro5/allegro_color.h>
#include <allegro5/allegro_primitives.h> 
#include <allegro5/allegro_direct3d.h>

#include <cstdio>
#include <climits>

int main(int argc, char **argv) { 

   if (!al_init()) {return 1;} 
   al_init_primitives_addon(); 
   al_install_keyboard();

   ALLEGRO_EVENT_QUEUE* queue = al_create_event_queue();
   if (!queue) {return 2;}
   al_register_event_source(queue , al_get_keyboard_event_source());

   al_set_new_display_option(ALLEGRO_SAMPLE_BUFFERS, 1, ALLEGRO_REQUIRE);
   al_set_new_display_option(ALLEGRO_SAMPLES, 8, ALLEGRO_SUGGEST); 

   bool use_opengl = false;
   if (use_opengl) {
      al_set_new_display_flags(ALLEGRO_OPENGL);
   }
   else {
      al_set_new_display_flags(ALLEGRO_DIRECT3D); 
   }
   ALLEGRO_DISPLAY *display = al_create_display(1024, 600); 
   if (!display) {return 2;}
   if (use_opengl) {
      al_set_window_title(display , "OpenGL window");
   }
   else {
      al_set_window_title(display , "Direct3D window");
   }
   al_register_event_source(queue , al_get_display_event_source(display));


   al_clear_to_color(al_color_name("black")); 
   al_draw_circle(500, 300, 200, al_color_name("white"), 5.0); 
   al_draw_line(200, 200, 700, 300, al_color_name("white"), 5.0); 
   al_flip_display(); 

   bool quit = false;
   while (!quit) {
      ALLEGRO_EVENT ev;
      al_wait_for_event(queue , &ev);
      if (ev.type == ALLEGRO_EVENT_KEY_DOWN && ev.keyboard.keycode == ALLEGRO_KEY_ESCAPE) {quit = true;}
      if (ev.type == ALLEGRO_EVENT_DISPLAY_CLOSE) {quit = true;}
   }
   return 0;
}
