#ifdef GL_ES
precision mediump float;
#endif

uniform sampler2D tex; // 0
uniform float time; // effect elapsed time

void main()
{
    vec2 uv = gl_TexCoord[0].xy;
    vec2 texCoord = uv;

    float r = 2.0*mod(time + 7.5 , 15.0)/15.0 - 1.0;
    float g = 2.0*mod(time       , 5.0)/5.0 - 1.0;
    float b = 2.0*mod(time       , 2.0)/2.0 - 1.0;
    if (r < 0.0) {r = -r;}
    if (g < 0.0) {g = -g;}
    if (b < 0.0) {b = -b;}
    
    
    vec4 texel = texture2D(tex, texCoord);
    gl_FragColor = vec4(r*texel.r , g*texel.g , b*texel.b , 1.0*texel.a);
}

