#include <allegro5/allegro.h>
#include <allegro5/allegro_image.h>
#include <allegro5/allegro_primitives.h>
#include <allegro5/allegro_opengl.h>

#include <cmath>
#include <iostream>


ALLEGRO_DISPLAY* d = 0;
ALLEGRO_EVENT_QUEUE* q = 0;
ALLEGRO_TIMER* t = 0;

ALLEGRO_BITMAP* buf = 0;

ALLEGRO_SHADER* myShader = 0;
const char * myShaderVertFileName("myShaderVert.glsl");
const char * myShaderFragFileName("myShaderFrag.glsl");

ALLEGRO_BITMAP * myImage = 0;
const char * myImageFileName("bg0.png");

int sw = 800;
int sh = 600;



template <class M>
int log (int error, M msg)
{
    std::cout << msg;

    return error;
}



ALLEGRO_SHADER* create_shader(const char* fileNameVert, const char* fileNameFrag )
{
    ALLEGRO_SHADER* shader = al_create_shader(ALLEGRO_SHADER_GLSL);
//    if(!al_attach_shader_source(shader,
//                                ALLEGRO_VERTEX_SHADER,
//                                al_get_default_shader_source(ALLEGRO_SHADER_GLSL, ALLEGRO_VERTEX_SHADER)))
    if(!al_attach_shader_source_file(shader, ALLEGRO_VERTEX_SHADER, fileNameVert))
    {
        printf("%s\n", al_get_shader_log(shader));
        return NULL;
    }
    if(!al_attach_shader_source_file(shader, ALLEGRO_PIXEL_SHADER, fileNameFrag))
    {
        printf("%s\n", al_get_shader_log(shader));
        return NULL;
    }
    if(!al_build_shader(shader))
    {
        printf("%s\n", al_get_shader_log(shader));
        return NULL;
    }
    std::cout << " >>> "<< al_get_shader_log(shader) << " \n";

    return shader;
}

// -----------------------------------------------------------------------
// ---- INIT ---
// -----------------------------------------------------------------------
int init()
{
// Init Allegro 5
    if (!al_init())
        return log(1,"Unable to Init ALLEGRO_5 ! \n");

// Init & Install : Modules & Addon
    if (!al_install_keyboard())
        return log(1,"Unable to Install Keyboard ! \n");

    if (!al_install_mouse())
        return log(1,"Unable to Install Keyboard ! \n");

    if (!al_init_image_addon())
        return log(1,"Unable to Init Image addon ! \n");

    if (!al_init_primitives_addon())
        return log(1,"Unable to Init Primitives addon ! \n");

// Settings
///    al_set_new_display_flags(ALLEGRO_PROGRAMMABLE_PIPELINE | ALLEGRO_OPENGL | ALLEGRO_WINDOWED);
///    al_set_new_display_flags(ALLEGRO_OPENGL | ALLEGRO_WINDOWED);
    al_set_new_display_flags(ALLEGRO_OPENGL | ALLEGRO_WINDOWED);

// Create All
    d = al_create_display(sw, sh);
    if (!d) {
        return log(1,"Unable to Create display ! \n");
    }
    sw = al_get_display_width(d);
    sh = al_get_display_height(d);
    

    buf = al_create_bitmap(sw,sh);
    myImage = al_create_bitmap(sw,sh);
    if (!buf)
        return log(1,"Unable to Create Buffer ! \n");

    q = al_create_event_queue();
    t = al_create_timer(1.0/60.0);
        
    al_register_event_source(q , al_get_display_event_source(d));
    al_register_event_source(q , al_get_mouse_event_source());
    al_register_event_source(q , al_get_timer_event_source(t));
    al_register_event_source(q , al_get_keyboard_event_source());
        
    al_show_mouse_cursor(d);

    ALLEGRO_BITMAP* image = al_load_bitmap(myImageFileName);
    al_set_target_bitmap(myImage);
    al_set_blender(ALLEGRO_ADD , ALLEGRO_ONE , ALLEGRO_ZERO);
    al_draw_scaled_bitmap(image , 0 , 0 , al_get_bitmap_width(image) , al_get_bitmap_height(image) , 0 , 0 , sw , sh , 0);
    al_set_blender(ALLEGRO_ADD , ALLEGRO_ONE , ALLEGRO_INVERSE_ALPHA);
    al_destroy_bitmap(image);

    myShader = create_shader(myShaderVertFileName,myShaderFragFileName);

    if(!myShader)
        return log(1," Error in create myShader !\n");

    return log(0,"--- init OK !\n");
}
// -----------------------------------------------------------------------
// --- DONE ---
// -----------------------------------------------------------------------
int done()
{
   al_uninstall_system();

   return log(0,"--- done OK !\n");
}
// -----------------------------------------------------------------------
// --- RUN ---
// -----------------------------------------------------------------------
int run()
{

   bool quit = false;
   bool redraw = true;

   bool keys[ALLEGRO_KEY_MAX] = {0};

   int mx = 0 , my = 0;
   int mbtn = 0;

   al_start_timer(t);
    
   while (!quit)
   {

      if (redraw) {
         redraw = false;
         // --- Render ---

         // clear windowbuffer !
         al_set_target_bitmap(buf);
         al_clear_to_color(al_map_rgb(0,0,255));

         // Begin drawing !

         // Use shader here before blit buffer to display !!
         al_use_shader(myShader);
         al_set_shader_sampler("tex", myImage, 0);

         double dt = al_get_time();
         al_set_shader_float("time" , dt);

         al_draw_bitmap(myImage, 0,0,0);

         al_use_shader(NULL);



         /// End drawing !

         // Blit buffer to display !
         al_set_target_backbuffer(d);
         al_clear_to_color(al_map_rgb(0,0,0));


         al_draw_bitmap(buf , 0 , 0 , 0);

         // Flip display !
         al_flip_display();
      }



    // --- Update ---
      do {
         ALLEGRO_EVENT ev;
         al_wait_for_event(q, &ev);

         // Keyboard Input !
         if (ev.type == ALLEGRO_EVENT_KEY_DOWN) {
            if (ev.keyboard.keycode == ALLEGRO_KEY_ESCAPE) {
               quit = true;
            }
            keys[ev.keyboard.keycode] = true;
         }
         if (ev.type == ALLEGRO_EVENT_KEY_UP) {
            keys[ev.keyboard.keycode] = false;
         }
         if (ev.type == ALLEGRO_EVENT_DISPLAY_CLOSE) {
            quit = true;
         }
         if (ev.type == ALLEGRO_EVENT_MOUSE_BUTTON_DOWN) {
            mbtn |= ev.mouse.button;
         }
         if (ev.type == ALLEGRO_EVENT_MOUSE_BUTTON_UP) {
            mbtn &= ~ev.mouse.button;
         }
         if (ev.type == ALLEGRO_EVENT_MOUSE_AXES) {
            mx = ev.mouse.x;
            my = ev.mouse.y;
            if (ev.mouse.dz) {
               
            }
         }
         if (ev.type == ALLEGRO_EVENT_MOUSE_BUTTON_DOWN && ev.mouse.button & 1) {

         }

         if (ev.type == ALLEGRO_EVENT_TIMER) {
            redraw = true;
            if (keys[ALLEGRO_KEY_EQUALS] || keys[ALLEGRO_KEY_MINUS]) {
               if (keys[ALLEGRO_KEY_EQUALS]) {
                  
               }
               if (keys[ALLEGRO_KEY_MINUS]) {
                  
               }
            }
            else if (mbtn & 1) {
            // ShockWave Update !
            }
            else {

            }
         }
      } while (!al_is_event_queue_empty(q));

    }

    return log(0,"--- run OK !\n");
}
// -----------------------------------------------------------------------
// --- MAIN ---
// -----------------------------------------------------------------------
int main()
{
    if (init())
        return log(1, "Error in init() \n");
    if (run())
        return log(1, "Error in run() \n");
    if (done())
        return log(1, "Error in done() \n");

    return log(0,"--- Terminated normally ! \n");;
}
