#version 110

uniform sampler2D tex; // 0
uniform float time; // effect elapsed time

uniform vec2 surface; // texture resolution

void main()
{
    float width = 1.0/4.0;/// In texels
    float factor = 0.05;/// Factors from 0.01 to 0.1 seem okay
    factor = factor*sin(time);
    vec2 uv = gl_TexCoord[0].xy;

    float power = 1.0;
    
    float xfact = (1.0 + sin((2.0*3.14159265*uv.x/width) + time))/2.0;/// [0,1.0)
    xfact = pow(xfact , power);

    float yfact = (1.0 + cos((2.0*3.14159265*uv.y/width) + time))/2.0;/// [0,1.0)
    yfact = pow(yfact , power);

    /// Modify x value by sin(2PI*x/50.0) and y value by sin(2PI*y/50.0)
    uv = vec2(uv.x + factor*yfact , uv.y + factor*xfact);
    gl_FragColor = texture2D(tex, uv);
}

