#include <iostream>
#include <string>
#include <vector>
#include <sstream>
#include <chrono>
#include <thread>
#include "allegro5\allegro.h"
#include "allegro5\allegro_color.h"
#include "allegro5/allegro_primitives.h"
#include "Chunk.h"
#include <random>
#include "Planet.h"
#include "AstronomicalObject.h"

void testDraw(AstronomicalObject *ast)
{
    ast->draw();
    if ( typeid(*ast) == typeid(Planet) )
    {
        std::cout<<"PLANET";
    }else
    {
        std::cout<<"imanobject";
    }
}
int main(int argc, char **argv)
{
    auto now = std::chrono::system_clock::now();
    auto now_ms = std::chrono::time_point_cast<std::chrono::milliseconds>(now);
    auto value = now_ms.time_since_epoch();
    unsigned int duration = value.count();

    srand(duration);
    if (al_init() && al_init_primitives_addon())
    {
        std::cout<<"It Works";
    }else
    {
        std::cout << "Allegro Not Loaded";
        return 1;
    }
    al_set_new_display_flags(ALLEGRO_FRAMELESS);
    ALLEGRO_DISPLAY * mainDisplay = al_create_display(1800,1000);
    Chunk testChunk;
    Planet * testPlanet = new Planet(3,6);
    testPlanet ->draw();
    al_flip_display();
    std::this_thread::sleep_for(std::chrono::milliseconds(1000));
    for (int u = 0;u<5;u++)
    {
        testChunk = Chunk(true);
        std::cout<<testChunk.getAstroObjListSize();
        al_clear_to_color(al_map_rgb(20,20,20));
        for (unsigned int i = 0; i<(testChunk.getAstroObjListSize());i++)
        {
            testDraw(testChunk.getAstroObjBylistIndex(i));
        }
        al_flip_display();
        std::this_thread::sleep_for(std::chrono::milliseconds(1000));

    }

    //al_set_target_bitmap(nullptr);
    //al_destroy_display(mainDisplay);
    al_shutdown_primitives_addon();
    return 0;
}
