
#define ALLEGRO_UNSTABLE

#include "allegro5/allegro.h"
#include "allegro5/allegro_image.h"
#include "allegro5/allegro_font.h"
#include "allegro5/allegro_ttf.h"


#include <cmath>
#include <iostream>


int ww = 1200;
int wh = 900;

ALLEGRO_DISPLAY* d = 0;

ALLEGRO_FONT* df = 0;

void RecreateBitmaps(ALLEGRO_BITMAP* buf[4]);
void RecreateBitmaps(ALLEGRO_BITMAP* buf[4]) {
   for (int i = 0 ; i < 4 ; ++i) {
      if (buf[i]) {al_destroy_bitmap(buf[i]);buf[i] = 0;}
   }
   
   al_set_new_bitmap_flags(ALLEGRO_VIDEO_BITMAP);
   
   ALLEGRO_BITMAP* bmp = al_load_bitmap("Survivor256.png");
   
   al_set_new_bitmap_flags(ALLEGRO_MIN_LINEAR);
   buf[0] = al_create_bitmap(256,256);
   al_set_new_bitmap_flags(ALLEGRO_MAG_LINEAR);
   buf[1] = al_create_bitmap(256,256);
   
   al_set_new_bitmap_flags(ALLEGRO_MIN_LINEAR | ALLEGRO_MIPMAP);
   buf[2] = al_create_bitmap(256,256);
   al_set_new_bitmap_flags(ALLEGRO_MAG_LINEAR | ALLEGRO_MIPMAP);
   buf[3] = al_create_bitmap(256,256);
   
   al_set_blender(ALLEGRO_ADD , ALLEGRO_ONE , ALLEGRO_ZERO);
   for (int i = 0 ; i < 4 ; ++i) {
      al_set_target_bitmap(buf[i]);
      al_clear_to_color(al_map_rgba(0,0,0,0));
      al_draw_bitmap(bmp , 0 , 0 , 0);
   }
   
   al_set_blender(ALLEGRO_ADD , ALLEGRO_ONE , ALLEGRO_INVERSE_ALPHA);
   al_destroy_bitmap(bmp);
}

int main(int argc , char** argv) {
    
    
    if (!al_init()) {return 1;}
    if (!al_init_image_addon()) {return 2;}
    if (!al_init_font_addon()) {return 3;}
    if (!al_init_ttf_addon()) {return 4;}
    
    if (!al_install_keyboard()) {return 10;}
    if (!al_install_mouse()) {return 11;}
    
///    al_set_new_display_option(ALLEGRO_SAMPLE_BUFFERS , 1 , ALLEGRO_SUGGEST);
///    al_set_new_display_option(ALLEGRO_SAMPLES , 8 , ALLEGRO_SUGGEST);
    
    al_set_new_display_flags(ALLEGRO_OPENGL | ALLEGRO_WINDOWED);
    
    d = al_create_display(ww,wh);
    
    if (!d) {return -1;}
    
///    if (al_get_display_option(d , ALLEGRO_SAMPLE_BUFFERS) != 1) {
///       std::cout << "Multi sampling not enabled." << std::endl;
///   }
///    std::cout << "There are " << al_get_display_option(d , ALLEGRO_SAMPLES) << " sample buffers in use." << std::endl;
    
    
    df = al_load_ttf_font("Verdana.ttf" , -20 , 0);
    if (!df) {return -2;}
    
    
    ALLEGRO_TIMER* t = al_create_timer(1.0/60.0);
    
    ALLEGRO_EVENT_QUEUE* q = al_create_event_queue();
    
    al_register_event_source(q , al_get_display_event_source(d));
    al_register_event_source(q , al_get_keyboard_event_source());
    al_register_event_source(q , al_get_timer_event_source(t));
    al_register_event_source(q , al_get_mouse_event_source());
    
    ALLEGRO_BITMAP* buf[4] = {0};
    
    RecreateBitmaps(buf);

    al_start_timer(t);
    
    bool redraw = true;
    bool quit = false;
    
    double theta = 0.0;
    int iscale = 100;
    double scale = iscale/100.0;
    
    RecreateBitmaps(buf);
    
    while (!quit) {
        if (redraw) {
            al_set_target_backbuffer(d);
            al_clear_to_color(al_map_rgb(255,255,255));
            
            al_set_target_bitmap(al_get_backbuffer(d));

            al_draw_scaled_rotated_bitmap(buf[0] , 128 , 128 , ww/4   , wh/4   , scale , scale , theta , 0);
            al_draw_scaled_rotated_bitmap(buf[1] , 128 , 128 , 3*ww/4 , wh/4   , scale , scale , theta , 0);
            al_draw_scaled_rotated_bitmap(buf[2] , 128 , 128 , ww/4   , 3*wh/4 , scale , scale , theta , 0);
            al_draw_scaled_rotated_bitmap(buf[3] , 128 , 128 , 3*ww/4 , 3*wh/4 , scale , scale , theta , 0);

            al_draw_textf(df , al_map_rgb(0,0,0) , ww/4 , 10   , ALLEGRO_ALIGN_CENTER , "ALLEGRO_MIN_LINEAR");
            al_draw_textf(df , al_map_rgb(0,0,0) , 3*ww/4 , 10 , ALLEGRO_ALIGN_CENTER , "ALLEGRO_MAG_LINEAR");
            
            al_draw_textf(df , al_map_rgb(0,0,0) , ww/2 , wh - 50 , ALLEGRO_ALIGN_CENTER , "ALLEGRO_MIPMAP");
            
            al_draw_textf(df , al_map_rgb(0,0,0) , ww/2 , wh/2 - 15 , ALLEGRO_ALIGN_CENTER , "Scale = %3.2f" , scale);
            al_draw_textf(df , al_map_rgb(0,0,0) , ww/2 , wh/2 + 15 , ALLEGRO_ALIGN_CENTER , "Theta = %4.2f" , theta*180.0/M_PI);
            
            al_flip_display();
            
            redraw = false;
        }
        do {
            ALLEGRO_EVENT ev;
            al_wait_for_event(q , &ev);
            
            if (ev.type == ALLEGRO_EVENT_MOUSE_AXES) {
               theta = atan2(ev.mouse.y - wh/2 , ev.mouse.x - ww/2);
               iscale += ev.mouse.dz;
               if (iscale < 1) {iscale = 1;}
               scale = iscale/100.0;
               redraw = true;
            }
            if (ev.type == ALLEGRO_EVENT_DISPLAY_CLOSE) {
                quit = true;
            }
            if (ev.type == ALLEGRO_EVENT_KEY_DOWN && ev.keyboard.keycode == ALLEGRO_KEY_ESCAPE) {
                quit = true;
            }
            if (ev.type == ALLEGRO_EVENT_TIMER) {
                redraw = true;
            }
        } while (!al_is_event_queue_empty(q));
            
    }
    
    return 0;
} 
