



#include "allegro5/allegro.h"
#include "allegro5/allegro_audio.h"
#include "allegro5/allegro_acodec.h"
#include "allegro5/allegro_font.h"
#include "allegro5/allegro_primitives.h"

#include <cstdio>


int main(int argc , char** argv) {
   
   (void)argc;
   (void)argv;
   
   int use_master_mixer = 1;
   
   if (argc == 2) {
        int on = 0;
        if (1 == sscanf(argv[1] , "%d" , &on)) {
            use_master_mixer = 1;
            if (on == 0) {use_master_mixer = 0;}
        }
   }
   
   
   int ww = 800;
   int wh = 600;
   
   if (!al_init()) {return 1;}

   if (!al_init_primitives_addon()) {return 1;}
   
   if (!al_install_audio()) {return 2;}

   if (!al_init_acodec_addon()) {return 3;}

   if (!al_install_keyboard()) {return -1;}
   
   
   al_set_new_display_flags(ALLEGRO_OPENGL | ALLEGRO_WINDOWED);

   ALLEGRO_DISPLAY* d = al_create_display(ww,wh);
   ALLEGRO_EVENT_QUEUE* q = al_create_event_queue();
   ALLEGRO_TIMER* t = al_create_timer(1.0/60.0);
   ALLEGRO_FONT* f = al_create_builtin_font();
   
   if (!f || !d || !t || !q) {
      return -2;
   }
   
   al_register_event_source(q , al_get_display_event_source(d));
   al_register_event_source(q , al_get_timer_event_source(t));
   al_register_event_source(q , al_get_keyboard_event_source());
   
   
///   ALLEGRO_MIXER *al_create_mixer(unsigned int freq , ALLEGRO_AUDIO_DEPTH depth , ALLEGRO_CHANNEL_CONF chan_conf)   
   

   if (!use_master_mixer) {
      al_reserve_samples(2);
   }
   
   int mvol = 255;
   int svol = 255;
   
   ALLEGRO_MIXER* mxmusic = al_create_mixer(44100 , ALLEGRO_AUDIO_DEPTH_FLOAT32 , ALLEGRO_CHANNEL_CONF_2);
   ALLEGRO_MIXER* mxsound = al_create_mixer(44100 , ALLEGRO_AUDIO_DEPTH_FLOAT32 , ALLEGRO_CHANNEL_CONF_2);
   
   
   ALLEGRO_SAMPLE* music = al_load_sample("music.ogg");
   ALLEGRO_SAMPLE* sound = al_load_sample("sound.ogg");
   
   ALLEGRO_SAMPLE_INSTANCE* minst = al_create_sample_instance(music);
   ALLEGRO_SAMPLE_INSTANCE* sinst = al_create_sample_instance(sound);
   
   
   ALLEGRO_VOICE* hwvoice = 0;
   ALLEGRO_MIXER* mxmaster = 0;

   if (use_master_mixer) {
///      hwvoice = al_create_voice(44100 , ALLEGRO_AUDIO_DEPTH_FLOAT32 , ALLEGRO_CHANNEL_CONF_2);/// FLOAT32 is not supported for voices
      hwvoice = al_create_voice(44100 , ALLEGRO_AUDIO_DEPTH_INT16 , ALLEGRO_CHANNEL_CONF_2);
      mxmaster = al_create_mixer(44100 , ALLEGRO_AUDIO_DEPTH_FLOAT32 , ALLEGRO_CHANNEL_CONF_2);
      al_attach_mixer_to_voice(mxmaster , hwvoice);
      al_attach_mixer_to_mixer(mxmusic , mxmaster);
      al_attach_mixer_to_mixer(mxsound , mxmaster);
   }
   else {
      al_attach_mixer_to_mixer(mxmusic , al_get_default_mixer());
      al_attach_mixer_to_mixer(mxsound , al_get_default_mixer());
   }
   al_attach_sample_instance_to_mixer(minst , mxmusic);
   al_attach_sample_instance_to_mixer(sinst , mxsound);
   
   
   bool play_music = false;
   bool play_sound = false;
   
   bool quit = false;
   bool redraw = true;
   
   al_start_timer(t);
   
   while (!quit) {
      if (redraw) {
         
         al_clear_to_color(al_map_rgb(0,0,0));
         
         
         /// Draw music volume and status
         al_draw_filled_rectangle(ww/5 , wh , 2*ww/5 , wh - mvol*wh/(2*255) , al_map_rgb(0,255,0));
         al_draw_rectangle(ww/5 , wh , 2*ww/5 , wh/2 , al_map_rgb(255,255,255) , 5.0);

         al_draw_textf(f , al_map_rgb(255,255,255) , 3*ww/10 , wh/2 - 20 , ALLEGRO_ALIGN_CENTER , "Music %s" , play_music?"On":"Off");
         
         /// Draw sound volume and status
         al_draw_filled_rectangle(3*ww/5 , wh , 4*ww/5 , wh - svol*wh/(2*255) , al_map_rgb(0,0,255));
         al_draw_rectangle(3*ww/5 , wh , 4*ww/5 , wh/2 , al_map_rgb(255,255,255) , 5.0);
         
         al_draw_textf(f , al_map_rgb(255,255,255) , 7*ww/10 , wh/2 - 20 , ALLEGRO_ALIGN_CENTER , "Sound %s" , play_sound?"On":"Off");

         al_flip_display();
         
         redraw = false;
      }
      do {
         ALLEGRO_EVENT ev;
         al_wait_for_event(q , &ev);
         if (ev.type == ALLEGRO_EVENT_DISPLAY_CLOSE) {
            quit = true;
         }
         if (ev.type == ALLEGRO_EVENT_KEY_DOWN && ev.keyboard.keycode == ALLEGRO_KEY_ESCAPE) {
            quit = true;
         }
         if (ev.type == ALLEGRO_EVENT_KEY_CHAR) {
            if (ev.keyboard.keycode == ALLEGRO_KEY_M) {
                if (ev.keyboard.modifiers & ALLEGRO_KEYMOD_CTRL) {
                    play_music = !play_music;
                    al_set_sample_instance_playing(minst , play_music);
                }
                else {
                    if (ev.keyboard.modifiers & ALLEGRO_KEYMOD_SHIFT) {
                        mvol--;
                        if (mvol < 0) {mvol = 0;}
                    }
                    else {
                        mvol++;
                        if (mvol > 255) {mvol = 255;}
                    }
                    al_set_mixer_gain(mxmusic , mvol/255.0);
                    redraw = true;
                }
            }
            if (ev.keyboard.keycode == ALLEGRO_KEY_S) {
                if (ev.keyboard.modifiers & ALLEGRO_KEYMOD_CTRL) {
                    play_sound = !play_sound;
                    al_set_sample_instance_playing(sinst , play_sound);
                }
                else {
                    if (ev.keyboard.modifiers & ALLEGRO_KEYMOD_SHIFT) {
                        svol--;
                        if (svol < 0) {svol = 0;}
                    }
                    else {
                        svol++;
                        if (svol > 255) {svol = 255;}
                    }
                    al_set_mixer_gain(mxsound , svol/255.0);
                    redraw = true;
                }
            }
            
         }
         if (ev.type == ALLEGRO_EVENT_TIMER) {
            if (!al_get_sample_instance_playing(minst)) {
                play_music = false;
            }
            if (!al_get_sample_instance_playing(sinst)) {
                play_sound = false;
            }
            redraw = true;
         }
      } while (!al_is_event_queue_empty(q));
      
   }
   
   al_uninstall_system();
   
   return 0;
}
