



#include "allegro5/allegro.h"
#include "allegro5/allegro_video.h"
#include "allegro5/allegro_audio.h"

#include <cstdio>

int main(int argc , char** argv) {
    
    const char* video_path = "cat.ogv";
    
    if (argc == 2) {
        video_path = argv[1];
    }
    
    
    int ww = 1024;
    int wh = 768;
    
    int vw = 600;
    int vh = 480;
    
    if (!al_init()) {return 1;}
    if (!al_init_video_addon()) {return 2;}
    
    if (!al_install_audio()) {return 3;}
    if (!al_install_keyboard()) {return 4;}

    al_reserve_samples(2);
    
    al_set_new_display_flags(ALLEGRO_OPENGL | ALLEGRO_WINDOWED | ALLEGRO_RESIZABLE);
    
    ALLEGRO_DISPLAY *display = al_create_display(ww,wh);
    ALLEGRO_VIDEO* video = NULL;
    ALLEGRO_BITMAP* bitmap = NULL;
    ALLEGRO_EVENT_QUEUE *evqueue = al_create_event_queue();

    ALLEGRO_TIMER *fps_timer = al_create_timer(1.0 / 60.0);
//    ALLEGRO_PATH *path = al_get_standard_path(ALLEGRO_RESOURCES_PATH);
//    chdir(al_path_cstr(path, '/'));


    al_register_event_source(evqueue, al_get_keyboard_event_source());
    al_register_event_source(evqueue, al_get_display_event_source(display));
    al_register_event_source(evqueue, al_get_timer_event_source(fps_timer));

    
    al_start_timer(fps_timer);
    
    bool redraw = true;
    bool quit = false;
    bool playing = false;
    bool play = true;

    video = al_open_video(video_path);
    if (!video) {
        printf("Failed to load video '%s'.\n" , video_path);
        return -1;
    }
    al_register_event_source(evqueue , al_get_video_event_source(video));
    
    while(!quit)
    {
        if(redraw)
        {
            al_clear_to_color(al_map_rgb(23,111,222));
            if (bitmap && playing) {
                int srcw = al_get_bitmap_width(bitmap);
                int srch = al_get_bitmap_height(bitmap);
                vw = al_get_video_scaled_width(video);
                vh = al_get_video_scaled_height(video);
//                float scalex = vw/destw;
//                float scaley = vh/desth;
//                float scale = (scalex>scaley)?scaley:scalex;
                
                al_draw_scaled_bitmap(bitmap , 0 , 0 , srcw , srch , (ww-vw)/2 , (wh - vh)/2 , vw , vh , 0);
            }
            al_flip_display();
            redraw = false;
        }
        do
        {
            ALLEGRO_EVENT ev;
            al_wait_for_event(evqueue, &ev);

            if(ev.type == ALLEGRO_EVENT_VIDEO_FRAME_SHOW)
            {
                bitmap = al_get_video_frame(video);
            }

            if (ev.type == ALLEGRO_EVENT_KEY_DOWN && ev.keyboard.keycode == ALLEGRO_KEY_P) {
                play = true;
            }
            if (ev.type == ALLEGRO_EVENT_VIDEO_FINISHED) {
                playing = false;
                play = true;/// restart video
            }
            
            if (play) {
                if (!playing) {
                    al_set_video_playing(video , false);
                    al_start_video(video , al_get_default_mixer());
                    al_seek_video(video , 0.0);
                    al_set_video_playing(video , true);
                    int i = 0;
                    while (!(bitmap = al_get_video_frame(video)) && i < 100) {
                        al_rest(0.01);
                        ++i;
                    }
                    if (i < 1000) {
                        playing = true;
                    }
                }
                else {
                    al_set_video_playing(video , false);
                    bitmap = 0;
                    playing = false;
                }
                play = false;
            }
            if (ev.type == ALLEGRO_EVENT_DISPLAY_CLOSE) {
                quit = true;
            }
            if (ev.type == ALLEGRO_EVENT_KEY_DOWN && ev.keyboard.keycode == ALLEGRO_KEY_ESCAPE) {
                quit = true;
            }
            if(ev.type == ALLEGRO_EVENT_TIMER)
            {
                redraw = true;
            }
            if (ev.type == ALLEGRO_EVENT_DISPLAY_RESIZE) {
                al_acknowledge_resize(display);
                ww = al_get_display_width(display);
                wh = al_get_display_height(display);
            }
        }
        while(!al_is_event_queue_empty(evqueue));

    }

    al_close_video(video);
    video = 0;
    
    al_uninstall_system();
    
    return 0;
}
