



#include "allegro5/allegro.h"
#include "allegro5/allegro_primitives.h"


#include <cmath>

int ww = 800;
int wh = 600;

struct BOUNCER {
    float cx , cy;
    float vx , vy;
    float rad , rw , rh;
};

BOUNCER b1;
BOUNCER b2;

void InitBouncer(BOUNCER* b , float cx , float cy , float rw , float rh , float vx , float vy);

void UpdateBouncer(BOUNCER* b , float dt);

void Reset();

void Update(float dt);

void DrawBouncer(BOUNCER* b , ALLEGRO_COLOR cc , ALLEGRO_COLOR rc);

void DrawBouncerSquare(BOUNCER* b , ALLEGRO_COLOR c , bool fill , double thickness = 1.0);

void DrawBouncerCircle(BOUNCER* b , ALLEGRO_COLOR c , bool fill , double thickness = 1.0);

int SquareCollide(BOUNCER* b1 , BOUNCER* b2);

int CircleCollide(BOUNCER* c1 , BOUNCER* c2);



int main(int argc , char** argv) {
    
    if (!al_init()) {return 1;}
    if (!al_install_keyboard()) {return 2;}

    if (!al_init_primitives_addon()) {return 3;}
    
    al_set_new_display_flags(ALLEGRO_OPENGL | ALLEGRO_WINDOWED);
    ALLEGRO_DISPLAY* d = al_create_display(ww,wh);
    
    ALLEGRO_TIMER* t = al_create_timer(1.0/60.0);
    
    ALLEGRO_EVENT_QUEUE* q = al_create_event_queue();
    
    al_register_event_source(q , al_get_keyboard_event_source());
    al_register_event_source(q , al_get_display_event_source(d));
    al_register_event_source(q , al_get_timer_event_source(t));
    
    Reset();
    
    bool quit = false;
    bool redraw = true;
    
    al_start_timer(t);

    while (!quit) {
            
        if (redraw) {
            al_set_target_backbuffer(d);
            al_clear_to_color(al_map_rgb(0,0,0));
            ALLEGRO_COLOR cc = al_map_rgb(0,0,0);
            ALLEGRO_COLOR rc = al_map_rgb(0,0,255);
            if (CircleCollide(&b1 , &b2)) {
               cc = al_map_rgb(255,0,0);
            }
            if (SquareCollide(&b1 , &b2)) {
                rc = al_map_rgb(0,255,0);
            }
            
            DrawBouncer(&b1 , cc , rc);
            DrawBouncer(&b2 , cc , rc);
            
            al_flip_display();
            
            redraw = false;
        }
        
        
        do {
            ALLEGRO_EVENT ev;
            al_wait_for_event(q , &ev);
            if (ev.type == ALLEGRO_EVENT_TIMER) {
                UpdateBouncer(&b1 , 1.0/60.0);
                UpdateBouncer(&b2 , 1.0/60.0);
                if (b1.cx < 0) {b1.vx = fabs(b1.vx);}
                if (b2.cx < 0) {b2.vx = fabs(b2.vx);}
                if (b1.cy < 0) {b1.vy = fabs(b1.vy);}
                if (b2.cy < 0) {b2.vy = fabs(b2.vy);}
                if (b1.cx > ww) {b1.vx = -fabs(b1.vx);}
                if (b2.cx > ww) {b2.vx = -fabs(b2.vx);}
                if (b1.cy > wh) {b1.vy = -fabs(b1.vy);}
                if (b2.cy > wh) {b2.vy = -fabs(b2.vy);}
                redraw = true;
            }
            if (ev.type == ALLEGRO_EVENT_DISPLAY_CLOSE || (ev.type == ALLEGRO_EVENT_KEY_DOWN && ev.keyboard.keycode == ALLEGRO_KEY_ESCAPE)) {
                quit = true;
            }
            if (ev.type == ALLEGRO_EVENT_KEY_DOWN && ev.keyboard.keycode == ALLEGRO_KEY_R) {
                Reset();
                redraw = true;
            }
            
        } while (!al_is_event_queue_empty(q));
    }

    al_uninstall_system();
    
    return 0;
}



void InitBouncer(BOUNCER* b , float cx , float cy , float rw , float rh , float vx , float vy) {
    b->cx = cx;
    b->cy = cy;
    b->rw = rw;
    b->rh = rh;
    b->rad = sqrt(rw*rw + rh*rh)/2.0;
    b->vx = vx;
    b->vy = vy;
}



void UpdateBouncer(BOUNCER* b , float dt) {
    b->cx += b->vx * dt;
    b->cy += b->vy * dt;
}



void Update(float dt) {
    BOUNCER b1a = b1;
    BOUNCER b2a = b2;
    UpdateBouncer(&b1a , dt);
    UpdateBouncer(&b2a , dt);
}



void Reset() {
    
    float sp1 = 200;
    float a1 = M_PI/4.0f;
    float sp2 = 250;
    float a2 = 3.0f*M_PI/4.0f;
    
    
    InitBouncer(&b1 , ww/4 , wh/2 , 180 , 60 , sp1*sin(a1) , sp1*cos(a1));
    InitBouncer(&b2 , 3*ww/4 , wh/2 , 60 , 180 , sp2*sin(a2) , sp2*cos(a2));
}



void DrawBouncer(BOUNCER* b , ALLEGRO_COLOR cc , ALLEGRO_COLOR rc) {
    DrawBouncerCircle(b , cc , true , 0.0);
    DrawBouncerCircle(b , al_map_rgb(255,255,255) , false , 5.0);
    DrawBouncerSquare(b , rc , true , 0.0);
    DrawBouncerSquare(b , al_map_rgb(0,255,255) , false , 5.0);
}



void DrawBouncerSquare(BOUNCER* b , ALLEGRO_COLOR c , bool fill , double thickness) {
    double lx = b->cx - b->rw/2.0;
    double rx = b->cx + b->rw/2.0;
    double ty = b->cy - b->rh/2.0;
    double by = b->cy + b->rh/2.0;
    if (fill) {
        al_draw_filled_rectangle(lx , ty , rx , by , c);
    }
    else {
        al_draw_rectangle(lx , ty , rx , by , c , thickness);
    }
}



void DrawBouncerCircle(BOUNCER* b , ALLEGRO_COLOR c , bool fill , double thickness) {
    if (fill) {
        al_draw_filled_circle(b->cx , b->cy , b->rad , c);
    }
    else {
        al_draw_circle(b->cx , b->cy , b->rad , c , thickness);
    }
}


int SquareCollide(BOUNCER* b1 , BOUNCER* b2) {
    double lx1 = b1->cx - b1->rw/2.0;
    double rx1 = b1->cx + b1->rw/2.0;
    double ty1 = b1->cy - b1->rh/2.0;
    double by1 = b1->cy + b1->rh/2.0;
    double lx2 = b2->cx - b2->rw/2.0;
    double rx2 = b2->cx + b2->rw/2.0;
    double ty2 = b2->cy - b2->rh/2.0;
    double by2 = b2->cy + b2->rh/2.0;
    
    if ((rx1 < lx2) || (lx1 > rx2) || (ty1 > by2) || (by1 < ty2)) {return 0;}
    
    return 1;
}



int CircleCollide(BOUNCER* c1 , BOUNCER* c2) {
    double dx = c2->cx - c1->cx;
    double dy = c2->cy - c1->cy;
    double dr = c1->rad + c2->rad;
    return ((dx*dx + dy*dy) <= (dr*dr));
}




