#ifndef _MAP2D_H_
#define _MAP2D_H_

#include <assert.h>

template <class T> class Map2D
{
protected:
	T *data;

	// dimensions of the map in tile units
	int dim_mx;
	int dim_my;

public:
	Map2D (int w, int h)
	{
		assert (w >= 0);
		assert (h >= 0);
		data = new T[w * h];
		dim_mx = w;
		dim_my = h;
	}

	Map2D ()
	{
		data = nullptr;
		dim_mx = 0;
		dim_my = 0;
	}

	virtual ~Map2D()
	{
		if (data) delete[] data;
		data = nullptr;
	}

	T &get (int mx, int my)
	{
		assert (inBounds(mx, my));
		assert (data);
		return data[mx + dim_mx * my];
	}

	void init (int w, int h)
	{
		if (data)
			delete[] data;

		dim_mx = w;
		dim_my = h;
		data = new T[dim_mx * dim_my];
	}

	int getDimMX() { return dim_mx; }
	int getDimMY() { return dim_my; }

	bool inBounds(int mx, int my)
	{
		return (mx >= 0) && (my >= 0) && (mx < dim_mx) && (my < dim_my);
	}
};

#endif
