#ifndef ENGINE_H
#define ENGINE_H

#include <allegro5/allegro.h>
#include "input.h"
#include "settings.h"
#include "resources.h"
#include <list>
#include "playercontrol.h"
#include "script.h"
#include "insults.h"
#include "component.h"
#include "mainloop.h"
#include "menubase.h"
#include <memory>

const int DIRNUM = 8;
extern const char *DIRECTIONS[];

class Engine : public IContainer
{
private:
	MenuListPtr mMain;
	MenuListPtr mKeys;
	MenuListPtr mPause;
	ALLEGRO_FONT *menufont;

	bool debug;
	
	Settings settings;
	Resources resources;
	
	std::string gameover_message;
	
	std::shared_ptr<PlayerControl> playerControl;
	std::shared_ptr<Script> script;
	
	Input btnScreenshot;

#ifdef DEBUG
	Input btnAbort;
	Input btnDebugMode;
#endif
	
	std::shared_ptr<IComponent> initMenuBackground();
	void initMenu();
public:	
	virtual void handleMessage (std::shared_ptr<IComponent> src, int msg) override;

	enum { E_NONE, E_MAINMENU, E_STARTGAME, E_NEXTLEVEL, E_NEXTSCRIPT, E_PAUSE, E_RESUME, E_QUIT, MENU_SETTINGS, E_TOGGLE_FULLSCREEN };

	Engine ();
	virtual ~Engine() {}
	Resources *getResources() { return &resources; }
	int init(); // call once during startup

	void initLevel(int level);
	
	virtual void onUpdate () override;
	void spawn();
	
	bool isDebug () { return debug; }

	int getCounter ();
	int getMaxZOrder ();

	std::shared_ptr<PlayerControl> getPlayerControl() { return playerControl; }

	Input* getInput();
};

#endif
