import std.random;
import std.algorithm;

enum w=80, h=25;

char scr[h][w];

//Cursor
int cx=0, cy=0;

void clear() {
	cx = cy = 0;
	foreach (int y; 0..h) {
		/*foreach (int x; 0..w) {
			scr[y][x] = cast(char)uniform!"[]"(32, 126);
		}*/
		scr[y][] = ' ';
	}
}

void write(string s) {
	foreach (c; s) write(c);
}

void write(char c) {
	if (c != '\n') {
		scr[cy][cx] = c;
		cx++;
	}
	if (c == '\n' || cx >= w) {
		cx = 0;
		cy++;
		if (cy >= h) {
			scrollUp();
			cy--;
		}
	}
}

void del() {
	if (cx == 0) {
		cx = w;
		cy--;
	}
	cx--;
	scr[cy][cx] = ' ';
}

void scrollUp() {
	foreach (y; 0..h-1)
		scr[y] = scr[y+1];
	scr[h-1][] = ' ';
}

//Simulates the scroll position being corrupted in a hardware scrolling environment :)
void scrollGlitch() {
	int r = uniform(0, w*h);
	//Rotate the content so that what's at 0,0 now appears at r.
	scr[0].ptr[0..w*h].reverse();
	scr[0].ptr[0..r].reverse();
	scr[0].ptr[r..w*h].reverse();
	//Move the cursor with it.
	cx += r;
	cy += cx/w; cx %= w;
	cy %= h;
}
