import allegro5.allegro;
import std.exception;
import std.string;

ALLEGRO_SHADER* fontShader;

void initShaders() {
	auto defaultVertexShaderSource = al_get_default_shader_source(ALLEGRO_SHADER_PLATFORM.ALLEGRO_SHADER_GLSL, ALLEGRO_SHADER_TYPE.ALLEGRO_VERTEX_SHADER);

	fontShader = enforce(al_create_shader(ALLEGRO_SHADER_PLATFORM.ALLEGRO_SHADER_GLSL), "al_create_shader");
	enforce(al_attach_shader_source(fontShader, ALLEGRO_SHADER_TYPE.ALLEGRO_VERTEX_SHADER, defaultVertexShaderSource), "al_attach_shader_source vertex");
	enforce(al_attach_shader_source(fontShader, ALLEGRO_SHADER_TYPE.ALLEGRO_PIXEL_SHADER, pixelShaderSource.toStringz()), "al_attach_shader_source pixel");
	enforce(al_build_shader(fontShader), "al_build_shader");
}

void destroyShaders() {
	al_destroy_shader(fontShader);
}

enum pixelShaderSource = `
#ifdef GL_ES
precision mediump float;
#endif
uniform sampler2D ` ~ ALLEGRO_SHADER_VAR_TEX ~ `;
uniform bool ` ~ ALLEGRO_SHADER_VAR_USE_TEX ~ `;
varying vec4 varying_color;
varying vec2 varying_texcoord;
void main() {
	ivec2 ts = textureSize(` ~ ALLEGRO_SHADER_VAR_TEX ~ `, 0);
	float yf = fract(varying_texcoord.y * ts.y) - 0.5;
	float brightness = 1.5 - abs(yf)*2;
	if (` ~ ALLEGRO_SHADER_VAR_USE_TEX ~ `)
		gl_FragColor = varying_color * texture2D(` ~ ALLEGRO_SHADER_VAR_TEX ~ `, varying_texcoord) * brightness;
	else
		gl_FragColor = varying_color * brightness;
}
`;
