static import textbuffer;
import std.conv;
import allegro5.allegro;
import main;
import std.stdio;

enum numScores = 10;

struct SCORE {
	string name;
	int score;
}

SCORE defaultScores[numScores] = [
	{"Data", 0x10000},
	{"HAL 9000", 0x9000},
	{"MCP", 0x8000},
	{"GLaDOS", 0x7000},
	{"Skynet", 0x6000},
	{"WOPR", 0x5000},
	{"Nikola Tesla", 0x4000},
	{"Albert Einstein", 0x3000},
	{"Leonardo Da Vinci", 0x2000},
	{"Wheatley", 0x100},
];

SCORE scores[numScores];

int step = 0;
bool doneTable = false;
int scoreAchieved = 0;
char[] newName;
int currentInputLine = -1;
bool backtrack;

enum currentVersion = 3;

void init(out bool fullscreen, out int wx, out int wy, out int sw, out int sh) {
	scores = defaultScores;
	wx = wy = int.min;
	sw = DEFAULT_SCREEN_W;
	sh = DEFAULT_SCREEN_H;
	fullscreen = false;

	try {
		auto f = al_fopen("HumanCPU.cfg", "rb");
		if (f) {
			scope (exit) al_fclose(f);

			int ver = al_fgetc(f);
			if (ver < 1 || ver > currentVersion) throw new Exception("Unsupported version " ~ to!string(ver));

			fullscreen = (al_fgetc(f) != 0);
			if (ver >= 2) {
				sw = al_fread32le(f);
				sh = al_fread32le(f);
				if (ver >= 3) {
					wx = al_fread32le(f);
					wy = al_fread32le(f);
				}
			}

			foreach (ref s; scores) {
				char[] c;
				c.length = al_fgetc(f);
				al_fread(f, c.ptr, c.length);
				s.name = c.idup;
				s.score = al_fread32le(f);
			}

			if (al_feof(f)) throw new Exception("al_feof");
			if (al_ferror(f)) throw new Exception("al_ferror");
		}
	} catch (Exception e) {
		writeln("Unable to load config: " ~ e.toString());
		scores = defaultScores;
		wx = wy = int.min;
		sw = DEFAULT_SCREEN_W;
		sh = DEFAULT_SCREEN_H;
		fullscreen = false;
	}
}

void save() {
	try {
		auto f = al_fopen("HumanCPU.cfg", "wb");
		if (!f) throw new Exception("al_fopen");
		scope (exit) al_fclose(f);

		al_fputc(f, currentVersion);

		al_fputc(f, (al_get_display_flags(display) & ALLEGRO_FULLSCREEN_WINDOW) ? 1 : 0);
		al_fwrite32le(f, windowWidth);
		al_fwrite32le(f, windowHeight);
		al_fwrite32le(f, windowX);
		al_fwrite32le(f, windowY);

		foreach (ref s; scores) {
			al_fputc(f, s.name.length);
			al_fwrite(f, s.name.ptr, s.name.length);
			al_fwrite32le(f, s.score);
		}

		if (al_feof(f)) throw new Exception("al_feof");
		if (al_ferror(f)) throw new Exception("al_ferror");
	} catch (Exception e) {
		writeln("Unable to save config: " ~ e.toString());
	}
}

void activate(int score) {
	step = 0;
	doneTable = false;
	scoreAchieved = score;
	newName.length = 0;
	currentInputLine = -1;
	backtrack = false;
}

void tick() {
	if (!doneTable && currentInputLine < 0) stepScoreTable();
}

//I miss C# coroutines...
void stepScoreTable() {
	int step2 = 0;
	if (step == step2++) {
		if (textbuffer.cy < textbuffer.h - 1) textbuffer.write('\n');
		else step++;
	} else if (step == step2++) {
		textbuffer.write('\n'); step++;
	} else if (step == step2++) {
		if (writeCentred("THE HUMAN CPU EXPERIMENT")) step++;
	} else if (step == step2++) {
		textbuffer.write('\n'); step++;
	} else if (step == step2++) {
		if (writeCentred("Allegro SpeedHack 2015 - Ben Wieczorek-Davis")) step++;
	} else if (step == step2++) {
		textbuffer.write('\n'); step++;
	} else {
		foreach (i, ref s; scores) {
			if (step == step2++) {
				textbuffer.write('\n'); step++; return;
			} else if (step == step2++) {
				string numStr = to!string(i+1) ~ ". ";
				if (textbuffer.cx < 4 - numStr.length) {textbuffer.write(' '); return;}
				if (textbuffer.cx < 4) {textbuffer.write(numStr[$ + textbuffer.cx - 4]); return;}
				if (scoreAchieved > 0 && scoreAchieved >= s.score) {currentInputLine = i; return;}
				if (backtrack && textbuffer.cx > 4) {textbuffer.del(); return;}
				backtrack = false;
				if (textbuffer.cx < 4 + s.name.length) {textbuffer.write(s.name[textbuffer.cx - 4]); return;}
				if (s.name.length > 0 && textbuffer.cx == 4 + s.name.length) {textbuffer.write(' '); return;}
				string scoreString = to!string(s.score, 16);
				if (textbuffer.cx < textbuffer.w - 1 - scoreString.length) {textbuffer.write('.'); return;}
				if (textbuffer.cx < textbuffer.w - scoreString.length) {textbuffer.write(' '); return;}
				textbuffer.write(scoreString[$ + textbuffer.cx - textbuffer.w]);
				if (textbuffer.cx == 0) step++;
				return;
			}
		}
		if (step == step2++) {
			textbuffer.write('\n'); step++;
		} else if (step == step2++) {
			version (OSX) {
				if (writeCentred("Cmd+Enter = toggle full screen      Cmd+R = reset high scores")) step++;
			} else {
				if (writeCentred("Alt+Enter = toggle full screen      Ctrl+R = reset high scores")) step++;
			}
		} else if (step == step2++) {
			textbuffer.write('\n'); step++;
		} else {
			doneTable = writeCentred("PRESS ANY KEY TO PLAY");
		}
	}
}

bool writeCentred(string msg) {
	int x = (textbuffer.w - msg.length) / 2;
	if (textbuffer.cx < x) textbuffer.cx++;
	else textbuffer.write(msg[textbuffer.cx - x]);
	return textbuffer.cx == x + msg.length;
}

bool writeRight(string msg, int x) {
	x -= msg.length;
	if (textbuffer.cx < x) textbuffer.cx++;
	else textbuffer.write(msg[textbuffer.cx - x]);
	return textbuffer.cx == x + msg.length;
}

void handleKeyChar(ref ALLEGRO_EVENT event) {
	if (!doneTable && currentInputLine < 0) {
		while (!doneTable && currentInputLine < 0)
			stepScoreTable();
		return;
	}

	if (currentInputLine >= 0) {
		int c = event.keyboard.unichar;
		if (c >= ' ' && c <= '~' && textbuffer.cx < textbuffer.w - to!string(scoreAchieved, 16).length - 1) {
			newName ~= c;
			textbuffer.write(cast(char)c);
		}
		if (event.keyboard.keycode == ALLEGRO_KEY_BACKSPACE ||
			event.keyboard.keycode == ALLEGRO_KEY_DELETE ||
			event.keyboard.keycode == ALLEGRO_KEY_PAD_DELETE ||
			event.keyboard.keycode == ALLEGRO_KEY_LEFT)
		{
			if (newName.length > 0) {
				newName.length--;
				textbuffer.del();
			}
		}

		if (event.keyboard.keycode == ALLEGRO_KEY_ENTER) {
			foreach_reverse (i; currentInputLine+1..numScores)
				scores[i] = scores[i-1];
			scores[currentInputLine].name = newName.idup;
			scores[currentInputLine].score = scoreAchieved;
			currentInputLine = -1;
			scoreAchieved = 0;
			save();
		}
		if (event.keyboard.keycode == ALLEGRO_KEY_ESCAPE) {
			backtrack = true;
			currentInputLine = -1;
			scoreAchieved = 0;
		}
		return;
	}

	if (event.keyboard.keycode == ALLEGRO_KEY_ESCAPE) {
		shouldExit = true;
	} else if (event.keyboard.keycode == ALLEGRO_KEY_R && (event.keyboard.modifiers & (ALLEGRO_KEYMOD_CTRL | ALLEGRO_KEYMOD_COMMAND))) {
		scores = defaultScores;
		save();
		//Rebuild the display
		activate(0);
		while (!doneTable)
			stepScoreTable();
	} else {
		textbuffer.write('\n');
		game.init();
		inGame = true;
	}
}
