import main;
static import textbuffer;
import hyperparticles;
import allegro5.allegro;
import questions;
import std.random;
static import sound;
import std.math;
import std.conv;

string intro =
`You are me.
You are the computer.
You must compute.

Follow the instructions.
Do not be slow. Computers are not slow.
Don't get them wrong. Computers don't get them wrong.

Ready
Set
Go!!!
`;
int introPos;
int introDelay;
char[] currentAnswer;
bool inputActive;
int severity;
enum fatalSeverity = 30;
int fateCountup;
int pause;	//Used to protect the user when they run out of time on a question, so they don't clobber the next question!
int score;

void init() {
	introPos = 0;
	introDelay = 100;
	currentAnswer.length = 0;
	inputActive = false;
	severity = 0;
	fateCountup = 0;
	pause = 0;
	score = 0;
	resetQuestions();
}

void handleKeyChar(ref ALLEGRO_EVENT event) {
	if (event.keyboard.keycode == ALLEGRO_KEY_ESCAPE || fateCountup >= explodeTime) {
		nonParticleScreenOn = true;
		highscores.activate(score);
		inGame = false;
		return;
	}

	//Skip intro
	if (introPos < intro.length) {
		textbuffer.write(intro[introPos..intro.length]);
		introPos = intro.length;
		introDelay = 50;
		return;
	}

	if (inputActive) {
		int c = event.keyboard.unichar;
		if (c >= ' ' && c <= '~' && currentAnswer.length < 255) {
			currentAnswer ~= c;
			textbuffer.write(cast(char)c);
		}
		if (event.keyboard.keycode == ALLEGRO_KEY_BACKSPACE ||
			event.keyboard.keycode == ALLEGRO_KEY_DELETE ||
			event.keyboard.keycode == ALLEGRO_KEY_PAD_DELETE ||
			event.keyboard.keycode == ALLEGRO_KEY_LEFT)
		{
			if (currentAnswer.length > 0) {
				currentAnswer.length--;
				textbuffer.del();
			}
		}

		if (event.keyboard.keycode == ALLEGRO_KEY_ENTER) {
			inputActive = false;
			checkAnswer(" XXX ");
		}
	}
}

void tick() {
	if (introDelay > 0) introDelay--;
	if (introDelay > 0) return;
	if (introPos < intro.length) {
		char c = intro[introPos++];
		textbuffer.write(c);
		if (c == '\n') introDelay = 50;
		else introDelay = 3;
		return;
	}

	//If we get here, intro is done.

	if (severity >= fatalSeverity) {
		doFate();
		fateCountup++;
	} else if (!inputActive) {
		if (pause > 0) pause--;
		if (pause == 0) nextQuestion();
	} else {
		//Time limit!
		if (ticks >= questionDeadline) {
			inputActive = false;
			pause = 100;
			checkAnswer(" TIME UP ");
		}
	}
}

void nextQuestion() {
	generateQuestion();
	textbuffer.write(question.message);
	textbuffer.write(": ");
	currentAnswer.length = 0;
	inputActive = true;
}

void checkAnswer(string ifWrong) {
	if (answerIsRight(currentAnswer)) {
		severity -= 3;
		if (severity < 0) severity = 0;
		sound.cutLouderThan(severity);
		enum maxPoints = 0x400;
		enum halvePointsForEvery = 5;	//seconds
		int bonus = cast(int)(maxPoints * pow(0.5f, cast(float)(ticks - questionStartTime) / (100f * halvePointsForEvery)));
		score += bonus;
		string scoreStr = "Score + " ~ to!string(bonus, 16) ~ " = " ~ to!string(score, 16);
		textbuffer.scr[textbuffer.cy][$-scoreStr.length..$] = scoreStr;
	} else {
		severity += 5;
		//Corrupt the screen a bit!
		foreach (i; 0..severity*severity/10) textbuffer.scr[uniform(0,$)][uniform(0,$)] = uniform!"[]"(' ','~');
		if (severity >= 15) textbuffer.scrollGlitch();
		setRandomNote(uniform(0,4), severity);

		textbuffer.write(ifWrong);
		textbuffer.write(question.rightAnswer);
	}
	textbuffer.write('\n');
	if (severity < fatalSeverity && pause == 0) nextQuestion();
}

void setRandomNote(int channel, int maxVolume) {
	if (maxVolume > 15) maxVolume = 15;
	sound.setNote(channel, uniform01() < 1f-severity*0.05f ? 0 : uniform(0,256), uniform!"[]"(1, maxVolume));
}

enum explodeTime = 100;

void doFate() {
	if (fateCountup == explodeTime) {
		initParticles();
		particleScr = textbuffer.scr;
		particleCx = textbuffer.cx;
		particleCy = textbuffer.cy;
		textbuffer.clear();
		particlesOn = true;
		nonParticleScreenOn = false;
	}

	if (fateCountup < explodeTime) {
		if (fateCountup == 0 || uniform01() < 0.01f) {
			foreach (i; 0..4) setRandomNote(i, 4);
			textbuffer.scrollGlitch();
		}
		if (uniform01() < 0.04f) {
			foreach (i; 0..100)
				textbuffer.scr[uniform(0,$)][uniform(0,$)] = uniform!"[]"(' ','~');
		}
	} else {
		int vol = 15 - (fateCountup - explodeTime) / 9;
		if (vol < 0) vol = 0;
		sound.setNote(0, 7, vol);
		//Warble the pitch: p, p/2, p/3, p/4, p/5, p/4, etc.
		enum p = 60;
		int pitch = (fateCountup - explodeTime) / 3;
		pitch = pitch % 8;
		if (pitch > 4) pitch = 8 - pitch;
		sound.setNote(1, p / (pitch + 1), 0);
		//Make another warbler at a different speed
		pitch = (fateCountup - explodeTime) / 3;
		pitch = pitch % 6;
		if (pitch > 3) pitch = 6 - pitch;
		sound.setNote(2, 20 / (pitch + 1), vol / 2);

		//Final channel off
		sound.setNote(3, 0, 0);
	}
}
