#include "Globals.h"

//object variables
T_SCENE scene;
T_CAM cam;
T_PLAYER you;
T_GUI gui;
T_BS bs;//bad sounds
vector <T_ART> weeds;


//Allegro variables
ALLEGRO_DISPLAY *display;
ALLEGRO_BITMAP *weed;
ALLEGRO_FONT *font15;
ALLEGRO_FONT *font40;


//GLOBAL VARIABLES
float diagonalDecrease;
int frameStart[3] = {0,1,3};
int reversePoint[4] = {CS_RIGHT,CS_LEFT,CS_DOWN,CS_UP};//reverse collision points


//prototypes
void InitPlayer();

void InitCam();
void InitScene();
void InitArticles();
void RenderScene();
void DestroyScene();

void InitGUI();
void RenderGUI();

void InitSound();
void PlaySound();
void DestroySound();


//movement
void calcPosLeft();
void calcPosRight();
void calcPosUp();
void calcPosDown();
void calcDiagonal();

void Update();
void CheckCollisions();
void AssistDirection();

void PlantWeed();
void RenderWeeds();


int main(void)
{
	//primitive variable
	const int FPS = 60;
	bool done = false;
	bool redraw = true;


	//init globals;
	diagonalDecrease = 1;
	display = NULL;//init display
	ALLEGRO_EVENT_QUEUE *event_queue = NULL;
	ALLEGRO_TIMER *timer = NULL;


	//Initialization Functions
	if(!al_init())										//initialize Allegro
		return -1;

	display = al_create_display(DISPLAYWIDTH, DISPLAYHEIGHT);			//create our display object

	if(!display)										//test display object
		return -1;

	//Allegro Module Init
	al_init_primitives_addon();
	al_install_keyboard();
	al_init_image_addon();
	al_init_font_addon();
	al_init_ttf_addon();

	//let there be rock
	al_install_audio();
	al_init_acodec_addon();
	al_reserve_samples(10);

	srand(time(NULL)); //seed the random number generator


	event_queue = al_create_event_queue();
	timer = al_create_timer(1.0 / FPS);


	//Game Init
	InitScene();
	InitPlayer();
	InitCam();
	InitGUI();
	InitSound();
	InitArticles();


	al_register_event_source(event_queue, al_get_keyboard_event_source());
	al_register_event_source(event_queue, al_get_display_event_source(display));
	al_register_event_source(event_queue, al_get_timer_event_source(timer));
	font15 = al_load_font(".\\SCENE\\FreeSansBold.ttf", 15, 0);
	font40 = al_load_font(".\\SCENE\\FreeSansBold.ttf", 40, 0);

	al_start_timer(timer);

	cooldown = 0;
	weedcount = 0;

	while(!done)
	{
		ALLEGRO_EVENT ev;
		al_wait_for_event(event_queue, &ev);

		if(ev.type == ALLEGRO_EVENT_DISPLAY_CLOSE)
		{
			done = true;
		}
		else if(ev.type == ALLEGRO_EVENT_TIMER)
		{
			redraw = true;

			you.dirX = 0;
			you.dirY = 0;
		
			if(keys[UP])
				you.dirY = -1;
			if(keys[DOWN])
				you.dirY = 1;
			if(keys[LEFT])
				you.dirX = -1;
			if(keys[RIGHT])
				you.dirX = 1;


		}
		else if(ev.type == ALLEGRO_EVENT_KEY_DOWN)
		{

			switch(ev.keyboard.keycode)
			{
				case ALLEGRO_KEY_ESCAPE:
					done = true;
					break;
				case ALLEGRO_KEY_UP:
					keys[UP] = true;
					break;
				case ALLEGRO_KEY_DOWN:
					keys[DOWN] = true;
					break;
				case ALLEGRO_KEY_RIGHT:
					keys[RIGHT] = true;
					break;
				case ALLEGRO_KEY_LEFT:
					keys[LEFT] = true;
					break;
				case ALLEGRO_KEY_SPACE:
					keys[SPACE] = true;
					break;

			}
		}
		else if(ev.type == ALLEGRO_EVENT_KEY_UP)
		{
			switch(ev.keyboard.keycode)
			{
				case ALLEGRO_KEY_UP:
					keys[UP] = false;
					break;
				case ALLEGRO_KEY_DOWN:
					keys[DOWN] = false;
					break;
				case ALLEGRO_KEY_RIGHT:
					keys[RIGHT] = false;
					break;
				case ALLEGRO_KEY_LEFT:
					keys[LEFT] = false;
					break;
				case ALLEGRO_KEY_SPACE:
					if(cooldown == 0)
					{
 						PlantWeed();
					}

					keys[SPACE] = false;
					break;

			}
		}

		//update & collision detection goes here
		Update();
		CheckCollisions();

		
		//render
		if(redraw && al_is_event_queue_empty(event_queue))
		{
			redraw = false;
			RenderScene();

			RenderWeeds();

			//draw player image
			if(you.state == STOP)
			{
				al_draw_bitmap_region(you.image,0 ,you.frameheight * you.stopCompass,
					you.framewidth, you.frameheight, cam.rendX,cam.rendY,0);
			}
			else
			{
				al_draw_bitmap_region(you.image,you.framewidth * (frameStart[you.state] + you.currentFrame),you.frameheight * you.compass,
					you.framewidth, you.frameheight, cam.rendX ,cam.rendY,0);			
			
			}

			if(you.water)//draw bucket
				al_draw_bitmap(you.waterbucket,cam.x - 16,cam.y - 16,0);


			//bounding box
			//al_draw_filled_rectangle(cam.x - you.boundx, cam.y - you.boundy, cam.x + you.boundx, cam.y + you.boundy, al_map_rgb(255,255,255));


			RenderGUI();

			al_flip_display();
			al_clear_to_color(al_map_rgb(0,0,0));
		}

	}//end gameloop

	
	//shuttdown
	DestroyScene();
	DestroySound();
	al_destroy_bitmap(you.image);
	al_destroy_bitmap(you.waterbucket);
	al_destroy_bitmap(weed);
	al_destroy_event_queue(event_queue);
	al_destroy_timer(timer);
	al_destroy_display(display);
	al_destroy_font(font15);
	al_destroy_font(font40);
	weeds.clear();


	return 0;
}


void InitPlayer()
{

	you.dirX = 0;
	you.dirY = 0;
	you.compass = 6;//south - start off faceing the audience
	you.stopCompass = 6;//same here
	you.framewidth = 96;
	you.frameheight = 96;
	you.halfwidth = you.framewidth / 2;
	you.halfheight = you.frameheight / 2;
	you.x = you.halfwidth;//top left corner
	you.y = (HEIGHT / 2) - you.halfheight;//half way down

	you.ID = PLAYER;
	you.lives = 3;
	you.speed = 3;
	you.boundx = 12;
	you.boundy = 24;
	you.score = 0;
	you.state = STOP;

	you.frameCount = 0;
	you.frameDelay = 10;
	you.maxFrame = 2;
	you.currentFrame = 0;

	//collision
	you.collision = false;
	for(int i = 0; i < 4; i++)
		you.colPoints[i] = -1;//-1 = no collision
	you.collidingWith = NOTHING;



	ALLEGRO_BITMAP *shrunk;
	int w, h;
	shrunk = al_load_bitmap(".\\SCENE\\hippy.png");//temp bitmap - expand to double
	w = al_get_bitmap_width(shrunk);
	h = al_get_bitmap_height(shrunk);

	you.image = al_create_bitmap(w * 2,h * 2);
	
	//double the size - halving the res :( 
	al_set_target_bitmap(you.image);

	al_draw_scaled_bitmap(shrunk,0,0,w,h,0,0,w*2,h*2,0);

	al_convert_mask_to_alpha(you.image,al_map_rgb(106,76,48)); 

	al_set_target_bitmap(al_get_backbuffer(display));

	al_destroy_bitmap(shrunk);

	//water
	you.water = false;
	you.waterbucket = al_load_bitmap(".\\SCENE\\waterbucket.png");
	al_convert_mask_to_alpha(you.waterbucket,al_map_rgb(189,117,198)); 


}


void InitCam()
{
	cam.x = you.x;
	cam.y = you.y;
	cam.offX = 0;
	cam.offY = 0;	
	cam.width = 2560;
	cam.height = 2880;
	cam.maxOffX = 2560 - WIDTH;
	cam.maxOffY = 2880 - HEIGHT;
	cam.movedX = false;
	cam.movedY = false;

}

void InitScene()
{

	ifstream atlasHeaderFile;
	ifstream atlasLayerFile;
	ifstream atlasBarrierTilesFile;

	stringstream ss;
	string scenePath = ".\\SCENE\\";

	string fpAtlasHeader;
	string fpAtlasLayer;
	string fpAtlasResource;
	string fpIrreg;

	fpAtlasLayer = fpAtlasHeader = scenePath;
	fpAtlasHeader += "WEEDHACK.AHF";//atlas header file extension

	atlasHeaderFile.open(fpAtlasHeader, ios::in);

	int trRenderOrder, i = 0;


	//LOAD ATLAS

	if(atlasHeaderFile)
	{

		while(atlasHeaderFile >> trRenderOrder)
		{
			scene.lays.resize(i + 1);

			scene.lays[i].renderOrder = trRenderOrder;

			
			atlasHeaderFile  >> scene.lays[i].tileTotal >> scene.lays[i].type >>  scene.lays[i].cellWidth >> scene.lays[i].cellHeight >>
				scene.lays[i].layerSize >> scene.lays[i].columns >> scene.lays[i].rows;

			int trLayerSize = scene.lays[i].layerSize;
			int trTileTotal = scene.lays[i].tileTotal;

			fpAtlasLayer = scenePath + "LAYER";
			
			
			ss.str("");//init stringstream
			ss << i;
			
			fpAtlasLayer += ss.str();
			fpAtlasLayer += ".ALF";//atlas layer file extension
			atlasLayerFile.open(fpAtlasLayer, ios::in);


			//resources
			ss.str("");//init stringstream
			ss << i;

			if(scene.lays[i].type == LAY_TERRAIN)
			{

				//init reource path
				fpAtlasResource = "";
				fpAtlasResource = scenePath + "LAYER";

				scene.lays[i].ter.resize(trLayerSize);
				
				for(int j = 0; j < trLayerSize; j++)
				{
					atlasLayerFile >> scene.lays[i].ter[j];
				}


				fpAtlasResource += ss.str();

				fpAtlasResource += ".PNG";//atlas layer file extension
				
				scene.lays[i].image.resize(1);
				scene.lays[i].image[0] = al_load_bitmap(fpAtlasResource.c_str());

			}
			else//(scene.lays[i].type == LAY_IRREGULAR)
			{

				scene.lays[i].irt.resize(trLayerSize);

				for(int j = 0; j < trLayerSize; j++)//load irregular tile data
				{
					atlasLayerFile >> scene.lays[i].irt[j].atlasIdx >> scene.lays[i].irt[j].tlX >> scene.lays[i].irt[j].tlY 
						>> scene.lays[i].irt[j].width >> scene.lays[i].irt[j].height;
				}

				//init reource path
				fpAtlasResource = "";
				fpAtlasResource = scenePath + "\\LAYER";
				fpAtlasResource += ss.str();

				fpIrreg = "";//init irregular tiles filepath

				for(int j = 0; j <	trTileTotal; j++)//load irregular tile images
				{
					//irregular path
					fpIrreg = fpAtlasResource;//init
					fpIrreg += "_RES";

					ss.str("");//init stringstream
					ss << j;
					fpIrreg += ss.str();
					fpIrreg += ".PNG";

					scene.lays[i].image.resize(j+1);
					scene.lays[i].image[j] = al_load_bitmap(fpIrreg.c_str());
					al_convert_mask_to_alpha(scene.lays[i].image[j] ,al_map_rgb(0,0,0));


				}
			}
			
			atlasLayerFile.close();

			i++;
	
		}//end while (atlasHeaderFile >> trRenderOrder)

		atlasHeaderFile.close();
	}


	scene.layerTotal = i;


	//LOAD BARRIERS
	ifstream loadBarrierFile;
	int BarrierTotal = 0,discard;

	string barrierfile;
	barrierfile = ".\\SCENE\\WEEDHACK.BAR";//EXTENSION

	loadBarrierFile.open(barrierfile, ios::in);
	
	if(loadBarrierFile)
	{

		

		loadBarrierFile >> BarrierTotal;//the very first element is the total of barriers

		for(int i=0; i< BarrierTotal; i++)
		{
			scene.bars.resize(i+1);

			loadBarrierFile >> scene.bars[i].barID >> scene.bars[i].barTLX >> scene.bars[i].barTLY >> 
				scene.bars[i].barWidth >> scene.bars[i].barHeight >> discard >> discard;
			
		}
	
		loadBarrierFile.close();
	}

	scene.barrierTotal = BarrierTotal;

}

void InitGUI()
{
	gui.center = DISPLAYWIDTH - ((DISPLAYWIDTH - WIDTH) / 2);
	gui.tlX = WIDTH;
	gui.tlY = 0;
	gui.brX = DISPLAYWIDTH;
	gui.brY = HEIGHT;
	gui.backcolor = al_map_rgb(34,177,76);//dark green
	gui.forecolor = al_map_rgb(255,242,0);//yellow
	gui.warningred = al_map_rgb(215,0,0);



}

void InitArticles()
{

	//weed image
	weed = al_load_bitmap(".\\SCENE\\weed.png");
	al_convert_mask_to_alpha(weed,al_map_rgb(191,123,199)); 




}

void RenderScene()
{

	int	left = cam.offX;
	int	right = cam.offX + WIDTH;
	int	top = cam.offY;
	int	bottom = cam.offY + HEIGHT;
	int i,t;//incrementers

	//terrain
	int trCellWidth;
	int trCellHeight;
	int trCols;
	int trRows;
	int startX;
	int offsetX;
	int startY;
	int offsetY;
	int endX;
	int endY;
	int trCell, tlX, tlY, trTilePosX, rpX, rpY;
	int r,c;//incrementers r for rows, c for cols


	//irregular
	int trTileTotal;
	int trImageIndex;
	int tileLeft, tileRight, tileTop, tileBottom;


	for(i = 0; i < scene.layerTotal; i++)
	{

		//TERRAIN
		if(scene.lays[i].type == LAY_TERRAIN)
		{
			trCellWidth = scene.lays[i].cellWidth;
			trCellHeight = scene.lays[i].cellHeight;
			trCols = scene.lays[i].columns;
			trRows = scene.lays[i].rows;
			startX = left / trCellWidth;
			offsetX = left % trCellWidth;
			startY =  top / trCellHeight;
			offsetY = top % trCellHeight;
			endX = right / trCellWidth;
			endY = bottom / trCellHeight;
			rpY = 0;

			if(endX < trCols)
				endX++; //if it isn't all the way to the left add one cell

			if(endY < trRows)
				endY++; //if it isn't all the way to the bottom add one cell


			for(r = startY; r < endY; r++)
			{
				rpX = 0;//reset render position X

				for(c = startX; c < endX; c++)
				{
					trCell = (r * trCols) + c;

					if(scene.lays[i].ter[trCell] > -1)
					{

						tlX = (rpX * trCellWidth) - offsetX;
						tlY = (rpY * trCellHeight) - offsetY;
						trTilePosX = scene.lays[i].ter[trCell] * trCellWidth;
						al_draw_bitmap_region(scene.lays[i].image[0], trTilePosX, 0, trCellWidth, trCellHeight, tlX, tlY,0);

					}

					rpX++;

				}
				
				rpY++;//reset render position Y
			}



		}
		else //IRREGULAR
		{

			trTileTotal = scene.lays[i].layerSize;

			for(t = 0; t < trTileTotal; t++)// needs work
			{

				tileLeft = scene.lays[i].irt[t].tlX;
				tileRight = scene.lays[i].irt[t].tlX + scene.lays[i].irt[t].width;
				tileTop = scene.lays[i].irt[t].tlY;
				tileBottom = scene.lays[i].irt[t].tlY + scene.lays[i].irt[t].height;
				trImageIndex = scene.lays[i].irt[t].atlasIdx;

				//Bounds Checking
				if(tileRight > left &&
					tileLeft < right &&
					tileBottom > top &&
					tileTop < bottom)//if this is true then render the tile
				{
					al_draw_bitmap(scene.lays[i].image[trImageIndex],tileLeft - left, tileTop - top, 0);
					
				}
			
			}

		}

	}

}

void RenderWeeds()
{

	if(weedcount > 0)
	{
		int	left = cam.offX;
		int	right = cam.offX + WIDTH;
		int	top = cam.offY;
		int	bottom = cam.offY + HEIGHT;
		int weedLeft, weedRight, weedTop, weedBottom;
		float percent,weedW,weedH;



		for(int i = 0; i < weedcount; i++)
		{
			percent = (float)(weeds[i].level + 1) / 10;
			weedLeft = weeds[i].artX - (weeds[i].boundx * percent);
			weedRight = weeds[i].artX + (weeds[i].boundx * percent);
			weedTop = weeds[i].artY - (weeds[i].boundy * percent);
			weedBottom = weeds[i].artY + (weeds[i].boundy * percent);
			weedW = 96 * percent;
			weedH = 96 * percent;
			//Bounds Checking
			if(weedRight > left &&
				weedLeft < right &&
				weedBottom > top &&
				weedTop < bottom)//if this is true then render the tile
			{
				al_draw_scaled_bitmap(weed,0,0,96,96, weedLeft - cam.offX, weedTop - cam.offY, weedW,  weedH, 0);
			}		

		}

	}

}

void RenderGUI()
{
	int ypos = 5;

	//draw background
	al_draw_filled_rectangle(gui.tlX,gui.tlY,gui.brX, gui.brY, gui.backcolor);

	//draw title
	al_draw_textf(font40,gui.forecolor,gui.center,ypos,1,GAMETITLE.c_str());
	ypos += font40->height + 5;

	al_draw_textf(font15,gui.forecolor,gui.center,ypos,1,"SCORE %i  - PRESS [ESC] TO QUIT", you.score);		
	ypos += font15->height + 5;

	//display a warning if the play is colliding
	if(you.collision)
	{
		if(you.water)
		{
			al_draw_textf(font15,gui.forecolor,gui.center,ypos,1,"YOU BUCKET IS FULL");		
			ypos += font15->height + 5;

		}
		al_draw_textf(font15,gui.warningred,gui.center,ypos,1,"!! THAT WILL SOUND BAD !!");
		ypos += font15->height + 5;
	
	}
	
	//weedcount
	al_draw_textf(font15,gui.forecolor,gui.center,ypos,1,"YOU HAVE %i WEEDS", weedcount);		
	ypos += font15->height + 5;

	if(weedcount < 5)
		al_draw_textf(font15,gui.forecolor,gui.center,ypos,1,"PRESS SPACE TO PLANT WEED");		
	else
		al_draw_textf(font15,gui.forecolor,gui.center,ypos,1,"YOU HAVE ENOUGH WEED");		
	ypos += font15->height + 5;

	if(cooldown > 0)
	{
		al_draw_textf(font15,gui.forecolor,gui.center,ypos,1,"%i SECONDS TILL NEXT WEED", cooldown / 60);		
		ypos += font15->height + 5;
	
	}
	


}


void DestroyScene()
{
	int vsize;

	for(int i = 0; i < scene.layerTotal; i++)
	{
		vsize = scene.lays[i].image.size();

		for(int j = 0; j < vsize; j++)
		{
			al_destroy_bitmap(scene.lays[i].image[j]);
		}
		
		//CLEAR VECTORS
		scene.lays[i].image.clear();
		if(scene.lays[i].type == LAY_TERRAIN)
		{
			scene.lays[i].ter.clear();
		}
		else//IRREGULAR
		{
			scene.lays[i].irt.clear();		
		}

	}

	//CLEAR OBJECT VECTORS
	if(scene.ents.size())
		scene.ents.clear();

	if(scene.arts.size())
		scene.arts.clear();

	if(scene.bars.size())
		scene.bars.clear();

}



//STEERING FUNCTIONS

void calcPosLeft()
{
	if(cam.offX > 0 && cam.x <= WIDTH / 2)// move map
	{
					
		cam.offX -= you.speed / diagonalDecrease;
				
		//bounds checking
		if(cam.offX < 0)
			cam.offX = 0;

		cam.x = WIDTH / 2;
		cam.movedX = true;
	}
	else // move Player
	{
				
		cam.x -=  you.speed / diagonalDecrease;
		//bounds checking
		if((cam.x - you.boundx) < 0)
			cam.x = you.boundx;

		cam.movedX = false;

	}
}
void calcPosRight()
{
	if(cam.offX < cam.maxOffX && cam.x >= WIDTH / 2)//move map
	{
				
		cam.offX += you.speed / diagonalDecrease;

		//bounds checking
		if(cam.offX > cam.maxOffX)
		cam.offX = cam.maxOffX;

		cam.x = WIDTH / 2;
		cam.movedX = true;
	}
	else// move Player
	{
				
		cam.x += you.speed / diagonalDecrease;

		//bounds checking
		if((cam.x + you.boundx) > WIDTH)
			cam.x = (WIDTH - you.boundx);

		cam.movedX = false;

	}

}
void calcPosUp()
{
	if(cam.offY > 0 && cam.y <= HEIGHT / 2)//move map
	{

		cam.offY -= you.speed / diagonalDecrease;

		//bounds checking
		if(cam.offY <0)
			cam.offY = 0;
				
		cam.y = HEIGHT / 2;
		cam.movedY = true;
	}
	else// move Player
	{
		
		cam.y -= you.speed / diagonalDecrease;

		//bounds checking
		if ((cam.y - you.boundy) < 0)
			cam.y = you.boundy;

		cam.movedY = false;
	}

}
void calcPosDown()
{
	if(cam.offY < cam.maxOffY && cam.y >= HEIGHT / 2)//move map
	{

		cam.offY += you.speed / diagonalDecrease;
				
		//bounds checking
		if(cam.offY > cam.maxOffY)
			cam.offY = cam.maxOffY;

		cam.y = HEIGHT / 2;
		cam.movedY = true;
	}
	else// move Player
	{

		cam.y += you.speed / diagonalDecrease;

		//bounds checking
		if((cam.y + you.boundy) > HEIGHT)
			cam.y = (HEIGHT - you.boundy);
		cam.movedY = false;
	}
}
void calcDiagonal()
{
	if(you.dirX && you.dirY)
		diagonalDecrease = DIAGONAL;
	else
		diagonalDecrease = 1;

}

void Update()
{
	//reset collision stuff
	you.collision = false;
	for(int i = 0; i < 4; i++)
	{
		you.colPoints[i] = -1;
	}
	you.collidingWith = NOTHING;

	calcDiagonal();//reset diagonaldecrease

	//Update Map & Player Screen position + Bounds Check Map & Player
			
	if(you.dirX < 0)//LEFT
	{
		calcPosLeft();
	}
	if(you.dirX >0)//RIGHT
	{
				
		calcPosRight();

	}		
	if(you.dirY <0)//UP
	{
		calcPosUp();
	}		
		
	if(you.dirY >0)//DOWN
	{
		calcPosDown();
	}	
	
	//update player position
	you.x = cam.x + cam.offX;
	you.y = cam.y + cam.offY;

	//update camera render position
	cam.rendX = cam.x - you.halfwidth;
	cam.rendY = cam.y - you.halfheight;


	//SET COMPASS FOR ANIMATION DIRECTION
	you.compass  = (you.dirX + 1) + ((you.dirY + 1) * 3);//calculate compass from direction
	
	if(you.compass < 4)//store current move compass in stop compass
	{
		you.stopCompass = you.compass;
		you.state = WALK;
	}//if compass = 4 stopCompass won't update
	else if(you.compass > 4)
	{
		you.compass--;
		you.stopCompass = you.compass;
		you.state = WALK;
	}
	else
	{
		you.state = STOP;
	}

	//UPDATE ANIMATION FRAMES
	if(you.state > STOP)
	{
		if(++you.frameCount >= you.frameDelay)//Update Animation 
		{
			you.currentFrame ++;
			if(you.currentFrame >= you.maxFrame)
				you.currentFrame = 0;//reset currentFrame
		
			you.frameCount = 0;//reset frameCount
		}
	}


	//plant cooldown
	if(cooldown > 0)
		cooldown --;

}

void CheckCollisions()
{

	int side[4];//0 = left,  1 = right, 2 = top, 3 = bottom, 
	int least;//the least value is the side that is colliding
	int barPoint[4];
	int youPoint[4];
	int weedPoint[4];
	int weedID;
	
	youPoint[CS_LEFT] = you.x - you.boundx;
	youPoint[CS_RIGHT] = you.x + you.boundx;
	youPoint[CS_UP] = you.y - you.boundy;
	youPoint[CS_DOWN] = you.y + you.boundy;

	//check barriers for collisions
	for(int i = 0; i < scene.barrierTotal; i++)
	{
		barPoint[CS_LEFT] = scene.bars[i].barTLX;
		barPoint[CS_RIGHT] = scene.bars[i].barTLX + scene.bars[i].barWidth;
		barPoint[CS_UP] = scene.bars[i].barTLY;
		barPoint[CS_DOWN] = scene.bars[i].barTLY + scene.bars[i].barHeight;

		if(youPoint[CS_RIGHT] > barPoint[CS_LEFT] &&
			youPoint[CS_LEFT] < barPoint[CS_RIGHT] &&
			youPoint[CS_DOWN] > barPoint[CS_UP] &&
			youPoint[CS_UP] < barPoint[CS_DOWN])
		{
			you.collision = true;
			you.collidingWith = BARRIER;

			//load array
			side[0] = abs(barPoint[CS_RIGHT] - youPoint[CS_LEFT]);//left
			side[1] = abs(youPoint[CS_RIGHT] - barPoint[CS_LEFT]);//right
			side[2] = abs(barPoint[CS_DOWN] - youPoint[CS_UP]);//up
			side[3] = abs(youPoint[CS_DOWN] - barPoint[CS_UP]);//down

			least = 0;//reset to element position
			
			for(int i = 0; i < 3; i++)//find the least
			{
				if(side[least] > side[i + 1])
					least = i + 1;
			}

			//record collision point
			you.colPoints[least] = barPoint[reversePoint[least]];

		}

	}

	weedID = -1;
	//check weed for collision
	for(int i = 0; i < weedcount; i++)
	{
		weedPoint[CS_LEFT] = weeds[i].artX - weeds[i].boundx;
		weedPoint[CS_RIGHT] = weeds[i].artX + weeds[i].boundx;
		weedPoint[CS_UP] = weeds[i].artY - weeds[i].boundy;
		weedPoint[CS_DOWN] = weeds[i].artY + weeds[i].boundy;

		if(youPoint[CS_RIGHT] > weedPoint[CS_LEFT] &&
			youPoint[CS_LEFT] < weedPoint[CS_RIGHT] &&
			youPoint[CS_DOWN] > weedPoint[CS_UP] &&
			youPoint[CS_UP] < weedPoint[CS_DOWN])
		{
			you.collision = true;
			you.collidingWith =	ARTICLE;
			weedID = i;

		}

	}


	if(you.collision)	//if there are any collisions - do this
	{
		if(you.collidingWith == BARRIER)
		{
			if(!you.water)
			{
				you.water = true;//you have water
			}

			AssistDirection();
			PlaySound();
		}
		else if(you.collidingWith == ARTICLE)
		{
			if(weedID > -1)
			{
				if(you.water)
				{
					you.water = false;//you have water
					weeds[weedID].level++;

					if(weeds[weedID].level >= 10)
					{
						you.score += 10;

						weeds.erase(weeds.begin() + weedID);
						weeds.resize(weedcount);//0 based
						weedcount --;
					}
				
				}

			}
		}


	}
	else if(al_get_sample_instance_playing(bs.sampinst))
	{	
		al_stop_sample_instance(bs.sampinst);
	}


}

void AssistDirection()
{

	if(you.colPoints[CS_LEFT] != -1)
	{		
		if(cam.movedX)
			cam.offX = (you.colPoints[CS_LEFT] + you.boundx) - cam.x;
		else
			cam.x = (you.colPoints[CS_LEFT] + you.boundx) - cam.offX;

		you.x = cam.offX + cam.x;

	}
	else if(you.colPoints[CS_RIGHT] != -1)
	{

		if(cam.movedX)
			cam.offX = (you.colPoints[CS_RIGHT] - you.boundx) - cam.x;
		else
			cam.x = (you.colPoints[CS_RIGHT] - you.boundx) - cam.offX;

		you.x = cam.offX + cam.x;

	}

	if(you.colPoints[CS_UP] != -1)
	{
		if(cam.movedY)
			cam.offY = (you.colPoints[CS_UP] + you.boundy) - cam.y;
		else
			cam.y = (you.colPoints[CS_UP] + you.boundy) - cam.offY;
		
		you.y = cam.offY + cam.y;
	}
	else if(you.colPoints[CS_DOWN] != -1)
	{
		if(cam.movedY)
			cam.offY = (you.colPoints[CS_DOWN] - you.boundy) - cam.y;
		else
			cam.y = (you.colPoints[CS_DOWN] - you.boundy) - cam.offY;
		
		you.y = cam.offY + cam.y;
	}
}

void PlantWeed()
{

	if(weedcount < 6)//plant weed
	{
		weeds.resize(weedcount + 1);

		weeds[weedcount].artID = 0; //unused - only one type
		weeds[weedcount].artX = you.x;
		weeds[weedcount].artY = you.y;
		weeds[weedcount].boundx = 48;
		weeds[weedcount].boundy = 48;
		weeds[weedcount].health = 100;
		weeds[weedcount].type = 0; //unused - only one type
		weeds[weedcount].level = 0;
		cooldown = 1800;//30 seconds
		weedcount++;

	}


}

void InitSound()
{
	//init variables
	//the music part
	bs.beatOn = true;//start the beat
	bs.beatcount = 0;
	bs.breakcount = 0;
	bs.cyclecount = 0;
	bs.cyclemax = 2 + (rand() % 12);
	bs.beatduration = 4 + (rand() % 20);
	bs.breakduration = 2 + (rand() % 10);
	bs.samp = NULL;

	//add talk sounds to talk sound vectors
	bs.samp = al_load_sample(".\\SCENE\\electricguitarloop.ogg");


	if(bs.samp)
	{

		bs.sampinst = al_create_sample_instance(bs.samp);
		bs.samplespeed = 0.5 + (((float)(rand() % 25)) / 25);
		al_set_sample_instance_speed(bs.sampinst, bs.samplespeed);
		al_set_sample_instance_playmode(bs.sampinst,ALLEGRO_PLAYMODE_LOOP);
		al_attach_sample_instance_to_mixer(bs.sampinst, al_get_default_mixer());

	}
	else
	{
		bs.sampinst = NULL;
	}

}

void PlaySound()
{

	if(bs.beatOn)
	{
		bs.beatcount++;
		if(bs.beatcount > bs.beatduration)
		{
			bs.beatcount = 0;
			al_stop_sample_instance(bs.sampinst);
			bs.beatOn = false;
		}
	}
	else
	{
		bs.breakcount++;				
		if(bs.breakcount > bs.breakduration)
		{
			bs.breakcount = 0;
			al_play_sample_instance(bs.sampinst);						
			bs.beatOn = true;
			bs.cyclecount++;
		}
				
	}

	if(bs.cyclecount > bs.cyclemax)
	{
		bs.cyclecount = 0;
		bs.cyclemax = 2 + (rand() % 12);
		bs.beatduration = 4 + (rand() % 20);
		bs.breakduration = 2 + (rand() % 10);
		float randchange = (((float)(rand() % 3)) - 1) / 10;
		bs.samplespeed += randchange;
		al_set_sample_instance_speed(bs.sampinst, bs.samplespeed);

	}

}

void DestroySound()
{
	if(bs.samp)
	{
		al_destroy_sample(bs.samp);
		al_destroy_sample_instance(bs.sampinst);
	}
}