//WEEDHACK 2015 By devo_au

#include <allegro5/allegro.h>
#include <allegro5/allegro_image.h>
#include <allegro5/allegro_primitives.h>
#include <allegro5/allegro_font.h>
#include <allegro5/allegro_ttf.h>
#include <allegro5/allegro_audio.h>
#include <allegro5/allegro_acodec.h>


#include <iostream>
#include <fstream>
#include <string>
#include <sstream>
#include <vector>
#include <math.h>
#include <time.h>
#include <list>

using namespace std;

const string GAMETITLE = "Weedhack 2015";

//THESE DEFS ARE THE ACTUAL WINDOW SIZE
const int DISPLAYWIDTH = 1200;
const int DISPLAYHEIGHT = 800;

//THESE DEFS ARE THE PLAY AREA SIZE
const int WIDTH = 900;
const int HEIGHT = 800;

int cooldown;
int weedcount;

//USEFUL STUFF
const float PI = 3.14159265; //That will do
const float DIAGONAL = 1.414213562373095;//root of 2

//GLOBALS==============================
enum KEYS{UP, DOWN, LEFT, RIGHT, SPACE};
bool keys[5] = {false, false, false, false, false};


enum LAYERTYPES {LAY_TERRAIN = 2, LAY_IRREGULAR = 3};
enum IDS{NOTHING, PLAYER, ENTITY ,ARTICLE, BARRIER};//Object IDs
enum COLLISION_SIDE {CS_LEFT,CS_RIGHT,CS_UP,CS_DOWN};
enum ANIMATIONSTATES {STOP, WALK, ACTION}; //SAME FOR PLAYER & ENTITIES




//OBJECT DEFS
typedef struct PLAYER_DATA
{
	int ID;
	int x;
	int y;
	int lx;
	int ly;
	int dirX;
	int dirY;
	int state;

	//animation related
	int framewidth;
	int frameheight;
	int maxFrame;
	int currentFrame;
	int frameCount;
	int frameDelay;
	int halfwidth;//half frame width & height - saves doing (/ 2) each time
	int halfheight;

	int compass;//used for animation
	int stopCompass;

	int lives;
	int speed;

	int boundx;
	int boundy;
	int score;//MONEY

	bool collision;
	int colPoints[4];
	int collidingWith;

	ALLEGRO_BITMAP *image;//PLAYER IMAGE

	//This is a game specific variable
	bool water; //if true - the player has water, and can water the plants
	ALLEGRO_BITMAP *waterbucket;


}T_PLAYER;


typedef struct BADSOUNDS
{
	float samplespeed;
	float gameTime;
	ALLEGRO_SAMPLE* samp;
	ALLEGRO_SAMPLE_INSTANCE* sampinst;

	//the music part
	bool beatOn;//if true the sound of a beat is playing, if false a break is happening
	int beatcount;//the number of frames in a beat being counted
	int breakcount;//the number of frames in a break being counted
	int breakduration;//the maximum number of frames in the break
	int beatduration;//the maximum number of frames in the beat
	int cyclecount;//the number of times a beat and a break being counted together
	int cyclemax;//the maximum number of cycles of beats and breaks

}T_BS;



typedef struct CAMERA 
{
	float x;
	float y;
	float rendX;
	float rendY;
	float lx;
	float ly;
	float offX;
	float offY;	
	int maxOffX;
	int maxOffY;
	int width;
	int height;
	bool movedX;
	bool movedY;

}T_CAM;


typedef struct GUI
{
	int center;
	int tlX;
	int tlY;
	int brX;
	int brY;
	ALLEGRO_COLOR backcolor;
	ALLEGRO_COLOR forecolor;
	ALLEGRO_COLOR warningred;


}T_GUI;


typedef struct POSITION //STORES MAP POSITIONS
{
	float x;
	float y;
	float offX;//used for map movement
	float offY;	

}T_POS;

typedef struct MESSAGE_ROW_PARAMETERS //I DUNNO?
{
	int start;
	int end;
	int length;

}T_MRP;

typedef struct IREGULAR_TILE
{
	int atlasIdx;
	int tlX;
	int tlY;
	int width;
	int height;

}T_IRT;


typedef struct LAYER_DATA 
{
	int renderOrder; 
	int tileTotal;
	int type; 
	int cellWidth;
	int cellHeight;
	int layerSize;
	int rows;
	int columns;
	vector <int> ter;
	vector <T_IRT> irt;
	vector <ALLEGRO_BITMAP*> image;

}T_LAYER;



typedef struct ENTITY_DATA //NPC'S
{
	int entID;
	int entX;
	int entY;
	int entContextID; //ENTITIES CAN TALK
	long entHealth;
	string entName;

}T_ENT;


typedef struct ARTICLE_DATA //THINGS
{
	int artID;
	int artX;
	int artY;
	int boundx;
	int boundy;
	int health;
	int type;
	int level;

}T_ART;


typedef struct BARRIER_DATA //PLACES YOU CAN'T GO
{
	int barID;
	int barTLX;
	int barTLY;
	int barWidth;
	int barHeight;

}T_BAR;


typedef struct SCENE_DATA
{
	T_POS start;

	int layerTotal;//total of layers
	int barrierTotal;//total of barriers

	vector <T_LAYER> lays;//scene layers

	//barrier related
	vector <T_BAR> bars;//a complete list of barriers relative to the scene

	//entity related
	vector <T_ENT> ents;//a complete list of entities relative to the scene

	//article related
	vector <T_ART> arts;//a complete list of articles relative to the scene

}T_SCENE;