
/**
   Homework 4 by Marc Davenport in Data Structures with Ryan Mccleary
   04/16/2015
*/

/*
   Module to plot graph on screen
   
*/
#ifndef Visualize_HPP
#define Visualize_HPP

#include "allegro5/allegro.h"
#include "allegro5/allegro_primitives.h"
#include "allegro5/allegro_font.h"
#include "allegro5/allegro_ttf.h"


#include <string>
#include <cstdio>

class Visualizer {

private :
   ALLEGRO_DISPLAY* display;
   ALLEGRO_EVENT_QUEUE* queue;
   ALLEGRO_TIMER* timer;
   ALLEGRO_FONT* font;
   ALLEGRO_VERTEX* allegro_vertices;
   unsigned int nallegro_vertices;
   ALLEGRO_VERTEX* allegro_edges;
   unsigned int nallegro_edges;
   ALLEGRO_VERTEX* allegro_shortest_path;
   unsigned int nallegro_shortest_path;
   
   double gcx;// graph center x
   double gcy;// graph center y
   double gcz;// graph center z
   double urad;// universe radius
   
   // Bounding prism xyz values of our universe
   double gxmin;
   double gymin;
   double gzmin;
   double gxmax;
   double gymax;
   double gzmax;
   
   double cam_x;
   double cam_y;
   double cam_z;
   
   double transx;
   double transy;
   double transz;
   
   double cam_zenith_theta;// 0.0 points up the positive z axis and rotates counterclockwise along the yz plane from the up vector
   double cam_azimuth_phi;/// 0.0 points right along the positive x-axis and counterclockwise towards up on the xy plane
   double cam_view_vector_x;
   double cam_view_vector_y;
   double cam_view_vector_z;
   double cam_sled_z;
   
   ALLEGRO_TRANSFORM proj_transform;
   ALLEGRO_TRANSFORM cam_transform;
   
   bool draw_bounds;
   
public :
//   Visualizer();
Visualizer() :
      display(0),
      queue(0),
      timer(0),
      font(0),
      allegro_vertices(0),
      nallegro_vertices(0),
      allegro_edges(0),
      nallegro_edges(0),
      allegro_shortest_path(0),
      nallegro_shortest_path(0),
      gcx(0.0),
      gcy(0.0),
      gcz(0.0),
      urad(0.0),
      gxmin(0.0),
      gymin(0.0),
      gzmin(0.0),
      gxmax(0.0),
      gymax(0.0),
      gzmax(0.0),
      cam_x(0.0),
      cam_y(0.0),
      cam_z(0.0),
      transx(0.0),
      transy(0.0),
      transz(0.0),
      cam_zenith_theta(0.0),
      cam_azimuth_phi(0.0),
      cam_view_vector_x(0.0),
      cam_view_vector_y(0.0),
      cam_view_vector_z(0.0),
      cam_sled_z(0.0),
      proj_transform(),
      cam_transform(),
      draw_bounds(true)
{
   printf("Init() was %s\n" , Init()?"successful":"unsuccessful");
}
   
   ~Visualizer();
   
   bool Init();

   bool HandleCommand(std::string cmd);
   void DestroyGraph();
   void SetupGraph();
   void CalculateGraphCenter();
   void CalculateUniverseRadius();
   void ResetCamOffset();
   void ResetCamera();

   void InputLoop();
   
   void SetupView();
   void ResetView();
   void Draw();
   
   void SetDrawBounds(bool draw) {draw_bounds = draw;}
};


#endif // Visualize_HPP
