


/**
   Homework 4 by Marc Davenport in Data Structures with Ryan Mccleary
   04/16/2015
*/



#include "Visualize.hpp"


#include "ShortestPath.hpp"

#include "allegro5/allegro.h"

Visualizer::~Visualizer() {
   DestroyGraph();
}



bool Visualizer::Init() {
   bool success = true;
   success = al_init();
   if (!success) {
      printf("Failed to init allegro\n");
      return false;
   }
   success = success && al_install_keyboard();
   success = success && al_install_mouse();
   success = success && al_init_primitives_addon();
   success = success && al_init_font_addon();
   success = success && al_init_ttf_addon();
   
   queue = al_create_event_queue();
   al_register_event_source(queue , al_get_keyboard_event_source());
   al_register_event_source(queue , al_get_mouse_event_source());
   
   timer = al_create_timer(1.0/60.0);
   al_register_event_source(queue , al_get_timer_event_source(timer));
   
   font = al_load_ttf_font("verdana.ttf" , 16 , 0);
   
   al_identity_transform(&proj_transform);
   al_identity_transform(&cam_transform);
   
   return success && queue && timer && font;
}



bool Visualizer::HandleCommand(std::string cmd) {
   if (cmd.compare("graph") == 0) {
      if (display) {
         al_destroy_display(display);
         display = 0;
      }
      int w = 600;
      int h = 600;
      al_set_new_display_flags(ALLEGRO_WINDOWED);
      display = al_create_display(w , h);
      if (!display) {
         printf("Could not create %d x %d window.\n" , w , h);
         return true;
      }
      al_register_event_source(queue , al_get_display_event_source(display));
      
      SetupGraph();
      
      ResetCamOffset();
      
      ResetCamera();
      
      InputLoop();
      
      al_destroy_display(display);
      display = 0;
      
      return true;
   }
   
   if (cmd.compare("help") == 0) {
      printf("Visualizer help :\n");
      printf("-----------------------------------------------------\n");
      printf("graph                   : View the current graph\n");
      return true;
   }
   
   return false;
}



void Visualizer::DestroyGraph() {
   if (allegro_vertices) {
      free(allegro_vertices);
      allegro_vertices = 0;
      nallegro_vertices = 0;
   }
   if (allegro_edges) {
      free(allegro_edges);
      allegro_edges = 0;
      nallegro_edges = 0;
   }
   if (allegro_shortest_path) {
      free(allegro_shortest_path);
      allegro_shortest_path = 0;
      nallegro_shortest_path = 0;
   }
}



void Visualizer::SetupGraph() {
   DestroyGraph();
   
   if (!graph.VSize()) {
      return;
   }
   
   allegro_vertices = (ALLEGRO_VERTEX*)malloc(graph.VSize()*sizeof(ALLEGRO_VERTEX));
   if (allegro_vertices) {
      nallegro_vertices = graph.VSize();
   }
   if (graph.ESize()) {
      allegro_edges = (ALLEGRO_VERTEX*)malloc(graph.ESize()*sizeof(ALLEGRO_VERTEX)*2);
      if (allegro_edges) {
         nallegro_edges = graph.ESize()*2;
      }
   }
   
   const vector<VERTEX_ID>& spath = graph.ShortestPath();
   nallegro_shortest_path = (spath.size() > 1)?spath.size():0;
   if (nallegro_shortest_path) {
      allegro_shortest_path = (ALLEGRO_VERTEX*)malloc((nallegro_shortest_path)*sizeof(ALLEGRO_VERTEX));
   }
   
   
   if (nallegro_vertices == 0 || (graph.ESize() && nallegro_edges == 0)) {
      DestroyGraph();
      EAGLE_DEBUG
      (
         printf("Failed to allocate %s%s%s\n" ,
               !allegro_vertices?"allegro vertices":"" ,
               (!allegro_vertices && !allegro_edges)?" and ":"" ,
                !allegro_edges?"allegro edges":"");
      );
      return;
   }
   
   for (SIZE_T i = 0 ; i < nallegro_vertices ; ++i) {
      ALLEGRO_VERTEX* av = &allegro_vertices[i];
      const Vertex* v = &(graph.Vertices()[i]);
      av->x = v->vx;
      av->y = v->vy;
      av->z = v->vz;
      av->color = al_map_rgb(255,0,0);
      av->u = 0.0;
      av->v = 0.0;
   }
   
   for (SIZE_T i = 0 ; i < graph.ESize() ; ++i) {
//nallegro_edges ; i += 2) {
      ALLEGRO_VERTEX* avfrom = &allegro_edges[2*i];
      ALLEGRO_VERTEX* avto = &allegro_edges[2*i + 1];
      const Edge* e = &(graph.Edges()[i]);
      VERTEX_ID vidfrom = e->vertex_from_id;
      VERTEX_ID vidto = e->vertex_to_id;
      *avfrom = allegro_vertices[vidfrom];
      *avto = allegro_vertices[vidto];
      ALLEGRO_COLOR fromcol = al_map_rgb(0,0,255);
      ALLEGRO_COLOR tocol = al_map_rgb(0,255,0);
      avfrom->color = fromcol;
      avto->color = tocol;
   }
   
   for (SIZE_T i = 0 ; i < nallegro_shortest_path ; ++i) {
      ALLEGRO_VERTEX* v = &allegro_vertices[spath[i]];
      ALLEGRO_VERTEX* v2 = &allegro_shortest_path[i];
      *v2 = *v;
      ALLEGRO_COLOR path_color = al_map_rgb(255,255,0);
      v2->color = path_color;
   }
   
   
   
   CalculateGraphCenter();
   CalculateUniverseRadius();
}



void Visualizer::CalculateGraphCenter() {
   gcx = 0.0;
   gcy = 0.0;
   gcz = 0.0;

   if (nallegro_vertices < 1) {return;}
   
   double ax = 0.0;
   double ay = 0.0;
   double az = 0.0;
   for (SIZE_T i = 0 ; i < nallegro_vertices ; ++i) {
      ax += allegro_vertices[i].x;
      ay += allegro_vertices[i].y;
      az += allegro_vertices[i].z;
   }
   
   gcx = ax/nallegro_vertices;
   gcy = ay/nallegro_vertices;
   gcz = az/nallegro_vertices;
   
}



void Visualizer::CalculateUniverseRadius() {
   urad = 0.0;
   gxmin = 0.0;
   gymin = 0.0;
   gzmin = 0.0;
   gxmax = 0.0;
   gymax = 0.0;
   gzmax = 0.0;
   if (graph.VSize()) {
      const Vertex* v = &graph.Vertices()[0];
      gxmin = v->vx;
      gymin = v->vy;
      gzmin = v->vz;
      gxmax = v->vx;
      gymax = v->vy;
      gzmax = v->vz;
   }
   for (SIZE_T i = 0 ; i < graph.VSize() ; ++i) {
      const Vertex* v = &graph.Vertices()[i];
      double dx = v->vx - gcx;
      double dy = v->vy - gcx;
      double dz = v->vz - gcx;
      double vrad = sqrt(dx*dx + dy*dy + dz*dz);
      if (vrad > urad) {
         urad = vrad;
      }
      // find bounding prism
      if (v->vx < gxmin) {gxmin = v->vx;}
      if (v->vy < gymin) {gymin = v->vy;}
      if (v->vz < gzmin) {gzmin = v->vz;}
      if (v->vx > gxmax) {gxmax = v->vx;}
      if (v->vy > gymax) {gymax = v->vy;}
      if (v->vz > gzmax) {gzmax = v->vz;}
   }
   
   printf("x = [%lf , %lf] , y = [%lf , %lf] , z = [%lf , %lf]\n" , gxmin , gxmax , gymin , gymax , gzmin , gzmax);
}



void Visualizer::ResetCamOffset() {
   transx = 0.0;
   transy = 0.0;
   transz = 0.0;
}


void Visualizer::ResetCamera() {
   
   
   
   
///   cos(azimuth_angle_phi);
   
   cam_sled_z = -2.0*urad;
   
   cam_x = gcx + transx;
   cam_y = gcy + transy + 2.5;

   cam_z = gcz + transz + cam_sled_z;
   cam_zenith_theta = 0.0;
   cam_azimuth_phi = M_PI/2.0;
//   cam_view_vector_x = 0.0;
//   cam_view_vector_y = 0.0;
//   cam_view_vector_z = 0.0;
   
}




void Visualizer::InputLoop() {
   
   
   int keys[ALLEGRO_KEY_MAX];
   
   for (int i = 0 ; i < ALLEGRO_KEY_MAX ; ++i) {keys[i] = 0;}
   
   
   bool quit = false;
   bool redraw = true;
   
   al_start_timer(timer);
   
   while (!quit) {
      do {
         ALLEGRO_EVENT ev;
         al_wait_for_event(queue , &ev);
         
         double vel = (urad/120.0);
         
         if (ev.type == ALLEGRO_EVENT_DISPLAY_CLOSE) {
            quit = true;
         }
         else if (ev.type == ALLEGRO_EVENT_KEY_DOWN) {
            if (ev.keyboard.keycode == ALLEGRO_KEY_ESCAPE) {
               quit = true;
            }
//            printf("%s pressed.\n" , al_keycode_to_name(ev.keyboard.keycode));
            keys[ev.keyboard.keycode] = 1;
         }
         else if (ev.type == ALLEGRO_EVENT_KEY_UP) {
//            printf("%s released.\n" , al_keycode_to_name(ev.keyboard.keycode));
            keys[ev.keyboard.keycode] = 0;
         }
         else if (ev.type == ALLEGRO_EVENT_TIMER) {
            if (keys[ALLEGRO_KEY_LEFT]) {
               transx += -vel;
            }
            if (keys[ALLEGRO_KEY_RIGHT]) {
               transx += vel;
            }
            if (keys[ALLEGRO_KEY_UP]) {
               transy += vel;
            }
            if (keys[ALLEGRO_KEY_DOWN]) {
               transy += -vel;
            }
            if (keys[ALLEGRO_KEY_A]) {
               transz += vel;
            }
            if (keys[ALLEGRO_KEY_Z]) {
               transz += -vel;
            }
            ResetCamera();
            redraw = true;
         }

      } while (!al_is_event_queue_empty(queue));
   
      if (redraw) {
         redraw = false;
         
         al_clear_to_color(al_map_rgb(0,0,0));
         
         Draw();
         
//         printf(".");
         
         al_flip_display();
      }
   };
   
}




void Visualizer::SetupView() {
   // set up projection
   al_identity_transform(&proj_transform);
   //ltnrbf
///   al_perspective_transform(&proj_transform , -urad/2.0 , urad/2.0 , urad , urad/2.0 , -urad/2.0 , urad*3.0);
   double rad = 1.0;
   al_perspective_transform(&proj_transform , -rad/2.0 , rad/2.0 , rad , rad/2.0 , -rad/2.0 , urad*15.0);
   al_use_projection_transform(&proj_transform);
   
///void al_build_camera_transform(ALLEGRO_TRANSFORM *trans,
///   float position_x, float position_y, float position_z,
///   float look_x, float look_y, float look_z,
///   float up_x, float up_y, float up_z)      
   al_build_camera_transform(&cam_transform , cam_x , cam_y , cam_z , gcx , gcy , gcz , 0.0 , 1.0 , 0.0);
   al_use_transform(&cam_transform);
   
   
}



void Visualizer::ResetView() {
   
   ALLEGRO_TRANSFORM t;
   al_identity_transform(&t);
   al_use_transform(&t);
   
   al_identity_transform(&proj_transform);
   al_orthographic_transform(&proj_transform , 0 , 0 , -1 , 600 , 600 , 1);
   al_use_projection_transform(&proj_transform);
}


void Visualizer::Draw() {
   
///int al_draw_prim(const void* vtxs, const ALLEGRO_VERTEX_DECL* decl, ALLEGRO_BITMAP* texture, int start, int end, int type)      

   const ALLEGRO_VERTEX bounding_vertices[8] = {
      {gxmin , gymin, gzmin, 0.0 , 0.0 , al_map_rgb(255,255,255)},// lbn
      {gxmin , gymin, gzmax, 0.0 , 0.0 , al_map_rgb(255,255,255)},// lbf
      {gxmin , gymax, gzmax, 0.0 , 0.0 , al_map_rgb(255,255,255)},// ltf
      {gxmin , gymax, gzmin, 0.0 , 0.0 , al_map_rgb(255,255,255)},// ltn
      {gxmax , gymin, gzmin, 0.0 , 0.0 , al_map_rgb(255,255,255)},// rbn
      {gxmax , gymin, gzmax, 0.0 , 0.0 , al_map_rgb(255,255,255)},// rbf
      {gxmax , gymax, gzmax, 0.0 , 0.0 , al_map_rgb(255,255,255)},// rtf
      {gxmax , gymax, gzmin, 0.0 , 0.0 , al_map_rgb(255,255,255)} // rtn
   };
//*/
   const ALLEGRO_VERTEX bounding_edge_vertices[12*2] = {
      bounding_vertices[0] , bounding_vertices[1] ,
      bounding_vertices[1] , bounding_vertices[2] ,
      bounding_vertices[2] , bounding_vertices[3] ,
      bounding_vertices[3] , bounding_vertices[0] ,
      bounding_vertices[4] , bounding_vertices[5] ,
      bounding_vertices[5] , bounding_vertices[6] ,
      bounding_vertices[6] , bounding_vertices[7] ,
      bounding_vertices[7] , bounding_vertices[4] ,
      bounding_vertices[0] , bounding_vertices[4] ,
      bounding_vertices[1] , bounding_vertices[5] ,
      bounding_vertices[2] , bounding_vertices[6] ,
      bounding_vertices[3] , bounding_vertices[7]
   };
   
//   al_hold_bitmap_drawing(true);

   SetupView();
   
   al_set_render_state(ALLEGRO_DEPTH_TEST, true);
   
   // draw edges vertices and then the vertices
   if (allegro_edges) {
      al_draw_prim(allegro_edges , 0 , 0 , 0 , nallegro_edges , ALLEGRO_PRIM_LINE_LIST);
   }
   if (allegro_vertices) {
      al_draw_prim(allegro_vertices , 0 , 0 , 0 , nallegro_vertices , ALLEGRO_PRIM_POINT_LIST);
   }
   if (draw_bounds) {
//   if (bounding_edge_vertices) {
      al_draw_prim(bounding_edge_vertices , 0 , 0 , 0 , 24 , ALLEGRO_PRIM_LINE_LIST);
//   }
   }
   al_set_render_state(ALLEGRO_DEPTH_TEST, false);   
   
   if (allegro_shortest_path) {
//      printf("nallegro_shortest_path = %u\n" , nallegro_shortest_path);
      al_draw_prim(allegro_shortest_path , 0 , 0 , 0 , nallegro_shortest_path , ALLEGRO_PRIM_LINE_STRIP);
   }
   
   /// TODO Draw shortest path
   
//   al_hold_bitmap_drawing(false);
   ResetView();

   al_draw_textf(font , al_map_rgb(255,255,255) , 10.0 , 10.0 , 0 ,
                 "xyz = (%lf,%lf,%lf)" , transx , transy , transz);
   
   al_draw_textf(font , al_map_rgb(255,255,255) , 10.0 , 570.0 , 0 ,
                 "gEsz = %u , nallegro_edges = %u, directed = %s" , graph.ESize() , nallegro_edges , graph.Directed()?"true":"false");
   
   
//   printf("xyz = (%lf,%lf,%lf) urad = %lf\n" , transx , transy , transz , urad);
   
}





