

/**
   Homework 4 by Marc Davenport in Data Structures with Ryan Mccleary
   04/16/2015
*/



#ifndef ShortestPath_HPP
#define ShortestPath_HPP


#include <climits>
#include <cstdio>
#include <cassert>
#include <cmath>

#include <string>
#include <vector>
#include <map>
#include <utility>
#include <stack>

using namespace std;


void LogFailedAssert(const char* exp , const char* file , int line);
void EpicFail();


/** CREDITS : Thanks to Per Larsson on allegro.cc for this do while trick in the macros */
#ifdef DEBUG
   #define EAGLE_ASSERT(exp) do {                                                \
                                if (!(exp)) {                                    \
                                   LogFailedAssert(# exp , __FILE__ , __LINE__); \
                                   EpicFail();                                   \
                                }                                                \
                              } while (false)
#else
   #define EAGLE_ASSERT(exp) do {} while (false)
#endif

#ifdef DEBUG
   #define EAGLE_DEBUG(exp) do {                \
                                 exp            \
                               } while (false)
#else
   #define EAGLE_DEBUG(exp) do {} while (false)
#endif



FILE* GetLinePN(FILE* f , std::string& s);
void SkipWhiteSpace(FILE* f);



class Edge;

typedef unsigned int VERTEX_ID;
typedef unsigned int EDGE_ID;

extern const VERTEX_ID VERTEX_ID_UNKNOWN;
extern const EDGE_ID EDGE_ID_UNKNOWN;


class Vertex {
   VERTEX_ID vertex_id;
   double vx,vy,vz;

   vector<EDGE_ID> incoming_edges;
   vector<EDGE_ID> outgoing_edges;

   bool known;
   VERTEX_ID prev_vertex;
   double total_distance;


public :
   Vertex();

   friend class Graph;
#ifdef VISUALIZE
   friend class Visualizer;
#endif
};

class Edge {
   EDGE_ID edge_id;
   double weight;
   VERTEX_ID vertex_from_id;
   VERTEX_ID vertex_to_id;

public :
   Edge();
   friend class Graph;
#ifdef VISUALIZE
   friend class Visualizer;
#endif
};


struct VTableEntry {
   VERTEX_ID vid;
   double dist;
//   bool in_use;// was gonna use this for lazy deletion but there are complications
public :
   VTableEntry() : vid(VERTEX_ID_UNKNOWN) , dist(-1.0) {}
};

typedef std::vector<VTableEntry> VTable;
typedef std::map<VERTEX_ID , int> VMap;

class VisitedVertexTable {

   /// We store our data in a sorted vector, performing an insertion sort. This allows us to use a binary search without
   /// using a linked list. All the ids are unique. Lazy deletion can't be used because there would be duplicate VERTEX_IDs.
   VTable vtable;
   VMap vmap;


public:
   // returns true if found in table and its index , false if not in table and then *store_index is -1
   bool FindTableIndex(VERTEX_ID vid , int* store_index);

private:
   // returns index where to insert a VTableEntry into the table by distance
   int FindNewTableIndexByDistance(double vdist);

   void InsertEntry(VERTEX_ID vid , double val);
   void Remove(int index);

public :
   VisitedVertexTable();

   void SetVertexValue(VERTEX_ID vid , double val);

   bool Empty();

   VTableEntry TakeMin();

};


/*
class CompareVertices {

private:
   Vertex* vertices;
   SIZE_T nvertices;

public :
   CompareVertices(Vertex* vertice_array , SIZE_T num_vertices) :
         vertices(vertice_array),
         nvertices(num_vertices)
   {
      assert(vertices && nvertices > 0);
   }


   bool operator() (VERTEX_ID vid1 , VERTEX_ID vid2) {
      Vertex* v1 = 0;
      Vertex* v2 = 0;
      if (vid1 < nvertices) {
         v1 = &vertices[vid1];
      }
      if (vid2 < nvertices) {
         v2 = &vertices[vid2];
      }
      assert(v1 && v2);
      return v1->total_distance < v2->total_distance;
   }
}
*/



typedef unsigned int SIZE_T;


class Graph {
   Vertex* vertices;
   Edge* edges;
   SIZE_T nvertices;
   SIZE_T nedges;

   void ResetVerticeTable();

   vector<VERTEX_ID> shortest_path;

   bool directed;

public :
   Graph();
   ~Graph();

   void Free();
   void FreeEdges();
   void FreeVertices();

   bool LoadGraphFile(const char* fpath);

   void GenerateGraph(SIZE_T num_vertices , SIZE_T num_edges);

   void PrintGraph(FILE* fout , bool directed);

   void SaveGraph(const char* savepath);


   void FindShortestPath(VERTEX_ID from , VERTEX_ID to);

   SIZE_T VSize() {return nvertices;}
   const Vertex* Vertices() {return vertices;}
   SIZE_T ESize() {return directed?nedges:2*nedges;}
   const Edge* Edges() {return edges;}
   const vector<VERTEX_ID>& ShortestPath(){return shortest_path;}

   void SetDirected(bool directed_graph) {directed = directed_graph;}
   bool Directed() {return directed;}
};


extern Graph graph;


#endif // ShortestPath_HPP
