

/**
   Homework 4 by Marc Davenport in Data Structures with Ryan Mccleary
   04/16/2015
*/

#include "ShortestPath.hpp"

Graph graph;

#include <cmath>
#include <cstdlib>
#include <ctime>
#include <iostream>
using std::cin;

#ifdef VISUALIZE
   #include "Visualize.hpp"

   Visualizer* visualizer = 0;
#endif

bool success = false;
bool quit = false;

void HandleCommand(std::string line);

int main(int argc , char** argv) {
   (void)argc;
   (void)argv;


   srand(time(NULL));

//   Graph graph;

#ifdef VISUALIZE
   visualizer = new Visualizer();

   graph.SetDirected(true);
   
   HandleCommand("demo1");

   HandleCommand("demo2");

#endif


   while (!quit) {

      printf("\nWelcome to the graph path solver. Enter help for commands.\n");

      std::string line;
      getline(cin , line);

      HandleCommand(line);

   }


   return 0;
}



void HandleCommand(std::string line) {
   if (line.compare("quit") == 0) {
      quit = true;
   }

   if (line.compare("help") == 0) {
      printf("Commands       :\n");
      printf("------------------------------------------------------------------------\n");
      printf("help                 : Show the commands\n");
      printf("quit                 : Quit the program\n");
      printf("load $FILE           : Load the file $FILE as a graph\n");
      printf("generate #V #E       : Generate a new graph with V vertices, and E edges\n");
      printf("print                : Print the current graph\n");
      printf("save $PATH           : Save the current graph in file $PATH\n");
      printf("findpath $VFrom $VTo : Find the path from vertice $VFrom to vertice $VTo\n");
#ifdef VISUALIZE
      printf("demo1                : Run demo1\n");
      printf("demo2                : Run demo2\n");
#endif
   }
   if (line.compare(0 , 5 , "load ") == 0) {
      std::string file = line.substr(5);
      success = graph.LoadGraphFile(file.c_str());
      printf("Graph %s loaded %ssuccessfully\n" , file.c_str() , success?"":"un");
   }

   if (line.compare(0 , 9 , "generate ") == 0) {
      SIZE_T nvert = 0;
      SIZE_T nedge = 0;
      if (2 == sscanf(line.c_str() , "generate %u %u" , &nvert , &nedge)) {
         graph.GenerateGraph(nvert , nedge);
      }
      else {
         printf("Failed to read 'generate' command.\n");
      }
   }

   if (line.compare(0 , 5 , "print") == 0) {
      graph.PrintGraph(stdout , false);
   }

   if (line.compare(0 , 5 , "save ") == 0) {
      std::string file = line.substr(5);
      graph.SaveGraph(file.c_str());
   }

   if (line.compare(0 , 9 , "findpath ") == 0) {
      VERTEX_ID from = VERTEX_ID_UNKNOWN;
      VERTEX_ID to = VERTEX_ID_UNKNOWN;
      if (2 != sscanf(line.c_str() , "findpath %u %u" , &from , &to)) {
         printf("Error reading findpath command\n");
      }
      else {
         graph.FindShortestPath(from , to);
      }
   }

   
    if (line.compare("directed") == 0) {
        graph.SetDirected(true);
    }
    if (line.compare("undirected") == 0) {
        graph.SetDirected(false);
    }


#ifdef VISUALIZE

   if (line.compare("demo1") == 0) {
      visualizer->SetDrawBounds(true);
      HandleCommand("load GraphTest2.txt");
      HandleCommand("graph");
   }

   if (line.compare("demo2") == 0) {
      visualizer->SetDrawBounds(false);
      HandleCommand("load Graph.txt");
      HandleCommand("graph");
   }

   visualizer->HandleCommand(line);

#endif
}





void LogFailedAssert(const char* exp , const char* file , int line) {
   // Use OutputLog below, not EagleLog
   printf("Assert(%s) failed at line %i of file %s\n" , exp , line , file);
//   OutputLog() << "Assert(" << exp << ") failed at line " << line << " of " << file << std::endl;
}



void EpicFail() {
   int i = 1/int(0);
   (void)i;
   assert(0);
}



FILE* GetLinePN(FILE* f , std::string& s) {
   s = "";
   if (!f || feof(f) || ferror(f)) {return f;}
   int c;
   while ((c = fgetc(f)) != EOF) {
      if (c == '\r') {// WINDOWS OR OSX
         int c2 = fgetc(f);
         ungetc(c2 , f);
         if (c2 == '\n') {
            c = fgetc(f);// use up \n
         }
         return f;
      }
      if (c == '\n') {// NIX
         return f;
      }
      s += c;
   }
   return f;
}



void SkipWhiteSpace(FILE* f) {
   int c = 0;
   while (1) {
      c = fgetc(f);
      if (!((c == ' ') ||
          (c == '\t') ||
          (c == '\n') ||
          (c == '\f') ||
          (c == '\r'))) {
         // not whitespace
         if (c != EOF) {
            ungetc(c , f);
         }
         break;
      }
   }
}



const EDGE_ID EDGE_ID_UNKNOWN = UINT_MAX;

const VERTEX_ID VERTEX_ID_UNKNOWN = UINT_MAX;



Vertex::Vertex() :
      vertex_id(VERTEX_ID_UNKNOWN),
      vx(0.0),
      vy(0.0),
      vz(0.0),
      incoming_edges(),
      outgoing_edges(),
      known(false),
      prev_vertex(VERTEX_ID_UNKNOWN),
      total_distance(-1.0)
{}



Edge::Edge() :
      edge_id(EDGE_ID_UNKNOWN),
      weight(0.0),
      vertex_from_id(VERTEX_ID_UNKNOWN),
      vertex_to_id(VERTEX_ID_UNKNOWN)
{}




bool VisitedVertexTable::FindTableIndex(VERTEX_ID vid , int* store_index) {

   bool present = vmap.find(vid) != vmap.end();

   *store_index = present?vmap[vid]:-1;

   return present;
}

int VisitedVertexTable::FindNewTableIndexByDistance(double vdist) {

   int left = 0;
///      int right = vtable.size() - 1;// see the bug here if size() is 0?
   int right = (int)vtable.size() - 1;
   if (right == -1) {
      // empty table - insert at 0
      return 0;
   }
   int middle = (left + right)/2;

   while (1) {// we will return out of this loop

//         VERTEX_ID lvid = vtable[left].vid;
//         VERTEX_ID rvid = vtable[right].vid;

      double ldist = vtable[left].dist;
      double rdist = vtable[right].dist;

      // base case 1 to stop the loop
      if (left == right) {
         // l and r are equal, we have found the spot where it is or where to insert it
         if (vdist >= ldist) {
            // newloc 1
            return left;// insert before left
         }
         else {
            // 1 newloc
            return left + 1;
         }
      }

      // base case 2 to stop the loop
      if (right == left + 1) {
         // 3 places it could go
         if (vdist >= ldist) {
            return left;
         }
         else if (vdist >= rdist) {
            return right;
         }
         else {
            return right + 1;
         }
      }

      // decide which half to search next
//         VERTEX_ID mvid = vtable[middle].vid;
      double mdist = vtable[middle].dist;
      if (vdist >= mdist) {
         right = middle;
      }
      else {
         // vdist < mdist
         left = middle;
      }

      middle = (left + right)/2;
   }

   EAGLE_ASSERT(0);// this should never be reached
   return false;
}



//*
void VisitedVertexTable::InsertEntry(VERTEX_ID vid , double val) {
   int index = FindNewTableIndexByDistance(val);
   // found index to insert 'before' (but really 'at')
   // need to push sub array back to make room for this entry
   vtable.resize(vtable.size() + 1);// contents are preserved and new entries are default constructed
   int i = vtable.size() - 1;

   while (i > index) {
      vtable[i] = vtable[i-1];
      VERTEX_ID cvid = vtable[i].vid;
      vmap[cvid] += 1;
      --i;
   }
   VTableEntry vte;
   vte.vid = vid;
   vte.dist = val;
   vtable[index] = vte;
   vmap[vte.vid] = index;
}
//*/



void VisitedVertexTable::Remove(int index) {
   VERTEX_ID vid = vtable[index].vid;
   VMap::iterator it = vmap.find(vid);
   EAGLE_ASSERT(it != vmap.end());
   vmap.erase(it);

   for (int i = index ; i < (int)vtable.size() - 1 ; ++i) {
      vtable[i] = vtable[i+1];
      vmap[vtable[i].vid] -= 1;
   }
   vtable.pop_back();
}



VisitedVertexTable::VisitedVertexTable() :
      vtable(),
      vmap()
{
   /// TODO : Reserve slots so push_back doesn't reallocate
}



void VisitedVertexTable::SetVertexValue(VERTEX_ID vid , double val) {
   int index = -1;
   if (FindTableIndex(vid , &index)) {
      Remove(index);
   }
   InsertEntry(vid , val);
}



bool VisitedVertexTable::Empty() {return vtable.empty();}



VTableEntry VisitedVertexTable::TakeMin() {
   EAGLE_ASSERT(!Empty());
   VTableEntry vte = vtable.back();
   vtable.pop_back();

   VMap::iterator it = vmap.find(vte.vid);
   EAGLE_ASSERT(it != vmap.end());
   vmap.erase(it);

   return vte;
}



void Graph::ResetVerticeTable() {
   for (int i = 0 ; i < (int)nvertices ; ++i) {
      vertices[i].known = false;
      vertices[i].prev_vertex = VERTEX_ID_UNKNOWN;
      vertices[i].total_distance = -1.0;
   }
}



Graph::Graph() :
      vertices(0),
      edges(0),
      nvertices(0),
      nedges(0),
      shortest_path(),
      directed(false)
{
}



Graph::~Graph() {
   Free();
}



void Graph::Free() {
   FreeVertices();
   FreeEdges();
}



void Graph::FreeEdges() {
   if (edges) {
      delete [] edges;
      edges = 0;
      nedges = 0;
   }
}



void Graph::FreeVertices() {
   if (vertices) {
      delete [] vertices;
      vertices = 0;
      nvertices = 0;
   }
}



bool Graph::LoadGraphFile(const char* fpath) {

   FILE* f = fopen(fpath , "r");
   if (!f) {
      return false;
   }

   string line;
   SIZE_T vcount = 0;
   SIZE_T ecount = 0;

   /// count vertices and edges in graph file
   while (feof(GetLinePN(f , line)) == 0) {
      // VERTEX2 0 0.000000 0.000000 0.000000
      if (line.compare(0,8,"VERTEX2 ") == 0) {
         ++vcount;
      }
      else if (line.compare(0,6,"EDGE2 ") == 0) {
         ++ecount;
      }

   }

   /// allocate vertices and edges
   if (vcount) {
      FreeVertices();
      vertices = new Vertex[vcount];
      nvertices = vcount;
   }
   if (ecount) {
      FreeEdges();
      edges = new Edge[2*ecount];
      nedges = ecount;
   }
   shortest_path.clear();

   /// reopen file and read vertices and edges
   rewind(f);
   vcount = 0;
   ecount = 0;

   while (feof(GetLinePN(f , line)) == 0) {
      // VERTEX2 0 0.000000 0.000000 0.000000
      if (line.compare(0,8,"VERTEX2 ") == 0) {
         Vertex* v = &vertices[vcount];
///         VERTEX_ID id = VERTEX_ID_UNKNOWN;
         if (sscanf(line.c_str() , "VERTEX2 %u %lf %lf %lf" , &v->vertex_id , &v->vx , &v->vy , &v->vz) != 4) {
            *v = Vertex();// reset
            fprintf(stdout , "Improper VERTEX2 (%s)\n" , line.c_str());
         }
         else {
            if (v->vertex_id != (VERTEX_ID)vcount) {
               fprintf(stdout , "Mismatched vertex id.\n");
            }
            ++vcount;
         }
      }
      else if (line.compare(0,6,"EDGE2 ") == 0) {
         // EDGE2 0 1 0.999098 -0.033582 0.008184 44.845999 11.946637 399.868803 9838.307632 0.000000 0.000000
         Edge* e = &edges[ecount];
         Edge* e2 = &edges[ecount + nedges];
         if (sscanf(line.c_str() , "EDGE2 %u %u" , &e->vertex_from_id , &e->vertex_to_id) != 2) {
            fprintf(stdout , "Improper EDGE2 (%s)\n" , line.c_str());
         }
         else {
            if (e->vertex_from_id < (VERTEX_ID)nvertices && e->vertex_to_id < (VERTEX_ID)nvertices) {
               ++ecount;
               e2->vertex_from_id = e->vertex_to_id;
               e2->vertex_to_id = e->vertex_from_id;
            }
            else {
               fprintf(stdout , "Vertex ids out of range. From = %u , To = %u , Nvertices = %d\n",
                       e->vertex_from_id , e->vertex_to_id , nvertices);
               *e = Edge();// reset this edge's data
               *e2 = Edge();// reset this edge's data
            }
         }
      }
      else {
         fprintf(stdout , "Improper data line. (%s)\n" , line.c_str());
      }

   }
   if (vcount != nvertices) {
      fprintf(stdout , "Actual number of vertices read does not match initial count. (%u/%u)\n" , vcount , nvertices);
      nvertices = vcount;
   }
   if (ecount != nedges) {
      fprintf(stdout , "Actual number of edges read does not match initial count. (%u/%u)\n" , ecount , nedges);
      nedges = ecount;
   }

   /// Now that all vertices and edges are read, compute edge weights and set incoming and outgoing edges for vertices

   for (SIZE_T i = 0 ; i < (SIZE_T)(nedges*2) ; ++i) {
      Edge* e = &edges[i];
      VERTEX_ID vid1 = e->vertex_from_id;
      VERTEX_ID vid2 = e->vertex_to_id;
      EAGLE_ASSERT(vid1 < (VERTEX_ID)nvertices && vid2 < (VERTEX_ID)nvertices);
      Vertex* v1 = &vertices[vid1];
      Vertex* v2 = &vertices[vid2];
      double dx = v2->vx - v1->vx;
      double dy = v2->vy - v1->vy;
      double dz = v2->vz - v1->vz;
      e->weight = sqrt(dx*dx + dy*dy + dz*dz);
      v1->outgoing_edges.push_back((EDGE_ID)i);
///      v2->outgoing_edges.push_back((EDGE_ID)i);
///      v2->incoming_edges.push_back((EDGE_ID)i);
///      v1->incoming_edges.push_back((EDGE_ID)i);
      v2->incoming_edges.push_back((EDGE_ID)i);
   }

   fclose(f);

   return true;

}



//void Graph::GenerateGraph(const char* savepath , SIZE_T num_vertices , SIZE_T num_edges) {
void Graph::GenerateGraph(SIZE_T num_vertices , SIZE_T num_edges) {

   Free();
   
   shortest_path.clear();

   EAGLE_ASSERT(num_vertices > 1);

   vertices = new Vertex[num_vertices];
   nvertices = num_vertices;

   nedges = num_edges + num_vertices - 1;

   edges = new Edge[2*nedges];

   for (SIZE_T i = 0 ; i < nvertices ; ++i) {
      Vertex* v = &vertices[i];
      v->vertex_id = (VERTEX_ID)i;
//      v->vx = (0.001)*(rand()%200000 - 100000);
//      v->vy = (0.001)*(rand()%200000 - 100000);
//      v->vz = (0.001)*(rand()%200000 - 100000);
      v->vx = ((double)rand()/RAND_MAX*200.0 - 100.0);
      v->vy = ((double)rand()/RAND_MAX*200.0 - 100.0);
      v->vz = ((double)rand()/RAND_MAX*200.0 - 100.0);
   }

   /// TODO : Remove duplicate edges when finished
//   std::map<VERTEX_ID , VERTEX_ID> vertexmap;

   /// Add in a number of random edges
   for (SIZE_T i = 0 ; i < num_edges ; ++i) {
      VERTEX_ID from = (VERTEX_ID)(rand()%nvertices);
      VERTEX_ID to = (VERTEX_ID)(rand()%nvertices);
//      std::map<VERTEX_ID , VERTEX_ID>::iterator it = vertexmap.find(from);
//      if (it != vertexmap.end()) {

//      }
      Edge* e = &edges[i];
      e->edge_id = i;
      e->vertex_from_id = from;
      e->vertex_to_id = to;
      Vertex* vfrom = &vertices[from];
      Vertex* vto = &vertices[to];
      double dx = vto->vx - vfrom->vx;
      double dy = vto->vy - vfrom->vy;
      double dz = vto->vz - vfrom->vz;
      e->weight = sqrt(dx*dx + dy*dy + dz*dz);

      vfrom->outgoing_edges.push_back(i);
      vto->incoming_edges.push_back(i);

      Edge* e2 = &edges[i + nedges];
      e2->edge_id = i + nedges;
      e2->vertex_from_id = to;
      e2->vertex_to_id = from;
      vfrom = &vertices[to];
      vto = &vertices[from];
      e2->weight = e->weight;

      vfrom->outgoing_edges.push_back(i);
      vto->incoming_edges.push_back(i);

   }

   /// Add in at least one path from start to end by linking every vertex to the next.
   /// This will most likely be the longest path but it guarantees there is one.
   for (SIZE_T i = 0 ; i < nvertices - 1 ; ++i) {
      EDGE_ID edge_id = i + num_edges;
//         num_edges ; i < nedges - 1 ; ++i) {
//   for (SIZE_T i = num_edges ; i < nedges - 1 ; ++i) {
      VERTEX_ID from = i;
      VERTEX_ID to = i + 1;
      Edge* e = &edges[edge_id];
      e->edge_id = edge_id;
      e->vertex_from_id = from;
      e->vertex_to_id = to;
      Vertex* vfrom = &vertices[from];
      Vertex* vto = &vertices[to];
      double dx = vto->vx - vfrom->vx;
      double dy = vto->vy - vfrom->vy;
      double dz = vto->vz - vfrom->vz;
      e->weight = sqrt(dx*dx + dy*dy + dz*dz);

      vfrom->outgoing_edges.push_back(edge_id);
      vto->incoming_edges.push_back(edge_id);

///      from = i +1;
///      to = i;
      Edge* e2 = &edges[edge_id + nedges];
      e2->edge_id = edge_id + nedges;
      e2->vertex_from_id = to;
      e2->vertex_to_id = from;
      vfrom = &vertices[to];
      vto = &vertices[from];
      e2->weight = e->weight;

      vfrom->outgoing_edges.push_back(edge_id + nedges);
      vto->incoming_edges.push_back(edge_id + nedges);
   }

//   PrintGraph(stdout);
}



void Graph::PrintGraph(FILE* fout , bool directed) {
   if (!fout) {return;}

   // print vertices
   for (SIZE_T i = 0 ; i < nvertices ; ++i) {
      Vertex* v = &vertices[i];
      fprintf(fout , "VERTEX2 %u %lf %lf %lf\n" , v->vertex_id , v->vx , v->vy , v->vz);
   }
   // print edges
   SIZE_T ne = directed?nedges:(2*nedges);
   for (SIZE_T i = 0 ; i < ne ; ++i) {
      const Edge& e = edges[i];
      fprintf(fout , "EDGE2 %u %u %lf\n" , e.vertex_from_id , e.vertex_to_id , e.weight);
   }
}



void Graph::SaveGraph(const char* savepath) {

   FILE* savefile = fopen(savepath , "w");
   if (!savefile) {
      printf("Failed to open %s for writing.\nWriting to cout :\n" , savepath);
      return;
   }

   PrintGraph(savefile , true);
   fclose(savefile);
}



void Graph::FindShortestPath(VERTEX_ID from , VERTEX_ID to) {
   ResetVerticeTable();

   if (!vertices) {
      fprintf(stdout , "Graph::FindShortestPath - No vertices to process.\n");
      return;
   }
   if (from >= nvertices) {
      fprintf(stdout , "Graph::FindShortestPath - VERTEX_ID 'from' out of range.\n");
   }
   if (to >= nvertices) {
      fprintf(stdout , "Graph::FindShortestPath - VERTEX_ID 'to' out of range.\n");
   }

   /// Create AVL tree to store visited unknown vertices sorted
   // use std::map for now
//      CompareVertices cvfunctor(vertices , nvertices);
//      map<VERTEX_ID , double , CompareVertices>

   /// Start with vertex 'from' and mark it known at a distance of 0.0
   VERTEX_ID current_vertex_id = from;
   Vertex* current = &vertices[from];
   current->known = true;
   current->total_distance = 0.0;
   current->prev_vertex = VERTEX_ID_UNKNOWN;

   if (vertices[to].incoming_edges.size() == 0) {
      // No incoming edges on the 'to' vertice.
      printf("Vertex %u has no incoming edges! There can be no path to this vertice.\n" , to);
      return;
   }


   /// Visit every outgoing edge of the current node and update distances and previous vertex
   VisitedVertexTable vtable;

   bool complete = false;
   while (!complete) {

    EAGLE_DEBUG(
      printf("Checking current vertex %u\n" , current_vertex_id);
    );
      double current_distance = current->total_distance;

      EAGLE_ASSERT(current_distance >= 0.0);/// TODO this is negative sometimes...???

      const vector<EDGE_ID>& edge_id_ref = current->outgoing_edges;

      for (SIZE_T index = 0 ; index < edge_id_ref.size() ; ++index) {
         EDGE_ID edge_id = edge_id_ref[index];

         EAGLE_ASSERT(edge_id < (SIZE_T)nedges*2);

         const Edge& e = edges[edge_id];
         VERTEX_ID vertex_id_next = e.vertex_to_id;
         Vertex* next = &vertices[vertex_id_next];
         if (next->known) {continue;}

         EAGLE_ASSERT(e.weight >= 0.0);

         double distance_to_v = current_distance + e.weight;

        EAGLE_DEBUG(
         printf("Checking outgoing edge %u from vertex %u to %u, total_distance = %lf\n",
                edge_id , current_vertex_id , vertex_id_next , distance_to_v);
        );

         if (distance_to_v < next->total_distance || next->total_distance < 0.0) {
            // found shorter path to next vertice
            next->total_distance = distance_to_v;
//            next->prev_vertex =
            next->prev_vertex = current_vertex_id;

            vtable.SetVertexValue(vertex_id_next , distance_to_v);
//               next->total_distance = distance_to_v
         }
      }

      // We've added all visited unknown edges - now find the minimum distance and mark that vertex known
      if (vtable.Empty()) {
         // no edges left to visit
         complete = true;
         break;
      }

      VTableEntry vte = vtable.TakeMin();

      Vertex* vmin = &vertices[vte.vid];
      vmin->known = true;
      if (vte.vid == to) {
         // We found the shortest path to the vertice
         complete = true;
         break;
      }

      current = vmin;
      current_vertex_id = vte.vid;
   }

   /// Print out path from the 'from' vertex to the 'to' vertex
   vector<VERTEX_ID> vids;
   VERTEX_ID cid = to;

   printf("\nPrinting path backwards from destination vertex %u to starting vertex %u\n",
          to , from);

   while (cid != VERTEX_ID_UNKNOWN) {
      VERTEX_ID previd = vertices[cid].prev_vertex;
      if (previd == VERTEX_ID_UNKNOWN) {
         printf("%u\n" , cid);
         vids.push_back(cid);
         break;
      }
      printf("%u <- " , cid);
      vids.push_back(cid);
      cid = previd;
   }

   if (vids.back() != from) {
      // Error, path does not trace back to the from node
      printf("Error, path does not lead back to the 'from' vertex %u\n" , from);
   }

   printf("\nPrinting path from vertex %u to vertex %u\n" , from , to);

   // Stack has now reversed the path so we have 'from' to 'to'
   /// Our path is in vertices, not edges so we have to recalculate the distance as looking up edges would be too expensive
   double distance = 0.0;
   double dx = 0.0;
   double dy = 0.0;
   double dz = 0.0;
   shortest_path.clear();
   if (vids.size() >= 2) {
      while (1) {

         VERTEX_ID vid = vids.back();
         shortest_path.push_back(vid);
         if (vids.size() >= 2) {
            VERTEX_ID vid2 = vids[vids.size() - 2];
            const Vertex* v1 = &vertices[vid];
            const Vertex* v2 = &vertices[vid2];
            dx = v2->vx - v1->vx;
            dy = v2->vy - v1->vy;
            dz = v2->vz - v1->vz;
            distance += sqrt(dx*dx + dy*dy + dz*dz);
         }

         if (vids.size() == 1) {
            printf("%u\n" , vid);
            break;
         }
         printf("%u -> " , vid);
         vids.pop_back();
      }
   }
   else {
      // only one vertices on path
      EAGLE_ASSERT(vertices[to].prev_vertex == VERTEX_ID_UNKNOWN);
      printf("Error. Vertice %u has no previous vertex. This must be on a different subtree.\n" , to);
   }
   printf("Total distance is %lf\n" , distance);

}




