#include <allegro5/allegro.h>
#include "m_config.h"
#include "g_header.h"
#include "c_header.h"

#include "g_misc.h"

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "e_log.h"
#include "e_slider.h"
#include "e_header.h"
#include "e_files.h"
#include "g_shape.h"
#include "i_header.h"
#include "i_console.h"
#include "c_data.h"
#include "c_prepr.h"


enum
{
 PTOKEN_TYPE_NUMBER,
 PTOKEN_TYPE_WORD,
 PTOKEN_TYPE_SYMBOL,
 PTOKEN_TYPE_UNKNOWN
};


enum
{
PRERR_UNRECOGNISED_DIRECTIVE,
PRERR_NUMBER_CONTAINS_LETTER,
PRERR_UNRECOGNISED_CHARACTER,
PRERR_TOKEN_TOO_LONG,
PRERR_INVALID_TOKEN,
PRERR_SCODE_LIMIT_REACHED,
PRERR_STRING_NOT_NULL_TERMINATED,
PRERR_NAME_ALREADY_USED,
PRERR_SYNTAX_ERROR,
PRERR_SYNTAX_ERROR_DIRECTIVE,
PRERR_TOO_MANY_DEFINES,
PRERR_RECURSIVE_MACRO,
PRERR_CANNOT_REDEFINE_NUMTOKEN,
PRERR_CANNOT_UNDEFINE_NUMTOKEN,
PRERR_NAME_ALREADY_USED_AS_IDENTIFIER,
PRERR_OUT_OF_PRSTACK,
PRERR_ENDIF_WITHOUT_IF,
PRERR_REACHED_END_WITHIN_IF,
PRERR_UNDEFINED_TOKEN_DOESNT_EXIST,
PRERR_FILE_READ_ERROR,
PRERR_FILE_TOO_LONG,
PRERR_FILE_OPEN_ERROR,
PRERR_EXPECTED_QUOTES_AFTER_INCLUDE,
PRERR_FILE_NAME_TOO_LONG,
PRERR_TOO_MANY_INCLUDED_FILES,
PRERR_COULDNT_ALLOCATE_INCLUDE_SOURCE,
PRERR_ERROR_DIRECTIVE,
PRERR_FILE_PATH_TOO_LONG,
PRERR_INVALID_FILE_PATH,
PRERR_UNKNOWN_DEFINE_ERROR,
PRERR_HEX_NUMBER_CONTAINS_INVALID_LETTER,
PRERR_INVALID_NUMBER,
PRERR_BINARY_NUMBER_CONTAINS_LETTER,
PRERR_COULDNT_ALLOCATE_BCODE,
PRERR_EMPTY,
PRERR_INVALID_STRING,
PRERRS
};




#define DEFTOKENS 500
//#define DEFTOKEN_LENGTH 32

#define SUB_TEXT_LENGTH 64
// DIRECTIVE_LENGTH is the maximum length of the name of a directive, e.g "define"
#define DIRECTIVE_LENGTH 12

struct definestruct
{
 int exists;
 int file_scope; // used for subdefines. Is -1 if just a normal define.
 char name [PTOKEN_LENGTH];
 char sub_text [SUB_TEXT_LENGTH]; // substituted text. a deftoken does not necessarily have this
// more complex macros, e.g. ones that take arguments, are not currently supported. sorry :(
};


struct definestruct deftoken [DEFTOKENS];


const struct numtokenstruct numtoken [NUMTOKENS] = // when adding numtokens, may need to increase NUMTOKENS
{
// method types:
 {"MT_NONE", MTYPE_NONE},

// proc methods
 {"MT_PR_MOVE", MTYPE_PR_MOVE},
 {"MT_PR_NEW", MTYPE_PR_NEW},
 {"MT_PR_NEW_SUB", MTYPE_PR_NEW_SUB},
 {"MT_PR_PACKET", MTYPE_PR_PACKET},
 {"MT_PR_DPACKET", MTYPE_PR_DPACKET},
 {"MT_PR_STREAM", MTYPE_PR_STREAM},
 {"MT_PR_DSTREAM", MTYPE_PR_DSTREAM},
 {"MT_PR_SCAN", MTYPE_PR_SCAN},
 {"MT_PR_IRPT", MTYPE_PR_IRPT},
 {"MT_PR_ALLOCATE", MTYPE_PR_ALLOCATE},
// {"MTYPE_GET_XY", MTYPE_GET_XY},
 {"MT_PR_STD", MTYPE_PR_STD},
 {"MT_PR_MATHS", MTYPE_PR_MATHS},
 {"MT_PR_DESIGNATE", MTYPE_PR_DESIGNATE},
 {"MT_PR_LINK", MTYPE_PR_LINK},
// {"MT_PR_TIME", MTYPE_PR_TIME},
 {"MT_PR_RESTORE", MTYPE_PR_RESTORE},
 {"MT_PR_REDUNDANCY", MTYPE_PR_REDUNDANCY},
 {"MT_PR_BROADCAST", MTYPE_PR_BROADCAST},
 {"MT_PR_LISTEN", MTYPE_PR_LISTEN},
 {"MT_PR_YIELD", MTYPE_PR_YIELD},
 {"MT_PR_STORAGE", MTYPE_PR_STORAGE},
 {"MT_PR_STATIC", MTYPE_PR_STATIC},
 {"MT_PR_COMMAND", MTYPE_PR_COMMAND},
// {"MT_PR_ACTION", MTYPE_PR_ACTION},
 {"MT_PR_VIRTUAL", MTYPE_PR_VIRTUAL},
// {"MT_PR_OUTPUT", MTYPE_PR_OUTPUT},

// client methods
 {"MT_CL_COMMAND_GIVE", MTYPE_CL_COMMAND_GIVE},
 {"MT_CL_TEMPLATE", MTYPE_CL_TEMPLATE},
 {"MT_CL_OUTPUT", MTYPE_CL_OUTPUT},

// client/observer methods
 {"MT_CLOB_POINT", MTYPE_CLOB_POINT},
 {"MT_CLOB_QUERY", MTYPE_CLOB_QUERY},
 {"MT_CLOB_SCAN", MTYPE_CLOB_SCAN},
 {"MT_CLOB_MATHS", MTYPE_CLOB_MATHS},
 {"MT_CLOB_STD", MTYPE_CLOB_STD},
 {"MT_CLOB_COMMAND_REC", MTYPE_CLOB_COMMAND_REC},

// observer methods
 {"MT_OB_INPUT", MTYPE_OB_INPUT},
 {"MT_OB_VIEW", MTYPE_OB_VIEW},
 {"MT_OB_CONSOLE", MTYPE_OB_CONSOLE},
 {"MT_OB_SELECT", MTYPE_OB_SELECT},
 {"MT_OB_CONTROL", MTYPE_OB_CONTROL},

// system methods
 {"MT_SY_PLACE_PROC", MTYPE_SY_PLACE_PROC},
 {"MT_SY_TEMPLATE", MTYPE_SY_TEMPLATE},
 {"MT_SY_MODIFY", MTYPE_SY_MODIFY_PROC},
// {"MT_SY_CONNECTION", MTYPE_SY_CONNECTION},
// {"MT_SY_DESTROY_PROC", MTYPE_SY_DESTROY_PROC},
 {"MT_SY_MANAGE", MTYPE_SY_MANAGE},

// misc mtypes
 {"MT_END", MTYPE_END},
 {"MT_ERROR_INVALID", MTYPE_ERROR_INVALID},
 {"MT_ERROR_VERTEX", MTYPE_ERROR_VERTEX},
 {"MT_ERROR_MASS", MTYPE_ERROR_MASS},
 {"MT_ERROR_DUPLICATE", MTYPE_ERROR_DUPLICATE},
 {"MT_ERROR_SUB", MTYPE_ERROR_SUB},

// Other method data:
// MT_PR_ACCEL
 {"MB_PR_MOVE_RATE", MBANK_PR_MOVE_RATE},
 {"MB_PR_MOVE_COUNTER", MBANK_PR_MOVE_COUNTER},
 {"MB_PR_MOVE_DELAY", MBANK_PR_MOVE_DELAY},
// MT_PR_NEW Mbank
 {"MB_PR_NEW_STATUS", MBANK_PR_NEW_STATUS},
 {"MB_PR_NEW_VERTEX1", MBANK_PR_NEW_VERTEX1},
 {"MB_PR_NEW_VERTEX2", MBANK_PR_NEW_VERTEX2},
 {"MB_PR_NEW_ANGLE", MBANK_PR_NEW_ANGLE},
 {"MB_PR_NEW_START", MBANK_PR_NEW_START_ADDRESS},
 {"MB_PR_NEW_END", MBANK_PR_NEW_END_ADDRESS},
 {"MB_PR_NEW_LINK", MBANK_PR_NEW_LINK},
 {"MB_PR_NEW_TEMPLATE", MBANK_PR_NEW_TEMPLATE},
// status
 {"MS_PR_NEW_NOTHING", MSTATUS_PR_NEW_NOTHING},
 {"MS_PR_NEW_BC_BUILD", MSTATUS_PR_NEW_BUILD},
 {"MS_PR_NEW_BC_TEST", MSTATUS_PR_NEW_TEST},
 {"MS_PR_NEW_BC_COST_DATA", MSTATUS_PR_NEW_COST_DATA},
 {"MS_PR_NEW_BC_COST_IRPT", MSTATUS_PR_NEW_COST_IRPT},
 {"MS_PR_NEW_T_BUILD", MSTATUS_PR_NEW_T_BUILD},
 {"MS_PR_NEW_T_TEST", MSTATUS_PR_NEW_T_TEST},
 {"MS_PR_NEW_T_COST_DATA", MSTATUS_PR_NEW_T_COST_DATA},
 {"MS_PR_NEW_T_COST_IRPT", MSTATUS_PR_NEW_T_COST_IRPT},
// result (return value of method call)
 {"MR_NEW_NONE", MRES_NEW_NONE}, // not sure this is actually used
 {"MR_NEW_SUCCESS", MRES_NEW_SUCCESS},
 {"MR_NEW_TEST_SUCCESS", MRES_NEW_TEST_SUCCESS},
 {"MR_NEW_FAIL_STATUS", MRES_NEW_FAIL_STATUS},
 {"MR_NEW_FAIL_TYPE", MRES_NEW_FAIL_TYPE},
 {"MR_NEW_FAIL_OBSTACLE", MRES_NEW_FAIL_OBSTACLE},
 {"MR_NEW_FAIL_IRPT", MRES_NEW_FAIL_IRPT},
 {"MR_NEW_FAIL_DATA", MRES_NEW_FAIL_DATA},
 {"MR_NEW_FAIL_START_BOUNDS", MRES_NEW_FAIL_START_BOUNDS},
 {"MR_NEW_FAIL_END_BOUNDS", MRES_NEW_FAIL_END_BOUNDS},
 {"MR_NEW_FAIL_INTERFACE", MRES_NEW_FAIL_INTERFACE},
 {"MR_NEW_FAIL_TOO_MANY_PROCS", MRES_NEW_FAIL_TOO_MANY_PROCS},
// {"MR_NEW_FAIL_GEN_LIMIT", MRES_NEW_FAIL_GEN_LIMIT},
 {"MR_NEW_FAIL_SHAPE", MRES_NEW_FAIL_SHAPE},
 {"MR_NEW_FAIL_SIZE", MRES_NEW_FAIL_SIZE},
 {"MR_NEW_FAIL_PARENT_VERTEX", MRES_NEW_FAIL_PARENT_VERTEX},
 {"MR_NEW_FAIL_CHILD_VERTEX", MRES_NEW_FAIL_CHILD_VERTEX},
 {"MR_NEW_FAIL_TEMPLATE", MRES_NEW_FAIL_TEMPLATE},
 {"MR_NEW_FAIL_TEMPLATE_EMPTY", MRES_NEW_FAIL_TEMPLATE_EMPTY},
 {"MR_NEW_FAIL_LOCATION", MRES_NEW_FAIL_LOCATION},
 {"MR_NEW_FAIL_PLAYER", MRES_NEW_FAIL_PLAYER},
// MT_SY_PLACE mbank
 {"MB_SY_PLACE_STATUS", MBANK_SY_PLACE_STATUS},
 {"MB_SY_PLACE_X", MBANK_SY_PLACE_X},
 {"MB_SY_PLACE_Y", MBANK_SY_PLACE_Y},
 {"MB_SY_PLACE_ANGLE", MBANK_SY_PLACE_ANGLE},
 {"MB_SY_PLACE_ADDRESS1", MBANK_SY_PLACE_ADDRESS1},
 {"MB_SY_PLACE_ADDRESS2", MBANK_SY_PLACE_ADDRESS2},
 {"MB_SY_PLACE_INDEX", MBANK_SY_PLACE_INDEX},
 {"MB_SY_PLACE_TEMPLATE", MBANK_SY_PLACE_TEMPLATE},
// statuses
 {"MS_SY_PLACE_NOTHING", MSTATUS_SY_PLACE_NOTHING},
 {"MS_SY_PLACE_BC_CALL", MSTATUS_SY_PLACE_CALL},
 {"MS_SY_PLACE_BC_CALL_TEST", MSTATUS_SY_PLACE_CALL_TEST},
 {"MS_SY_PLACE_BC_COST_DATA", MSTATUS_SY_PLACE_COST_DATA},
 {"MS_SY_PLACE_BC_COST_IRPT", MSTATUS_SY_PLACE_COST_IRPT},
 {"MS_SY_PLACE_T_CALL", MSTATUS_SY_PLACE_T_CALL},
 {"MS_SY_PLACE_T_CALL_TEST", MSTATUS_SY_PLACE_T_CALL_TEST},
 {"MS_SY_PLACE_T_COST_DATA", MSTATUS_SY_PLACE_T_COST_DATA},
 {"MS_SY_PLACE_T_COST_IRPT", MSTATUS_SY_PLACE_T_COST_IRPT},
// The result statuses are the MR_NEW_* ones (same as for PR_NEW method)
/* {"MS_SY_PLACE_FAIL_STATUS", MSTATUS_SY_PLACE_FAIL_STATUS},
 {"MS_SY_PLACE_SUCCESS", MSTATUS_SY_PLACE_SUCCESS},
 {"MS_SY_PLACE_TEST_SUCCESS", MSTATUS_SY_PLACE_TEST_SUCCESS},
 {"MS_SY_PLACE_FAIL_OBSTACLE", MSTATUS_SY_PLACE_FAIL_OBSTACLE},
 {"MS_SY_PLACE_FAIL_START", MSTATUS_SY_PLACE_FAIL_START},
 {"MS_SY_PLACE_FAIL_END", MSTATUS_SY_PLACE_FAIL_END},
 {"MS_SY_PLACE_FAIL_INTERFACE", MSTATUS_SY_PLACE_FAIL_INTERFACE},
 {"MS_SY_PLACE_FAIL_TOO_MANY_PROCS", MSTATUS_SY_PLACE_FAIL_TOO_MANY_PROCS},
 {"MS_SY_PLACE_FAIL_TYPE", MSTATUS_SY_PLACE_FAIL_TYPE},
 {"MS_SY_PLACE_FAIL_SHAPE", MSTATUS_SY_PLACE_FAIL_SHAPE},
 {"MS_SY_PLACE_FAIL_SIZE", MSTATUS_SY_PLACE_FAIL_SIZE},
 {"MS_SY_PLACE_FAIL_TEMPLATE", MSTATUS_SY_PLACE_FAIL_TEMPLATE},
 {"MS_SY_PLACE_FAIL_LOCATION", MSTATUS_SY_PLACE_FAIL_LOCATION},
 {"MS_SY_PLACE_FAIL_PLAYER", MSTATUS_SY_PLACE_FAIL_PLAYER},*/
// MT_PR_PACKET mbank
 {"MB_PR_PACKET_COUNTER", MBANK_PR_PACKET_COUNTER},
 {"MB_PR_PACKET_FRIENDLY", MBANK_PR_PACKET_FRIENDLY},

 {"MB_PR_DPACKET_COUNTER", MBANK_PR_DPACKET_COUNTER},
 {"MB_PR_DPACKET_ANGLE", MBANK_PR_DPACKET_ANGLE},
 {"MB_PR_DPACKET_FRIENDLY", MBANK_PR_DPACKET_FRIENDLY},

 {"MB_PR_STREAM_FIRE", MBANK_PR_STREAM_FIRE},
// {"MB_PR_STREAM_TIME", MBANK_PR_STREAM_TIME},

 {"MB_PR_DSTREAM_FIRE", MBANK_PR_DSTREAM_FIRE},
// {"MB_PR_DSTREAM_TIME", MBANK_PR_DSTREAM_TIME},
 {"MB_PR_DSTREAM_ANGLE", MBANK_PR_DSTREAM_ANGLE},

// {"MB_PR_PACKET_ANGLE", MBANK_PR_PACKET_ANGLE}, not currently used
// statuses
/*
 {"MS_PR_PACKET_NOTHING", MSTATUS_PR_PACKET_NOTHING}, // not currently used
 {"MS_PR_PACKET_ACTIVE", MSTATUS_PR_PACKET_ACTIVE},
 {"MS_PR_PACKET_SUCCESS", MSTATUS_PR_PACKET_SUCCESS},
 {"MS_PR_PACKET_FAIL_IRPT", MSTATUS_PR_PACKET_FAIL_IRPT},
 {"MS_PR_PACKET_FAIL_TOO_MANY", MSTATUS_PR_PACKET_FAIL_TOO_MANY},*/
// MT_PR_SCAN mbank
 {"MB_PR_SCAN_STATUS", MBANK_PR_SCAN_STATUS},
 {"MB_PR_SCAN_START_ADDRESS", MBANK_PR_SCAN_START_ADDRESS},
 {"MB_PR_SCAN_NUMBER", MBANK_PR_SCAN_NUMBER},
 {"MB_PR_SCAN_X1", MBANK_PR_SCAN_X1},
 {"MB_PR_SCAN_Y1", MBANK_PR_SCAN_Y1},
 {"MB_PR_SCAN_SIZE", MBANK_PR_SCAN_SIZE},
 {"MB_PR_SCAN_SIZE2", MBANK_PR_SCAN_Y2},// not used
 {"MB_PR_SCAN_BITFIELD_WANT", MBANK_PR_SCAN_BITFIELD_WANT},
 {"MB_PR_SCAN_BITFIELD_NEED", MBANK_PR_SCAN_BITFIELD_NEED},
 {"MB_PR_SCAN_BITFIELD_REJECT", MBANK_PR_SCAN_BITFIELD_REJECT},
// statuses
 {"MS_PR_SCAN_SCAN", MSTATUS_PR_SCAN_SCAN},
 {"MS_PR_SCAN_EXAMINE", MSTATUS_PR_SCAN_EXAMINE},
// {"MS_PR_SCAN_RECTANGLE", MSTATUS_PR_SCAN_RECTANGLE},
// CLOB_SCAN statuses
 {"MS_CLOB_SCAN_SCAN", MSTATUS_CLOB_SCAN_SCAN},
 {"MS_CLOB_SCAN_RECTANGLE", MSTATUS_CLOB_SCAN_RECTANGLE},
 {"MS_CLOB_SCAN_EXAMINE", MSTATUS_CLOB_SCAN_EXAMINE},
 {"MS_CLOB_SCAN_SCAN_INDEX", MSTATUS_CLOB_SCAN_SCAN_INDEX},
 {"MS_CLOB_SCAN_RECTANGLE_INDEX", MSTATUS_CLOB_SCAN_RECTANGLE_INDEX},
// Scan results:
 {"MR_SCAN_FAIL_SIZE", MRES_SCAN_FAIL_SIZE}, // These are all < 0. there are no success MR results because success returns the number of procs found.
 {"MR_SCAN_FAIL_RANGE", MRES_SCAN_FAIL_RANGE},
 {"MR_SCAN_FAIL_STATUS", MRES_SCAN_FAIL_STATUS},
 {"MR_SCAN_FAIL_ADDRESS", MRES_SCAN_FAIL_ADDRESS},
 {"MR_SCAN_FAIL_NUMBER", MRES_SCAN_FAIL_NUMBER},
 {"MR_SCAN_FAIL_IRPT", MRES_SCAN_FAIL_IRPT},

// MT_PR_IRPT
 {"MB_PR_IRPT_STATUS", MBANK_PR_IRPT_STATUS},
// status
 {"MS_PR_IRPT_SET", MSTATUS_PR_IRPT_SET},
 {"MS_PR_IRPT_MAX", MSTATUS_PR_IRPT_MAX},
// MT_PR_ALLOCATE
// {"MB_PR_ALLOCATE_STATUS", MBANK_PR_ALLOCATE_STATUS}, - not currently used as ALLOCATE is a called method that ignores mbank
 {"MB_PR_STD_STATUS", MBANK_PR_STD_STATUS},
// MT_PR_STD statuses
// These are also used by MT_CLOB_QUERY
 {"MS_PR_STD_GET_X", MSTATUS_PR_STD_GET_X},
 {"MS_PR_STD_GET_Y", MSTATUS_PR_STD_GET_Y},
 {"MS_PR_STD_GET_ANGLE", MSTATUS_PR_STD_GET_ANGLE},
 {"MS_PR_STD_GET_SPEED_X", MSTATUS_PR_STD_GET_SPEED_X},
 {"MS_PR_STD_GET_SPEED_Y", MSTATUS_PR_STD_GET_SPEED_Y},
 {"MS_PR_STD_GET_TEAM", MSTATUS_PR_STD_GET_TEAM},
 {"MS_PR_STD_GET_HP", MSTATUS_PR_STD_GET_HP},
 {"MS_PR_STD_GET_HP_MAX", MSTATUS_PR_STD_GET_HP_MAX},
 {"MS_PR_STD_GET_INSTR", MSTATUS_PR_STD_GET_INSTR},
 {"MS_PR_STD_GET_INSTR_MAX", MSTATUS_PR_STD_GET_INSTR_MAX},
 {"MS_PR_STD_GET_IRPT", MSTATUS_PR_STD_GET_IRPT},
 {"MS_PR_STD_GET_IRPT_MAX", MSTATUS_PR_STD_GET_IRPT_MAX},
 {"MS_PR_STD_GET_OWN_IRPT_MAX", MSTATUS_PR_STD_GET_OWN_IRPT_MAX},
 {"MS_PR_STD_GET_DATA", MSTATUS_PR_STD_GET_DATA},
 {"MS_PR_STD_GET_DATA_MAX", MSTATUS_PR_STD_GET_DATA_MAX},
 {"MS_PR_STD_GET_OWN_DATA_MAX", MSTATUS_PR_STD_GET_OWN_DATA_MAX},
 {"MS_PR_STD_GET_SPIN", MSTATUS_PR_STD_GET_SPIN},
 {"MS_PR_STD_GET_GR_X", MSTATUS_PR_STD_GET_GR_X},
 {"MS_PR_STD_GET_GR_Y", MSTATUS_PR_STD_GET_GR_Y},
// {"MS_PR_STD_GET_GR_ANGLE", MSTATUS_PR_STD_GET_GR_ANGLE},
 {"MS_PR_STD_GET_GR_SPEED_X", MSTATUS_PR_STD_GET_GR_SPEED_X},
 {"MS_PR_STD_GET_GR_SPEED_Y", MSTATUS_PR_STD_GET_GR_SPEED_Y},
 {"MS_PR_STD_GET_GR_MEMBERS", MSTATUS_PR_STD_GET_GR_MEMBERS},
 {"MS_PR_STD_GET_EX_COUNT", MSTATUS_PR_STD_GET_EX_COUNT},
 {"MS_PR_STD_GET_WORLD_W", MSTATUS_PR_STD_GET_WORLD_W},
 {"MS_PR_STD_GET_WORLD_H", MSTATUS_PR_STD_GET_WORLD_H},
 {"MS_PR_STD_GET_TIME", MSTATUS_PR_STD_GET_TIME},
 {"MS_PR_STD_GET_VERTICES", MSTATUS_PR_STD_GET_VERTICES},
 {"MS_PR_STD_GET_VX_ANGLE", MSTATUS_PR_STD_GET_VERTEX_ANGLE},
 {"MS_PR_STD_GET_VX_DIST", MSTATUS_PR_STD_GET_VERTEX_DIST},
 {"MS_PR_STD_GET_VX_ANGLE_PREV", MSTATUS_PR_STD_GET_VERTEX_ANGLE_PREV},
 {"MS_PR_STD_GET_VX_ANGLE_NEXT", MSTATUS_PR_STD_GET_VERTEX_ANGLE_NEXT},
 {"MS_PR_STD_GET_VX_ANGLE_MIN", MSTATUS_PR_STD_GET_VERTEX_ANGLE_MIN},
 {"MS_PR_STD_GET_VX_ANGLE_MAX", MSTATUS_PR_STD_GET_VERTEX_ANGLE_MAX},
 {"MS_PR_STD_ACTION", MSTATUS_PR_STD_ACTION},
 {"MS_PR_STD_WAIT", MSTATUS_PR_STD_WAIT},
 {"MS_PR_STD_COLOUR", MSTATUS_PR_STD_COLOUR},
 {"MS_PR_STD_SET_COMMAND", MSTATUS_PR_STD_SET_COMMAND},
 {"MS_PR_STD_COMMAND_BIT_0", MSTATUS_PR_STD_COMMAND_BIT_0},
 {"MS_PR_STD_COMMAND_BIT_1", MSTATUS_PR_STD_COMMAND_BIT_1},
 {"MS_PR_STD_PRINT_OUT", MSTATUS_PR_STD_PRINT_OUT},
 {"MS_PR_STD_PRINT_OUT2", MSTATUS_PR_STD_PRINT_OUT2},
 {"MS_PR_STD_PRINT_ERR", MSTATUS_PR_STD_PRINT_ERR},
 {"MS_PR_STD_TEMPLATE_NAME", MSTATUS_PR_STD_TEMPLATE_NAME},

// MT_PR_COMMAND
 {"MB_PR_COMMAND_STATUS", MBANK_PR_COMMAND_STATUS},
 {"MB_PR_COMMAND_INDEX", MBANK_PR_COMMAND_INDEX},
 {"MB_PR_COMMAND_BIT", MBANK_PR_COMMAND_BIT},
// statuses
 {"MS_PR_COMMAND_READ", MSTATUS_PR_COMMAND_VALUE},
 {"MS_PR_COMMAND_BIT", MSTATUS_PR_COMMAND_BIT},
// {"MS_PR_COMMAND_WRITE", MSTATUS_PR_COMMAND_WRITE},
// MT_CL_COMMAND
 {"MB_CL_COMMAND_STATUS", MBANK_CL_COMMAND_STATUS},
 {"MB_CL_COMMAND_PR_INDEX", MBANK_CL_COMMAND_PROC_INDEX},
 {"MB_CL_COMMAND_CMD_INDEX", MBANK_CL_COMMAND_CMD_INDEX},
 {"MB_CL_COMMAND_VALUE", MBANK_CL_COMMAND_VALUE},
// statuses
 {"MS_CL_COMMAND_VALUE", MSTATUS_CL_COMMAND_SET_VALUE},
 {"MS_CL_COMMAND_BIT_0", MSTATUS_CL_COMMAND_BIT_0},
 {"MS_CL_COMMAND_BIT_1", MSTATUS_CL_COMMAND_BIT_1},
// MT_CLOB_COMMAND
 {"MS_CLOB_COMMAND_VALUE", MSTATUS_CLOB_COMMAND_VALUE},
 {"MS_CLOB_COMMAND_BIT", MSTATUS_CLOB_COMMAND_BIT},
// MT_CL_TEMPLATE
 {"MB_CL_TEMPLATE_INDEX", MBANK_CL_TEMPLATE_INDEX},
 {"MB_CL_TEMPLATE_START", MBANK_CL_TEMPLATE_START},
 {"MB_CL_TEMPLATE_END", MBANK_CL_TEMPLATE_END},
 {"MB_CL_TEMPLATE_NAME", MBANK_CL_TEMPLATE_NAME},
// MT_PR_ACTION
// {"MB_PR_ACTION_VALUE", MBANK_PR_ACTION_VALUE},
// MT_PR_RESTORE mbank
 {"MB_PR_RESTORE_NUMBER", MBANK_PR_RESTORE_NUMBER},
// virtual
 {"MB_PR_VIRTUAL_STATUS", MBANK_PR_VIRTUAL_STATUS},
 {"MB_PR_VIRTUAL_VALUE", MBANK_PR_VIRTUAL_VALUE},
 {"MB_PR_VIRTUAL_CURRENT", MBANK_PR_VIRTUAL_CURRENT},
 {"MB_PR_VIRTUAL_MAX", MBANK_PR_VIRTUAL_MAX},
// status
 {"MS_PR_VIRTUAL_CHARGE", MSTATUS_PR_VIRTUAL_CHARGE},
 {"MS_PR_VIRTUAL_GET_STATE", MSTATUS_PR_VIRTUAL_GET_STATE},
 {"MS_PR_VIRTUAL_GET_MAX", MSTATUS_PR_VIRTUAL_GET_MAX},
 {"MS_PR_VIRTUAL_DISABLE", MSTATUS_PR_VIRTUAL_DISABLE},

// {"MB_PR_RESTORE_IRPT", MBANK_PR_RESTORE_IRPT},
// MT_CLOB_WORLD status
 {"MS_CLOB_STD_WORLD_SIZE_X", MSTATUS_CLOB_STD_WORLD_SIZE_X},
 {"MS_CLOB_STD_WORLD_SIZE_Y", MSTATUS_CLOB_STD_WORLD_SIZE_Y},
 {"MS_CLOB_STD_WORLD_PROCS", MSTATUS_CLOB_STD_WORLD_PROCS},
 {"MS_CLOB_STD_WORLD_TEAM", MSTATUS_CLOB_STD_WORLD_TEAM},
 {"MS_CLOB_STD_WORLD_TEAMS", MSTATUS_CLOB_STD_WORLD_TEAMS},
 {"MS_CLOB_STD_WORLD_TEAM_SIZE", MSTATUS_CLOB_STD_WORLD_TEAM_SIZE},
 {"MS_CLOB_STD_WORLD_PROCS_EACH", MSTATUS_CLOB_STD_WORLD_MAX_PROCS_EACH},
 {"MS_CLOB_STD_WORLD_FIRST_PROC", MSTATUS_CLOB_STD_WORLD_FIRST_PROC},
 {"MS_CLOB_STD_WORLD_LAST_PROC", MSTATUS_CLOB_STD_WORLD_LAST_PROC},
// {"MS_CLOB_WORLD_GEN_LIMIT", MSTATUS_CLOB_WORLD_GEN_LIMIT},
// {"MS_CLOB_WORLD_GEN_NUMBER", MSTATUS_CLOB_WORLD_GEN_NUMBER},
 {"MS_CLOB_STD_WORLD_INSTR_LEFT", MSTATUS_CLOB_STD_WORLD_INSTR_LEFT},
 {"MS_CLOB_STD_WORLD_TIME", MSTATUS_CLOB_STD_WORLD_TIME},
 {"MS_CLOB_STD_TEMPLATE_NAME", MSTATUS_CLOB_STD_TEMPLATE_NAME},


// MT_SY_TEMPLATE mbank
 {"MB_SY_TEMPLATE_TYPE", MBANK_SY_TEMPLATE_TYPE},
// {"MB_SY_TEMPLATE_INDEX", MBANK_SY_TEMPLATE_INDEX}, no longer used
 {"MB_SY_TEMPLATE_START", MBANK_SY_TEMPLATE_START},
 {"MB_SY_TEMPLATE_END", MBANK_SY_TEMPLATE_END},
 {"MB_SY_TEMPLATE_NAME", MBANK_SY_TEMPLATE_NAME},

// Template types for SY_TEMPLATE method:
 {"TEMPLATE_OBSERVER", FIND_TEMPLATE_OBSERVER},
 {"TEMPLATE_P0_CLIENT", FIND_TEMPLATE_P0_CLIENT},
 {"TEMPLATE_P1_CLIENT", FIND_TEMPLATE_P1_CLIENT},
 {"TEMPLATE_P2_CLIENT", FIND_TEMPLATE_P2_CLIENT},
 {"TEMPLATE_P3_CLIENT", FIND_TEMPLATE_P3_CLIENT},
 {"TEMPLATE_P0_PROCESS_0", FIND_TEMPLATE_P0_PROC_0},
 {"TEMPLATE_P0_PROCESS_1", FIND_TEMPLATE_P0_PROC_1},
 {"TEMPLATE_P0_PROCESS_2", FIND_TEMPLATE_P0_PROC_2},
 {"TEMPLATE_P0_PROCESS_3", FIND_TEMPLATE_P0_PROC_3},
 {"TEMPLATE_P1_PROCESS_0", FIND_TEMPLATE_P1_PROC_0},
 {"TEMPLATE_P1_PROCESS_1", FIND_TEMPLATE_P1_PROC_1},
 {"TEMPLATE_P1_PROCESS_2", FIND_TEMPLATE_P1_PROC_2},
 {"TEMPLATE_P1_PROCESS_3", FIND_TEMPLATE_P1_PROC_3},
 {"TEMPLATE_P2_PROCESS_0", FIND_TEMPLATE_P2_PROC_0},
 {"TEMPLATE_P2_PROCESS_1", FIND_TEMPLATE_P2_PROC_1},
 {"TEMPLATE_P2_PROCESS_2", FIND_TEMPLATE_P2_PROC_2},
 {"TEMPLATE_P2_PROCESS_3", FIND_TEMPLATE_P2_PROC_3},
 {"TEMPLATE_P3_PROCESS_0", FIND_TEMPLATE_P3_PROC_0},
 {"TEMPLATE_P3_PROCESS_1", FIND_TEMPLATE_P3_PROC_1},
 {"TEMPLATE_P3_PROCESS_2", FIND_TEMPLATE_P3_PROC_2},
 {"TEMPLATE_P3_PROCESS_3", FIND_TEMPLATE_P3_PROC_3},
// MT_PR_TIME mbank
// {"MB_PR_TIME_STATUS", MBANK_PR_TIME_STATUS},
// MT_PR_TIME status
// {"MS_PR_TIME_GET", MSTATUS_PR_TIME_GET},
// {"MS_PR_TIME_WAIT", MSTATUS_PR_TIME_WAIT},
// output methods (PR and CL)
// {"MB_PR_OUTPUT_STATUS", MBANK_PR_OUTPUT_STATUS},
// {"MS_PR_OUTPUT_COLOUR", MSTATUS_PR_OUTPUT_COLOUR},
// {"MB_CL_OUTPUT_STATUS", MBANK_CL_OUTPUT_STATUS},
// {"MS_CL_OUTPUT_COLOUR", MSTATUS_CL_OUTPUT_COLOUR},
// colours for use in printing (using -1 causes no change):
 {"COL_DGREY", PRINT_COL_DGREY},
 {"COL_LGREY", PRINT_COL_LGREY},
 {"COL_WHITE", PRINT_COL_WHITE},
 {"COL_LBLUE", PRINT_COL_LBLUE},
 {"COL_DBLUE", PRINT_COL_DBLUE},
 {"COL_LRED", PRINT_COL_LRED},
 {"COL_DRED", PRINT_COL_DRED},
 {"COL_LGREEN", PRINT_COL_LGREEN},
 {"COL_DGREEN", PRINT_COL_DGREEN},
 {"COL_LPURPLE", PRINT_COL_LPURPLE},
 {"COL_DPURPLE", PRINT_COL_DPURPLE},
// colours for other things like consoles
 {"BCOL_GREY", COL_GREY},
 {"BCOL_RED", COL_RED},
 {"BCOL_GREEN", COL_GREEN},
 {"BCOL_BLUE", COL_BLUE},
 {"BCOL_YELLOW", COL_YELLOW},
 {"BCOL_ORANGE", COL_ORANGE},
 {"BCOL_PURPLE", COL_PURPLE},
 {"BCOL_TURQUOISE", COL_TURQUOISE},
 {"BCOL_AQUA", COL_AQUA},
 {"BCOL_CYAN", COL_CYAN},
// MT_PR_MATHS mbank
 {"MB_PR_MATHS_STATUS", MBANK_PR_MATHS_STATUS},
 {"MB_PR_MATHS_TERM1", MBANK_PR_MATHS_TERM1},
 {"MB_PR_MATHS_TERM2", MBANK_PR_MATHS_TERM2},
 {"MB_PR_MATHS_TERM3", MBANK_PR_MATHS_TERM3},
// statuses
 {"MS_PR_MATHS_NONE", MSTATUS_PR_MATHS_NONE},
 {"MS_PR_MATHS_ATAN2", MSTATUS_PR_MATHS_ATAN2},
 {"MS_PR_MATHS_SIN", MSTATUS_PR_MATHS_SIN},
 {"MS_PR_MATHS_COS", MSTATUS_PR_MATHS_COS},
 {"MS_PR_MATHS_HYPOT", MSTATUS_PR_MATHS_HYPOT},
 {"MS_PR_MATHS_TURN_DIR", MSTATUS_PR_MATHS_TURN_DIR},
 {"MS_PR_MATHS_ANGLE_DIFF", MSTATUS_PR_MATHS_ANGLE_DIFF},
 {"MS_PR_MATHS_ANGLE_DIFF_S", MSTATUS_PR_MATHS_ANGLE_DIFF_S},
 {"MS_PR_MATHS_ABS", MSTATUS_PR_MATHS_ABS},
 {"MS_PR_MATHS_SQRT", MSTATUS_PR_MATHS_SQRT},
 {"MS_PR_MATHS_POW", MSTATUS_PR_MATHS_POW},
// {"MS_PR_MATHS_RANDOM", MSTATUS_PR_MATHS_RANDOM},
// CLOB maths
 {"MB_CLOB_MATHS_STATUS", MBANK_PR_MATHS_STATUS},
 {"MB_CLOB_MATHS_TERM1", MBANK_PR_MATHS_TERM1},
 {"MB_CLOB_MATHS_TERM2", MBANK_PR_MATHS_TERM2},
 {"MB_CLOB_MATHS_TERM3", MBANK_PR_MATHS_TERM3},
// statuses
 {"MS_CLOB_MATHS_NONE", MSTATUS_PR_MATHS_NONE},
 {"MS_CLOB_MATHS_ATAN2", MSTATUS_PR_MATHS_ATAN2},
 {"MS_CLOB_MATHS_SIN", MSTATUS_PR_MATHS_SIN},
 {"MS_CLOB_MATHS_COS", MSTATUS_PR_MATHS_COS},
 {"MS_CLOB_MATHS_HYPOT", MSTATUS_PR_MATHS_HYPOT},
 {"MS_CLOB_MATHS_TURN_DIR", MSTATUS_PR_MATHS_TURN_DIR},
 {"MS_CLOB_MATHS_ANGLE_DIFF", MSTATUS_PR_MATHS_ANGLE_DIFF},
 {"MS_CLOB_MATHS_ABS", MSTATUS_PR_MATHS_ABS},
 {"MS_CLOB_MATHS_SQRT", MSTATUS_PR_MATHS_SQRT},
 {"MS_CLOB_MATHS_POW", MSTATUS_PR_MATHS_POW},
// {"MS_CLOB_MATHS_RANDOM", MSTATUS_PR_MATHS_RANDOM},
// MT_PR_DESIGNATE
 {"MB_PR_DESIGNATE_STATUS", MBANK_PR_DESIGNATE_STATUS},
 {"MB_PR_DESIGNATE_X", MBANK_PR_DESIGNATE_X},
 {"MB_PR_DESIGNATE_Y", MBANK_PR_DESIGNATE_Y},
// statuses
 {"MS_PR_DESIGNATE_LOCATE", MSTATUS_PR_DESIGNATE_LOCATE},
 {"MS_PR_DESIGNATE_ACQUIRE", MSTATUS_PR_DESIGNATE_ACQUIRE},
 {"MS_PR_DESIGNATE_SPEED", MSTATUS_PR_DESIGNATE_SPEED},
// MT_PR_YIELD
 {"MB_PR_YIELD_IRPT", MBANK_PR_YIELD_IRPT},
 {"MB_PR_YIELD_DATA", MBANK_PR_YIELD_DATA},
 {"MB_PR_YIELD_X", MBANK_PR_YIELD_X},
 {"MB_PR_YIELD_Y", MBANK_PR_YIELD_Y},
// results
 {"MR_YIELD_SUCCESS", MRES_YIELD_SUCCESS},
 {"MR_YIELD_FAIL_ALREADY", MRES_YIELD_FAIL_ALREADY},
 {"MR_YIELD_FAIL_SETTINGS", MRES_YIELD_FAIL_SETTINGS},
 {"MR_YIELD_FAIL_IRPT", MRES_YIELD_FAIL_IRPT},
 {"MR_YIELD_FAIL_DATA", MRES_YIELD_FAIL_DATA},
 {"MR_YIELD_FAIL_TARGET", MRES_YIELD_FAIL_TARGET},
 {"MR_YIELD_FAIL_FULL", MRES_YIELD_FAIL_FULL},
 {"MR_YIELD_FAIL_RANGE", MRES_YIELD_FAIL_RANGE},
// MT_PR_BROADCAST
 {"MB_PR_BROADCAST_POWER", MBANK_PR_BROADCAST_POWER},
 {"MB_PR_BROADCAST_ID", MBANK_PR_BROADCAST_ID},
 {"MB_PR_BROADCAST_VALUE1", MBANK_PR_BROADCAST_VALUE1},
 {"MB_PR_BROADCAST_VALUE2", MBANK_PR_BROADCAST_VALUE2},
// MT_PR_LISTEN
 {"MB_PR_LISTEN_ID_WANT", MBANK_PR_LISTEN_ID_WANT},
 {"MB_PR_LISTEN_ID_NEED", MBANK_PR_LISTEN_ID_NEED},
 {"MB_PR_LISTEN_ID_REJECT", MBANK_PR_LISTEN_ID_REJECT},
 {"MB_PR_LISTEN_ADDRESS", MBANK_PR_LISTEN_ADDRESS},
// Number of messages that will be received:
 {"LISTEN_MESSAGES", LISTEN_MESSAGES_MAX},
// Contents of a message in listener's bcode:
 {"LISTEN_RECORD_ID", LISTEN_RECORD_ID},
 {"LISTEN_RECORD_VALUE1", LISTEN_RECORD_VALUE1},
 {"LISTEN_RECORD_VALUE2", LISTEN_RECORD_VALUE2},
 {"LISTEN_RECORD_SOURCE_X", LISTEN_RECORD_OFFSET_X},
 {"LISTEN_RECORD_SOURCE_Y", LISTEN_RECORD_OFFSET_Y},
// Size of a message in listener's bcode:
 {"LISTEN_MESSAGE_SIZE", LISTEN_MESSAGE_SIZE},
// MT_OB_INPUT
// {"MB_OB_INPUT_MODE", MBANK_OB_INPUT_MODE}, don't bother with status numtoken for methods like this
// statuses
 {"MS_OB_INPUT_MOUSE_BUTTON", MSTATUS_OB_INPUT_MODE_MOUSE_BUTTON},
 {"MS_OB_INPUT_MOUSE_XY", MSTATUS_OB_INPUT_MODE_MOUSE_XY},
 {"MS_OB_INPUT_MOUSE_SCREEN_XY", MSTATUS_OB_INPUT_MODE_MOUSE_SCREEN_XY},
 {"MS_OB_INPUT_MOUSE_MAP_XY", MSTATUS_OB_INPUT_MODE_MOUSE_MAP_XY},
 {"MS_OB_INPUT_KEY", MSTATUS_OB_INPUT_KEY},
 {"MS_OB_INPUT_ANY_KEY", MSTATUS_OB_INPUT_ANY_KEY},

// MT_OB_CONSOLE
 {"MS_OB_CONSOLE_OPEN", MSTATUS_OB_CONSOLE_OPEN},
 {"MS_OB_CONSOLE_CLOSE", MSTATUS_OB_CONSOLE_CLOSE},
 {"MS_OB_CONSOLE_MIN", MSTATUS_OB_CONSOLE_MIN},
 {"MS_OB_CONSOLE_STATE", MSTATUS_OB_CONSOLE_STATE},
 {"MS_OB_CONSOLE_GET_XY", MSTATUS_OB_CONSOLE_GET_XY},
 {"MS_OB_CONSOLE_MOVE", MSTATUS_OB_CONSOLE_MOVE},
 {"MS_OB_CONSOLE_SIZE", MSTATUS_OB_CONSOLE_SIZE},
 {"MS_OB_CONSOLE_LINES", MSTATUS_OB_CONSOLE_LINES},
 {"MS_OB_CONSOLE_ACTION_SET", MSTATUS_OB_CONSOLE_ACTION_SET},
 {"MS_OB_CONSOLE_ACTION_CHECK", MSTATUS_OB_CONSOLE_ACTION_CHECK},
 {"MS_OB_CONSOLE_CLEAR", MSTATUS_OB_CONSOLE_CLEAR},
 {"MS_OB_CONSOLE_STYLE", MSTATUS_OB_CONSOLE_STYLE},
 {"MS_OB_CONSOLE_OUT", MSTATUS_OB_CONSOLE_OUT},
 {"MS_OB_CONSOLE_ERR", MSTATUS_OB_CONSOLE_ERR},
 {"MS_OB_CONSOLE_COLOUR", MSTATUS_OB_CONSOLE_COLOUR},
 {"MS_OB_CONSOLE_FONT", MSTATUS_OB_CONSOLE_FONT},
 {"MS_OB_CONSOLE_BACKGROUND", MSTATUS_OB_CONSOLE_BACKGROUND},
 {"MS_OB_CONSOLE_TITLE", MSTATUS_OB_CONSOLE_TITLE},
 {"MS_OB_CONSOLE_LINES_USED", MSTATUS_OB_CONSOLE_LINES_USED},

 {"MS_OB_CONSOLE_OUT_SYSTEM", MSTATUS_OB_CONSOLE_OUT_SYSTEM},
 {"MS_OB_CONSOLE_OUT_OBSERVER", MSTATUS_OB_CONSOLE_OUT_OBSERVER},
 {"MS_OB_CONSOLE_OUT_PLAYER", MSTATUS_OB_CONSOLE_OUT_PLAYER},
// {"MS_OB_CONSOLE_OUT2_SYSTEM", MSTATUS_OB_CONSOLE_OUT2_SYSTEM},
// {"MS_OB_CONSOLE_OUT2_OBSERVER", MSTATUS_OB_CONSOLE_OUT2_OBSERVER},
 {"MS_OB_CONSOLE_OUT2_PLAYER", MSTATUS_OB_CONSOLE_OUT2_PLAYER},
 {"MS_OB_CONSOLE_ERR_SYSTEM", MSTATUS_OB_CONSOLE_ERR_SYSTEM},
 {"MS_OB_CONSOLE_ERR_OBSERVER", MSTATUS_OB_CONSOLE_ERR_OBSERVER},
 {"MS_OB_CONSOLE_ERR_PLAYER", MSTATUS_OB_CONSOLE_ERR_PLAYER},

// Console action types:

 {"CONSOLE_ACTION_NONE", CONSOLE_ACTION_NONE},
 {"CONSOLE_ACTION_SYSTEM", CONSOLE_ACTION_SYSTEM},
 {"CONSOLE_ACTION_OBSERVER", CONSOLE_ACTION_OBSERVER},
 {"CONSOLE_ACTION_OPERATOR", CONSOLE_ACTION_OPERATOR},
 {"CONSOLE_ACTION_PROCESS", CONSOLE_ACTION_PROC},
// Console styles:
 {"CONSOLE_STYLE_BASIC", CONSOLE_STYLE_BASIC},
 {"CONSOLE_STYLE_BASIC_UP", CONSOLE_STYLE_BASIC_UP},
 {"CONSOLE_STYLE_CLEAR_CENTRED", CONSOLE_STYLE_CLEAR_CENTRED},
 {"CONSOLE_STYLE_BOX", CONSOLE_STYLE_BOX},
 {"CONSOLE_STYLE_BOX_UP", CONSOLE_STYLE_BOX_UP},
 {"CONSOLE_STYLES", CONSOLE_STYLES},
// Fonts:
 {"FONT_CODE", FONT_BASIC},
 {"FONT_CODE_BOLD", FONT_BASIC_BOLD},
 {"FONT_BASIC", FONT_SQUARE},
 {"FONT_BASIC_BOLD", FONT_SQUARE_BOLD},
 {"FONT_BASIC_LARGE", FONT_SQUARE_LARGE},
// score box statuses go here (not currently implemented)
// MT_OB_VIEW
 {"MS_OB_VIEW_FOCUS_XY", MSTATUS_OB_VIEW_FOCUS_XY},
 {"MS_OB_VIEW_FOCUS_PROC", MSTATUS_OB_VIEW_FOCUS_PROC},
 {"MS_OB_VIEW_PROC_DATA", MSTATUS_OB_VIEW_PROC_DATA},
 {"MS_OB_VIEW_PROC_DATA_XY", MSTATUS_OB_VIEW_PROC_DATA_XY},
 {"MS_OB_VIEW_SCROLL_XY", MSTATUS_OB_VIEW_SCROLL_XY},
 {"MS_OB_VIEW_MAP_VISIBLE", MSTATUS_OB_VIEW_MAP_VISIBLE},
 {"MS_OB_VIEW_MAP_XY", MSTATUS_OB_VIEW_MAP_XY},
 {"MS_OB_VIEW_MAP_SIZE", MSTATUS_OB_VIEW_MAP_SIZE},
 {"MS_OB_VIEW_DISPLAY_SIZE", MSTATUS_OB_VIEW_GET_DISPLAY_SIZE},
 {"MS_OB_VIEW_COLOUR_PROC", MSTATUS_OB_VIEW_COLOUR_PROC},
 {"MS_OB_VIEW_COLOUR_PACKET", MSTATUS_OB_VIEW_COLOUR_PACKET},
 {"MS_OB_VIEW_COLOUR_DRIVE", MSTATUS_OB_VIEW_COLOUR_DRIVE},
 {"MS_OB_VIEW_COLOUR_BACK", MSTATUS_OB_VIEW_COLOUR_BACK},
 {"MS_OB_VIEW_COLOUR_BACK2", MSTATUS_OB_VIEW_COLOUR_BACK2},
 {"MS_OB_VIEW_SOUND", MSTATUS_OB_VIEW_SOUND},
// MT_OB_CONTROL
 {"MS_OB_CONTROL_PAUSED", MSTATUS_OB_CONTROL_PAUSED},
 {"MS_OB_CONTROL_PAUSE_SET", MSTATUS_OB_CONTROL_PAUSE_SET},
 {"MS_OB_CONTROL_FF", MSTATUS_OB_CONTROL_FF},
 {"MS_OB_CONTROL_FF_SET", MSTATUS_OB_CONTROL_FF_SET},
 {"MS_OB_CONTROL_PHASE", MSTATUS_OB_CONTROL_PHASE},
 {"MS_OB_CONTROL_SYSTEM_SET", MSTATUS_OB_CONTROL_SYSTEM_SET},
 {"MS_OB_CONTROL_SYSTEM_READ", MSTATUS_OB_CONTROL_SYSTEM_READ},
 {"MS_OB_CONTROL_TURN", MSTATUS_OB_CONTROL_TURN},
 {"MS_OB_CONTROL_TURNS", MSTATUS_OB_CONTROL_TURNS},
 {"MS_OB_CONTROL_SECONDS_LEFT", MSTATUS_OB_CONTROL_SECONDS_LEFT},
 {"MS_OB_CONTROL_TICKS_LEFT", MSTATUS_OB_CONTROL_TICKS_LEFT},
 {"MS_OB_CONTROL_TURN_SECONDS", MSTATUS_OB_CONTROL_TURN_SECONDS},
// MT_SY_MANAGE
 {"MS_SY_MANAGE_PAUSED", MSTATUS_SY_MANAGE_PAUSED},
 {"MS_SY_MANAGE_PAUSE_SET", MSTATUS_SY_MANAGE_PAUSE_SET},
 {"MS_SY_MANAGE_FF", MSTATUS_SY_MANAGE_FF},
 {"MS_SY_MANAGE_FF_SET", MSTATUS_SY_MANAGE_FF_SET},
 {"MS_SY_MANAGE_PHASE", MSTATUS_SY_MANAGE_PHASE},
 {"MS_SY_MANAGE_OB_SET", MSTATUS_SY_MANAGE_OB_SET},
 {"MS_SY_MANAGE_OB_READ", MSTATUS_SY_MANAGE_OB_READ},
 {"MS_SY_MANAGE_TURN", MSTATUS_SY_MANAGE_TURN},
 {"MS_SY_MANAGE_TURNS", MSTATUS_SY_MANAGE_TURNS},
 {"MS_SY_MANAGE_SECONDS_LEFT", MSTATUS_SY_MANAGE_SECONDS_LEFT},
 {"MS_SY_MANAGE_TICKS_LEFT", MSTATUS_SY_MANAGE_TICKS_LEFT},
 {"MS_SY_MANAGE_TURN_SECONDS", MSTATUS_SY_MANAGE_TURN_SECONDS},
 {"MS_SY_MANAGE_GAMEOVER", MSTATUS_SY_MANAGE_GAMEOVER},
 {"MS_SY_MANAGE_END_PREGAME", MSTATUS_SY_MANAGE_END_PREGAME},
 {"MS_SY_MANAGE_END_TURN", MSTATUS_SY_MANAGE_END_TURN},
 {"MS_SY_MANAGE_START_TURN", MSTATUS_SY_MANAGE_START_TURN},
 {"MS_SY_MANAGE_LOAD_OBSERVER", MSTATUS_SY_MANAGE_LOAD_OBSERVER},
 {"MS_SY_MANAGE_LOAD_CLIENT", MSTATUS_SY_MANAGE_LOAD_CLIENT},
 {"MS_SY_MANAGE_ALLOCATE_EFFECT", MSTATUS_SY_MANAGE_ALLOCATE_EFFECT},

// game phases (returned by call to MSTATUS_SY_MANAGE_PHASE:
 {"PHASE_WORLD", GAME_PHASE_WORLD},
 {"PHASE_PREGAME", GAME_PHASE_PREGAME},
 {"PHASE_TURN", GAME_PHASE_TURN},
 {"PHASE_OVER", GAME_PHASE_OVER},
// game end states (used in MS_SY_MANAGE_GAMEOVER)
 {"GAME_END_BASIC", GAME_END_BASIC},
 {"GAME_END_YOU_WON", GAME_END_YOU_WON},
 {"GAME_END_YOU_LOST", GAME_END_YOU_LOST},
 {"GAME_END_PLAYER_WON", GAME_END_PLAYER_WON},
 {"GAME_END_PLAYER_LOST", GAME_END_PLAYER_LOST},
 {"GAME_END_DRAW", GAME_END_DRAW},
 {"GAME_END_TIME", GAME_END_TIME},
 {"GAME_END_ERROR_STATUS", GAME_END_ERROR_STATUS},
 {"GAME_END_ERROR_PLAYER", GAME_END_ERROR_PLAYER},
 {"GAME_END_STATES", GAME_END_STATES},
// ALLOCATE_EFFECT types (Determines what happens when a player's process disrupts a block node)
	{"ALLOCATE_EFFECT_DISRUPT", ALLOCATE_EFFECT_DISRUPT},
	{"ALLOCATE_EFFECT_ALIGN", ALLOCATE_EFFECT_ALIGN},

// MT_SY_MODIFY mbank
 {"MB_SY_MODIFY_PROC_STATUS", MBANK_SY_MODIFY_PROC_STATUS},
 {"MB_SY_MODIFY_PROC_INDEX", MBANK_SY_MODIFY_PROC_INDEX},
 {"MB_SY_MODIFY_PROC_VALUE", MBANK_SY_MODIFY_PROC_VALUE},
 {"MB_SY_MODIFY_PROC_VALUE2", MBANK_SY_MODIFY_PROC_VALUE2},
// MT_SY_MODIFY statuses
 {"MS_SY_MODIFY_HP", MSTATUS_SY_MODIFY_PROC_HP},
 {"MS_SY_MODIFY_IRPT", MSTATUS_SY_MODIFY_PROC_IRPT},
 {"MS_SY_MODIFY_DATA", MSTATUS_SY_MODIFY_PROC_DATA},
 {"MS_SY_MODIFY_MB", MSTATUS_SY_MODIFY_PROC_MB},
 {"MS_SY_MODIFY_BCODE", MSTATUS_SY_MODIFY_PROC_BCODE},
 {"MS_SY_MODIFY_INSTANT", MSTATUS_SY_MODIFY_PROC_INSTANT},
// MT_PR_LINK
 {"MB_PR_LINK_STATUS", MBANK_PR_LINK_STATUS},
 {"MB_PR_LINK_VALUE1", MBANK_PR_LINK_VALUE1},
 {"MB_PR_LINK_VALUE2", MBANK_PR_LINK_VALUE2},
 {"MB_PR_LINK_MESSAGE_ADDRESS", MBANK_PR_LINK_MESSAGE_ADDRESS},
// {"MB_PR_LINK_DATA", MBANK_PR_HOLD_DATA},
 {"LINK_MESSAGES", LINK_MESSAGES_MAX},
 {"LINK_MESSAGE_SIZE", LINK_MESSAGE_SIZE},
// {"MB_PR_LINK_SEND", MBANK_PR_LINK_SEND},
// MT_PR_LINK statuses
 {"MS_PR_LINK_EXISTS", MSTATUS_PR_LINK_EXISTS},
 {"MS_PR_LINK_MESSAGE", MSTATUS_PR_LINK_MESSAGE},
 {"MS_PR_LINK_RECEIVED", MSTATUS_PR_LINK_RECEIVED},
 {"MS_PR_LINK_GIVE_IRPT", MSTATUS_PR_LINK_GIVE_IRPT},
 {"MS_PR_LINK_GIVE_DATA", MSTATUS_PR_LINK_GIVE_DATA},
 {"MS_PR_LINK_TAKE_IRPT", MSTATUS_PR_LINK_TAKE_IRPT},
 {"MS_PR_LINK_TAKE_DATA", MSTATUS_PR_LINK_TAKE_DATA},
 {"MS_PR_LINK_NEXT_EXECUTION", MSTATUS_PR_LINK_NEXT_EXECUTION},
 {"MS_PR_LINK_DISCONNECT", MSTATUS_PR_LINK_DISCONNECT},
// MT_OB_SELECT statuses
 {"MS_OB_SELECT_SET_MARKER", MSTATUS_OB_SELECT_SET_MARKER},
 {"MS_OB_SELECT_PLACE_MARKER", MSTATUS_OB_SELECT_PLACE_MARKER},
 {"MS_OB_SELECT_PLACE_MARKER2", MSTATUS_OB_SELECT_PLACE_MARKER2},
 {"MS_OB_SELECT_BIND_MARKER", MSTATUS_OB_SELECT_BIND_MARKER},
 {"MS_OB_SELECT_BIND_MARKER2", MSTATUS_OB_SELECT_BIND_MARKER2},
 {"MS_OB_SELECT_UNBIND_PROCESS", MSTATUS_OB_SELECT_UNBIND_PROCESS},
 {"MS_OB_SELECT_CLEAR_ALL", MSTATUS_OB_SELECT_CLEAR_MARKERS},
 {"MS_OB_SELECT_EXPIRE_ALL", MSTATUS_OB_SELECT_EXPIRE_MARKERS},
 {"MS_OB_SELECT_CLEAR", MSTATUS_OB_SELECT_CLEAR_A_MARKER},
 {"MS_OB_SELECT_EXPIRE", MSTATUS_OB_SELECT_EXPIRE_A_MARKER},
 {"MS_OB_SELECT_MARKER_SPIN", MSTATUS_OB_SELECT_MARKER_SPIN},
 {"MS_OB_SELECT_MARKER_ANGLE", MSTATUS_OB_SELECT_MARKER_ANGLE},
 {"MS_OB_SELECT_MARKER_SIZE", MSTATUS_OB_SELECT_MARKER_SIZE},


// Marker types:
 {"MARKER_BASIC", MARKER_BASIC},
 {"MARKER_BASIC_6", MARKER_BASIC_6},
 {"MARKER_BASIC_8", MARKER_BASIC_8},
 {"MARKER_PROC_BOX", MARKER_PROC_BOX},
 {"MARKER_CORNERS", MARKER_CORNERS},
 {"MARKER_SHARP", MARKER_SHARP},
 {"MARKER_SHARP_5", MARKER_SHARP_5},
 {"MARKER_SHARP_7", MARKER_SHARP_7},

 {"MARKER_BOX", MARKER_BOX},
 {"MARKER_MAP_POINT", MARKER_MAP_POINT},
 {"MARKER_MAP_AROUND_1", MARKER_MAP_AROUND_1},
 {"MARKER_MAP_AROUND_2", MARKER_MAP_AROUND_2},
 {"MARKER_MAP_CROSS", MARKER_MAP_CROSS},
 {"MARKER_MAP_LINE", MARKER_MAP_LINE},
 {"MARKER_MAP_BOX", MARKER_MAP_BOX},

// MT_CLOB_POINT statuses
 {"MS_CLOB_POINT_EXACT", MSTATUS_CLOB_POINT_EXACT},
 {"MS_CLOB_POINT_FUZZY", MSTATUS_CLOB_POINT_FUZZY},
 {"MS_CLOB_POINT_ALLOC_EFFIC", MSTATUS_CLOB_POINT_ALLOC_EFFIC},
// Range of allocator interference
 {"ALLOCATE_INTERFERENCE_RANGE", ALLOCATE_INTERFERENCE_BOX_SIZE},

// program types
 {"PROGRAM_TYPE_PROCESS", PROGRAM_TYPE_PROCESS},
 {"PROGRAM_TYPE_DELEGATE", PROGRAM_TYPE_DELEGATE},
 {"PROGRAM_TYPE_OPERATOR", PROGRAM_TYPE_OPERATOR},
 {"PROGRAM_TYPE_OBSERVER", PROGRAM_TYPE_OBSERVER},
 {"PROGRAM_TYPE_SYSTEM", PROGRAM_TYPE_SYSTEM},
 {"PROGRAM_TYPES", PROGRAM_TYPES},

// misc
 {"PROCESS_TEMPLATES", TEMPLATES_PER_PLAYER},
 {"BCODE_SIZE_SYSTEM", SYSTEM_BCODE_SIZE},
 {"BCODE_SIZE_CLIENT", CLIENT_BCODE_SIZE},
 {"BCODE_SIZE_PROCESS", PROC_BCODE_SIZE},

// process shapes
 {"SHAPE_3TRIANGLE", SHAPE_3TRIANGLE},
 {"SHAPE_4SQUARE", SHAPE_4SQUARE},
 {"SHAPE_4DIAMOND", SHAPE_4DIAMOND},
 {"SHAPE_4POINTY", SHAPE_4POINTY},
 {"SHAPE_4TRAP", SHAPE_4TRAP},
 {"SHAPE_4IRREG_L", SHAPE_4IRREG_L},
 {"SHAPE_4IRREG_R", SHAPE_4IRREG_R},
 {"SHAPE_4ARROW", SHAPE_4ARROW},
 {"SHAPE_5PENTAGON", SHAPE_5PENTAGON},
 {"SHAPE_5POINTY", SHAPE_5POINTY},
 {"SHAPE_5LONG", SHAPE_5LONG},
 {"SHAPE_5WIDE", SHAPE_5WIDE},
 {"SHAPE_6HEXAGON", SHAPE_6HEXAGON},
 {"SHAPE_6POINTY", SHAPE_6POINTY},
 {"SHAPE_6LONG", SHAPE_6LONG},
 {"SHAPE_6IRREG_L", SHAPE_6IRREG_L},
 {"SHAPE_6IRREG_R", SHAPE_6IRREG_R},
 {"SHAPE_6ARROW", SHAPE_6ARROW},
 {"SHAPE_6STAR", SHAPE_6STAR},
 {"SHAPE_8OCTAGON", SHAPE_8OCTAGON},
 {"SHAPE_8POINTY", SHAPE_8POINTY},
 {"SHAPE_8LONG", SHAPE_8LONG},
 {"SHAPE_8STAR", SHAPE_8STAR},
// {"SHAPE_8BOX", SHAPE_8BOX},
// {"SHAPE_8LONG", SHAPE_8LONG},

// angle shortcuts
 {"ANGLE_1", ANGLE_1},
 {"ANGLE_2", ANGLE_2},
 {"ANGLE_4", ANGLE_4},
 {"ANGLE_8", ANGLE_8},
 {"ANGLE_16", ANGLE_16},
 {"ANGLE_32", ANGLE_32},
 {"ANGLE_MASK", ANGLE_MASK},

// data() modes
 {"DATA_SHAPE_VERTICES", CDATA_SHAPE_VERTICES}, // further parameters: shape
 {"DATA_SHAPE_VERTEX_ANGLE", CDATA_SHAPE_VERTEX_ANGLE}, // further parameters: shape, vertex
 {"DATA_SHAPE_VERTEX_DIST", CDATA_SHAPE_VERTEX_DIST}, // further parameters: shape, size, vertex
 {"DATA_SHAPE_VERTEX_ANGLE_PREV", CDATA_SHAPE_VERTEX_ANGLE_PREV}, // further parameters: shape, vertex
 {"DATA_SHAPE_VERTEX_ANGLE_NEXT", CDATA_SHAPE_VERTEX_ANGLE_NEXT}, // further parameters: shape, vertex
 {"DATA_SHAPE_VERTEX_ANGLE_MIN", CDATA_SHAPE_VERTEX_ANGLE_MIN}, // further parameters: shape, vertex
 {"DATA_SHAPE_VERTEX_ANGLE_MAX", CDATA_SHAPE_VERTEX_ANGLE_MAX}, // further parameters: shape, vertex

// interface details
 {"BCODE_JUMP", 0},
 {"BCODE_JUMP_ADDRESS", 1},
 {"BCODE_PROGRAM_TYPE", 2},
 {"BCODE_SHAPE", 3},
 {"BCODE_SIZE", 4},
 {"BCODE_BASE_VERTEX", 5},
 {"BCODE_METHOD_TYPE", 6},
 {"BCODE_METHOD_VERTEX", 7},
 {"BCODE_METHOD_ANGLE", 8},
 {"BCODE_METHOD_EXT_0", 9},
 {"BCODE_METHOD_EXT_1", 10},
 {"BCODE_METHOD_EXT_2", 11},

 {"BCODE_METHOD_SIZE", 6},

// key codes
 {"KEY_0", KEY_0},
 {"KEY_1", KEY_1},
 {"KEY_2", KEY_2},
 {"KEY_3", KEY_3},
 {"KEY_4", KEY_4},
 {"KEY_5", KEY_5},
 {"KEY_6", KEY_6},
 {"KEY_7", KEY_7},
 {"KEY_8", KEY_8},
 {"KEY_9", KEY_9},

 {"KEY_A", KEY_A},
 {"KEY_B", KEY_B},
 {"KEY_C", KEY_C},
 {"KEY_D", KEY_D},
 {"KEY_E", KEY_E},
 {"KEY_F", KEY_F},
 {"KEY_G", KEY_G},
 {"KEY_H", KEY_H},
 {"KEY_I", KEY_I},
 {"KEY_J", KEY_J},
 {"KEY_K", KEY_K},
 {"KEY_L", KEY_L},
 {"KEY_M", KEY_M},
 {"KEY_N", KEY_N},
 {"KEY_O", KEY_O},
 {"KEY_P", KEY_P},
 {"KEY_Q", KEY_Q},
 {"KEY_R", KEY_R},
 {"KEY_S", KEY_S},
 {"KEY_T", KEY_T},
 {"KEY_U", KEY_U},
 {"KEY_V", KEY_V},
 {"KEY_W", KEY_W},
 {"KEY_X", KEY_X},
 {"KEY_Y", KEY_Y},
 {"KEY_Z", KEY_Z},

 {"KEY_MINUS", KEY_MINUS},
 {"KEY_EQUALS", KEY_EQUALS},
 {"KEY_SBRACKET_OPEN", KEY_SBRACKET_OPEN},
 {"KEY_SBRACKET_CLOSE", KEY_SBRACKET_CLOSE},
 {"KEY_BACKSLASH", KEY_BACKSLASH},
 {"KEY_SEMICOLON", KEY_SEMICOLON},
 {"KEY_APOSTROPHE", KEY_APOSTROPHE},
 {"KEY_COMMA", KEY_COMMA},
 {"KEY_PERIOD", KEY_PERIOD},
 {"KEY_SLASH", KEY_SLASH},

 {"KEY_LSHIFT", KEY_LSHIFT},
 {"KEY_RSHIFT", KEY_RSHIFT},
 {"KEY_LCTRL", KEY_LCTRL},
 {"KEY_RCTRL", KEY_RCTRL},

 {"KEY_UP", KEY_UP},
 {"KEY_DOWN", KEY_DOWN},
 {"KEY_LEFT", KEY_LEFT},
 {"KEY_RIGHT", KEY_RIGHT},

 {"KEY_ENTER", KEY_ENTER},
 {"KEY_BACKSPACE", KEY_BACKSPACE},
 {"KEY_INSERT", KEY_INSERT},
 {"KEY_HOME", KEY_HOME},
 {"KEY_PGUP", KEY_PGUP},
 {"KEY_PGDN", KEY_PGDN},
 {"KEY_DELETE", KEY_DELETE},
 {"KEY_END", KEY_END},
 {"KEY_TAB", KEY_TAB},
// KEY_ESCAPE, should probably intercept this

 {"KEY_PAD_0", KEY_PAD_0},
 {"KEY_PAD_1", KEY_PAD_1},
 {"KEY_PAD_2", KEY_PAD_2},
 {"KEY_PAD_3", KEY_PAD_3},
 {"KEY_PAD_4", KEY_PAD_4},
 {"KEY_PAD_5", KEY_PAD_5},
 {"KEY_PAD_6", KEY_PAD_6},
 {"KEY_PAD_7", KEY_PAD_7},
 {"KEY_PAD_8", KEY_PAD_8},
 {"KEY_PAD_9", KEY_PAD_9},
 {"KEY_PAD_MINUS", KEY_PAD_MINUS},
 {"KEY_PAD_PLUS", KEY_PAD_PLUS},
 {"KEY_PAD_ENTER", KEY_PAD_ENTER},
 {"KEY_PAD_DELETE", KEY_PAD_DELETE},
 {"KEYS", KEYS},

// mouse status:
 {"MOUSE_STATUS_OUTSIDE", MOUSE_STATUS_OUTSIDE},
 {"MOUSE_STATUS_AVAILABLE", MOUSE_STATUS_AVAILABLE},
 {"MOUSE_STATUS_MAP", MOUSE_STATUS_MAP},
 {"MOUSE_STATUS_CONSOLE", MOUSE_STATUS_CONSOLE},
 {"MOUSE_STATUS_PROCESS", MOUSE_STATUS_PROCESS},

// button status (key or mouse)
 {"BUTTON_JUST_RELEASED", BUTTON_JUST_RELEASED},
 {"BUTTON_NOT_PRESSED", BUTTON_NOT_PRESSED},
 {"BUTTON_JUST_PRESSED", BUTTON_JUST_PRESSED},
 {"BUTTON_HELD", BUTTON_HELD},

 {"", 0}, // the final numtoken must be just an empty string

}; // end numtoken definition

//int write_to_scode(char write_char);
//int get_ptoken_type(char read_char);


int preprocess_source(struct sourcestruct* source);
int prepr_string(char* source_str, int str_length, int original_source_line);

int add_user_string_to_scode(char* source_str, int str_length, int original_source_line, int source_pos);
int add_ptoken_to_scode(char ptoken [PTOKEN_LENGTH]);
int add_number_to_scode(s16b number);
int append_space_to_scode(void);
int read_next_ptoken(char* source_str, char ptoken [PTOKEN_LENGTH], int* source_pos, int str_length);
int prepr_read_spaces(char* source_str, int source_pos, int str_length);
int prepr_valid_character(char read_char);
int prepr_skip_spaces(char* source_str, int* source_pos, int str_length);
void free_included_sourcestructs(void);
void clear_subdefines(int source_file);

int parse_prepr_directive(char* source_str, int str_length);
int prepr_expect_character(char* source_str, int* source_pos, int str_length, char expect_char);
int prepr_check_next(char* source_str, int source_pos, int str_length, char check_name [DIRECTIVE_LENGTH]);

int prstack_push(int prstack_status, int source_file);
int prstack_pop(void);
int skip_to_closing_endif(void);
int get_file_name_from_path(char* file_name, const char* file_path, int preprocessing);
int remove_file_name_from_path(char* file_path, int preprocessing);
int define_in_scope(int deftoken_index);

int letter_number(char read_char);
int letter(char read_char);

int prepr_error(int error_type);
int prepr_error_minus1(int error_type);
int prepr_error_no_source(int error_type, const char* file_name);
int prepr_error_no_source_minus1(int error_type, const char* file_name);

int prepare_include_sourcestruct(const char* included_file_path, int* source_file_index);
int load_source_file(const char* file_path, struct sourcestruct* target_source, int src_file_index, int preprocessing);
int load_binary_file(const char* file_path, struct bcodestruct* bcode, int src_file_index, int preprocessing);
void convert_bcode_to_asm_source_initialiser(struct bcodestruct* bcode, char text [SOURCE_TEXT_LINES] [SOURCE_TEXT_LINE_LENGTH]);
int allocate_bcode_ops(struct bcodestruct* bcode, int bcode_size);

int include_source_file(const char* included_file_path);
int include_binary_file(const char* included_file_path);

struct prstackstruct
{
 int type;
 int source_file; // if this is a PRSTACK_INCLUDE or PRSTACK_MAIN_FILE entry, this is the source file (index in source array) of the included file. Otherwise it is -1.
// int parent_source_file;
};

#define PRSTACK_SIZE 50

enum
{
PRSTACK_ERROR, // must be zero
PRSTACK_NONE,
PRSTACK_MAIN_FILE,
PRSTACK_IF,
PRSTACK_INCLUDE,

};

struct prstatestruct
{
 int scode_pos; // current position in scode
 int src_line; // source line of current position
 int src_pos; // position in that line
 int error;

 struct sourcestruct* source [SOURCE_FILES]; // source [0] is the original file; others are #included files
 struct scodestruct* scode; // target scode
// struct sourcestruct* include_source [INCLUDED_FILES];

 int prepr_string_recursion; // a counter to prevent infinite loops if a #define macro is recursive

 int long_comment; // in a /* */ comment

 struct prstackstruct prstack [PRSTACK_SIZE];

 int stack_pos; // position in the prstack
 int source_file; // index in source array
// int parent_source_file; // is this needed? Can probably be left to the prstack

};

struct prstatestruct prstate;

extern struct identifierstruct identifier [IDENTIFIER_MAX]; // externed from c_comp.c. preprocessor should be called only after the identifiers for keywords etc are filled in (to avoid clashes with #define macros)






enum
{
PTOKEN_READ_ERROR, // invalid character or word. must be zero
PTOKEN_READ_END, // end of source string reached
PTOKEN_READ_SYMBOL, // punctuation, operator etc.
PTOKEN_READ_NUMBER, // number consistent entirely of numerals
PTOKEN_READ_WORD // word beginning with letter or _ and consisting only of letters, numbers and _
};


// defined is a single predefined deftoken
int preprocess(struct sourcestruct* source, struct scodestruct *scode, const char* defined)
{
 prstate.src_line = 0;
 prstate.src_pos = 0;
 prstate.scode_pos = 0;
 prstate.scode = scode;
 prstate.prepr_string_recursion = 0;
 prstate.long_comment = 0;

 prstate.scode->text [prstate.scode_pos] = '\0';

 int i;

 for (i = 0; i < DEFTOKENS; i ++)
 {
  deftoken[i].exists = 0;
  deftoken[i].name [0] = 0;
  deftoken[i].sub_text [0] = 0;
  deftoken[i].file_scope = -1; // universal file scope (or irrelevant)
 }

 if (defined != NULL)
	{
// the defined string allows a single deftoken to be set when a file is preprocessed.
// Currently this is only used to distinguish missions from advanced missions (which have the ADVANCED deftoken set)
// Should be able to assume that defined is safe as it can only be set at game compile time.
		deftoken[0].exists = 1;
		strcpy(deftoken[0].name, defined);
// Can just used default sub_text and file_scope values
	}


 prstate.stack_pos = 0;
 prstate.prstack[0].type = PRSTACK_MAIN_FILE;
 prstate.prstack[0].source_file = 0; // main file is always source file index 0
 prstate.source_file = 0;

// prstate.parent_source_file = -1;

 for (i = 0; i < SOURCE_FILES; i ++)
 {
  prstate.source [i] = NULL; // should have been initialised to NULL anyway. NULL values are used in free_included_sourcestructs to indicate which sourcestructs don't need to be freed.
  scode->src_file_name [i] [0] = '\0';
 }

// now set up source [0], which is the main source code (possibly the only source code, if no #includes are used):
 prstate.source [0] = source;
 strcpy(scode->src_file_name [0], prstate.source [0]->src_file_name);

// Now run the preprocessor:
 int retval = preprocess_source(source);


// now copy the names of any included files to the scodestruct (so they can be displayed in error messages):
 for (i = 1; i < SOURCE_FILES; i ++) // note i = 1
 {
  if (prstate.source [i] != NULL)
   strcpy(scode->src_file_name [i], prstate.source [i]->src_file_name);
 }

// Memory leak warning! free_included_sourcestructs must be called before returning!
 free_included_sourcestructs();

 return retval;

}


/*

This is the main preprocessor loop. It goes through each line of source->text and preprocesses it.
It can be called recursively as a result of an #include directive.


Returns 1 on success, 0 (prepr_error()) on failure
*/
int preprocess_source(struct sourcestruct* source)
{


// changes in this function may need to be reflected in prepr_skip_to_endif();

// for (i = 0; i < SOURCE_TEXT_LINES; i ++)
 for (prstate.src_line = 0; prstate.src_line < SOURCE_TEXT_LINES; prstate.src_line ++)
 {
// first, ensure that the line is null-terminated
  source->text [prstate.src_line] [SOURCE_TEXT_LINE_LENGTH - 1] = '\0';
//  prstate.src_line = i;

// should probably search the source line for \n and \r as well and replace with 0

  if (!prstate.long_comment
   && source->text [prstate.src_line] [0] == '#')
  {
   if (!parse_prepr_directive(source->text [prstate.src_line], SOURCE_TEXT_LINE_LENGTH))
    return 0;
   continue; // parse_prepr_directive should have processed the whole line
  }

  if (!prepr_string(source->text [prstate.src_line], SOURCE_TEXT_LINE_LENGTH, 1)) // the 1 means that this is a source line (not within a macro), so prstate.src_pos should be updated
   return 0;

// now that we've finished reading a line, put a space at the end of the scode (unless one is there already)
  if (append_space_to_scode() == -1)
   return 0;

 }

 return 1;

}


/*
reads through source_str, adding to scode
checks for invalid characters (via get_next_ptoken)
is recursive if a macro is found (with limits of depth of recursion)
doesn't assume source_str is null-terminated, as long as str_length is set correctly

if original_source_line is 1, prstate.src_pos is updated as the string is read (because the string is a line of code from the source, rather than e.g. substituted macro text)

returns 1/0 on success/error
note that success may mean nothing was written
*/
int prepr_string(char* source_str, int str_length, int original_source_line)
{

 int source_pos = 0;
 char ptoken [PTOKEN_LENGTH];
 int ptoken_type;
 int characters_written;
 int i;
 int found_macro;

 while (source_str [source_pos] != 0
     && source_pos < str_length)
 {

  if (original_source_line)
   prstate.src_pos = source_pos;

// prepr_read_spaces skips any number of spaces, and writes a single space to scode if at least 1 space is found
  source_pos = prepr_read_spaces(source_str, source_pos, str_length);

  if (source_pos == -1) // reached end of source_str
   return 1;
  if (source_pos == -2) // error
   return 0;

  ptoken_type = read_next_ptoken(source_str, ptoken, &source_pos, str_length);

  if (original_source_line)
   prstate.src_pos = source_pos;

  if (prstate.long_comment) // inside /* */
  {
   if (ptoken_type == PTOKEN_READ_SYMBOL
    && ptoken [0] == '*'
    && source_pos < str_length - 1
    && source_str [source_pos] == '/')
   {
    prstate.long_comment = 0; // found */ end of comment
    source_pos ++;
   }
   continue;
  }

  switch(ptoken_type)
  {
   case PTOKEN_READ_ERROR:
    return 0;
   case PTOKEN_READ_END:
//    characters_written = append_space_to_scode();
//    if (characters_written == -1) // error in append_space_to_scode
//     return 0;
    return 1;
   case PTOKEN_READ_NUMBER:
    characters_written = add_ptoken_to_scode(ptoken);
    if (characters_written == -1) // error in add_ptoken_to_scode
     return 0;
    break;
   case PTOKEN_READ_WORD:
// check against defined things here
    found_macro = 0;
    for (i = 0; i < DEFTOKENS; i ++)
    {
     if (!deftoken[i].exists)
      continue;
     if (strcmp(deftoken[i].name, ptoken) != 0) // match!
      continue;
     if (!define_in_scope(i)) // if this is a subdefine and is out of scope, ignore it.
       continue; // not in scope
     prstate.prepr_string_recursion ++;
     if (prstate.prepr_string_recursion > 100)
      return prepr_error(PRERR_RECURSIVE_MACRO);
     if (!prepr_string(deftoken[i].sub_text, SUB_TEXT_LENGTH, 0))
      return 0;
     prstate.prepr_string_recursion --;
     found_macro = 1;
     break;
    }
    if (found_macro)
     break;
// now check against built-in numtokens
    for (i = 0; i < NUMTOKENS; i ++)
    {
     if (numtoken[i].name [0] == '\0') // reached the end
      break;
     if (strcmp(numtoken[i].name, ptoken) == 0) // match!
     {
      characters_written = add_number_to_scode(numtoken[i].value);
      if (characters_written == -1) // error in add_ptoken_to_scode
       return 0;
      found_macro = 1;
      break;
     }
    }
    if (found_macro)
     break;
// not a macro, so write it to scode:
    characters_written = add_ptoken_to_scode(ptoken);
    if (characters_written == -1) // error in add_ptoken_to_scode
     return 0;
    break;
   case PTOKEN_READ_SYMBOL:
// check for double slash comment:
    if (ptoken [0] == '/')
    {
     if (source_pos < str_length - 1)
     {
      if (source_str [source_pos] == '/')
       return 1; // found // comment, so finish this string
      if (source_str [source_pos] == '*')
      {
       prstate.long_comment = 1; // found /* comment
       break;
      }
     }
    }
// Check for text string:
    if (ptoken [0] == '"')
				{
// first add the '"'
     characters_written = add_ptoken_to_scode(ptoken);
     if (characters_written == -1) // error in add_ptoken_to_scode
      return 0;
// now add the string:
					int user_string_added = add_user_string_to_scode(source_str, str_length, original_source_line, source_pos);
					if (user_string_added == -1)
						return 0;
					source_pos = user_string_added;
					break;
				}
    characters_written = add_ptoken_to_scode(ptoken);
    if (characters_written == -1) // error in add_ptoken_to_scode
     return 0;
    break;

  } // end switch(ptoken_type)

// may not reach this point if inside /* */ comment

 };

 return 1;

}

// returns new value of source_pos
//  or -1 on failure
int add_user_string_to_scode(char* source_str, int str_length, int original_source_line, int source_pos)
{

	char ptoken [PTOKEN_LENGTH];

 while (TRUE)
 {

 	if (source_pos >= str_length
			|| source_str [source_pos] == '\0')
				return prepr_error_minus1(PRERR_INVALID_STRING);

 	ptoken [0] = source_str [source_pos];
 	ptoken [1] = '\0';

  if (original_source_line)
   prstate.src_pos = source_pos;

 	if (add_ptoken_to_scode(ptoken) == -1)
			return -1;

		source_pos++;

		if (ptoken [0] == '"')
			return source_pos;


 };

 return source_pos; // shouldn't reach here

}


/*
adds ptoken to prstate.scode
assumes ptoken is null-terminated; returns -1 if length exceeded
assumes ptoken has at least one non-null character
does bounds-checking for scode and returns -1 if end reached (which is an error)

returns number of characters written
or -1 on error
*/
int add_ptoken_to_scode(char ptoken [PTOKEN_LENGTH])
{

 int ptoken_pos = 0;

 while (ptoken [ptoken_pos] != 0)
 {
  if (prstate.scode_pos >= SCODE_LENGTH - 1)
   return prepr_error_minus1(PRERR_SCODE_LIMIT_REACHED);
  if (ptoken_pos >= PTOKEN_LENGTH)
   return prepr_error_minus1(PRERR_STRING_NOT_NULL_TERMINATED);
  prstate.scode->text [prstate.scode_pos] = ptoken [ptoken_pos];
  prstate.scode->src_line [prstate.scode_pos] = prstate.src_line;
  prstate.scode->src_line_pos [prstate.scode_pos] = prstate.src_pos;
  prstate.scode->src_file [prstate.scode_pos] = prstate.source_file;
  prstate.scode_pos ++;
  prstate.scode->text [prstate.scode_pos] = 0;
  ptoken_pos ++;
 };

 return ptoken_pos; // this is the number of characters written

}

int add_number_to_scode(s16b number)
{

// let's leave plenty of space for the number:
  if (prstate.scode_pos >= SCODE_LENGTH - 10)
   return prepr_error_minus1(PRERR_SCODE_LIMIT_REACHED);

 int chars_written = sprintf(&prstate.scode->text [prstate.scode_pos], "%i", number);

 int i;

 for (i = 0; i < chars_written; i ++)
 {
  prstate.scode->src_line [prstate.scode_pos + i] = prstate.src_line;
  prstate.scode->src_line_pos [prstate.scode_pos + i] = prstate.src_pos;
 }

 prstate.scode_pos += chars_written;

 return chars_written; // this is the number of characters written

}

// puts a space at the end of the scode if there is not one there already.
// if there's already a space, does nothing.
// returns 1 if space written, 0 if not, -1 on error
int append_space_to_scode(void)
{

 char ptoken [PTOKEN_LENGTH];
 strcpy(ptoken, " ");

 if (prstate.scode_pos == 0)
  return 0;

 if (prstate.scode->text [prstate.scode_pos - 1] == ' ')
  return 0;

 return add_ptoken_to_scode(ptoken);

}


/*
reads the next ptoken from source_str into ptoken
starts reading from source_pos
checks each character for validity/invalidity
updates source_pos
does bounds-checking against str_length

returns PTOKEN_READ_x value
returns zero (which is PTOKEN_READ_ERROR) on error

*/
int read_next_ptoken(char* source_str, char ptoken [PTOKEN_LENGTH], int* source_pos, int str_length)
{

 int i = 0;
 ptoken [0] = 0;
 char read_char;

 read_char = source_str [*source_pos];

 if (read_char == 0)
  return PTOKEN_READ_END;

// read in a word
 if (letter(read_char))
 {
  while(TRUE)
  {
   if ((*source_pos) >= str_length)
    return prepr_error(PRERR_STRING_NOT_NULL_TERMINATED);
   if (read_char == 0 || !letter_number(read_char)) // read_char==0 probably redundant here
   {
    ptoken [i] = 0;
    return PTOKEN_READ_WORD; // source_pos will be one space after the last character in the word.
   }
   ptoken [i] = read_char;
   (*source_pos) ++;
   i ++;
   if (i >= PTOKEN_LENGTH)
    return prepr_error(PRERR_TOKEN_TOO_LONG);
   read_char = source_str [*source_pos];
  };
 }

// read in a decimal number other than 0
 if (read_char >= '1' && read_char <= '9')
 {
  while(TRUE)
  {
   if ((*source_pos) >= str_length)
    return prepr_error(PRERR_STRING_NOT_NULL_TERMINATED);
   if (letter(read_char))
    return prepr_error(PRERR_NUMBER_CONTAINS_LETTER);
   if (read_char == 0 || read_char < '0' || read_char > '9')
   {
    ptoken [i] = 0;
    return PTOKEN_READ_NUMBER;
   }
   ptoken [i] = read_char;
   (*source_pos) ++;
   i ++;
   if (i >= PTOKEN_LENGTH)
    return prepr_error(PRERR_TOKEN_TOO_LONG);
   read_char = source_str [*source_pos];
  };
 }

// read in a number starting with zero
 if (read_char == '0')
 {
  ptoken [i] = read_char;
  (*source_pos) ++;
  i ++;
  read_char = source_str [*source_pos];
  if ((*source_pos) >= str_length)
   return prepr_error(PRERR_STRING_NOT_NULL_TERMINATED);
  if (read_char == 'x'
   || read_char == 'X')
  {
// now go past the x
   ptoken [i] = read_char;
   (*source_pos) ++;
   i ++;
   read_char = source_str [*source_pos];
   while(TRUE)
   {
    if ((*source_pos) >= str_length)
     return prepr_error(PRERR_STRING_NOT_NULL_TERMINATED);
// any letter other than a-f/A-F is invalid:
    if (letter(read_char)
     && !((read_char >= 'a' && read_char <= 'f')
      || (read_char >= 'A' && read_char <= 'Z')))
     return prepr_error(PRERR_HEX_NUMBER_CONTAINS_INVALID_LETTER);
    if (read_char == 0
     || ((read_char < '0' || read_char > '9')
      && (read_char < 'a' || read_char > 'f')
      && (read_char < 'A' || read_char > 'F')))
    {
     ptoken [i] = 0;
     return PTOKEN_READ_NUMBER;
    }
    ptoken [i] = read_char;
    (*source_pos) ++;
    i ++;
    if (i >= PTOKEN_LENGTH)
     return prepr_error(PRERR_TOKEN_TOO_LONG);
    read_char = source_str [*source_pos];
   };
  }
  if (read_char == 'b'
   || read_char == 'B')
  {
// now go past the b
   ptoken [i] = read_char;
   (*source_pos) ++;
   i ++;
   read_char = source_str [*source_pos];
   while(TRUE)
   {
    if ((*source_pos) >= str_length)
     return prepr_error(PRERR_STRING_NOT_NULL_TERMINATED);
// any letter is invalid:
    if (letter(read_char))
     return prepr_error(PRERR_BINARY_NUMBER_CONTAINS_LETTER);
    if (read_char == 0
     || (read_char != '0' && read_char != '1'))
    {
     ptoken [i] = 0;
     return PTOKEN_READ_NUMBER;
    }
    ptoken [i] = read_char;
    (*source_pos) ++;
    i ++;
    if (i >= PTOKEN_LENGTH)
     return prepr_error(PRERR_TOKEN_TOO_LONG);
    read_char = source_str [*source_pos];
   };
  }
  if (read_char == 0
   || ((read_char < '0' || read_char > '9')
    && !letter(read_char)))
  {
   ptoken [i] = 0;
   return PTOKEN_READ_NUMBER;
  }
  return prepr_error(PRERR_INVALID_NUMBER);
 }


// must be a symbol:

 if (!prepr_valid_character(read_char))
 {
  ptoken [0] = read_char;
  ptoken [1] = 0;

  start_log_line(MLOG_COL_ERROR);
  write_to_log("Character (");
  write_to_log(ptoken);
  write_to_log(") found.");
  finish_log_line();

  return prepr_error(PRERR_UNRECOGNISED_CHARACTER);
 }

 ptoken [0] = read_char;
 ptoken [1] = 0;
 (*source_pos) ++;
 return PTOKEN_READ_SYMBOL;

}

/*
reads through spaces, finding the next non-space character in source_str
starts from source_pos
returns:
-2 if error
-1 if end of source_str reached (this is not an error)
otherwise, returns new source_pos

see prepr_skip_spaces for a function that skips spaces without writing anything to scode
*/
int prepr_read_spaces(char* source_str, int source_pos, int str_length)
{

 int written_space = 0;

 while(source_str [source_pos] != 0
    && source_pos < str_length)
 {
  if (source_str [source_pos] == ' '
   || source_str [source_pos] == '\t') // tab
  {
   if (written_space == 0)
   {
// writes a single space to scode if at least one space is found.
    if (append_space_to_scode() == -1)
     return -2; // error
/*    char ptoken [PTOKEN_LENGTH];
    ptoken [0] = ' ';
    ptoken [1] = 0;
    if (!add_ptoken_to_scode(ptoken)) // probably means reached end of scode
     return -2; // error*/
    written_space = 1; // means that append_space_to_scode has either written a space, or found one already there
   }
  }
   else
    return source_pos;
  source_pos ++;
 };

 return -1; // reached end of source_str

}



int prepr_valid_character(char read_char)
{

 if (read_char >= '0' && read_char <= '9')
  return 1;

 if ((read_char >= 'A' && read_char <= 'Z')
  || (read_char >= 'a' && read_char <= 'z'))
   return 1;

 switch(read_char)
 {
  case '(':
  case ')':
  case '+':
  case '-':
  case '*':
  case '=':
  case '{':
  case '}':
  case '[':
  case ']':
  case '/':
  case '_':
  case ';':
  case ':':
  case ',':
  case '.':
  case '>':
  case '<':
  case '&':
  case '^':
  case '#': // if # appears at start of line, we expect a preprocessor directive
  case '|':
  case '!':
  case '%':
  case '?':
  case '"':
  case '$': // used for strings
  case '\'':
  case '\\':
  case '\n':
  case '\r':
   return 1;

 }

 return 0;

}

int letter_number(char read_char)
{

    if ((read_char >= '0' && read_char <= '9')
     || (read_char >= 'a' && read_char <= 'z')
     || (read_char >= 'A' && read_char <= 'Z')
     || read_char == '_')
      return 1;

    return 0;

}

int letter(char read_char)
{

    if ((read_char >= 'a' && read_char <= 'z')
     || (read_char >= 'A' && read_char <= 'Z')
     || read_char == '_')
      return 1;

    return 0;

}


// call this just after reading # at start of line
// returns 1 on success and 0 on failure
// doesn't update source_pos in any way, as nothing else should appear on the same line as a directive so we shouldn't be writing anything.
int parse_prepr_directive(char* source_str, int str_length)
{

 int retval;
 int i, j;
 char macro_name [PTOKEN_LENGTH];
 int found = 0;
 int source_pos = 1; // position on line. Starts at 1 because we've already read in the #
 int define_file_scope = -1; // used for #define. #subdefine changes it to current file.

 retval = prepr_check_next(source_str, source_pos, str_length, "define");

// if it's not "define", it might be subdefine:
 if (retval == -1)
 {
  retval = prepr_check_next(source_str, source_pos, str_length, "subdefine");

  if (retval != -1)
   define_file_scope = prstate.source_file;
// retval is left so that the following check will pick it up...
 }

 if (retval != -1) // #define or #subdefine
 {

  source_pos = retval;
// make sure it's followed by a space
  if (!prepr_expect_character(source_str, &source_pos, str_length, ' '))
   return prepr_error(PRERR_UNRECOGNISED_DIRECTIVE);

// now read the following word, which is to be the macro's name:
  retval = read_next_ptoken(source_str, macro_name, &source_pos, str_length);
  if (retval != PTOKEN_READ_WORD)
   return prepr_error(PRERR_INVALID_TOKEN);
// now check the word against the identifier list, which at this stage (i.e. before any compilation has happened) holds only built-in keywords and similar
  for (i = 0; i < USER_IDENTIFIERS; i ++)
  {
   if (strcmp(macro_name, identifier[i].name) == 0)
    return prepr_error(PRERR_NAME_ALREADY_USED_AS_IDENTIFIER);
  }
// now check against built-in numtokens
  for (i = 0; i < NUMTOKENS; i ++)
  {
   if (numtoken[i].name [0] == '\0') // reached the end
    break;
   if (strcmp(numtoken[i].name, macro_name) == 0) // match!
    return prepr_error(PRERR_CANNOT_REDEFINE_NUMTOKEN);
  }
// now check to avoid duplicating macro names
  for (i = 0; i < DEFTOKENS; i ++)
  {
   if (deftoken[i].exists // unlike numtokens (which have no gaps), must check this as non-existent deftokens may have been #undefined
    && strcmp(macro_name, deftoken[i].name) == 0
    && define_in_scope(i)) // no clash if this is a subdefine with different scope
   {
    return prepr_error(PRERR_NAME_ALREADY_USED);
   }
   if (!deftoken[i].exists)
    break; // use this value
  }
  if (i == DEFTOKENS)
   return prepr_error(PRERR_TOO_MANY_DEFINES);
// try to skip spaces. If nothing is found between the macro name and the end of the line, this is a macro just being defined so that #ifdef will find it
  if (!prepr_skip_spaces(source_str, &source_pos, str_length))
  {
   deftoken[i].exists = 1;
   strcpy(deftoken[i].name, macro_name);
   deftoken[i].sub_text [0] = 0; // should have already been initialised to zero but do this anyway
   deftoken[i].file_scope = define_file_scope;
   return 1;
  }
   else
   {
// now read the text into deftoken[i].sub_text until the end is reached
    j = 0;
    deftoken[i].exists = 1;
    deftoken[i].file_scope = define_file_scope;
    strcpy(deftoken[i].name, macro_name);
    while(TRUE)
    {
     if (source_pos + j >= str_length
      || j >= SUB_TEXT_LENGTH - 1)
       return prepr_error(PRERR_SYNTAX_ERROR_DIRECTIVE);
     if (source_str [source_pos + j] == 0
      || source_str [source_pos + j] == '\n')
      {
       return 1;
      }
     deftoken[i].sub_text [j] = source_str [source_pos + j];
     deftoken[i].sub_text [j+1] = 0;
     j ++;
    };

   }

  return prepr_error(PRERR_UNKNOWN_DEFINE_ERROR); // should never be reached
 } // end #define/#subdefine

 retval = prepr_check_next(source_str, source_pos, str_length, "undef");

 if (retval != -1)
 {
  source_pos = retval;
// make sure it's followed by a space
  if (!prepr_expect_character(source_str, &source_pos, str_length, ' '))
   return prepr_error(PRERR_UNRECOGNISED_DIRECTIVE);

// now read the following word, which is the name of the macro being undefined:
  retval = read_next_ptoken(source_str, macro_name, &source_pos, str_length);
  if (retval != PTOKEN_READ_WORD)
   return prepr_error(PRERR_INVALID_TOKEN);
// first check against numtokens (not strictly necessary, but we should remind user that numtokens can't be undefined)
  for (i = 0; i < NUMTOKENS; i ++)
  {
   if (numtoken[i].name [0] == '\0') // reached the end
    break;
   if (strcmp(numtoken[i].name, macro_name) == 0) // match!
    return prepr_error(PRERR_CANNOT_UNDEFINE_NUMTOKEN);
  }
// now check against the list of existing deftokens:
  for (i = 0; i < DEFTOKENS; i ++)
  {
   if (deftoken[i].exists
    && strcmp(macro_name, deftoken[i].name) == 0)
    break;
  }
  if (i == DEFTOKENS)
   return prepr_error(PRERR_UNDEFINED_TOKEN_DOESNT_EXIST);
// must have found a deftoken. delete it:
  deftoken[i].exists = 0;
  deftoken[i].sub_text [0] = '\0';
  return 1;
 } // end #undefine

 retval = prepr_check_next(source_str, source_pos, str_length, "ifdef");

 if (retval != -1)
 {
  source_pos = retval;
// make sure it's followed by a space
  if (!prepr_expect_character(source_str, &source_pos, str_length, ' '))
   return prepr_error(PRERR_UNRECOGNISED_DIRECTIVE);

// now read the following word, which is the name of the macro being checked:
  retval = read_next_ptoken(source_str, macro_name, &source_pos, str_length);
  if (retval != PTOKEN_READ_WORD)
   return prepr_error(PRERR_INVALID_TOKEN);
// first check against numtokens
  for (i = 0; i < NUMTOKENS; i ++)
  {
   if (numtoken[i].name [0] == '\0') // reached the end
    break;
   if (strcmp(numtoken[i].name, macro_name) == 0) // match!
   {
    found = 1;
    break;
   }
  }
// now check against the list of existing deftokens:
  if (!found)
  {
   for (i = 0; i < DEFTOKENS; i ++)
   {
    if (deftoken[i].exists
     && strcmp(macro_name, deftoken[i].name) == 0)
    {
     found = 1;
     break;
    }
   }
  }
  if (found)
  {
   if (!prstack_push(PRSTACK_IF, -1))
    return 0;
  }
   else
   {
    if (!skip_to_closing_endif())
     return 0;
   }
  return 1; // at this point has either put the #ifdef on the prstack and is ready to read past it, or has skipped past the associated #endif
 } // end #ifdef


 retval = prepr_check_next(source_str, source_pos, str_length, "ifndef");
// should really combine this with ifdef somehow, as the code is almost identical

 if (retval != -1)
 {
  source_pos = retval;
// make sure it's followed by a space
  if (!prepr_expect_character(source_str, &source_pos, str_length, ' '))
   return prepr_error(PRERR_UNRECOGNISED_DIRECTIVE);

// now read the following word, which is the name of the macro being checked:
  retval = read_next_ptoken(source_str, macro_name, &source_pos, str_length);
  if (retval != PTOKEN_READ_WORD)
   return prepr_error(PRERR_INVALID_TOKEN);
// first check against numtokens
  for (i = 0; i < NUMTOKENS; i ++)
  {
   if (numtoken[i].name [0] == '\0') // reached the end
    break;
   if (strcmp(numtoken[i].name, macro_name) == 0) // match!
   {
    found = 1;
    break;
   }
  }
// now check against the list of existing deftokens:
  if (!found)
  {
   for (i = 0; i < DEFTOKENS; i ++)
   {
    if (deftoken[i].exists
     && strcmp(macro_name, deftoken[i].name) == 0)
    {
     found = 1;
     break;
    }
   }
  }
  if (!found)
  {
   if (!prstack_push(PRSTACK_IF, -1))
    return 0;
  }
   else
   {
    if (!skip_to_closing_endif())
     return 0;
   }
  return 1; // at this point has either put the #ifndef on the prstack and is ready to read past it, or has skipped past the associated #endif
 } // end #ifndef



 retval = prepr_check_next(source_str, source_pos, str_length, "endif");

// Note that this code should only find an endif associated with an if/ifdef that was true (or ifndef that was false). Otherwise the endif should be read and skipped by skip_to_closing_endif().

 if (retval != -1)
 {
// anything on the same line as the #endif is ignored. Is this okay? Probably not ideal...
  if (prstack_pop() != PRSTACK_IF)
   return prepr_error(PRERR_ENDIF_WITHOUT_IF);

  return 1;

 } // end #endif


 retval = prepr_check_next(source_str, source_pos, str_length, "include");

 if (retval != -1)
 {
  source_pos = retval;
// make sure it's followed by a space
  if (!prepr_expect_character(source_str, &source_pos, str_length, ' '))
   return prepr_error(PRERR_UNRECOGNISED_DIRECTIVE);

// then a "
  if (!prepr_expect_character(source_str, &source_pos, str_length, '"'))
   return prepr_error(PRERR_EXPECTED_QUOTES_AFTER_INCLUDE);

// now read everything until the next " and append it to the current source's directory path
  char included_file_path [FILE_PATH_LENGTH];

// the #include directive should specify a path relative to the #including file.
// we need to append it to the path of the directory the including file is in:

// set the base path (i.e. the path of the main source file with the actual file name removed):
  if (prstate.source [prstate.source_file]->from_a_file == 1)
  {
   strcpy(included_file_path, prstate.source [prstate.source_file]->src_file_path); // these two arrays should be the same length (FILE_PATH_LENGTH)
   remove_file_name_from_path(included_file_path, 1); // removes the file name, leaving only the directory.
  }
   else
    included_file_path [0] = '\0'; // might not work (but you shouldn't be #including things from an unsaved editor tab anyway)

  i = strlen(included_file_path);

  while(TRUE)
  {
   if (source_pos >= str_length)
    return prepr_error(PRERR_SYNTAX_ERROR_DIRECTIVE);
   if (i >= FILE_PATH_LENGTH)
    return prepr_error(PRERR_FILE_NAME_TOO_LONG);
   if (source_str [source_pos] == '"')
   {
    included_file_path [i] = '\0';
    break;
   }
   included_file_path [i] = source_str [source_pos];

   i ++;
   source_pos ++;
  };

//  fprintf(stdout, "\nincluded_file_path is (%s) (source path is (%s))", included_file_path, prstate.source [prstate.source_file]->src_file_path);

// we need to work out whether it's a source file (*.c) or a binary file (*.bc)

  int file_type = get_file_type_from_name(included_file_path);

  switch(file_type)
  {

   case FILE_TYPE_SOURCE:
    return include_source_file(included_file_path);

   case FILE_TYPE_BINARY:
    return include_binary_file(included_file_path);

  }

  return prepr_error(PRERR_INVALID_FILE_PATH);

 } // end #include

 retval = prepr_check_next(source_str, source_pos, str_length, "error");

 if (retval != -1)
 {
  return prepr_error(PRERR_ERROR_DIRECTIVE); // error directive text not yet supported
 }

 return prepr_error(PRERR_UNRECOGNISED_DIRECTIVE);

}

// loads #included source file (.c) and preprocesses it into scode
// returns 1 success 0 error (writes error message on error)
int include_source_file(const char* included_file_path)
{


// this call to prepare_include_sourcestruct sets included_source_index to the index of the included file in the prstate.include_source array.
    int included_source_index = 0;

    int prepare_include_result = prepare_include_sourcestruct(included_file_path, &included_source_index);

    switch(prepare_include_result)
    {
				 case 0:
				 	return 0; // error - prepare_include_sourcestruct should have written error message

				 case 1:	// #include refers to a new source file - need to load from disk
      if (!load_source_file(included_file_path, prstate.source [included_source_index], included_source_index, 1)) // the 1 indicates that this call is from the preprocessor, so any errors will be handled through prepr_error()
       return prepr_error(PRERR_EMPTY); // just prints src name and line number
      if (!prstack_push(PRSTACK_INCLUDE, included_source_index))
       return 0; // prstrack_push should have written error message
//      fprintf(stdout, "\nLoaded: index %i file %s", included_source_index, included_file_path);
				 	break;

				 case 2: // #include refers to a source file that's already loaded
      if (!prstack_push(PRSTACK_INCLUDE, included_source_index))
       return 0; // prstrack_push should have written error message
//      fprintf(stdout, "\nFound: index %i file %s", included_source_index, included_file_path);
						break;

    }

//    if (included_source_index == -1)
//     return 0; // prepare_include_sourcestruct should have written error message

// need to save the source line and file information for the current file, so the prstate variables can be used for the #included file:
    int save_src_line = prstate.src_line; // prstate.src_line will be set to the line numbers in the included source file by preprocess_source().
    int save_source_file = prstate.source_file;

    prstate.source_file = included_source_index;

// now call preprocess_source recursively
    if (!preprocess_source(prstate.source [prstate.source_file]))
     return 0;

// now need to clear all #subdefine macros (in order to make sure that they aren't recognised again if this file is preprocessed again, e.g. because it's #included by something else)
    clear_subdefines(prstate.source_file);

    prstate.src_line = save_src_line;
    prstate.source_file = save_source_file;

    if (prstack_pop() != PRSTACK_INCLUDE)
     return prepr_error(PRERR_SYNTAX_ERROR);

    return 1;

}

// Call this after finishing preprocessing a source file.
// It clears subdefines defined in that file
//  (because we may preprocess the same file again later)
void clear_subdefines(int source_file)
{
	int i;

	for (i = 0; i < DEFTOKENS; i ++)
	{
		if (deftoken[i].file_scope == source_file)
			deftoken[i].exists = 0;
	}

}


// loads an #included binary file (.bc) and copies its contents to scode (as asm initialiser in text format) via an include_sourcestruct
// uses same functions as the editor does when converting bcode to source
//  *** TO DO: this could be done more efficiently by not using the intermediate steps of converting to include_sourcestruct and then to scode!
// returns 1 success 0 failure (and writes error message)
int include_binary_file(const char* included_file_path)
{

    struct bcodestruct load_bcode;
// Need to initialise load_bcode
    if (!allocate_bcode_ops(&load_bcode, BCODE_MAX))
					return 0;

// this call to prepare_include_sourcestruct sets included_source_index to the index of the included file in the prstate.include_source array.
    int included_source_index = 0;

    int prepare_include_result = prepare_include_sourcestruct(included_file_path, &included_source_index);

    switch(prepare_include_result)
    {
				 case 0:
				 	goto return_fail; // error - prepare_include_sourcestruct should have written error message

				 case 1:	// #include refers to a new source file - need to load from disk
      if (!load_binary_file(included_file_path, &load_bcode, included_source_index, 1)) // the 1 indicates that this call is from the preprocessor, so any errors will be handled through prepr_error()
       goto return_fail; // load_binary_file should have written error message
      convert_bcode_to_asm_source_initialiser(&load_bcode, prstate.source [included_source_index]->text); // can't fail
      strcpy(prstate.source [included_source_index]->src_file_path, included_file_path);
      if (!get_file_name_from_path(prstate.source [included_source_index]->src_file_name, included_file_path, 1))
       goto return_fail;
// we know that the source is from a file:
      prstate.source [included_source_index]->from_a_file = 1;
      if (!prstack_push(PRSTACK_INCLUDE, included_source_index))
       goto return_fail; // prstrack_push should have written error message
				 	break;

				 case 2: // #include refers to a source file that's already loaded
      if (!prstack_push(PRSTACK_INCLUDE, included_source_index))
       goto return_fail; // prstrack_push should have written error message
						break;

    }

// this call to prepare_include_sourcestruct sets included_source_index to the index of the included file in the prstate.include_source array.
//    int included_source_index = prepare_include_sourcestruct(included_file_path);

//    if (included_source_index == -1)
//     return 0; // prepare_include_sourcestruct should have written error message

//    if (!prstack_push(PRSTACK_INCLUDE, included_source_index))
//     return 0; // prstrack_push should have written error message

// load the .bc file into load_bcode:

// now convert load_bcode into the text array of prstate.source [included_source_index]:
//    convert_bcode_to_asm_source_initialiser(&load_bcode, prstate.source [included_source_index]->text); // can't fail

// prstate.source [included_source_index] now has the contents of the binary file in it as an asm initialiser, with asm_only and asm instructions
//  TO DO: the asm_only and asm instructions assume that include_binary_file will only ever be used to include complete processes - is this correct?

// now we need to finish off the prstate.source [included_source_index] sourcestruct:
// file_path has been checked for length above
//    strcpy(prstate.source [included_source_index]->src_file_path, included_file_path);
// need to extract the file name from the path:
//    if (!get_file_name_from_path(prstate.source [included_source_index]->src_file_name, included_file_path, 1))
//     return 0;
// we know that the source is from a file:
//    prstate.source [included_source_index]->from_a_file = 1;

// need to save the source line and file information for the current file, so the prstate variables can be used for the #included file:
    int save_src_line = prstate.src_line; // prstate.src_line will be set to the line numbers in the included source file by preprocess_source().
    int save_source_file = prstate.source_file;

    prstate.source_file = included_source_index;

// now call preprocess_source recursively
    if (!preprocess_source(prstate.source [prstate.source_file]))
     goto return_fail;

    prstate.src_line = save_src_line;
    prstate.source_file = save_source_file;

    if (prstack_pop() != PRSTACK_INCLUDE)
				{
     prepr_error(PRERR_SYNTAX_ERROR);
     goto return_fail;
				}

    free(load_bcode.op);
    return 1;

return_fail:

    free(load_bcode.op);
			 return 0;

}

// attempts to calloc bcode's op array
// and also sets bcode_size
// returns 0 fail/1 success
int allocate_bcode_ops(struct bcodestruct* bcode, int bcode_size)
{

	bcode->op = calloc(bcode_size, sizeof(s16b));

	if (!bcode->op)
		return prepr_error(PRERR_COULDNT_ALLOCATE_BCODE);

	bcode->bcode_size = bcode_size;

	return 1;

}

/*
Either finds an existing loaded source file, or
allocates memory for a sourcestruct in prstate.include_source [].

Assumes included_file_name is a valid string of length no more than FILE_NAME_LENGTH

Returns 0 on failure
Returns 1 if it loaded a new source file
Returns 2 if it found an existing source file

*/
int prepare_include_sourcestruct(const char* included_file_path, int* source_file_index)
{
 int i;

 *source_file_index = -1;

// First, check whether the file has already been loaded in:
 for (i = 0; i < SOURCE_FILES; i ++)
 {
  if (prstate.source [i] != NULL
		 && strcmp(prstate.source[i]->src_file_path, included_file_path) == 0)
		{
			*source_file_index = i;
   return 2;
		}
 }

// Need to load a new one:
 for (i = 0; i < SOURCE_FILES; i ++)
 {
  if (prstate.source [i] == NULL)
   break;
 }
 if (i == SOURCE_FILES)
  return prepr_error(PRERR_TOO_MANY_INCLUDED_FILES);

 prstate.source [i] = calloc(1, sizeof (struct sourcestruct));

 if (!prstate.source [i])
  return prepr_error(PRERR_COULDNT_ALLOCATE_INCLUDE_SOURCE);

 strcpy(prstate.source [i]->src_file_path, included_file_path);

 if (!get_file_name_from_path(prstate.source [i]->src_file_name, included_file_path, 1))
  return 0; // failure!

 *source_file_index = i;
 return 1;

}


// writes a bcodestruct to an array of strings
// text can be the text array from a sourcestruct or a source_editstruct (they should have the same dimensions; see comments in each struct declaration)
// if using with a source_editstruct, may need separate code to make sure the source_editstruct's line_index is ordered correctly
// this function shouldn't be able to fail
// assumes that bcode->static_length is valid
void convert_bcode_to_asm_source_initialiser(struct bcodestruct* bcode, char text [SOURCE_TEXT_LINES] [SOURCE_TEXT_LINE_LENGTH])
{

 int text_line = 0;
 int numbers_on_line = 0;
 char temp_str [10];
 int i;

// now write an asm_only header to the source_editstruct's text array (can assume that call to new_empty_source_tab() resulted in all text lines being of 0 length):
 strcpy(text [text_line], "asm_only");
 text_line+= 2;
 strcpy(text [text_line], "asm");
 text_line++;
 strcpy(text [text_line], "{");
 text_line++;
 strcpy(text [text_line], " {"); // brace enclosing all of the numbers as initialisers
 text_line++;

/*// add first_number (do this separately as it's the only number not preceded by a comma:
 sprintf(temp_str, "%i,", se->bcode.op [0]);
 strcat(se->text [text_line], temp_str);
 numbers_on_line ++;*/

// now add numbers one by one, 10 to each line:
 i = 0;
 while(TRUE)
 {
  sprintf(temp_str, " %i", bcode->op [i]);
  strcat(text [text_line], temp_str);
  i++;
  if (i >= bcode->bcode_size)
   break;
  strcat(text [text_line], ",");
  numbers_on_line ++;
  if (numbers_on_line == 10)
  {
   text_line ++;
   numbers_on_line = 0;
  }
#ifdef SANITY_CHECK
 if (text_line >= SOURCE_TEXT_LINES) // shouldn't be possible unless SOURCE_TEXT_LINES decreases a lot or bc->bcode_size increases a lot
 {
  fprintf(stdout, "\nError: c_prepr.c: convert_bcode_to_asm_source_initialiser(): text_lines exceeds SOURCE_TEXT_LINES (%i); bcode_length is %i, numbers written is %i", SOURCE_TEXT_LINES, bcode->static_length, i);
  error_call();
 }
#endif
 };

// add closing braces
 text_line++;
 strcpy(text [text_line], " }");
 text_line++;
 strcpy(text [text_line], "}");


}


/*
pushes prstack_status onto the prstack (is used for nested #ifdefs and similar)

returns 1 on success, 0 on failure
*/
int prstack_push(int prstack_status, int source_file)
{
 prstate.stack_pos ++;

 if (prstate.stack_pos >= PRSTACK_SIZE)
  return prepr_error(PRERR_OUT_OF_PRSTACK);

 prstate.prstack[prstate.stack_pos].type = prstack_status;
 prstate.prstack[prstate.stack_pos].source_file = source_file; // may be -1 if not a file
// prstate.prstack[prstate.stack_pos].source_file = prstate.source_file;
// prstate.prstack[prstate.stack_pos].parent_source_file = parent_sfile;

 return 1;

}

/*
Pops prstack (result is returned)

returns PRSTACK_ERROR on failure

*/
int prstack_pop(void)
{
 if (prstate.stack_pos <= 0)
  return PRSTACK_ERROR;

 int popval = prstate.prstack[prstate.stack_pos].type;
 prstate.stack_pos --;

 return popval;

}

/*
Skips through source until it finds a matching #endif. Uses the prstack to deal with nested #ifs

Doesn't read anything in between except to check for #ifs and #endifs

Returns 1 on success, 0 on failure

*/
int skip_to_closing_endif(void)
{

// changes in this function may need to be reflected in preprocess_source()

 int i;
 int retval;
 int base_prstack_pos = prstate.stack_pos;

 prstate.src_line ++;

 for (i = prstate.src_line; i < SOURCE_TEXT_LINES; i ++)
 {

  if (prstate.source [prstate.source_file]->text [i] [0] == '#')
  {
   retval = prepr_check_next(prstate.source [prstate.source_file]->text [i], 1, SOURCE_TEXT_LINE_LENGTH, "endif");

   if (retval != -1)
   {
// if an #endif is found, we check whether the prstack is at the same position as the opening #if (for which this function is being called).
//  if so, we've found the end. If not, confirm that the #endif is associated with a nested #if.
    if (prstate.stack_pos == base_prstack_pos)
    {
     prstate.src_line = i;
     return 1; // found the matching #endif
    }

    if (prstack_pop() != PRSTACK_IF)
     return prepr_error(PRERR_ENDIF_WITHOUT_IF); // possible? Not sure.
   }

// now check for either ifdef or ifndef. It doesn't matter which, because it's nested inside code that's being skipped and we only need to
//  know it's their to keep track of which #endif is associated with the one that caused this function to be called.
   retval = prepr_check_next(prstate.source [prstate.source_file]->text [i], 1, SOURCE_TEXT_LINE_LENGTH, "ifdef");
   if (retval == -1)
   {
    retval = prepr_check_next(prstate.source [prstate.source_file]->text [i], 1, SOURCE_TEXT_LINE_LENGTH, "ifndef");
   }

   if (retval != -1)
   {
// Just need to push PRSTACK_IF so it can be sitting on the stack when the nested #endif is found.
    if (!prstack_push(PRSTACK_IF, -1))
     return 0;
   }

  } // end if line starts with #
 } // end i loop

 return prepr_error(PRERR_REACHED_END_WITHIN_IF);




}


int prepr_expect_character(char* source_str, int* source_pos, int str_length, char expect_char)
{
 if ((*source_pos) >= str_length)
  return prepr_error(PRERR_SYNTAX_ERROR);
 if (source_str [*source_pos] != expect_char)
  return prepr_error(PRERR_SYNTAX_ERROR);
// found a match!
 (*source_pos) ++;
 return 1;
}

/*
skips spaces without doing anything to scode
for use in directives and similar
expects something other than 0

returns 0 if it finds 0 or end of string
returns 1 if it finds anything else (whether or not any spaces actually skipped)
*/
int prepr_skip_spaces(char* source_str, int* source_pos, int str_length)
{

 while(TRUE)
 {
  if (*source_pos >= str_length
   || source_str [*source_pos] == 0)
   return 0;
  if (source_str [*source_pos] != ' ')
   return 1;
  (*source_pos) ++;
 };

}

// call this with source_pos at the first letter of the word to be checked
// returns -1 on failure
// or the new value of source_pos on success
int prepr_check_next(char* source_str, int source_pos, int str_length, char check_name [DIRECTIVE_LENGTH])
{

 int i = 0;
 char read_char;

 while (TRUE)
 {
// first do bounds-checking for both strings
  if (source_pos >= str_length)
   return -1;
  if (i >= DIRECTIVE_LENGTH) // probably not possible
   return -1;

  read_char = source_str [source_pos];

  if ((read_char == ' ' || read_char == 0)
   && check_name [i] == 0)
   return source_pos; // success!

  if (read_char != check_name [i])
   return -1; // mismatch - failure
  source_pos ++;
  i ++;
 };

}



// returns 1 if deftoken[deftoken_index] is in the current scope, 0 otherwise.
//  - if deftoken is a #define, it is always in scope (unless #undefined)
//  - if deftoken is a #subdefine, this function checks it against the current file then searches the pr_stack if needed to find it
// assumes that deftoken exists
int define_in_scope(int deftoken_index)
{

 if (deftoken[deftoken_index].file_scope == -1 // #define
  || deftoken[deftoken_index].file_scope == 0) // main file #subdefines are also always in scope
  return 1;

 int stack_search_index = prstate.stack_pos;

 while (stack_search_index > 0) // don't bother checking 0 as it is always PRSTACK_MAIN_FILE
 {
  if (prstate.prstack[stack_search_index].type == PRSTACK_INCLUDE
   && prstate.prstack[stack_search_index].source_file == deftoken[deftoken_index].file_scope)
   return 1;
  stack_search_index --;
 };

 return 0;

}


/*
This function loads source file file_name into sourcestruct target_source.
src_file_index is the index of the file to identify it in multi-file bcodenotestructs

 - TO DO: probably should store the names of all included files in the sourcestruct (to copy to bcodenotestruct)

Assumes file_name is a valid string (of any length; checks length).
Assumes src_file_index is valid (from 0 to INCLUDED_FILES-1).
 - current src_file_index isn't used

Doesn't assume file file_name exists, or can be read in correctly.
Is used by both the preprocessor (in which case preprocessing==1 and errors are treated as preprocessor errors) and the editor's file open command (preprocessing==0)

returns 1 on success, 0 on failure. Will call prepr_error if preprocessing==1; otherwise will write error to log
*/
int load_source_file(const char* file_path, struct sourcestruct* target_source, int src_file_index, int preprocessing)
{

#define READ_SIZE 100000

 char buffer [READ_SIZE];
 FILE *file;
 unsigned int read_in = 0;
 int i;

 if (strlen(file_path) >= FILE_PATH_LENGTH)
 {
  if (preprocessing)
   return prepr_error_no_source(PRERR_FILE_PATH_TOO_LONG, file_path);
  write_line_to_log("Error: Path too long.", MLOG_COL_ERROR);
  return 0;
 }


// open the file:
 file = fopen(file_path, "rt");


 if (file)
 {

    read_in = fread(buffer, 1, READ_SIZE, file);


    if (ferror(file) || read_in == 0)
    {
     fclose(file);
     if (preprocessing)
      return prepr_error_no_source(PRERR_FILE_READ_ERROR, file_path);
     write_line_to_log("Error: Couldn't read file.", MLOG_COL_ERROR);
     return 0;
    }

    if (!feof(file))
    {
     fclose(file);
     if (preprocessing)
      return prepr_error_no_source(PRERR_FILE_TOO_LONG, file_path);
     write_line_to_log("Error: EOF not found (file too long?).", MLOG_COL_ERROR);
     return 0;
    }

    fclose(file);

 }
  else
  {
   if (preprocessing)
    return prepr_error_no_source(PRERR_FILE_OPEN_ERROR, file_path);
   write_line_to_log("Error: File not found.", MLOG_COL_ERROR);
   return 0;
  }

// file_path has been checked for length above
 strcpy(target_source->src_file_path, file_path);

// need to extract the file name from the path:
 if (!get_file_name_from_path(target_source->src_file_name, file_path, 1))
  return 0;

// we know that the source is from a file:
 target_source->from_a_file = 1;

// need to add null terminator
 if (read_in < READ_SIZE)
  buffer [read_in] = 0;
   else
    buffer [READ_SIZE - 1] = 0;

 int src_line = 0;
 int src_pos = 0;
 int line_finished;

 for (i = 0; i < read_in; i ++)
 {
// Peter Hull solved a problem with loading source code on systems that don't use Windows-style line endings:
   /* hack for *nix */
   if (buffer[i] == '\r')
    continue;
   /* end hack */
   if (buffer[i] == '\t')
    buffer[i] = ' '; // I'm not really sure how to handle tabs, sorry
  target_source->text [src_line] [src_pos] = buffer [i];
//  target_source->source_file [src_line] = src_file_index; // only actually need to do this once per line. Oh well.
  line_finished = 0;
  if (buffer[i] == '\n')
  {
   line_finished = 1;
// newline found - fill the rest of the source line with 0s
   if (src_pos < SOURCE_TEXT_LINE_LENGTH)
   {
//    target_source->text [src_line] [src_pos] = ' '; // this will replace the \n with a space
    target_source->text [src_line] [src_pos] = '\0'; // this will replace the \n with a space
    src_pos ++;
   }
   while (src_pos < SOURCE_TEXT_LINE_LENGTH)
   {
    target_source->text [src_line] [src_pos] = 0;
    src_pos ++;
   }
  }
  src_pos ++;

  if (src_pos >= SOURCE_TEXT_LINE_LENGTH - 1)
  {
   target_source->text [src_line] [src_pos] = '\0'; // if line is too long, terminate it and start new line
   if (!line_finished) // line is too long and was not terminated by newline
   {
    start_log_line(MLOG_COL_ERROR);
    write_to_log("Error: line ");
    write_number_to_log(src_line + 1);
    write_to_log(" of file ");
    write_to_log(target_source->src_file_name);
    write_to_log(" too long (maximum is ");
    write_number_to_log(SOURCE_TEXT_LINE_LENGTH);
    write_to_log(" chars).");
    finish_log_line();
    return 0;
   }
   src_line ++;
   src_pos = 0;
  }
  if (src_line >= SOURCE_TEXT_LINES)
  {
   if (preprocessing)
    return prepr_error_no_source(PRERR_FILE_TOO_LONG, file_path);
   write_line_to_log("Error: too many lines in file.", MLOG_COL_ERROR);
   return 0;
  }
 }

// fill the rest of the sourcestruct with 0s
 while (src_line < SOURCE_TEXT_LINES)
 {
  target_source->text [src_line] [src_pos] = '\0';
  src_pos ++;
  if (src_pos >= SOURCE_TEXT_LINE_LENGTH)
  {
   src_line ++;
   src_pos = 0;
  }
 };

// make sure every source line is null-terminated:
 src_line = 0;

 while (src_line < SOURCE_TEXT_LINES)
 {
  target_source->text [src_line] [SOURCE_TEXT_LINE_LENGTH - 1] = '\0';
  src_line ++;
 };

 return 1;

}



/*
This function loads binary (.bc) file file_name into bcodestruct bcode.
src_file_index is the index of the file to identify it in multi-file bcodenotestructs (probably not used at all for now)

 - TO DO: probably should store the names of all included files in the sourcestruct (to copy to bcodenotestruct)

Assumes file_name is a valid string (of any length; checks length).
Assumes src_file_index is valid (from 0 to INCLUDED_FILES-1).
 *** currently src_file_index isn't used (not implemented)

Doesn't assume file file_name exists, or can be read in correctly.
Is used by both the preprocessor (in which case preprocessing==1 and errors are treated as preprocessor errors) and the editor's file open command (preprocessing==0)

leaves length of file in bcode->static_length

returns 1 on success, 0 on failure. Will call prepr_error if preprocessing==1; otherwise will write error to log
*/
int load_binary_file(const char* file_path, struct bcodestruct* bcode, int src_file_index, int preprocessing)
{

#define BINARY_READ_SIZE 20000

 s16b sbuffer [BINARY_READ_SIZE];
 FILE *file;
 unsigned int read_in = 0;
 int i;

 if (strlen(file_path) >= FILE_PATH_LENGTH)
 {
  if (preprocessing)
   return prepr_error_no_source(PRERR_FILE_PATH_TOO_LONG, file_path);
  write_line_to_log("Error: Path too long.", MLOG_COL_ERROR);
  return 0;
 }


// open the file:
 file = fopen(file_path, "rb");


 if (file)
 {

    read_in = fread(sbuffer, sizeof(s16b), BINARY_READ_SIZE, file);


    if (ferror(file) || read_in == 0)
    {
     fclose(file);
     if (preprocessing)
      return prepr_error_no_source(PRERR_FILE_READ_ERROR, file_path);
     write_line_to_log("Error: Couldn't read binary file.", MLOG_COL_ERROR);
     return 0;
    }

    if (!feof(file))
    {
     fclose(file);
     if (preprocessing)
      return prepr_error_no_source(PRERR_FILE_TOO_LONG, file_path);
     write_line_to_log("Error: EOF not found (file too long?).", MLOG_COL_ERROR);
     return 0;
    }

    if (read_in >= bcode->bcode_size)
    {
     fclose(file);
     if (preprocessing)
      return prepr_error_no_source(PRERR_FILE_TOO_LONG, file_path);
     write_line_to_log("Error: binary file too long.", MLOG_COL_ERROR);
     return 0;
    }

    fclose(file);

 }
  else
  {
   if (preprocessing)
    return prepr_error_no_source(PRERR_FILE_OPEN_ERROR, file_path);
   write_line_to_log("Error: failed to open binary file.", MLOG_COL_ERROR);
   return 0;
  }

// file_path has been checked for length above
 strcpy(bcode->src_file_path, file_path);

// need to extract the file name from the path:
 if (!get_file_name_from_path(bcode->src_file_name, file_path, 1))
  return 0;

// we know that the source is from a file:
 bcode->from_a_file = 1;

// clear target bcode
 for (i = 0; i < bcode->bcode_size; i ++)
 {
  bcode->op [i] = 0;
 }

// we've already checked length of read buffer (read_in) and confirmed it's less than BCODE_MAX
 for (i = 0; i < read_in; i ++)
 {
  bcode->op [i] = sbuffer [i];
 }

 bcode->static_length = read_in;

 return 1;

}



// extracts the file name from file_path and copies it to *file_name
// assumes file_name is at least FILE_NAME_LENGTH and file_path is at least FILE_PATH_LENGTH
// on failure, calls prepr_error if preprocessing == 1  - otherwise just writes to mlog
// returns 0 fail/ 1 success
int get_file_name_from_path(char* file_name, const char* file_path, int preprocessing)
{

 ALLEGRO_PATH* path_struct = al_create_path(file_path);

 if (path_struct == NULL)
 {
  if (preprocessing)
   return prepr_error_no_source(PRERR_INVALID_FILE_PATH, file_path);
  write_line_to_log("Error: Invalid path.", MLOG_COL_ERROR);
// don't need to call al_destroy_path() before returning as it wasn't created properly
  return 0;
 }

 const char* file_name_ptr = al_get_path_filename(path_struct);

 if (strlen(file_name_ptr) >= FILE_NAME_LENGTH)
 {
  al_destroy_path(path_struct); // remember not to use path_struct after this
  if (preprocessing)
   return prepr_error_no_source(PRERR_FILE_NAME_TOO_LONG, file_path);
  write_line_to_log("Error: File name too long.", MLOG_COL_ERROR);
  return 0;
 }

 strcpy(file_name, file_name_ptr);

 al_destroy_path(path_struct);

 return 1;

}

// alters file_path by removing everything after the final delimiter
// assumes file_path is a null-terminated string
// returns 1 if no delimiter
// returns 0 fail or 1 success
int remove_file_name_from_path(char* file_path, int preprocessing)
{

 int i = strlen(file_path) - 1;

 if (i <= 0)
 {
  if (preprocessing)
   return prepr_error_no_source(PRERR_INVALID_FILE_PATH, file_path);
  write_line_to_log("Error: invalid path.", MLOG_COL_ERROR);
// not sure these errors can ever actually happen
  return 0;
 }

 while(i > -1)
 {
  if (file_path [i] == '\\' || file_path [i] == '/')
  {
   file_path [i + 1] = '\0'; // remember that i is initialised to strlen(file_path) - 1
   return 1;
  }
  i --;
 };

 file_path [0] = '\0'; // not sure about this
 return 1;

}

// This function frees allocated memory for included sourcestructs.
// Assumes that any prstate.included_file pointer that isn't NULL points to a calloc'd sourcestruct.
void free_included_sourcestructs(void)
{
 int i;

 for (i = 1; i < SOURCE_FILES; i ++) // i starts at 1 because source 0 is the main source being compiled (which is not dynamically allocated)
 {
  if (prstate.source [i] != NULL)
   free(prstate.source [i]);
  prstate.source [i] = NULL; // is this needed? can't hurt.
 }

}


const char *prepr_error_name [PRERRS] =
{
"unrecognised directive", // PRERR_UNRECOGNISED_DIRECTIVE,
"token beginning with number contains non-number character", // PRERR_NUMBER_CONTAINS_LETTER
"unrecognised character", // PRERR_UNRECOGNISED_CHARACTER
"token too long", // PRERR_TOKEN_TOO_LONG,
"invalid token after directive", // PRERR_INVALID_TOKEN,
"input source too long", // PRERR_SCODE_LIMIT_REACHED
"source string not null-terminated? This should not happen", // PRERR_STRING_NOT_NULL_TERMINATED
"macro already defined", // PRERR_NAME_ALREADY_USED
"syntax error", // PRERR_SYNTAX_ERROR
"syntax error in preprocessor directive", // PRERR_SYNTAX_ERROR_DIRECTIVE
"too many #defines or #subdefines", // PRERR_TOO_MANY_DEFINES
"complexity limit reached - recursive macro? (macros can't be recursive)", // PRERR_RECURSIVE_MACRO
"cannot redefine built-in number macro", // PRERR_CANNOT_REDEFINE_NUMTOKEN,
"cannot undefine built-in number macro", // PRERR_CANNOT_UNDEFINE_NUMTOKEN,
"macro name already used as identifier", // PRERR_NAME_ALREADY_USED_AS_IDENTIFIER,
"preprocessor stack limit reached - too many nested directives?", // PRERR_OUT_OF_PRSTACK,
"#endif without #if", // PRERR_ENDIF_WITHOUT_IF,
"end of source file reached within #if", // PRERR_REACHED_END_WITHIN_IF,
"#undefined token doesn't exist", // PRERR_UNDEFINED_TOKEN_DOESNT_EXIST
"file read error", // PRERR_FILE_READ_ERROR,
"file too long", // PRERR_FILE_TOO_LONG,
"couldn't open file", // PRERR_FILE_OPEN_ERROR,
"included file name must be surrounded by quotes (\")", // PRERR_EXPECTED_QUOTES_AFTER_INCLUDE,
"file name too long", // PRERR_FILE_NAME_TOO_LONG,
"too many included files", // PRERR_TOO_MANY_INCLUDED_FILES,
"couldn't allocate memory for source code!", // PRERR_COULDNT_ALLOCATE_INCLUDE_SOURCE,
"error directive reached", // PRERR_ERROR_DIRECTIVE
"file path too long", // PRERR_FILE_PATH_TOO_LONG
"invalid file path", // PRERR_INVALID_FILE_PATH,
"unknown error (shouldn't happen!)", // PRERR_UNKNOWN_DEFINE_ERROR
"hex number contains invalid character", // PRERR_HEX_NUMBER_CONTAINS_INVALID_LETTER,
"invalid number (number begins with 0 but not 0x or 0b?)", // PRERR_INVALID_NUMBER,
"binary number contains invalid character", // PRERR_BINARY_NUMBER_CONTAINS_LETTER
"couldn't allocate bcode (out of memory?)", // PRERR_COULDNT_ALLOCATE_BCODE
"(empty)", // PRERR_EMPTY
"invalid string", // PRERR_INVALID_STRING
};

int prepr_error(int error_type)
{

     start_log_line(MLOG_COL_ERROR);
     write_to_log("Preprocessor error at line ");
     write_number_to_log(prstate.src_line + 1);
     if (prstate.source_file == 0)
      write_to_log(" of file ");
       else
        write_to_log(" of included file ");
     write_to_log(prstate.source [prstate.source_file]->src_file_name);
     write_to_log(".");
     finish_log_line();

     if (error_type != PRERR_EMPTY)
     {
      start_log_line(MLOG_COL_ERROR);
      write_to_log("Error: ");
      write_to_log(prepr_error_name [error_type]);
      write_to_log(".");
      finish_log_line();
     }
/*
     if (ctoken != NULL)
     {
      start_log_line(MLOG_COL_COMPILER);
      write_to_log("Last token read: ");
      write_to_log(ctoken->name);
      write_to_log(".");
      finish_log_line();
     }*/

     prstate.error = error_type;
     return 0;


}




// this wrapper for prepr_error is used when an error is found by a function that returns -1 on error
int prepr_error_minus1(int error_type)
{

 prepr_error(error_type);
 return -1;

}


// This function is like prepr_error, but doesn't assume a source file has been loaded (so it can be used in file loading functions)
int prepr_error_no_source(int error_type, const char* file_name)
{

     start_log_line(MLOG_COL_ERROR);
     write_to_log("Preprocessor error: ");
     write_to_log(prepr_error_name [error_type]);
     write_to_log(".");
     finish_log_line();

     start_log_line(MLOG_COL_ERROR);
     write_to_log("File: ");
     write_to_log(file_name);
     finish_log_line();

     prstate.error = error_type;
     return 0;

}


// this wrapper for prepr_error_no_source is used when an error is found by a function that returns -1 on error
int prepr_error_no_source_minus1(int error_type, const char* file_name)
{

 prepr_error_no_source(error_type, file_name);
 return -1;


}
