#include <allegro5\allegro.h>
#include <allegro5\allegro_primitives.h>
#include <allegro5\allegro_font.h>
#include <allegro5\allegro_ttf.h>
#include <allegro5\allegro_image.h>
#define _USE_MATH_DEFINES
#include <math.h>
#include "objects.h"




//Global Variables
enum KEYS{ UP, DOWN, LEFT, RIGHT, SPACE, ONE, MOUSE1};
enum CNTRLR{ LUP, LDOWN, LRIGHT, LLEFT, RUP, RDOWN, RRIGHT, RLEFT, A, B, Y, X, LB, RB, LT, RT, SELECT, START};
int width = 1200;
int height = 900;
const int NUM_BULLETS = 30;
const int NUM_ENEMIES = 100;
const int NUM_PLANETS = 2;
double mousex, mousey;
int bulletCD = 0;
bool joystick = false;

//Variables
bool draw = false;
bool done = false;
const int FPS = 60;
bool gameOver = false;
bool keys[7] = {false, false, false, false, false, false, false};
bool Cntrlr[18] = {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
int framesCur = 0, framesPS = 0, sec = 0;

	

//prototypes
struct Vector2
{
  float x;
  float y;
};

void initPlayer(Player1 &p1);
void movePlayerUp(Player1 &p1);
void movePlayerDown(Player1 &p1);
void movePlayerLeft(Player1 &p1);
void movePlayerRight(Player1 &p1);
void updatePlayer(Player1 &p1);
void drawPlayer(Player1 &p1);

void initPlanet(Image Planets[], int size);
void drawPlanet(Image Planets[], int size);
void updatePlanet(Image Planets[], int size);

void initBackground(Background &bg);
void drawBackground(Background &bg);
void updateBackground(Background &bg);

void initBullet(Bullet bullet[], int size);
void drawBullet(Bullet bullet[], int size);
void fireBullet(Bullet bullet[], int size, Player1 &p1);
void updateBullet(Bullet bullet[], int size);
void collideBullet(Bullet bullet[], int bsize, Enemies enemy[], int csize, Player1 &p1);

void initPulse(Pulse &pulse);
void drawPulse(Pulse &pulse);
void firePulse(Pulse &pulse, Player1 &p1);
void updatePulse(Pulse &pulse, Player1 &p1);
void collidePulse(Pulse &pulse, Enemies enemy[], int csize, Player1 &p1);

void initEnemy(Enemies enemy[], int size);
void drawEnemy(Enemies enemy[], int size);
void startEnemy(Enemies enemy[], int size);
void updateEnemy(Enemies enemy[], int size);
void collideComet(Enemies enemy[], int csize, Player1 &p1);
int returnRand(int num);

void drawHealth(Player1 &p1);

int main (void)
{
	
	//Object Variables
	Player1 p1;
	Bullet bullets[NUM_BULLETS];
	Pulse pulseAttack;
	Enemies enemy[NUM_ENEMIES];
	Image Planets[NUM_PLANETS];
	Background bg;

	//Allegro variables
	ALLEGRO_DISPLAY *display = NULL;
	ALLEGRO_MONITOR_INFO info;
	ALLEGRO_EVENT_QUEUE *event_queue = NULL;
	ALLEGRO_TIMER *LPS = NULL;
	ALLEGRO_FONT *font18 = NULL;

//Initialization Funtions
if(!al_init())
{
return -1;
}

al_get_monitor_info(0, &info);
width = info.x2 - info.x1; 
height = info.y2 - info.y1; 
display = al_create_display(width, height);

if(!display)
	return -1;

al_init_primitives_addon();
al_install_keyboard();
al_install_mouse();
al_install_joystick();
al_init_font_addon();
al_init_ttf_addon();
al_init_image_addon();

font18 = al_load_font("arial.ttf", 18, 0);
event_queue = al_create_event_queue();
LPS = al_create_timer(1.0 / FPS);

ALLEGRO_JOYSTICK *joy = al_get_joystick(0);
ALLEGRO_JOYSTICK_STATE joystate;

if(joy == NULL)
	joystick = false;
else
	joystick = true;

al_register_event_source(event_queue, al_get_display_event_source(display));
al_register_event_source(event_queue, al_get_keyboard_event_source());
al_register_event_source(event_queue, al_get_mouse_event_source());
al_register_event_source(event_queue, al_get_joystick_event_source());
al_register_event_source(event_queue, al_get_timer_event_source(LPS));




srand(time(NULL));
initBackground(bg);
initPlanet(Planets, NUM_PLANETS);
initPlayer(p1);
initPulse(pulseAttack);
initBullet(bullets, NUM_BULLETS);
initEnemy(enemy, NUM_ENEMIES);

al_hide_mouse_cursor(display);
al_start_timer(LPS);

while(!done)
{
	ALLEGRO_EVENT ev;
	al_wait_for_event(event_queue, &ev);
	if(joystick)
		al_get_joystick_state(joy, &joystate);

	if(ev.type == ALLEGRO_EVENT_TIMER)
	{	
		draw = true;
		sec++;
				
		if(!keys[UP] && !keys[DOWN] && p1.picDir != 1)
		{p1.picDir = 1;}

		if(p1.expCur >= p1.expNeeded)
		{p1.level++;
		 p1.expCur = 0;
		 p1.expNeeded += 25;}
		
		if(p1.health == 0 && !gameOver)
			gameOver = true;
		
		if(keys[UP] || Cntrlr[LUP]) movePlayerUp(p1);
		if(keys[DOWN] || Cntrlr[LDOWN]) movePlayerDown(p1);
		if(keys[LEFT] || Cntrlr[LLEFT]) movePlayerLeft(p1);
		if(keys[RIGHT] || Cntrlr[LRIGHT]) movePlayerRight(p1);
		if(joystick)
		{

			float dirx = joystate.stick[1].axis[0] - 0;
			float diry = joystate.stick[1].axis[1] - 0;
			float angle = atan2(diry, dirx);
			
			if(joystate.stick[1].axis[0] != 0 || joystate.stick[1].axis[1] != 0)
			{
				mousex = p1.x + 100 * cos(angle);
				mousey = p1.y + 100 * sin(angle);
			}
			al_set_mouse_xy(display, mousex, mousey);

			if(keys[SPACE] || keys[MOUSE1] || Cntrlr[RT])
			{
				bulletCD++;
				if(bulletCD == 16)
				{fireBullet(bullets, NUM_BULLETS, p1); bulletCD = 0;}
			}
			if(Cntrlr[A])
			{
				firePulse(pulseAttack, p1);
			}

		}

		if(!joystick)
		{
			if(keys[SPACE] || keys[MOUSE1] || Cntrlr[RT])
			{
				bulletCD++;
				if(bulletCD == 16)
				{fireBullet(bullets, NUM_BULLETS, p1); bulletCD = 0;}
			}
		}
		
		updateBackground(bg);
		updatePlayer(p1);
		updatePlanet(Planets, NUM_PLANETS);
		updatePulse(pulseAttack, p1);
		updateBullet(bullets, NUM_BULLETS);
		startEnemy(enemy, NUM_ENEMIES);
		updateEnemy(enemy, NUM_ENEMIES);
		collideBullet(bullets, NUM_BULLETS, enemy, NUM_ENEMIES, p1);
		collideComet(enemy, NUM_ENEMIES, p1);

		if (sec == FPS)
		{framesPS = framesCur; framesCur = sec = 0;}
		
	}

	else if(ev.type == ALLEGRO_EVENT_DISPLAY_CLOSE)
	{
		done = true;
	}
	else if(ev.type == ALLEGRO_EVENT_KEY_DOWN)
	{
		switch (ev.keyboard.keycode)
		{
		case ALLEGRO_KEY_ESCAPE:
			done = true;
			break;
		case ALLEGRO_KEY_W:
			keys[UP] = true;
			break;
		case ALLEGRO_KEY_S:
			keys[DOWN] = true;
			break;
		case ALLEGRO_KEY_A:
			keys[LEFT] = true;
			break;
		case ALLEGRO_KEY_D:
			keys[RIGHT] = true;
			break;
		case ALLEGRO_KEY_SPACE:
			keys[SPACE] = true;
			break;
		case ALLEGRO_KEY_1:
			keys[ONE] = true;
			gameOver = true;
			break;
		}
	}
	else if(ev.type == ALLEGRO_EVENT_KEY_UP)
	{
		switch (ev.keyboard.keycode)
		{
		case ALLEGRO_KEY_ESCAPE:
			done = true;
			break;
		case ALLEGRO_KEY_W:
			keys[UP] = false;
			break;
		case ALLEGRO_KEY_S:
			keys[DOWN] = false;
			break;
		case ALLEGRO_KEY_A:
			keys[LEFT] = false;
			break;
		case ALLEGRO_KEY_D:
			keys[RIGHT] = false;
			break;
		case ALLEGRO_KEY_SPACE:
			keys[SPACE] = false;
			break;
		case ALLEGRO_KEY_1:
			keys[ONE] = false;
			break;
		}
	}
	else if(ev.type == ALLEGRO_EVENT_MOUSE_BUTTON_DOWN)
	{
		switch (ev.mouse.button)
		{
		case 1:
			keys[MOUSE1] = true;
			break;
		}
	}
	else if(ev.type == ALLEGRO_EVENT_MOUSE_BUTTON_UP)
	{
		switch (ev.mouse.button)
		{
		case 1:
			keys[MOUSE1] = false;
			break;
		}
	}


	if(joystick)
	{	
		if(joystate.stick[0].axis[0] >= .3)
			Cntrlr[LRIGHT] = true;
		else if(joystate.stick[0].axis[0] <= -.3)
			Cntrlr[LLEFT] = true;
		else if(joystate.stick[0].axis[0] >= -.3 && joystate.stick[0].axis[0] <= .3 && Cntrlr[LRIGHT] || Cntrlr[LLEFT])
		{Cntrlr[LRIGHT] = false;
		 Cntrlr[LLEFT] = false;}

		if(joystate.stick[0].axis[1] >= .3)
			Cntrlr[DOWN] = true;
		else if(joystate.stick[0].axis[1] <= -.3)
			Cntrlr[LUP] = true;
		else if (joystate.stick[0].axis[1] >= -.3 && joystate.stick[0].axis[1] <= .3 && Cntrlr[LDOWN] || Cntrlr[LUP])
		{Cntrlr[LDOWN] = false;
		 Cntrlr[LUP] = false;}
		
		if(joystate.stick[1].axis[0] > 0 || joystate.stick[1].axis[0] < 0 || joystate.stick[1].axis[1] < 0 || joystate.stick[1].axis[1] > 0)
			Cntrlr[RT] = true;
		else if (joystate.stick[1].axis[0] == 0 && joystate.stick[1].axis[1] == 0 && Cntrlr[RT])
		{Cntrlr[RT] = false;}
		
		if(joystate.button[0])
			Cntrlr[A] = true;
		else if(!joystate.button[0] && Cntrlr[A])
			Cntrlr[A] = false;
		if (joystate.button[6])
		{keys[SELECT] = true;
		 done = true;}
	}

	if(draw && al_is_event_queue_empty(event_queue))
	{
		draw = false;
		//draw to buffer
		drawBackground(bg);
		drawPlanet(Planets, NUM_PLANETS);
		drawBullet(bullets, NUM_BULLETS);
		drawPulse(pulseAttack);
		drawEnemy(enemy, NUM_ENEMIES);
		drawPlayer(p1);
		al_draw_textf(font18, al_map_rgb(0,255,255), 10, 10, ALLEGRO_ALIGN_LEFT, "FPS: %d XP: %d/%d  Level: %d  player: %f,%f", framesPS, p1.expCur, p1.expNeeded, p1.level, p1.x, p1.y);
		drawHealth(p1);
		if(gameOver)
			al_draw_textf(font18, al_map_rgb(0,255,255), width/2, height/2, ALLEGRO_ALIGN_CENTRE, "Game Over.");
		al_flip_display();

		//clear buffer
		al_clear_to_color(al_map_rgb(0,0,0));

		framesCur++;
	}
			
}

al_destroy_display(display);
al_destroy_bitmap(bg.pic);
for(int i = 0; i < NUM_ENEMIES; i++)
{al_destroy_bitmap(enemy[i].pic);}
al_destroy_bitmap(pulseAttack.pic);
al_destroy_bitmap(p1.pic);
al_destroy_bitmap(Planets[0].pic);
al_destroy_bitmap(Planets[1].pic);
al_destroy_timer(LPS);
al_destroy_font(font18);
al_destroy_event_queue(event_queue);
 

return 0;
}

void initPlayer(Player1 &p1)
{
	p1.x = 80;
	p1.y = height / 2;
	p1.ID = PLAYER;
	p1.pic = al_load_bitmap("Spaceship.png");
	al_convert_mask_to_alpha(p1.pic, al_map_rgb(255, 0, 255));
	p1.picDir = 1;
	p1.picNum = 4;
	p1.picdelay = 0;
	p1.angle = 0;
	p1.health = 100;
	p1.mana = 50;
	p1.speed = 10;
	p1.expCur = 0;
	p1.expNeeded = 100;
	p1.boundx = 40;
	p1.boundy = 35;
	p1.level = 0;

}
void updatePlayer(Player1 &p1)
{
	p1.picdelay++;
	if(p1.picdelay == 8)
	{p1.picNum--; p1.picdelay = 0;}
	if(p1.picNum == 2) {p1.picNum = 4;}
	p1.angle = atan2((mousey - p1.y), (mousex - p1.x));
}
void movePlayerUp(Player1 &p1)
{
	if(p1.picDir != 0)
	{p1.picDir = 0;}
	p1.y -= p1.speed;
	mousey -= p1.speed;
	if(p1.y < 0) p1.y = 0;
}
void movePlayerDown(Player1 &p1)
{
	if(p1.picDir != 2)
	{p1.picDir = 2;}
	p1.y += p1.speed;
	mousey += p1.speed;
	if(p1.y + 30 > height) p1.y = height - 30;
}
void movePlayerLeft(Player1 &p1)
{
	if(p1.picDir != 1)
	{p1.picDir = 1;}
	p1.x -= p1.speed;
	mousex -= p1.speed;
	if(p1.x < 0) p1.x = 0;
}
void movePlayerRight(Player1 &p1)
{
	if(p1.picDir != 1)
	{p1.picDir = 1;}
	p1.x += p1.speed;
	mousex += p1.speed;
	if(p1.x + 30 > width) p1.x = width - 30;	
}
void drawPlayer(Player1 &p1)
{
	ALLEGRO_BITMAP *plchdr = al_create_bitmap(47, 41), *plchdr1 = al_create_bitmap(94, 82), *prev_bmp;
	prev_bmp = al_get_target_bitmap();
	al_set_target_bitmap(plchdr);
	al_draw_bitmap_region(p1.pic, p1.picNum * 47, p1.picDir * 41, 47, 41, 0, 0, 0);
	al_set_target_bitmap(plchdr1);
	al_draw_scaled_bitmap(plchdr, 0, 0, 47, 41, 0, 0, 94, 82, 0);
	al_set_target_bitmap(prev_bmp);
	al_draw_rotated_bitmap(plchdr1, 90, 41, p1.x, p1.y, p1.angle, 0);
	//DEBUGGING: bounding box for player
	//al_draw_rectangle(p1.x - p1.boundx, p1.y - p1.boundy, p1.x + p1.boundx, p1.y + p1.boundy, al_map_rgb(255,255,255), 4);
	al_destroy_bitmap(plchdr);
	al_destroy_bitmap(plchdr1);
}
void drawHealth(Player1 &p1)
{
	if(p1.health > 0)
	{
		float curHealth = (p1.health * 4) + 20;
		al_draw_filled_rectangle(20, 50, curHealth, 90, al_map_rgb(255, 0, 0));
	}
	float firstpoint = 20;
	float secondpoint = 0;
	for (int i = 1; i < 11; i++)
	{
		if(i != 1)
			firstpoint += 40;
		secondpoint = firstpoint + 40;
		al_draw_rectangle(firstpoint, 50, secondpoint, 90, al_map_rgb(255, 50, 50), 1);
	}
}

void initBullet(Bullet bullet[], int size)
{
	for(int i = 0; i < size; i++)
	{
		bullet[i].ID = BULLET; 
		bullet[i].speed = 15;
		bullet[i].destx = 0;
		bullet[i].desty = 0;
		bullet[i].distance = 0;
		bullet[i].velx = 0;
		bullet[i].vely = 0;
		bullet[i].live = false;}
	}
void drawBullet(Bullet bullet[], int size)
{
	for(int i = 0; i < size; i++)
	{
		if(bullet[i].live)
		{
			al_draw_line(bullet[i].x, bullet[i].y, bullet[i].x + bullet[i].velx, bullet[i].y + bullet[i].vely, al_map_rgb(0, 255, 0), 2);
		}
	}
}
void fireBullet(Bullet bullet[], int size, Player1 &p1)
{
	for(int i = 0; i < size; i++)
	{
		if(!bullet[i].live)
		{
			bullet[i].x = p1.x;
			bullet[i].y = p1.y;
			bullet[i].destx = mousex;
			bullet[i].desty = mousey;
			bullet[i].distance = sqrt((bullet[i].desty - bullet[i].y) * (bullet[i].desty - bullet[i].y) + (bullet[i].destx - bullet[i].x) * (bullet[i].destx - bullet[i].x));
			bullet[i].velx = bullet[i].speed * (bullet[i].destx - bullet[i].x) / bullet[i].distance;
			bullet[i].vely = bullet[i].speed * (bullet[i].desty - bullet[i].y) / bullet[i].distance;
			bullet[i].live = true; 
			break;
		}
	}
}
void updateBullet(Bullet bullet[], int size)
{
	for(int i = 0; i < size; i++)
	{
		if(bullet[i].live)
		{
			bullet[i].x += bullet[i].velx;
			bullet[i].y += bullet[i].vely;
			if(bullet[i].x > width || bullet[i].x < 0 || bullet[i].y > height || bullet[i].y < 0)
				bullet[i].live = false;
		}
	}
}
void collideBullet(Bullet bullet[], int bsize, Enemies enemy[], int csize, Player1 &p1)
{
	for(int i = 0; i < bsize; i++)
	{
		if(bullet[i].live)
		{
			for(int j = 0; j < csize; j++)
			{
				if(enemy[j].live)
				{
					if(bullet[i].x >= (enemy[j].x - enemy[j].boundx) &&
						bullet[i].x <= (enemy[j].x + enemy[j].boundx) &&
						bullet[i].y >= (enemy[j].y - enemy[j].boundy) &&
						bullet[i].y <= (enemy[j].y + enemy[j].boundy))
					{
						bullet[i].live = false;
						enemy[j].live = false;
						p1.expCur += enemy[j].size;
					}
				}

			}
		}
	}
}


void initPulse(Pulse &pulseAttack)
{
	pulseAttack.ID = BULLET;
	pulseAttack.pic = al_load_bitmap("Pulse.png");
	al_convert_mask_to_alpha(pulseAttack.pic, al_map_rgb(255, 0, 255));
	pulseAttack.picNum = 0;
	pulseAttack.picdelay = 0;
	pulseAttack.timer = 0;
	pulseAttack.spacing = 100;
	pulseAttack.destx = 0;
	pulseAttack.desty = 0;
	pulseAttack.velx = 0;
	pulseAttack.vely = 0;
	pulseAttack.distance = 600;
	pulseAttack.live = false;
}
void drawPulse(Pulse &pulseAttack)
{
	if(pulseAttack.live)
	{
		if(pulseAttack.timer < 4)
		{
			for(int i = 0; i < pulseAttack.picNum; i++)
			{
				ALLEGRO_BITMAP *plchdr = al_create_bitmap(15, 60), *plchdr1 = al_create_bitmap(240, 360), *prev_bmp;
				prev_bmp = al_get_target_bitmap();
				al_set_target_bitmap(plchdr);
				al_draw_bitmap_region(pulseAttack.pic, i * 15, 0, 15, 60, 0, 0, 0);
				al_set_target_bitmap(plchdr1);
				al_draw_scaled_bitmap(plchdr, 0, 0, 15, 60, 0, 0, 240, 360, 0);
				al_set_target_bitmap(prev_bmp);
				al_draw_rotated_bitmap(plchdr1, 80, 190, pulseAttack.x + (pulseAttack.velx * (i * 5)), pulseAttack.y + (pulseAttack.vely * (i * 5)), pulseAttack.angle, 0);
				//DEBUGGING: bounding box for pulse
				//al_draw_rectangle(pulseAttack.x, pulseAttack.y, pulseAttack.x, pulseAttack.y, al_map_rgb(255,255,255), 4);
				al_destroy_bitmap(plchdr);
				al_destroy_bitmap(plchdr1);
			}
		}
		else
		{
			for(int i = 0; i < pulseAttack.picNum; i++)
				{
					if(i == 0 && pulseAttack.timer >= 5 || i == 1 && pulseAttack.timer >= 6 || i == 2 && pulseAttack.timer >= 7 || i == 3 && pulseAttack.timer >= 8)
						continue;
					ALLEGRO_BITMAP *plchdr = al_create_bitmap(15, 60), *plchdr1 = al_create_bitmap(240, 360), *prev_bmp;
					prev_bmp = al_get_target_bitmap();
					al_set_target_bitmap(plchdr);
					al_draw_bitmap_region(pulseAttack.pic, i * 15, 0, 15, 60, 0, 0, 0);
					al_set_target_bitmap(plchdr1);
					al_draw_scaled_bitmap(plchdr, 0, 0, 15, 60, 0, 0, 240, 360, 0);
					al_set_target_bitmap(prev_bmp);
					al_draw_rotated_bitmap(plchdr1, 80, 190, pulseAttack.x + (pulseAttack.velx * (i * 5)), pulseAttack.y + (pulseAttack.vely * (i * 5)), pulseAttack.angle, 0);
					//DEBUGGING: bounding box for pulse
					//al_draw_rectangle(pulseAttack.x, pulseAttack.y, pulseAttack.x, pulseAttack.y, al_map_rgb(255,255,255), 4);
					al_destroy_bitmap(plchdr);
					al_destroy_bitmap(plchdr1);
				}

		}
	}
}
void firePulse(Pulse &pulseAttack, Player1 &p1)
{
	if(!pulseAttack.live)
		{
			pulseAttack.x = p1.x;
			pulseAttack.y = p1.y;
			pulseAttack.destx = mousex;
			pulseAttack.desty = mousey;
			pulseAttack.velx = pulseAttack.spacing * (pulseAttack.destx - pulseAttack.x) / pulseAttack.distance;
			pulseAttack.vely = pulseAttack.spacing * (pulseAttack.desty - pulseAttack.y) / pulseAttack.distance;
			pulseAttack.angle = atan2((mousey - p1.y), (mousex - p1.x));
			pulseAttack.timer = 0;
			pulseAttack.picNum = 0;
			pulseAttack.live = true; 
		}
}
void updatePulse(Pulse &pulseAttack, Player1 &p1)
{
	if(pulseAttack.live)
		{
			pulseAttack.picdelay++;
			pulseAttack.destx = mousex;
			pulseAttack.desty = mousey;
			pulseAttack.velx = pulseAttack.spacing * (pulseAttack.destx - pulseAttack.x) / pulseAttack.distance;
			pulseAttack.vely = pulseAttack.spacing * (pulseAttack.desty - pulseAttack.y) / pulseAttack.distance;
			pulseAttack.x = p1.x;
			pulseAttack.y = p1.y;
			pulseAttack.angle = atan2((mousey - p1.y), (mousex - p1.x));
			if(pulseAttack.picdelay == 2)
			{
				pulseAttack.picNum++;
				pulseAttack.picdelay = 0;
				pulseAttack.timer++;
			}
			if(pulseAttack.timer >= 8)
				pulseAttack.live = false;
		}
}
void collidePulse(Pulse &pulseAttack, Enemies enemy[], int csize, Player1 &p1)
{
	if(pulseAttack.live)
		{
			for(int j = 0; j < csize; j++)
			{
				if(enemy[j].live)
				{
					if(pulseAttack.x >= (enemy[j].x - enemy[j].boundx) &&
						pulseAttack.x <= (enemy[j].x + enemy[j].boundx) &&
						pulseAttack.y >= (enemy[j].y - enemy[j].boundy) &&
						pulseAttack.y <= (enemy[j].y + enemy[j].boundy))
					{
						enemy[j].live = false;
						p1.expCur += enemy[j].size;
					}
				}

			}
		}
}

void initEnemy(Enemies enemy[], int size)
{
	for(int i = 0; i < size; i++)
	{
		enemy[i].ID = ENEMY;
		enemy[i].pic = NULL;
		enemy[i].speed = 4; 
		enemy[i].health = 50;
		enemy[i].size = 0;
		enemy[i].live = false;
		enemy[i].x;
		enemy[i].y;
		enemy[i].boundx = 20;
		enemy[i].boundy = 20;
		enemy[i].expGranted = 20;
	}
}
void drawEnemy(Enemies enemy[], int size)
{
	for(int i = 0; i < size; i++)
	{
		if(enemy[i].live)
		{
			al_draw_bitmap(enemy[i].pic, enemy[i].x, enemy[i].y, 0);
		}
		//DEBUGGING: bounding box for player
		//if(i == 0)
		//al_draw_rectangle(enemy[i].x - enemy[i].boundx, enemy[i].y - enemy[i].boundy, enemy[i].x + enemy[i].boundx, enemy[i].y + enemy[i].boundy, al_map_rgb(255,255,255), 4);
	}
}
void startEnemy(Enemies enemy[], int size)
{
	for(int i = 0; i < size; i++)
	{
		if(!enemy[i].live)
			if(rand() % 200 == 0)
			{
				enemy[i].live = true;
				enemy[i].x = width;
				enemy[i].size = rand() % 60 + 40;
				enemy[i].boundx = enemy[i].size / 2;
				enemy[i].boundy = enemy[i].size / 2;
				enemy[i].y = 30 + rand() % (height - 60);


				ALLEGRO_BITMAP *prev_target, *loaded_pic;
				int rnd = rand() % 2;
				if(rnd == 1)
					loaded_pic = al_load_bitmap("meteor1.png");
				else
					loaded_pic = al_load_bitmap("meteor2.png");
				
				enemy[i].pic = al_create_bitmap(enemy[i].size, enemy[i].size);
			
				prev_target = al_get_target_bitmap();
				al_set_target_bitmap(enemy[i].pic);
				al_draw_scaled_bitmap(loaded_pic, 0, 0, 64, 64, 0, 0, enemy[i].size, enemy[i].size, 0);
				al_set_target_bitmap(prev_target);
				al_destroy_bitmap(loaded_pic);

				break;
			}

	}
}
void updateEnemy(Enemies enemy[], int size)
{
	for(int i = 0; i < size; i++)
	{
		if(enemy[i].live)
		{
			enemy[i].x -= enemy[i].speed;

			if(enemy[i].x < 0)
			{
				enemy[i].live = false;
			}
		}

	}
}
void collideComet(Enemies enemy[], int csize, Player1 &p1)
{
	for(int i = 0; i < csize; i++)
	{
		if(enemy[i].live)
		{
			if(enemy[i].x - enemy[i].boundx < p1.x + p1.boundx &&
				enemy[i].x + enemy[i].boundx > p1.x - p1.boundx &&
				enemy[i].y - enemy[i].boundy < p1.y + p1.boundy &&
				enemy[i].y + enemy[i].boundy > p1.y - p1.boundy)
			{
				if(p1.health > 0)
					p1.health -= 10;
				enemy[i].live = false;
			}
		}
	}
}

int returnRand(int num)
{
	int ranNum = 0;
	while(ranNum > mousex - num)
				ranNum = rand();
	return ranNum;
}

void initPlanet(Image Planets[], int size)
{
	for(int i = 0; i < 2; i++)
	{
		Planets[i].ID = IMAGE;
		Planets[i].pic = NULL;
		if( i == 0)
		{
			Planets[i].size = 200;
			Planets[i].pic = al_create_bitmap(Planets[i].size, Planets[i].size);
			Planets[i].speed = 2;
			Planets[i].x = width;
			Planets[i].y = rand() % (height - 100) + 30;

			ALLEGRO_BITMAP *prev_target, *loaded_pic = al_load_bitmap("planet2.png");
			
			prev_target = al_get_target_bitmap();
			al_set_target_bitmap(Planets[i].pic);
			al_draw_scaled_bitmap(loaded_pic, 0, 0, al_get_bitmap_width(loaded_pic), al_get_bitmap_height(loaded_pic), 0, 0, Planets[i].size, Planets[i].size, 0);
			al_set_target_bitmap(prev_target);
			al_destroy_bitmap(loaded_pic);
					}
		else
		{
			Planets[i].size = 500;
			Planets[i].pic = al_create_bitmap(Planets[i].size, Planets[i].size);
			Planets[i].speed = 3;
			Planets[i].x = width;
			Planets[i].y = rand() % (height - 300) + 30;

			ALLEGRO_BITMAP *prev_target, *loaded_pic = al_load_bitmap("neptune_lg.jpg");
			al_convert_mask_to_alpha(loaded_pic, al_map_rgb(0,0,0));
			
			prev_target = al_get_target_bitmap();
			al_set_target_bitmap(Planets[i].pic);
			al_draw_scaled_bitmap(loaded_pic, 0, 0, al_get_bitmap_width(loaded_pic), al_get_bitmap_height(loaded_pic), 0, 0, Planets[i].size, Planets[i].size, 0);
			al_set_target_bitmap(prev_target);
			al_destroy_bitmap(loaded_pic);
		}
	}

}
void drawPlanet(Image Planets[], int size)
{
	for(int i = 0; i < 2; i++)
	{
		al_draw_bitmap(Planets[i].pic, Planets[i].x, Planets[i].y, 0);
	}
}
void updatePlanet(Image Planets[], int size)
{
	for(int i = 0; i < 2; i++)
	{
		if (Planets[i].x > 0 - Planets[i].size)
		{Planets[i].x -= Planets[i].speed;}
		else
		{Planets[i].x = width;
		 Planets[i].y = rand() % (height - 500) + 30;
		}
	}
}


void initBackground(Background &bg)
{
	bg.ID = IMAGE;
	bg.pic = al_create_bitmap(width, height);
	bg.width = width;
	bg.height = height;
	bg.placement = 0;

	ALLEGRO_BITMAP *prev_target, *loaded_pic = al_load_bitmap("space_bg.jpg");
	prev_target = al_get_target_bitmap();

	al_set_target_bitmap(bg.pic);
	al_draw_scaled_bitmap(loaded_pic, 0, 0, al_get_bitmap_width(loaded_pic), al_get_bitmap_height(loaded_pic), 0, 0, width, height, 0);
	al_set_target_bitmap(prev_target);
	al_destroy_bitmap(loaded_pic);
}
void drawBackground(Background &bg)
{
	ALLEGRO_BITMAP *bgplaceholder = al_create_bitmap(1600, 1000), *prev_target;
	prev_target = al_get_target_bitmap();
	al_set_target_bitmap(bgplaceholder);
		
	al_draw_bitmap_region(bg.pic, bg.placement, 0, (1600 - bg.placement), 1000, 0, 0, 0);
	al_draw_bitmap_region(bg.pic, 0, 0, bg.placement, 1000, 1600 - bg.placement, 0, 0);
	al_set_target_bitmap(prev_target);
	al_draw_scaled_bitmap(bgplaceholder, 0, 0, 1600, 1000, 0, 0, width, height, 0);
	al_destroy_bitmap(bgplaceholder);
}
void updateBackground(Background &bg)
{
	if(bg.placement < 1599)
		bg.placement += 1;
	else
		bg.placement = 0;
}

