#include <allegro5/allegro.h>
#include <allegro5/allegro_image.h>
#include <allegro5/allegro_font.h>
#include <allegro5/allegro_ttf.h>
#include <allegro5/allegro_primitives.h>
#include <cmath> 
#include "Header.h"
#include <iostream>

using namespace std;

//Prototypes
void RedrawEnvironment(ALLEGRO_BITMAP *&environment, ALLEGRO_BITMAP *&water, ALLEGRO_BITMAP *&sand, ALLEGRO_BITMAP *&stone, ALLEGRO_BITMAP *&grass, ALLEGRO_BITMAP *&grassSide, ALLEGRO_BITMAP *&sandSide, int waterX,  ALLEGRO_BITMAP *&tree, Player &player, Tree trees[], Block (&blocks)[125][125],bool waterdraw, bool &waterUpdateNeeded);
void DrawScreen(ALLEGRO_DISPLAY *&display, Player &player, ALLEGRO_BITMAP *&screen, ALLEGRO_BITMAP *&environment, ALLEGRO_BITMAP *&overlay);
void DrawInventory(Inventory inventboxes[], ALLEGRO_BITMAP *selficon, ALLEGRO_DISPLAY *display, ALLEGRO_BITMAP *itemBox);
void RedrawOverlay(ALLEGRO_BITMAP *&overlay, ALLEGRO_BITMAP *&clouds, ALLEGRO_BITMAP *&playerSprite, Player &player, int cloud1x, int cloud2x, Mouse maincurser);
void HitDetect(Player &player);

Block blocks[125][125];

int main ()
{
	//Initializations
	al_init();
	al_install_keyboard();
	al_install_mouse();

	srand(time(NULL));
	

	//Game Variables
	bool done = false;
	bool draw = true;
	bool waterdraw = false;
	bool inventoryon = false;
	bool waterUpdateNeeded = true;

	double fps = 0; 
	int frames_done = 0; 
	double old_time = al_get_time();

	int waterX = 0;
	int cloud1x = 0;
	int cloud2x = 4000;
	int itemNumber = 0;

	//Allegro Variables
	ALLEGRO_DISPLAY *display = al_create_display(WIDTH, HEIGHT);
	al_init_image_addon(); 
	al_init_primitives_addon();
	al_init_font_addon();
	al_init_ttf_addon();
	al_set_new_bitmap_flags(ALLEGRO_VIDEO_BITMAP);
	ALLEGRO_EVENT_QUEUE *queue = al_create_event_queue();
	ALLEGRO_TIMER *mainTimer = al_create_timer(1.0/FPS);
	ALLEGRO_TIMER *waterTimer = al_create_timer(1.0/WATER_FPS);
	ALLEGRO_BITMAP *tilemap = al_create_bitmap(125, 125);
	ALLEGRO_BITMAP *environment = al_create_bitmap(al_get_bitmap_width(tilemap) * 32, al_get_bitmap_height(tilemap)*32);
	ALLEGRO_BITMAP *overlay = al_create_bitmap(al_get_bitmap_width(tilemap) * 32, al_get_bitmap_height(tilemap)*32);
	ALLEGRO_BITMAP *grass = al_load_bitmap("grassblock.png");
	ALLEGRO_BITMAP *sand = al_load_bitmap("sandblock.png");
	ALLEGRO_BITMAP *water = al_load_bitmap("waterblock.png");
	ALLEGRO_BITMAP *stone = al_load_bitmap("stone.png");
	ALLEGRO_BITMAP *tree = al_load_bitmap("tree.png");
	ALLEGRO_BITMAP *grassSide = al_load_bitmap("sidegrass.png");
	ALLEGRO_BITMAP *grassTwoSides = al_load_bitmap("grasstwosides.png");
	ALLEGRO_BITMAP *sandSide = al_load_bitmap("sidesand.png");
	ALLEGRO_BITMAP *clouds = al_load_bitmap("clouds.png");
	ALLEGRO_BITMAP *inventorybox = al_load_bitmap("inventorybox.png");
	ALLEGRO_BITMAP *selficon = al_load_bitmap("selficon.png");
	ALLEGRO_BITMAP *woodicon = al_load_bitmap("woodicon.png");
	ALLEGRO_FONT *font16 = al_load_ttf_font("arial.ttf", 16, NULL);
	ALLEGRO_COLOR grasscolor = al_map_rgb_f(0,1,0);
	ALLEGRO_COLOR watercolor = al_map_rgb_f(0,0,1);
	ALLEGRO_COLOR sandcolor = al_map_rgb_f(1,1,0);
	ALLEGRO_BITMAP *screen = al_create_bitmap(WIDTH, HEIGHT);
	ALLEGRO_BITMAP *playerSprite = al_load_bitmap("player.png");
	
	al_hide_mouse_cursor(display);
	al_clear_to_color(al_map_rgb_f(1,1,1));
	al_draw_text(font16, al_map_rgb_f(0,0,0), WIDTH/2, HEIGHT/2, ALLEGRO_ALIGN_CENTRE, "LOADING"); 
	al_flip_display();

	Player player;
	player.x = player.y = 1984;
	player.ID = PLAYER;
	player.speed = 3;
	player.direction = DOWN;
	player.imageX = 32;
	al_set_window_position(display, 1400, 0);

	Mouse maincurser; 
	maincurser.x = maincurser.y = -1;
	maincurser.graphic = al_create_bitmap(10, 10);
	al_set_target_bitmap(maincurser.graphic);
	al_draw_filled_circle(al_get_bitmap_width(maincurser.graphic)/2, al_get_bitmap_height(maincurser.graphic)/2, 3, al_map_rgb_f(0,0,1));

	Inventory readyBoxes[ITEM_AMOUNT];
	for (int i = 0; i < ITEM_AMOUNT; i++)
	{
		//readyBoxes[i].box = al_load_bitmap("inventorybox.png");
		readyBoxes[i].y = i * al_get_bitmap_height(inventorybox);
	}
	readyBoxes[0].Item = SELF;
	readyBoxes[1].Item = NONE;
	readyBoxes[2].Item = NONE;
	readyBoxes[3].Item = NONE;
	readyBoxes[4].Item = NONE;

	al_set_target_bitmap(tilemap);
	al_clear_to_color(al_map_rgb_f(0,0,1));
	al_draw_filled_circle(al_get_bitmap_width(tilemap)/2, al_get_bitmap_height(tilemap)/2, al_get_bitmap_width(tilemap)/2 - 6, al_map_rgb_f(1,1,0)); 
	al_draw_filled_circle(al_get_bitmap_width(tilemap)/2, al_get_bitmap_height(tilemap)/2, al_get_bitmap_width(tilemap)/2 - 10, al_map_rgb_f(0,1,0)); 

	Pond ponds[NUM_PONDS];
	
	for (int i = 0; i < NUM_PONDS; i++)
	{
		ponds[i].radius = rand()%10 + 1;
		ponds[i].x = (rand()%73)+26;
		ponds[i].y = (rand()%73)+26;
		al_draw_filled_circle(ponds[i].x, ponds[i].y, ponds[i].radius, al_map_rgb_f(0,0,1));
	}
	
	//Register event sources
	al_register_event_source(queue, al_get_keyboard_event_source());
	al_register_event_source(queue, al_get_mouse_event_source());
	al_register_event_source(queue, al_get_timer_event_source(mainTimer));
	al_register_event_source(queue, al_get_timer_event_source(waterTimer));

	//Create Environment
	for (int i = 0; i < al_get_bitmap_width(tilemap); i++)
	{
		for (int j = 0; j < al_get_bitmap_height(tilemap); j++)
		{
			blocks[i][j].x = i * 32;
			blocks[i][j].y = j * 32;
			blocks[i][j].Item = NONE;
			//If water
			if(al_get_pixel(tilemap, i, j).b == 1 && al_get_pixel(tilemap, i, j).r == 0 && al_get_pixel(tilemap, i, j).g == 0)
			{	
				blocks[i][j].ID = WATER;
				blocks[i][j].strength = 0;
			}
			//If sand
			else if (al_get_pixel(tilemap, i, j).b == 0 && al_get_pixel(tilemap, i, j).r == 1 && al_get_pixel(tilemap, i, j).g == 1)
			{
				blocks[i][j].ID = SAND;
				blocks[i][j].strength = 20;
			}
			//If grass
			else 
			{
				blocks[i][j].ID = GRASS;
				blocks[i][j].strength = 50;
				if(rand()%50 == 1)
				{
					blocks[i][j].ID = STONE;
					blocks[i][j].strength = 200;
				}
			}
		}
	}

	al_set_target_bitmap(environment); 

	//Draw Tiles
	for(int i = 0; i < 125; i++)
	{
		for(int j = 0; j < 125; j++)
		{	
			switch(blocks[i][j].ID)
			{
			case WATER:
				al_draw_filled_rectangle(blocks[i][j].x, blocks[i][j].y, blocks[i][j].x + 32, blocks[i][j].y + 32, al_map_rgb(5, 11, 226));
				break;
			case SAND:
				al_draw_bitmap(sand, blocks[i][j].x, blocks[i][j].y, NULL);
				break;
			case STONE:
				al_draw_bitmap(stone, blocks[i][j].x, blocks[i][j].y, NULL);
				break;
			default: al_draw_bitmap(grass, blocks[i][j].x, blocks[i][j].y, NULL);			
			}

			if(blocks[i+1][j].ID == WATER &&
						blocks[i][j+1].ID == WATER &&
						blocks[i-1][j].ID == WATER &&
						blocks[i][j-1].ID == WATER &&
						blocks[i+1][j+1].ID == WATER &&
						blocks[i-1][j-1].ID == WATER &&
						blocks[i-1][j+1].ID == WATER &&
						blocks[i+1][j-1].ID == WATER)
			{
				blocks[i][j].surrounded = true;
			}
			else {blocks[i][j].surrounded = false;}
		}
	}

	//Draw Edges
	for(int i = 0; i < 125; i++)
	{
		for(int j = 0; j < 125; j++)
		{
			if(blocks[i][j].ID == GRASS)
			{
				//Top
				if(blocks[i][j-1].ID != GRASS)
				{
					al_draw_bitmap(grassSide, blocks[i][j].x, blocks[i][j].y - 4, NULL);
				}
				//Bottom
				if (blocks[i][j+1].ID != GRASS)
				{
					al_draw_bitmap(grassSide, blocks[i][j].x, blocks[i][j].y + al_get_bitmap_height(grass), ALLEGRO_FLIP_VERTICAL);
				}
				//Left
				if (blocks[i-1][j].ID != GRASS)
				{
					al_draw_rotated_bitmap(grassSide, 0, 0, blocks[i][j].x, blocks[i][j].y, PI/2, ALLEGRO_FLIP_VERTICAL); 
				}
				//Right
				if (blocks[i+1][j].ID != GRASS)
				{
					al_draw_rotated_bitmap(grassSide, 0, al_get_bitmap_height(grassSide), blocks[i][j].x + al_get_bitmap_width(grass), blocks[i][j].y, PI/2, NULL); 
				}
			}
			else if (blocks[i][j].ID == SAND)
			{
				//Top
				if(blocks[i][j-1].ID == WATER)
				{
					al_draw_bitmap(sandSide, blocks[i][j].x, blocks[i][j].y - 4, NULL);
				}
				//Bottom
				if (blocks[i][j+1].ID == WATER)
				{
					al_draw_bitmap(sandSide, blocks[i][j].x, blocks[i][j].y + al_get_bitmap_height(grass), ALLEGRO_FLIP_VERTICAL);
				}
				//Left
				if (blocks[i-1][j].ID == WATER)
				{
					al_draw_rotated_bitmap(sandSide, 0, 0, blocks[i][j].x, blocks[i][j].y, PI/2, ALLEGRO_FLIP_VERTICAL); 
				}
				//Right
				if (blocks[i+1][j].ID == WATER)
				{
					al_draw_rotated_bitmap(sandSide, 0, al_get_bitmap_height(grassSide), blocks[i][j].x + al_get_bitmap_width(grass), blocks[i][j].y, PI/2, NULL); 
				}
			}
		}
	}

	Tree trees[TREE_DENSITY];
	for(int i = 0; i < TREE_DENSITY; i++)
	{
		trees[i].live = false;
		trees[i].strength = 100;
		trees[i].x = (rand()%(al_get_bitmap_width(environment))/32)*32;
		trees[i].y = (rand()%(al_get_bitmap_height(environment))/32)*32;
		blocks[trees[i].x/32][trees[i].y/32].Item = TREE; 
		if(blocks[trees[i].x/32][trees[i].y/32].ID == GRASS)
		{
			trees[i].live = true;
		}
		if(trees[i].live && trees[i].x > player.x - WIDTH/2 && trees[i].x < player.x + WIDTH/2 && trees[i].y > player.y - HEIGHT/2 && trees[i].y < player.y + HEIGHT/2)
			al_draw_bitmap(tree, trees[i].x, trees[i].y, NULL);
	}

	al_start_timer(mainTimer);
	al_start_timer(waterTimer);
	while(!done)
	{
		ALLEGRO_EVENT ev;
		al_wait_for_event(queue, &ev);
		if(ev.type == ALLEGRO_EVENT_TIMER)
		{
			if(ev.timer.source == mainTimer)
			{
				draw = true;
				if(inputs[W]){player.y -= player.speed; player.direction = UP; player.imageX -= 32;}
				else if(inputs[S]){player.y += player.speed; player.direction = DOWN; player.imageX -= 32;}
				else if(inputs[A]){player.x -= player.speed; player.direction = LEFT; player.imageX -= 32;}
				else if(inputs[D]){player.x += player.speed; player.direction = RIGHT; player.imageX -= 32;}

				
				if(player.imageX < 0){player.imageX = 64;}

				//Bounds checking
				if (player.x > al_get_bitmap_width(environment)){player.x = al_get_bitmap_width(environment);}
				else if (player.x < 0){player.x = 0;}
				if (player.y < 0){player.y = 0;}
				else if (player.y > al_get_bitmap_height(environment)){player. y = al_get_bitmap_height(environment);}
			
				HitDetect(player);
				cloud1x -= 1;
				cloud2x -= 1;
				if(cloud1x < -4000){cloud1x = 4000;}
				if(cloud2x < -4000){cloud2x = 4000;}
			}

			else if (ev.timer.source == waterTimer)
			{
				waterdraw = true;
				waterUpdateNeeded = true;
				waterX += 32;
				if (waterX > 96){waterX = 0;} 
			}
		}

		else if (ev.type == ALLEGRO_EVENT_KEY_DOWN)
		{
			switch (ev.keyboard.keycode)
			{
			case ALLEGRO_KEY_W:
				inputs[W] = true;
				break;
			case ALLEGRO_KEY_S:
				inputs[S] = true;
				break;
			case ALLEGRO_KEY_A:
				inputs[A] = true;
				break;
			case ALLEGRO_KEY_D:
				inputs[D] = true;
				break;
			case ALLEGRO_KEY_SPACE:
				inputs[SPACE] = true;
				break;
			case ALLEGRO_KEY_I:
				inputs[I] = true;
				inventoryon = !inventoryon;

				break;
			case ALLEGRO_KEY_ESCAPE:
				done = true;
				break;
			}
		}
		else if (ev.type == ALLEGRO_EVENT_KEY_UP)
		{
			switch (ev.keyboard.keycode)
			{
			case ALLEGRO_KEY_W:
				inputs[W] = false;
				break;
			case ALLEGRO_KEY_S:
				inputs[S] = false;
				break;
			case ALLEGRO_KEY_A:
				inputs[A] = false;
				break;
			case ALLEGRO_KEY_D:
				inputs[D] = false;
				break;
			case ALLEGRO_KEY_SPACE:
				inputs[SPACE] = false;
				break;
			case ALLEGRO_KEY_I:
				inputs[I] = false;
				break;
			}
		}

		else if (ev.type == ALLEGRO_EVENT_MOUSE_AXES)
		{
			maincurser.x = ev.mouse.x;
			maincurser.y = ev.mouse.y;
		}

		else if (ev.type == ALLEGRO_EVENT_MOUSE_BUTTON_DOWN)
		{

		}

		if(draw && al_is_event_queue_empty(queue))
		{
			//-------------------FPS--------------------------
			double game_time = al_get_time(); 
			if(game_time - old_time >= 1.0) 
			{ 
				fps = frames_done / (game_time - old_time); 
				frames_done = 0; old_time = game_time; 
			} 
			frames_done++;
			cout << fps << endl;
			//--------------------------------------------------
			draw = false;
			//Redraw
			RedrawEnvironment(environment, water, sand, stone, grass, grassSide, sandSide, waterX, tree, player, trees, blocks, waterdraw, waterUpdateNeeded);
			RedrawOverlay(overlay, clouds, playerSprite, player, cloud1x, cloud2x, maincurser);

			//Draw Camera/HUD
			DrawScreen(display, player, screen, environment, overlay);

			//if(inventoryon){DrawInventory(readyBoxes, selficon, display, inventorybox);}
			al_draw_bitmap(maincurser.graphic, maincurser.x - al_get_bitmap_width(maincurser.graphic)/2, 
				maincurser.y - al_get_bitmap_height(maincurser.graphic)/2, NULL);

			al_flip_display();
			al_clear_to_color(al_map_rgb_f(0,0,0));
		}
	}

	//Deallocate
	al_destroy_display(display);
	al_destroy_event_queue(queue);
	al_destroy_timer(mainTimer);
	al_destroy_timer(waterTimer);
	al_destroy_bitmap(tilemap);
	al_destroy_bitmap(environment);
	al_destroy_bitmap(overlay);
	al_destroy_bitmap(grass);
	al_destroy_bitmap(water);
	al_destroy_bitmap(sand);
	al_destroy_bitmap(stone);
	al_destroy_bitmap(playerSprite);
	al_destroy_bitmap(tree);
	al_destroy_bitmap(grassSide);
	al_destroy_bitmap(sandSide);
	al_destroy_bitmap(grassTwoSides);
	al_destroy_bitmap(clouds);
	al_destroy_bitmap(inventorybox);
	al_destroy_bitmap(selficon);
	al_destroy_bitmap(woodicon);
	al_destroy_font(font16);
	al_destroy_bitmap(screen);
}

void RedrawEnvironment(ALLEGRO_BITMAP *&environment, ALLEGRO_BITMAP *&water, ALLEGRO_BITMAP *&sand, ALLEGRO_BITMAP *&stone, ALLEGRO_BITMAP *&grass, ALLEGRO_BITMAP *&grassSide, ALLEGRO_BITMAP *&sandSide, int waterX,  ALLEGRO_BITMAP *&tree, Player &player, Tree trees[], Block (&blocks)[125][125],bool waterdraw, bool &waterUpdateNeeded)
{
	al_set_target_bitmap(environment);
	int xIndex = (player.x - WIDTH/2) / 32;
	int yIndex = (player.y - HEIGHT/2) / 32;

	for(int i = xIndex; i < xIndex + (WIDTH/32); i++)
	{
		for(int j = yIndex; j < yIndex + (HEIGHT/32); j++)
		{
			if(blocks[i][j].surrounded)
			{
				al_draw_bitmap_region(water, waterX, 0, 32, 32, blocks[i][j].x, blocks[i][j].y, NULL);
			}
		}
	}
}

void DrawScreen(ALLEGRO_DISPLAY *& display, Player &player, ALLEGRO_BITMAP *&screen, ALLEGRO_BITMAP *&environment, ALLEGRO_BITMAP *&overlay)
{
	al_set_target_bitmap(al_get_backbuffer(display));
	al_draw_bitmap_region(environment, player.x - WIDTH/2, player.y - HEIGHT/2, WIDTH, HEIGHT, 0, 0, NULL);
	al_draw_bitmap_region(overlay, player.x - WIDTH/2, player.y - HEIGHT/2, WIDTH, HEIGHT, 0, 0, NULL);
}

void RedrawOverlay(ALLEGRO_BITMAP *&overlay, ALLEGRO_BITMAP *&clouds,  ALLEGRO_BITMAP *&playerSprite, Player &player, int cloud1x, int cloud2x, Mouse maincurser)
{
	al_set_target_bitmap(overlay);	
	al_clear_to_color(al_map_rgba_f(0,0,0,0));
	al_draw_bitmap_region(playerSprite, 0, player.direction, 26, 26, player.x - 13, player.y - 13, NULL);
	//al_draw_filled_circle(player.x, player.y, 3, al_map_rgb_f(1,0,1));
	//al_draw_bitmap_region(clouds, , , WIDTH, HEIGHT, 0, 0, NULL);
	//al_draw_bitmap(clouds, cloud2x, 0, NULL);	
}

void DrawInventory(Inventory inventboxes[], ALLEGRO_BITMAP *selficon, ALLEGRO_DISPLAY *display, ALLEGRO_BITMAP *itemBox)
{
	for (int i = 0; i < ITEM_AMOUNT; i++)
	{
		al_set_target_bitmap(itemBox);
		switch(inventboxes[i].Item)
		{
		case SELF:
			al_draw_bitmap(selficon, 0, 0, NULL);
			break;
		}
		al_set_target_bitmap(al_get_backbuffer(display)); 
		al_draw_bitmap(itemBox, 0, inventboxes[i].y, NULL);
	}
}

void HitDetect(Player &player)
{
	int index1 = player.x/32;
	int index2 = player.y/32;

	switch (player.direction)
	{
	case UP:
		index2 = (player.y - 13)/32;
		if (blocks[index1][index2].ID == WATER || blocks[index1][index2].Item == TREE)
		{
			player.y = blocks[index1][index2].y + 32 + 13 + 1;
		}
		break;
	case DOWN:
		index2 = (player.y + 13)/32;
		if (blocks[index1][index2].ID == WATER || blocks[index1][index2].Item == TREE)
		{
			player.y = blocks[index1][index2].y - 13 - 1;
		}
		break;
	case LEFT:
		index1 = (player.x - 13)/32;
		if (blocks[index1][index2].ID == WATER || blocks[index1][index2].Item == TREE)
		{
			player.x = blocks[index1][index2].x + 32 + 13 + 1;
		}
		break;
	case RIGHT:
		index1 = (player.x + 13)/32;
		if (blocks[index1][index2].ID == WATER || blocks[index1][index2].Item == TREE)
		{
			player.x = blocks[index1][index2].x - 13 - 1;
		}
		break;
	}
	
}