#pragma once
#ifndef __ALLEGRO_FLARE_TEXT_OBJECT_HEADER
#define __ALLEGRO_FLARE_TEXT_OBJECT_HEADER



#include <allegro5/allegro.h>
#include <allegro5/allegro_font.h>
#include <allegro5/allegro_ttf.h>
#include <allegro5/allegro_color.h>


#include "font_bin.h"
#include "vec2d.h"
#include "useful.h"
#include "object2d.h"

//#include <allegro_flare/animation.h>

#include <string>

//extern int SCREEN_W, SCREEN_H;



class Text : public object2d
{
private:
	static Text *dummy;

public:
	std::string str;
	ALLEGRO_FONT *_font;

	static Text *get_dummy()
	{
		if (!dummy) dummy = new Text("");
		return dummy;
	}

public:
	Text(std::string str="") : object2d(0,0,200,30), str(str), _font(NULL)
	{
		text(str);
	}
	inline Text &clean()
	{
		if (_placement) _placement->clear();
		if (_appearance) _appearance->clear();
		str = "";
		_font = NULL;
		*_h = 0;
		*_w = 0;
		return *this;
	}
	inline Text &text(std::string str)
	{
		if (str == this->str) return *this;

		this->str = str;
		if (_font)
		{
			*_w = al_get_text_width(_font, str.c_str());
			*_h = al_get_font_line_height(_font);
		}
		return *this;
	}
	inline Text &align(float x, float y) { object2d::align(x, y); return *this; }
	inline Text &position(float x, float y) { object2d::position(x, y); return *this; }
	inline Text &anchor(float x, float y) { object2d::anchor(x, y); return *this; }
	inline Text &scale(float x, float y) { object2d::scale(x, y); return *this; }
	inline Text &scale(float s) { object2d::scale(s); return *this; }
	inline Text &opacity(float opacity) { object2d::opacity(opacity); return *this; }
	inline Text &font(ALLEGRO_FONT *font)
	{
		if (_font == font) return *this;
		_font = font;
		*_h = al_get_font_line_height(_font);
		*_w = al_get_text_width(_font, str.c_str());
		return *this;
	}
	inline Text &color(ALLEGRO_COLOR color) { object2d::color(color); return *this; }
	inline Text &color(const char *color) { object2d::color(color); return *this; }

	ALLEGRO_BITMAP *create_render()
	{
		ALLEGRO_BITMAP *img = NULL;
		ALLEGRO_STATE state;
		if (!(*_w>=1.0 && *_h>=1.0)) return NULL;

		img = al_create_bitmap(*_w, *_h);
		al_store_state(&state, ALLEGRO_STATE_TARGET_BITMAP);
		al_set_target_bitmap(img);
		al_clear_to_color(al_map_rgba_f(0,0,0,0));
		al_draw_text(_font, (_appearance)?color::color(_appearance->color, _appearance->opacity):al_map_rgba_f(1,1,1,1), 0, 0, NULL, str.c_str());
		al_restore_state(&state);
		return img;
	}
	inline Text &draw()
	{
		if (_placement) _placement->start_transform();
 		if (_font) al_draw_text(_font, (_appearance)?color::color(_appearance->color, _appearance->opacity):al_map_rgba_f(1,1,1,1), 0, 0, NULL, str.c_str());
		if (_placement) _placement->restore_transform();
		return *this;
	}
};



inline Text &text(std::string str)
{
	Text::get_dummy()->clean().text(str);
	return *Text::get_dummy();
}



#endif
