

#include "screen.h"
#include <allegro5/allegro_color.h>
#include "display.h"



void Screen::on_events(ALLEGRO_EVENT *ev)
{
	for (unsigned i=0; i<screens.size(); i++)
		//if (instance[i]->active && instance[i]->timer_func)
			screens[i]->on_event(ev);
}


#include <iostream>
void Screen::primary_timer_funcs()
{
	// humm... this should be rethought but it works for now.

	// do screens with NULL displays first
	for (unsigned i=0; i<screens.size(); i++)
	{
		if (screens[i]->display == NULL) screens[i]->primary_timer_func();
	}

	// then do screens in order sorted by displays.
	for (unsigned d=0; d<Display::displays.size(); d++)
	{
		Display::displays[d]->set_as_target_bitmap(); // < THIS LINE HAS BEEN COMMENTED OUT 
													  // since the discovery that it doesn't
													  // play nicely with 3D and projections
		al_clear_to_color(Display::displays[d]->_background_color);
		for (unsigned i=0; i<screens.size(); i++)
		{
			if (screens[i]->display == Display::displays[d])
			{
				Display::displays[d]->set_as_target_bitmap(); // < THIS LINE HAS BEEN COMMENTED OUT 
															  // since the discovery that it doesn't
															  // play nicely with 3D and projections
				screens[i]->primary_timer_func();
			}
		}
		Display::displays[d]->flip();
	}
}



void Screen::timer_funcs()
{
	for (unsigned i=0; i<screens.size(); i++)
		screens[i]->timer_func();
}



void Screen::display_switch_in_funcs()
{
	for (unsigned d=0; d<Display::displays.size(); d++)
	{
		for (unsigned i=0; i<screens.size(); i++)
		{
			if (screens[i]->display == NULL || screens[i]->display == Display::displays[d])
				screens[i]->display_switch_in_func();
		}
	}
}



void Screen::display_switch_out_funcs()
{
	for (unsigned d=0; d<Display::displays.size(); d++)
	{
		for (unsigned i=0; i<screens.size(); i++)
		{
			if (screens[i]->display == NULL || screens[i]->display == Display::displays[d])
				screens[i]->display_switch_out_func();
		}
	}
}



void Screen::key_down_funcs()
{
	for (unsigned i=0; i<screens.size(); i++)
		//if (instance[i]->input_active)
			screens[i]->key_down_func();
}


void Screen::key_up_funcs()
{
	for (unsigned i=0; i<screens.size(); i++)
		//if (instance[i]->input_active)
			screens[i]->key_up_func();
}


void Screen::key_char_funcs()
{
	for (unsigned i=0; i<screens.size(); i++)
		//if (instance[i]->input_active)
			screens[i]->key_char_func();
}


void Screen::mouse_axes_funcs()
{
	for (unsigned i=0; i<screens.size(); i++)
		//if (instance[i]->input_active)
			screens[i]->mouse_axes_func();
}


void Screen::mouse_down_funcs()
{
	for (unsigned i=0; i<screens.size(); i++)
		//if (instance[i]->input_active)
			screens[i]->mouse_down_func();
}


void Screen::mouse_up_funcs()
{
	for (unsigned i=0; i<screens.size(); i++)
		//if (instance[i]->input_active)
			screens[i]->mouse_up_func();
}


void Screen::joy_axis_funcs()
{
	for (unsigned i=0; i<screens.size(); i++)
		//if (instance[i]->input_active)
			screens[i]->joy_axis_func();
}


void Screen::joy_up_funcs()
{
	for (unsigned i=0; i<screens.size(); i++)
		//if (instance[i]->input_active)
			screens[i]->joy_up_func();
}


void Screen::joy_down_funcs()
{
	for (unsigned i=0; i<screens.size(); i++)
		//if (instance[i]->input_active)
			screens[i]->joy_down_func();
}


void Screen::user_event_funcs()
{
	for (unsigned i=0; i<screens.size(); i++)
		//if (instance[i]->input_active)
			screens[i]->user_event_func();
}


void Screen::native_menu_click_funcs()
{
	for (unsigned i=0; i<screens.size(); i++)
		//if (instance[i]->input_active)
			screens[i]->native_menu_click_func();
}


void Screen::send_signal(int signal, void *data)
{
	for (unsigned i=0; i<screens.size(); i++)
		screens[i]->receive_signal(signal, data);
}


void Screen::send_signal(std::string const &signal, void *data)
{
	for (unsigned i=0; i<screens.size(); i++)
		screens[i]->receive_signal(signal, data);
}



Screen::Screen(Display *display)
	//: background_color(al_color_name("darkolivegreen"))
	//, updating(true)
	//, input_active(true)
	//, drawing(true)
	: display(display)
{
	screens.push_back(this);
}



Screen::~Screen()
{
	for (unsigned i=0; i<screens.size(); i++)
		if (screens[i] == this)
		{
			screens.erase(screens.begin() + i);
			i--;
		}
}


	
void Screen::bring_to_front(Screen *s)
{
	if (!s) return;

	unsigned index = 0;
	for (unsigned i=0; i<screens.size(); i++)
		if (screens[i] == s)
		{
			screens.erase(screens.begin()+i);
			break;
		}
	screens.push_back(s);
}



void Screen::set_on_display(Display *display)
{
	this->display = display;
}


int Screen::get_num_screens()
{
	return screens.size();
}


void Screen::on_event(ALLEGRO_EVENT *ev) {}
void Screen::primary_timer_func() {}
void Screen::timer_func() {}
void Screen::mouse_axes_func() {}
void Screen::display_switch_in_func() {}
void Screen::display_switch_out_func() {}
void Screen::mouse_down_func() {}
void Screen::mouse_up_func() {}
void Screen::key_down_func() {}
void Screen::key_up_func() {}
void Screen::key_char_func() {}
void Screen::joy_down_func() {}
void Screen::joy_up_func() {}
void Screen::joy_axis_func() {}
void Screen::user_event_func() {}
void Screen::native_menu_click_func() {}
void Screen::receive_signal(int signal, void *data) {}
void Screen::receive_signal(std::string const &signal, void *data) {}


std::vector<Screen *> Screen::screens;


