




#include "placement3d.h"
#include "useful.h" // just for #define TAU




placement3d::placement3d()
	: x(0), y(0), z(0)
	, w(0), h(0), d(0)
	, rotation_x(0), rotation_y(0), rotation_z(0)
	, align_x(0.5), align_y(0.5), align_z(0.5)
	, scale_x(1.0), scale_y(1.0), scale_z(1.0)
	, anchor_x(0), anchor_y(0), anchor_z(0)
{}



placement3d::placement3d(float x, float y, float z)
	: x(x), y(y), z(z),
	w(0), h(0), d(0),
	rotation_x(0), rotation_y(0), rotation_z(0),
	align_x(0.5), align_y(0.5), align_z(0.5),
	scale_x(1.0), scale_y(1.0), scale_z(1.0),
	anchor_x(0), anchor_y(0), anchor_z(0)
{}



void placement3d::start_transform()
{
	ALLEGRO_TRANSFORM transform;

	al_copy_transform(&previous_transform, al_get_current_transform());
	al_identity_transform(&transform);

	al_translate_transform_3d(&transform, -align_x*w, -align_y*h, -align_z*d);

	al_scale_transform_3d(&transform, scale_x, scale_y, scale_z);

	al_translate_transform_3d(&transform, anchor_x, anchor_y, anchor_z);

	// rotate
	al_rotate_transform_3d(&transform, 1, 0, 0, rotation_x * TAU); // <-- uuhh... not sure how this should work
	al_rotate_transform_3d(&transform, 0, 1, 0, rotation_y * TAU); // <-- uuhh... not sure how this should work
	al_rotate_transform_3d(&transform, 0, 0, 1, rotation_z * TAU); // <-- uuhh... not sure how this should work

	// translate
	al_translate_transform_3d(&transform, x, y, z);

	al_compose_transform(&transform, &previous_transform);


	al_use_transform(&transform);
}



void placement3d::restore_transform()
{
	al_use_transform(&previous_transform);
}
