

#include "placement2d.h"

#include <allegro5/allegro_primitives.h>
#include <allegro5/allegro_color.h>
#include <sstream>



placement2d::placement2d()
	: x(0), y(0), w(0), h(0), rotation(0), scale_x(1), scale_y(1),
	align_x(0.5), align_y(0.5), anchor_x(0), anchor_y(0)
{}




placement2d::placement2d(float x, float y, float w, float h)
	: x(x), y(y), w(w), h(h), rotation(0), scale_x(1), scale_y(1),
	align_x(0.5), align_y(0.5), anchor_x(0), anchor_y(0)
{}




placement2d::placement2d(float x, float y, float w, float h, float rotation, float scale_x, float scale_y, float align_x, float align_y, float anchor_x, float anchor_y)
	: x(x), y(y), w(w), h(h), rotation(rotation), scale_x(scale_x), scale_y(scale_y),
	align_x(align_x), align_y(align_y), anchor_x(anchor_x), anchor_y(anchor_y)
{}




void placement2d::start_transform()
{
	ALLEGRO_TRANSFORM transform;

	al_copy_transform(&previous_transform, al_get_current_transform());
	al_identity_transform(&transform);

	al_translate_transform(&transform, -align_x*w, -align_y*h);
	al_scale_transform(&transform, scale_x, scale_y);
	al_translate_transform(&transform, anchor_x, anchor_y);
	al_rotate_transform(&transform, rotation);
	al_translate_transform(&transform, x, y);

	al_compose_transform(&transform, &previous_transform);

	al_use_transform(&transform);
}




void placement2d::draw_origin()
{
	float half_size = 12;
	ALLEGRO_COLOR color = al_map_rgba_f(1, 0, 0, 1);
	al_draw_line(x, y-half_size, x, y+half_size, color, 1.0);
	al_draw_line(x-half_size, y, x+half_size, y, color, 1.0);
}



void placement2d::restore_transform()
{
	al_use_transform(&previous_transform);
}



void placement2d::draw_box(ALLEGRO_COLOR color, bool draw_origin)
{
	if (draw_origin) al_draw_circle(x, y, 5, color, 3.0);
	start_transform();
	al_draw_rectangle(0, 0, w, h, color, 3.0);
	restore_transform();
}



void placement2d::transform_coordinates(float *xx, float *yy)
	// unsure
{
	ALLEGRO_TRANSFORM transform;

	al_copy_transform(&transform, al_get_current_transform());
	al_translate_transform(&transform, -align_x*w, -align_y*h);
	al_scale_transform(&transform, scale_x, scale_y);
	al_translate_transform(&transform, -anchor_x, -anchor_y);
	al_rotate_transform(&transform, rotation);
	al_translate_transform(&transform, x, y);

	al_invert_transform(&transform);
	al_transform_coordinates(&transform, xx, yy);
}



void placement2d::place_coordinates(float *xx, float *yy)
	// unsure
{
	ALLEGRO_TRANSFORM transform;

	//al_copy_transform(&previous_transform, al_get_current_transform());
	al_identity_transform(&transform);

	al_translate_transform(&transform, -align_x*w, -align_y*h);
	al_scale_transform(&transform, scale_x, scale_y);
	al_translate_transform(&transform, anchor_x, anchor_y);
	al_rotate_transform(&transform, rotation);
	al_translate_transform(&transform, x, y);

	al_transform_coordinates(&transform, xx, yy);
}



bool placement2d::collide(float xx, float yy)
{
	transform_coordinates(&xx, &yy);

	// todo account for anchors and widths things (?)
	if (xx < 0) return false;
	if (xx > w) return false;
	if (yy < 0) return false;
	if (yy > h) return false;
	return true;
}



void placement2d::clear()
{
	x = 0;
	y = 0;
	align_x = 0.5;
	align_y = 0.5;
	rotation = 0;
	scale_x = 1;
	scale_y = 1;
	w = 1;
	h = 1;
	anchor_x = 0;
	anchor_y = 0;
}



std::string placement2d::get_string()
{
	std::stringstream ss;
	ss << "x" << x << " y" << y << " w" << w << " h" << h;
	return ss.str();
}