#ifndef __ALLEGRO_FLARE_MOTION_CONTROL
#define __ALLEGRO_FLARE_MOTION_CONTROL



#include <vector>
//#include <allegro_flare/allegro_flare.h>
#include "interpolators.h"


class MotionControl
{
public:
	float *val;
	float start_time;
	float end_time;
	float start_val;
	float end_val;
	void (*callback_func)(void *);
	void *callback_data;
	float (*interpolator_func)(float);
	bool active;

	MotionControl();
	MotionControl(float *val, float start_time, float end_time, float start_val, float end_val,
		float (*interpolator_func)(float), void (*callback_func)(void *data), void *callback_data);
	bool update(float time_now);
	void set(float *val, float start_time, float end_time, float start_val, float end_val,
		float (*interpolator_func)(float), void (*callback_func)(void *data), void *callback_data);
	void clear();
};


class MotionManager
{
private:
	int last_index;
	unsigned num_reserved;
	int get_new_index();
	std::vector<MotionControl *> control;

public:
	MotionManager(unsigned num_reserved=200);
	bool update(float time_now);

	bool is_being_animated(float *val);
	bool clear_animations_on(float *val);
	bool clear_animations_on(std::vector<float *> vals);
	void clear_all();

	// simple motion
	void animate(float *val, float start_val, float end_val, float start_time, float end_time, float (*interpolator_func)(float), void (*callback_func)(void *), void *callback_data);
	void move(float *val, float displacement, float duration, float (*interpolator_func)(float)=interpolator::fastIn, void (*callback_func)(void *)=NULL, void *callback_data=NULL);
	void move_to(float *val, float dest_val, float duration, float (*interpolator_func)(float)=interpolator::fastIn, void (*callback_func)(void *)=NULL, void *callback_data=NULL);

	// clears first
	void canimate(float *val, float start_val, float end_val, float start_time, float end_time, float (*interpolator_func)(float), void (*callback_func)(void *), void *callback_data);
	void cmove(float *val, float displacement, float duration, float (*interpolator_func)(float)=interpolator::fastIn, void (*callback_func)(void *)=NULL, void *callback_data=NULL);
	void cmove_to(float *val, float dest_val, float duration, float (*interpolator_func)(float)=interpolator::fastIn, void (*callback_func)(void *)=NULL, void *callback_data=NULL);
};




#endif