


#include "font_bin.h"
#include <allegro5/allegro_ttf.h>
//#include <algorithm>







int FontBin::_get_valid_font_size(std::string num)
{
	return atoi(num.c_str());
}





FontBin::FontBin(std::string directory)
	: Bin<ALLEGRO_FONT *>(directory)
{}



FontBin::~FontBin()
{
	clear();
}




ALLEGRO_FONT *FontBin::load_data(std::string identifier)
{
	std::string actual_font_filename = identifier;
	int font_size = 16; 
	size_t pos = identifier.find_last_of(' ');
	if (pos == std::string::npos)
	{
		std::cout << "[" __FUNCTION__ "] font size should be included in the identifier string \"" << identifier << "\"." << std::endl;
	}
	else
	{
		actual_font_filename = identifier.substr(0, pos);
		font_size = _get_valid_font_size(identifier.substr(pos+0));
	}

	return al_load_font(actual_font_filename.c_str(), font_size, ALLEGRO_TTF_NO_KERNING);
}




void FontBin::destroy_data(ALLEGRO_FONT *f)
{
	al_destroy_font(f);
}





/*
FontBin::FontRecord::FontRecord(std::string identifier, int size)
	: identifier(identifier)
	, size(size)
	, font(al_load_font(identifier.c_str(), size, NULL))
{}



ALLEGRO_FONT *FontBin::get(std::string identifier, int size)
{
	for (unsigned i=0; i<record.size(); i++)
		if (record[i]->size == size && record[i]->identifier.compare(identifier)==0)
			return record[i]->font;

	record.push_back(new FontRecord(identifier, size));
	std::sort(record.begin(), record.end());
		
	return get(identifier, size);
}
*/

