#ifndef __AF_FLAGS_HEADER
#define __AF_FLAGS_HEADER




#include <cstdint>

class BitFlags
{
private:
	uint64_t flags; // 64 possible flags
public:

	BitFlags(int64_t flags=0);

	bool has(int64_t state_flag);
	bool set(int64_t state_flag); // only sets individual flags, not a whole flag set
	bool unset(int64_t state_flag);
	bool toggle(int64_t state_flag);
	void clear();
};


/*
// you might define your flags something like this:
enum tile_flag_t
{
	// this is 8 flags, and a dullard (0x00) which isn't a flag
	TILE_FLAG_UNDEF = 0x00,
	TILE_FLAG_BOUNDRY_TOP = 0x01,
	TILE_FLAG_BOUNDRY_BOTTOM = 0x02,
	TILE_FLAG_BOUNDRY_LEFT = 0x04,
	TILE_FLAG_BOUNDRY_RIGHT = 0x08,
	TILE_FLAG_LADDER = 0x10,
	TILE_FLAG_INSTADEATH = 0x20,
	TILE_FLAG_DESTRUCTABLE = 0x40,
	TILE_FLAG_GOAL = 0x80
};
*/




#endif