



#include "flags.h"





BitFlags::BitFlags(int64_t flags)
	: flags(flags)
{}


bool BitFlags::has(int64_t state_flag)
{
	return (flags & state_flag) == state_flag;
}


bool BitFlags::set(int64_t state_flag)
{
	flags = flags | state_flag;
	return true;
}


bool BitFlags::unset(int64_t state_flag)
{
	flags &= ~state_flag;
	// e.g. this works in this case too, too:
	//		my.emask &= ~(ENABLE_SHOOT|SOME_OTHER|ONE_MORE);
	return false;
}


bool BitFlags::toggle(int64_t state_flag)
{
	if (has(state_flag)) unset(state_flag);
	else set(state_flag);
	return has(state_flag);
}


void BitFlags::clear()
{
	flags = 0;
}