



#include "camera3d.h"
#include "frustum.h"

#include "vec2d.h"
#include "useful.h"



Camera3D::Camera3D(int width, int height, Entity *entity)
	: entity_attached_to(entity)
	//: Entity()
	, width(width)
	, height(height)
	, pitch(0)
	, stepback(0)
	, stepback_pitch(0)
	, stepback_rotation_default(0)
	, stepback_rotation(0)
{}
void Camera3D::update() // this should be done in the map, and Camera should be an Entity (or maybe attached to an Entity?)... anyway...
{
	if (!entity_attached_to) return;
}
void Camera3D::set_frustum_as_camera(ALLEGRO_DISPLAY *d)
	// might want to rename this function to something else
{
	auto position = vec3d(0, 0, 0);
	auto view_vector = vec3d(0, 0, 1);
		
	if (entity_attached_to)
	{
		position = entity_attached_to->position;
		view_vector = entity_attached_to->view_vector;
	}

	ALLEGRO_TRANSFORM transform;
	//ALLEGRO_DISPLAY *d = al_get_current_display();
	//auto dw = al_get_display_width(d);
	//auto dh = al_get_display_height(d);

	Frustum frustum(width, height, 500, 0.0001);

	al_identity_transform(&transform);

	// ... ok... I don't know why this transform requires a (+0.5, +0.5, 0) but if it's not there,
	// then the camera does not stick on the point 0, 0.  maybe it has something to do with
	// the view vector, maybe something with ALLEGRO doing pixel coordinates,
	// but I'm a little unsure, hopefully this line will be resolved properly somewherre else and
	// not needed in the future: 
	al_translate_transform_3d(&transform, 0.5, 0.5, 0);

	al_translate_transform_3d(&transform, -position.x, -position.y, -position.z); // hmm, using negatives is new


	vec2d thing(view_vector.x, view_vector.z);
	al_rotate_transform_3d(&transform, 0, 1, 0, thing.GetAngle() + TAU/4);//(al_get_time()*0.2));



	// this is the vector for roll
	al_rotate_transform_3d(&transform, 0, 0, 1, (TAU/2)); // flip the world ... ? // maybe this messes with the strafe and up vectors



		al_rotate_transform_3d(&transform, 0, 1, 0, stepback_rotation.y); //  tilt the camera to look downward slightly
		//al_rotate_transform_3d(&transform, 1, 0, 0, pitch); //  tilt the camera to look downward slightly





	//al_rotate_transform_3d(&transform, 1, 0, 0, -(TAU/8)); //  tilt the camera to look downward slightly
	al_rotate_transform_3d(&transform, 1, 0, 0, pitch); //  tilt the camera to look downward slightly

			
		
		al_translate_transform_3d(&transform, stepback.x, stepback.y, stepback.z); // hmm, using negatives is new
		al_rotate_transform_3d(&transform, 1, 0, 0, stepback_pitch); //  tilt the camera to look downward slightly



	al_perspective_transform(&transform,
		frustum.left, frustum.top, frustum.znear,
		frustum.right, frustum.bottom, frustum.zfar);

	al_set_projection_transform(d, &transform);		
}
